"""
This type stub file was generated by pyright.
"""

import numpy as np
from typing import Callable, Dict, Optional, Union, Any

from .compat import _LGBMClassifierBase, _LGBMModelBase, _LGBMRegressorBase

"""Scikit-learn wrapper interface for LightGBM."""
class _ObjectiveFunctionWrapper:
    """Proxy class for objective function."""
    def __init__(self, func) -> None:
        """Construct a proxy class.

        This class transforms objective function to match objective function with signature ``new_func(preds, dataset)``
        as expected by ``lightgbm.engine.train``.

        Parameters
        ----------
        func : callable
            Expects a callable with signature ``func(y_true, y_pred)`` or ``func(y_true, y_pred, group)``
            and returns (grad, hess):

                y_true : array-like of shape = [n_samples]
                    The target values.
                y_pred : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                    The predicted values.
                    Predicted values are returned before any transformation,
                    e.g. they are raw margin instead of probability of positive class for binary task.
                group : array-like
                    Group/query data.
                    Only used in the learning-to-rank task.
                    sum(group) = n_samples.
                    For example, if you have a 100-document dataset with ``group = [10, 20, 40, 10, 10, 10]``, that means that you have 6 groups,
                    where the first 10 records are in the first group, records 11-30 are in the second group, records 31-70 are in the third group, etc.
                grad : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                    The value of the first order derivative (gradient) of the loss
                    with respect to the elements of y_pred for each sample point.
                hess : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                    The value of the second order derivative (Hessian) of the loss
                    with respect to the elements of y_pred for each sample point.

        .. note::

            For multi-class task, the y_pred is group by class_id first, then group by row_id.
            If you want to get i-th row y_pred in j-th class, the access way is y_pred[j * num_data + i]
            and you should group grad and hess in this way as well.
        """
        ...
    
    def __call__(self, preds, dataset) -> tuple[Any , Any]:
        """Call passed function with appropriate arguments.

        Parameters
        ----------
        preds : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
            The predicted values.
        dataset : Dataset
            The training dataset.

        Returns
        -------
        grad : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
            The value of the first order derivative (gradient) of the loss
            with respect to the elements of preds for each sample point.
        hess : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
            The value of the second order derivative (Hessian) of the loss
            with respect to the elements of preds for each sample point.
        """
        ...
    


class _EvalFunctionWrapper:
    """Proxy class for evaluation function."""
    def __init__(self, func) -> None:
        """Construct a proxy class.

        This class transforms evaluation function to match evaluation function with signature ``new_func(preds, dataset)``
        as expected by ``lightgbm.engine.train``.

        Parameters
        ----------
        func : callable
            Expects a callable with following signatures:
            ``func(y_true, y_pred)``,
            ``func(y_true, y_pred, weight)``
            or ``func(y_true, y_pred, weight, group)``
            and returns (eval_name, eval_result, is_higher_better) or
            list of (eval_name, eval_result, is_higher_better):

                y_true : array-like of shape = [n_samples]
                    The target values.
                y_pred : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                    The predicted values.
                    In case of custom ``objective``, predicted values are returned before any transformation,
                    e.g. they are raw margin instead of probability of positive class for binary task in this case.
                weight : array-like of shape = [n_samples]
                    The weight of samples.
                group : array-like
                    Group/query data.
                    Only used in the learning-to-rank task.
                    sum(group) = n_samples.
                    For example, if you have a 100-document dataset with ``group = [10, 20, 40, 10, 10, 10]``, that means that you have 6 groups,
                    where the first 10 records are in the first group, records 11-30 are in the second group, records 31-70 are in the third group, etc.
                eval_name : str
                    The name of evaluation function (without whitespace).
                eval_result : float
                    The eval result.
                is_higher_better : bool
                    Is eval result higher better, e.g. AUC is ``is_higher_better``.

        .. note::

            For multi-class task, the y_pred is group by class_id first, then group by row_id.
            If you want to get i-th row y_pred in j-th class, the access way is y_pred[j * num_data + i].
        """
        ...
    
    def __call__(self, preds, dataset):
        """Call passed function with appropriate arguments.

        Parameters
        ----------
        preds : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
            The predicted values.
        dataset : Dataset
            The training dataset.

        Returns
        -------
        eval_name : str
            The name of evaluation function (without whitespace).
        eval_result : float
            The eval result.
        is_higher_better : bool
            Is eval result higher better, e.g. AUC is ``is_higher_better``.
        """
        ...
    


_lgbmmodel_doc_fit = ...
_lgbmmodel_doc_custom_eval_note = ...
_lgbmmodel_doc_predict = ...
class LGBMModel(_LGBMModelBase):
    """Implementation of the scikit-learn API for LightGBM."""
    def __init__(self, boosting_type: str = ..., num_leaves: int = ..., max_depth: int = ..., learning_rate: float = ..., n_estimators: int = ..., subsample_for_bin: int = ..., objective: Optional[Union[str, Callable]] = ..., class_weight: Optional[Union[Dict, str]] = ..., min_split_gain: float = ..., min_child_weight: float = ..., min_child_samples: int = ..., subsample: float = ..., subsample_freq: int = ..., colsample_bytree: float = ..., reg_alpha: float = ..., reg_lambda: float = ..., random_state: Optional[Union[int, np.random.RandomState]] = ..., n_jobs: int = ..., silent: Union[bool, str] = ..., importance_type: str = ..., **kwargs) -> None:
        r"""Construct a gradient boosting model.

        Parameters
        ----------
        boosting_type : str, optional (default='gbdt')
            'gbdt', traditional Gradient Boosting Decision Tree.
            'dart', Dropouts meet Multiple Additive Regression Trees.
            'goss', Gradient-based One-Side Sampling.
            'rf', Random Forest.
        num_leaves : int, optional (default=31)
            Maximum tree leaves for base learners.
        max_depth : int, optional (default=-1)
            Maximum tree depth for base learners, <=0 means no limit.
        learning_rate : float, optional (default=0.1)
            Boosting learning rate.
            You can use ``callbacks`` parameter of ``fit`` method to shrink/adapt learning rate
            in training using ``reset_parameter`` callback.
            Note, that this will ignore the ``learning_rate`` argument in training.
        n_estimators : int, optional (default=100)
            Number of boosted trees to fit.
        subsample_for_bin : int, optional (default=200000)
            Number of samples for constructing bins.
        objective : str, callable or None, optional (default=None)
            Specify the learning task and the corresponding learning objective or
            a custom objective function to be used (see note below).
            Default: 'regression' for LGBMRegressor, 'binary' or 'multiclass' for LGBMClassifier, 'lambdarank' for LGBMRanker.
        class_weight : dict, 'balanced' or None, optional (default=None)
            Weights associated with classes in the form ``{class_label: weight}``.
            Use this parameter only for multi-class classification task;
            for binary classification task you may use ``is_unbalance`` or ``scale_pos_weight`` parameters.
            Note, that the usage of all these parameters will result in poor estimates of the individual class probabilities.
            You may want to consider performing probability calibration
            (https://scikit-learn.org/stable/modules/calibration.html) of your model.
            The 'balanced' mode uses the values of y to automatically adjust weights
            inversely proportional to class frequencies in the input data as ``n_samples / (n_classes * np.bincount(y))``.
            If None, all classes are supposed to have weight one.
            Note, that these weights will be multiplied with ``sample_weight`` (passed through the ``fit`` method)
            if ``sample_weight`` is specified.
        min_split_gain : float, optional (default=0.)
            Minimum loss reduction required to make a further partition on a leaf node of the tree.
        min_child_weight : float, optional (default=1e-3)
            Minimum sum of instance weight (hessian) needed in a child (leaf).
        min_child_samples : int, optional (default=20)
            Minimum number of data needed in a child (leaf).
        subsample : float, optional (default=1.)
            Subsample ratio of the training instance.
        subsample_freq : int, optional (default=0)
            Frequency of subsample, <=0 means no enable.
        colsample_bytree : float, optional (default=1.)
            Subsample ratio of columns when constructing each tree.
        reg_alpha : float, optional (default=0.)
            L1 regularization term on weights.
        reg_lambda : float, optional (default=0.)
            L2 regularization term on weights.
        random_state : int, RandomState object or None, optional (default=None)
            Random number seed.
            If int, this number is used to seed the C++ code.
            If RandomState object (numpy), a random integer is picked based on its state to seed the C++ code.
            If None, default seeds in C++ code are used.
        n_jobs : int, optional (default=-1)
            Number of parallel threads.
        silent : bool, optional (default=True)
            Whether to print messages while running boosting.
        importance_type : str, optional (default='split')
            The type of feature importance to be filled into ``feature_importances_``.
            If 'split', result contains numbers of times the feature is used in a model.
            If 'gain', result contains total gains of splits which use the feature.
        **kwargs
            Other parameters for the model.
            Check http://lightgbm.readthedocs.io/en/latest/Parameters.html for more parameters.

            .. warning::

                \*\*kwargs is not supported in sklearn, it may cause unexpected issues.

        Note
        ----
        A custom objective function can be provided for the ``objective`` parameter.
        In this case, it should have the signature
        ``objective(y_true, y_pred) -> grad, hess`` or
        ``objective(y_true, y_pred, group) -> grad, hess``:

            y_true : array-like of shape = [n_samples]
                The target values.
            y_pred : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                The predicted values.
                Predicted values are returned before any transformation,
                e.g. they are raw margin instead of probability of positive class for binary task.
            group : array-like
                Group/query data.
                Only used in the learning-to-rank task.
                sum(group) = n_samples.
                For example, if you have a 100-document dataset with ``group = [10, 20, 40, 10, 10, 10]``, that means that you have 6 groups,
                where the first 10 records are in the first group, records 11-30 are in the second group, records 31-70 are in the third group, etc.
            grad : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                The value of the first order derivative (gradient) of the loss
                with respect to the elements of y_pred for each sample point.
            hess : array-like of shape = [n_samples] or shape = [n_samples * n_classes] (for multi-class task)
                The value of the second order derivative (Hessian) of the loss
                with respect to the elements of y_pred for each sample point.

        For multi-class task, the y_pred is group by class_id first, then group by row_id.
        If you want to get i-th row y_pred in j-th class, the access way is y_pred[j * num_data + i]
        and you should group grad and hess in this way as well.
        """
        ...
    
    def __sklearn_is_fitted__(self) -> bool:
        ...
    
    def get_params(self, deep=...):
        """Get parameters for this estimator.

        Parameters
        ----------
        deep : bool, optional (default=True)
            If True, will return the parameters for this estimator and
            contained subobjects that are estimators.

        Returns
        -------
        params : dict
            Parameter names mapped to their values.
        """
        ...
    
    def set_params(self, **params) -> "LGBMModel":
        """Set the parameters of this estimator.

        Parameters
        ----------
        **params
            Parameter names with their new values.

        Returns
        -------
        self : object
            Returns self.
        """
        ...
    
    def fit(self, X, y, sample_weight=..., init_score=..., group=..., eval_set=..., eval_names=..., eval_sample_weight=..., eval_class_weight=..., eval_init_score=..., eval_group=..., eval_metric=..., early_stopping_rounds=..., verbose=..., feature_name=..., categorical_feature=..., callbacks=..., init_model=...):
        """Docstring is set after definition, using a template."""
        ...
    
    def predict(self, X, raw_score=..., start_iteration=..., num_iteration=..., pred_leaf=..., pred_contrib=..., **kwargs) -> Any:
        """Docstring is set after definition, using a template."""
        ...
    
    @property
    def n_features_(self) -> int | None:
        """:obj:`int`: The number of features of fitted model."""
        ...
    
    @property
    def n_features_in_(self) -> int | None:
        """:obj:`int`: The number of features of fitted model."""
        ...
    
    @property
    def best_score_(self): # -> dict[Unknown, Unknown] | None:
        """:obj:`dict`: The best score of fitted model."""
        ...
    
    @property
    def best_iteration_(self) -> int | None:
        """:obj:`int` or :obj:`None`: The best iteration of fitted model if ``early_stopping()`` callback has been specified."""
        ...
    
    @property
    def objective_(self): # -> str | ((...) -> Unknown) | None:
        """:obj:`str` or :obj:`callable`: The concrete objective used while fitting this model."""
        ...
    
    @property
    def booster_(self): # -> Booster | None:
        """Booster: The underlying Booster of this model."""
        ...
    
    @property
    def evals_result_(self): # -> dict[Unknown, Unknown] | None:
        """:obj:`dict` or :obj:`None`: The evaluation results if validation sets have been specified."""
        ...
    
    @property
    def feature_importances_(self): # -> NDArray[int32] | NDArray[float64]:
        """:obj:`array` of shape = [n_features]: The feature importances (the higher, the more important).

        .. note::

            ``importance_type`` attribute is passed to the function
            to configure the type of importance values to be extracted.
        """
        ...
    
    @property
    def feature_name_(self) -> list[Any]:
        """:obj:`array` of shape = [n_features]: The names of features."""
        ...
    


class LGBMRegressor(_LGBMRegressorBase, LGBMModel):
    """LightGBM regressor."""
    def fit(self, X, y, sample_weight=..., init_score=..., eval_set=..., eval_names=..., eval_sample_weight=..., eval_init_score=..., eval_metric=..., early_stopping_rounds=..., verbose=..., feature_name=..., categorical_feature=..., callbacks=..., init_model=...)-> "LGBMRegressor":
        """Docstring is inherited from the LGBMModel."""
        ...
    
    _base_doc = ...



class LGBMClassifier(_LGBMClassifierBase, LGBMModel):
    """LightGBM classifier."""
    def fit(self, X, y, sample_weight=..., init_score=..., eval_set=..., eval_names=..., eval_sample_weight=..., eval_class_weight=..., eval_init_score=..., eval_metric=..., early_stopping_rounds=..., verbose=..., feature_name=..., categorical_feature=..., callbacks=..., init_model=...) -> "LGBMClassifier":
        """Docstring is inherited from the LGBMModel."""
        ...
    
    _base_doc = ...
    _base_doc = ...
    def predict(self, X, raw_score=..., start_iteration=..., num_iteration=..., pred_leaf=..., pred_contrib=..., **kwargs) -> Any:
        """Docstring is inherited from the LGBMModel."""
        ...
    
    def predict_proba(self, X, raw_score=..., start_iteration=..., num_iteration=..., pred_leaf=..., pred_contrib=..., **kwargs) -> Any:
        """Docstring is set after definition, using a template."""
        ...
    
    @property
    def classes_(self): # -> NDArray[Unknown] | tuple[NDArray[Unknown], ...] | tuple[NDArray[Unknown], NDArray[Unknown]] | list[Unknown] | tuple[Unknown | list[Unknown] | None, ...] | tuple[Unknown | list[Unknown], ...] | tuple[Unknown | list[Unknown], Unknown | None] | Any | None:
        """:obj:`array` of shape = [n_classes]: The class label array."""
        ...
    
    @property
    def n_classes_(self) -> int:
        """:obj:`int`: The number of classes."""
        ...
    


class LGBMRanker(LGBMModel):
    """LightGBM ranker.

    .. warning::

        scikit-learn doesn't support ranking applications yet,
        therefore this class is not really compatible with the sklearn ecosystem.
        Please use this class mainly for training and applying ranking models in common sklearnish way.
    """
    def fit(self, X, y, sample_weight=..., init_score=..., group=..., eval_set=..., eval_names=..., eval_sample_weight=..., eval_init_score=..., eval_group=..., eval_metric=..., eval_at=..., early_stopping_rounds=..., verbose=..., feature_name=..., categorical_feature=..., callbacks=..., init_model=...) -> "LGBMRanker":
        """Docstring is inherited from the LGBMModel."""
        ...
    
    _base_doc = ...


