from typing import Any, Type
from matplotlib._typing import *
from matplotlib.text import Text
from matplotlib.font_manager import FontProperties
from matplotlib.transforms import Affine2DBase, Transform
from matplotlib.backend_bases import (
    FigureCanvasBase,
    FigureManagerBase,
    GraphicsContextBase,
    RendererBase,
    _Backend,
)
from encodings.utf_8 import StreamWriter
from io import BytesIO, TextIOWrapper

backend_version = ...

def escape_cdata(s)-> str: ...
def escape_comment(s)-> str: ...
def escape_attrib(s)-> str: ...
def short_float_fmt(x)-> str: ...

class XMLWriter:
    def __init__(self, file: TextIOWrapper | StreamWriter) -> None: ...
    def start(self, tag: str, attrib: dict[str, str] = ..., **extra) -> int: ...
    def comment(self, comment: str) -> None: ...
    def data(self, text: str) -> None: ...
    def end(self, tag: str | None = ..., indent: bool = ...) -> None: ...
    def close(self, id: int) -> None: ...
    def element(
        self, tag: str, text: str | None = ..., attrib: dict[str, str] = ..., **extra
    ) -> None: ...
    def flush(self) -> None: ...

def generate_transform(transform_list=...)-> str: ...
def generate_css(attrib=...)-> str: ...

class RendererSVG(RendererBase):
    def __init__(
        self, width, height, svgwriter, basename=..., image_dpi=..., *, metadata=...
    ) -> None: ...
    def finalize(self) -> None: ...
    def open_group(self, s: str, gid: str | None = ...) -> None: ...
    def close_group(self, s: str) -> None: ...
    def option_image_nocomposite(self) -> bool: ...
    def draw_path(self, gc, path, transform, rgbFace=...)-> None: ...
    def draw_markers(
        self,
        gc: GraphicsContextBase,
        marker_path,
        marker_trans: Transform,
        path,
        trans: Transform,
        rgbFace=...,
    )-> None: ...
    def draw_path_collection(
        self,
        gc,
        master_transform,
        paths,
        all_transforms,
        offsets,
        offsetTrans,
        facecolors,
        edgecolors,
        linewidths,
        linestyles,
        antialiaseds,
        urls,
        offset_position,
    )-> None: ...
    def draw_gouraud_triangle(self, gc: GraphicsContextBase, points, colors, trans)-> None: ...
    def draw_gouraud_triangles(
        self, gc, triangles_array, colors_array, transform: Transform
    )-> None: ...
    def option_scale_image(self) -> bool: ...
    def get_image_magnification(self) -> float: ...
    def draw_image(
        self,
        gc: GraphicsContextBase,
        x: Scalar,
        y: Scalar,
        im,
        transform: Affine2DBase = ...,
    )-> None: ...
    def draw_tex(self, gc, x, y, s, prop, angle, *, mtext=...)-> None: ...
    def draw_text(
        self,
        gc: GraphicsContextBase,
        x: float,
        y: float,
        s: str,
        prop: FontProperties,
        angle: float,
        ismath=...,
        mtext: Text = ...,
    )-> None: ...
    def flipy(self) -> bool: ...
    def get_canvas_width_height(self)-> tuple[float, float]: ...
    def get_text_width_height_descent(
        self, s: str, prop: FontProperties, ismath: bool
    ) -> tuple[float, float, float]: ...

class FigureCanvasSVG(FigureCanvasBase):
    filetypes: dict[str, str] = ...
    fixed_dpi: float = ...

    def print_svg(
        self,
        filename: BytesIO | str,
        *args,
        bbox_inches_restore=...,
        metadata: dict[str, Any] = ...
    ) -> None: ...
    def print_svgz(self, filename: str | PathLike | FileLike, *args, **kwargs)-> None: ...
    def get_default_filetype(self)-> str: ...
    def draw(self)-> None: ...

FigureManagerSVG: Type[FigureManagerBase] = ...
svgProlog: str = ...

class _BackendSVG(_Backend):
    FigureCanvas = FigureCanvasSVG
