import pathlib
from matplotlib.path import Path
from typing import Any, Callable, Literal, Sequence
from ._typing import *
from .transforms import Bbox, Transform
from .backend_bases import MouseEvent, RendererBase
from .font_manager import FontProperties
from .figure import Figure
from .artist import Artist, allow_rasterization
from .offsetbox import DraggableAnnotation
from .patches import FancyBboxPatch
from pathlib import PosixPath

def get_rotation(
    rotation: float | Literal[None, "horizontal", "vertical"]
) -> float: ...

class Text(Artist):

    zorder = ...
    def __repr__(self): ...
    def __init__(
        self,
        x: float = ...,
        y: float = ...,
        text: str = ...,
        color: Color = ...,
        verticalalignment: str = ...,
        horizontalalignment: str = ...,
        multialignment: str = ...,
        fontproperties: FontProperties = ...,
        rotation: float | str = ...,
        linespacing: float = ...,
        rotation_mode: str = ...,
        usetex: bool = ...,
        wrap: bool = ...,
        transform_rotates_text: bool = ...,
        *,
        parse_math=...,
        **kwargs
    ) -> None: ...
    def update(self, kwargs: dict[str, Any]) -> None: ...
    def __getstate__(self): ...
    def contains(self, mouseevent: MouseEvent) -> tuple[bool, dict]: ...
    def get_rotation(self) -> float: ...
    def get_transform_rotates_text(self) -> bool: ...
    def set_rotation_mode(self, m: None | Literal["default", "anchor"]) -> None: ...
    def get_rotation_mode(self) -> None | str: ...
    def update_from(self, other: Text) -> None: ...
    def set_bbox(self, rectprops: dict[str, Any]) -> None: ...
    def get_bbox_patch(self) -> None | FancyBboxPatch: ...
    def update_bbox_position_size(self, renderer: RendererBase) -> None: ...
    def set_clip_box(self, clipbox) -> None: ...
    def set_clip_path(self, path: Path, transform: Transform = ...) -> None: ...
    def set_clip_on(self, b: bool) -> None: ...
    def get_wrap(self) -> bool: ...
    def set_wrap(self, wrap: bool) -> None: ...
    @allow_rasterization
    def draw(self, renderer): ...
    def get_color(
        self,
    ) -> Color: ...
    def get_fontproperties(self) -> FontProperties: ...
    def get_fontfamily(self) -> list[str]: ...
    def get_fontname(self) -> str: ...
    def get_fontstyle(self) -> str: ...
    def get_fontsize(self) -> float: ...
    def get_fontvariant(self) -> str: ...
    def get_fontweight(self) -> str: ...
    def get_stretch(self) -> str: ...
    def get_horizontalalignment(self) -> str: ...
    def get_unitless_position(self) -> tuple[float, float]: ...
    def get_position(
        self,
    ) -> tuple[float, float]: ...
    def get_prop_tup(self, renderer: RendererBase = ...): ...
    def get_text(self) -> str: ...
    def get_verticalalignment(self) -> str: ...
    def get_window_extent(
        self,
        renderer: RendererBase = ...,
        dpi: float = ...,
    ): ...
    def set_backgroundcolor(self, color: Color) -> None: ...
    def set_color(self, color: Color) -> None: ...
    def set_horizontalalignment(
        self, align: Literal["left", "right", "center"]
    ) -> None: ...
    def set_multialignment(self, align: Literal["left", "right", "center"]) -> None: ...
    def set_linespacing(self, spacing): ...
    def set_fontfamily(
        self,
        fontname: str
        | Literal["serif", "sans-serif", "cursive", "fantasy", "monospace"],
    ) -> None: ...
    def set_fontvariant(self, variant: Literal["normal", "small-caps"]) -> None: ...
    def set_fontstyle(
        self, fontstyle: Literal["normal", "italic", "oblique"]
    ) -> None: ...
    def set_fontsize(
        self,
        fontsize: float
        | Literal[
            "xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"
        ],
    ) -> None: ...
    def get_math_fontfamily(self) -> str: ...
    def set_math_fontfamily(self, fontfamily: str) -> None: ...
    def set_fontweight(
        self,
        weight: float
        | Literal[
            "ultralight",
            "light",
            "normal",
            "regular",
            "book",
            "medium",
            "roman",
            "semibold",
            "demibold",
            "demi",
            "bold",
            "heavy",
            "extra bold",
            "black",
        ],
    ) -> None: ...
    def set_fontstretch(
        self,
        stretch: float
        | Literal[
            "ultra-condensed",
            "extra-condensed",
            "condensed",
            "semi-condensed",
            "normal",
            "semi-expanded",
            "expanded",
            "extra-expanded",
            "ultra-expanded",
        ],
    ): ...
    def set_position(self, xy: Sequence[float]) -> None: ...
    def set_x(self, x: float) -> None: ...
    def set_y(self, y: float) -> None: ...
    def set_rotation(self, s: float | Literal["vertical", "horizontal"]) -> None: ...
    def set_transform_rotates_text(self, t: bool): ...
    def set_verticalalignment(
        self, align: Literal["bottom", "baseline", "center", "center_baseline", "top"]
    ) -> None: ...
    def set_text(self, s) -> None: ...
    def set_fontproperties(
        self, fp: str | pathlib.Path | PosixPath | FontProperties
    ) -> None: ...
    def set_usetex(self, usetex: bool) -> None: ...
    def get_usetex(self) -> bool: ...
    def set_parse_math(self, parse_math: bool) -> None: ...
    def get_parse_math(self) -> bool: ...
    def set_fontname(
        self,
        fontname: str
        | Literal["serif", "sans-serif", "cursive", "fantasy", "monospace"],
    ) -> None: ...

class OffsetFrom:
    def __init__(
        self,
        artist: Annotation,
        ref_coord: Sequence[float],
        unit: Literal["points", "pixels"] = "points",
    ) -> None: ...
    def set_unit(self, unit: str) -> None: ...
    def get_unit(self) -> str: ...
    def __call__(self, renderer: RendererBase) -> Transform: ...

class _AnnotationBase:
    def __init__(
        self,
        xy: Sequence[float],
        xycoords: str | Artist | Transform | Callable | Sequence[float] = ...,
        annotation_clip: bool = ...,
    ) -> None: ...
    def set_annotation_clip(self, b: bool | None) -> None: ...
    def get_annotation_clip(self) -> bool | None: ...
    def draggable(
        self, state: bool | None = ..., use_blit: bool = ...
    ) -> None | DraggableAnnotation: ...

class Annotation(Text, _AnnotationBase):
    def __str__(self) -> str: ...
    def __init__(
        self,
        text: str,
        xy: Sequence[float],
        xytext: Sequence[float] = ...,
        xycoords: str | Artist | Transform | Callable | Sequence[float] = "data",
        textcoords: str | Artist | Transform | Callable | Sequence[float] = ...,
        arrowprops: dict = ...,
        annotation_clip: bool | None = ...,
        **kwargs
    ) -> None: ...
    def contains(self, event): ...
    @property
    def xycoords(self) -> str | Artist | Transform | Callable | Sequence[float]: ...
    @xycoords.setter
    def xycoords(
        self, xycoords: str | Artist | Transform | Callable | Sequence[float]
    ): ...
    @property
    def xyann(self): ...
    @xyann.setter
    def xyann(self, xytext): ...
    def get_anncoords(
        self,
    ) -> str | Artist | Transform | Callable | Sequence[float]: ...
    def set_anncoords(
        self, coords: str | Artist | Transform | Callable | Sequence[float]
    ): ...
    anncoords = ...
    def set_figure(self, fig: Figure) -> None: ...
    def update_positions(self, renderer: RendererBase) -> None: ...
    @allow_rasterization
    def draw(self, renderer: RendererBase): ...
    def get_window_extent(self, renderer: RendererBase = ...): ...
    def get_tightbbox(self, renderer: RendererBase = ...) -> Bbox: ...
