import numpy as np
from typing import Any
from matplotlib._typing import *
from .trifinder import TrapezoidMapTriFinder

class Triangulation:
    def __init__(
        self,
        x: ArrayLike,
        y: ArrayLike,
        triangles: ArrayLike = ...,
        mask: ArrayLike = ...,
    ) -> None: ...
    def calculate_plane_coefficients(self, z: ArrayLike) -> np.ndarray: ...
    @property
    def edges(self) -> np.ndarray: ...
    def get_cpp_triangulation(self) -> object: ...
    def get_masked_triangles(self) -> np.ndarray: ...
    @staticmethod
    def get_from_args_and_kwargs(
        *args, **kwargs
    ) -> tuple[Triangulation, list, dict[str, Any]]: ...
    def get_trifinder(self) -> TrapezoidMapTriFinder: ...
    @property
    def neighbors(self) -> np.ndarray: ...
    def set_mask(self, mask: None) -> None: ...
