from typing import Any

from typing_extensions import Self

from pandas._libs.ops_dispatch import (
    maybe_dispatch_ufunc_to_dunder_op as maybe_dispatch_ufunc_to_dunder_op,
)

class OpsMixin:
    def __eq__(self, other: object) -> Self: ...  # type: ignore[override]
    def __ne__(self, other: object) -> Self: ...  # type: ignore[override]
    def __lt__(self, other: Any) -> Self: ...
    def __le__(self, other: Any) -> Self: ...
    def __gt__(self, other: Any) -> Self: ...
    def __ge__(self, other: Any) -> Self: ...
    # -------------------------------------------------------------
    # Logical Methods
    def __and__(self, other: Any) -> Self: ...
    def __rand__(self, other: Any) -> Self: ...
    def __or__(self, other: Any) -> Self: ...
    def __ror__(self, other: Any) -> Self: ...
    def __xor__(self, other: Any) -> Self: ...
    def __rxor__(self, other: Any) -> Self: ...
    # -------------------------------------------------------------
    # Arithmetic Methods
    def __add__(self, other: Any) -> Self: ...
    def __radd__(self, other: Any) -> Self: ...
    def __sub__(self, other: Any) -> Self: ...
    def __rsub__(self, other: Any) -> Self: ...
    def __mul__(self, other: Any) -> Self: ...
    def __rmul__(self, other: Any) -> Self: ...
    def __truediv__(self, other: Any) -> Self: ...
    def __rtruediv__(self, other: Any) -> Self: ...
    def __floordiv__(self, other: Any) -> Self: ...
    def __rfloordiv__(self, other: Any) -> Self: ...
    def __mod__(self, other: Any) -> Self: ...
    def __rmod__(self, other: Any) -> Self: ...
    def __divmod__(self, other: Any) -> tuple[Self, Self]: ...
    def __rdivmod__(self, other: Any) -> tuple[Self, Self]: ...
    def __pow__(self, other: Any) -> Self: ...
    def __rpow__(self, other: Any) -> Self: ...
