from typing import (
    List,
    Sequence,
    Union,
)

from pandas.core.base import PandasObject
from pandas.core.indexes.api import Index
from pandas.core.internals.blocks import Block

class BlockManager(PandasObject):
    axes = ...
    blocks = ...
    def __init__(
        self,
        blocks: Sequence[Block],
        axes: Sequence[Index],
        do_integrity_check: bool = ...,
    ) -> None: ...
    def make_empty(self, axes=...): ...
    def __nonzero__(self): ...
    __bool__ = ...
    @property
    def shape(self): ...
    @property
    def ndim(self) -> int: ...
    def set_axis(self, axis, new_labels) -> None: ...
    def rename_axis(self, mapper, axis, copy: bool = ..., level=...): ...
    @property
    def items(self): ...
    def get_dtype_counts(self): ...
    def get_dtypes(self): ...
    def __len__(self) -> int: ...
    def reduce(self, func, *args, **kwargs): ...
    def apply(self, f, filter=..., **kwargs): ...
    def quantile(
        self,
        axis: int = ...,
        consolidate: bool = ...,
        transposed: bool = ...,
        interpolation: str = ...,
        qs=...,
        numeric_only=...,
    ): ...
    def isna(self, func): ...
    def where(self, **kwargs): ...
    def setitem(self, **kwargs): ...
    def putmask(self, **kwargs): ...
    def diff(self, **kwargs): ...
    def interpolate(self, **kwargs): ...
    def shift(self, **kwargs): ...
    def fillna(self, **kwargs): ...
    def downcast(self, **kwargs): ...
    def astype(self, dtype, copy: bool = ..., errors: str = ...): ...
    def convert(self, **kwargs): ...
    def replace(self, value, **kwargs): ...
    def replace_list(
        self, src_list, dest_list, inplace: bool = ..., regex: bool = ...
    ): ...
    def is_consolidated(self): ...
    @property
    def is_mixed_type(self): ...
    @property
    def is_numeric_mixed_type(self): ...
    @property
    def is_datelike_mixed_type(self): ...
    @property
    def any_extension_types(self): ...
    @property
    def is_view(self): ...
    def get_bool_data(self, copy: bool = ...): ...
    def get_numeric_data(self, copy: bool = ...): ...
    def combine(self, blocks, copy: bool = ...): ...
    def get_slice(self, slobj: slice, axis: int = ...): ...
    def __contains__(self, item) -> bool: ...
    @property
    def nblocks(self) -> int: ...
    def copy(self, deep: bool = ...): ...
    def as_array(self, transpose: bool = ..., items=...): ...
    def to_dict(self, copy: bool = ...): ...
    def fast_xs(self, loc): ...
    def consolidate(self): ...
    def get(self, item): ...
    def iget(self, i): ...
    def delete(self, item) -> None: ...
    def set(self, item, value): ...
    def insert(self, loc: int, item, value, allow_duplicates: bool = ...): ...
    def reindex_axis(
        self, new_index, axis, method=..., limit=..., fill_value=..., copy: bool = ...
    ): ...
    def reindex_indexer(
        self,
        new_axis,
        indexer,
        axis,
        fill_value=...,
        allow_dups: bool = ...,
        copy: bool = ...,
    ): ...
    def take(
        self, indexer, axis: int = ..., verify: bool = ..., convert: bool = ...
    ): ...
    def equals(self, other): ...
    def unstack(self, unstacker_func, fill_value): ...

class SingleBlockManager(BlockManager):
    ndim: int = ...
    axes = ...
    blocks = ...
    def __init__(
        self,
        block: Block,
        axis: Union[Index, List[Index]],
        do_integrity_check: bool = ...,
        fastpath: bool = ...,
    ) -> None: ...
    def get_slice(self, slobj, axis: int = ...): ...
    @property
    def index(self): ...
    @property
    def dtype(self): ...
    @property
    def array_dtype(self): ...
    def get_dtype_counts(self): ...
    def get_dtypes(self): ...
    def external_values(self): ...
    def internal_values(self): ...
    def get_values(self): ...
    def is_consolidated(self): ...
    def delete(self, item) -> None: ...
    def fast_xs(self, loc): ...
    def concat(self, to_concat, new_axis): ...

def create_block_manager_from_blocks(blocks, axes): ...
def create_block_manager_from_arrays(arrays, names, axes): ...
def construction_error(tot_items, block_shape, axes, e=...) -> None: ...
def form_blocks(arrays, names, axes): ...
def concatenate_block_managers(mgrs_indexers, axes, concat_axis, copy): ...
