from typing import (
    IO,
    Iterable,
)

from pandas.io.formats.format import (
    DataFrameFormatter as DataFrameFormatter,
    TableFormatter as TableFormatter,
)

class HTMLFormatter:
    indent_delta: int = ...
    fmt = ...
    classes = ...
    frame = ...
    columns = ...
    elements = ...
    bold_rows = ...
    escape = ...
    show_dimensions = ...
    border = ...
    table_id = ...
    render_links = ...
    def __init__(
        self,
        formatter: DataFrameFormatter,
        classes: str | list[str] | tuple[str, ...] | None = ...,
        border: int | None = ...,
    ) -> None: ...
    @property
    def show_row_idx_names(self) -> bool: ...
    @property
    def show_col_idx_names(self) -> bool: ...
    @property
    def row_levels(self) -> int: ...
    @property
    def is_truncated(self) -> bool: ...
    @property
    def ncols(self) -> int: ...
    def write(self, s, indent: int = ...) -> None: ...
    def write_th(
        self, s, header: bool = ..., indent: int = ..., tags: str | None = ...
    ) -> None: ...
    def write_td(self, s, indent: int = ..., tags: str | None = ...) -> None: ...
    def write_tr(
        self,
        line: Iterable,
        indent: int = ...,
        indent_delta: int = ...,
        header: bool = ...,
        align: str | None = ...,
        tags: dict[int, str] | None = ...,
        nindex_levels: int = ...,
    ) -> None: ...
    def render(self) -> list[str]: ...
    def write_result(self, buf: IO[str]) -> None: ...

class NotebookFormatter(HTMLFormatter):
    def write_style(self) -> None: ...
    def render(self) -> list[str]: ...
