from ..scene.node import Node
from ..util.event import Event
from numpy.typing import ArrayLike
from ..visuals.transforms.chain import ChainTransform
from ..visuals.transforms.transform_system import TransformSystem

# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

import weakref

from ..util.event import Event, EmitterGroup
from ..visuals.transforms import (
    NullTransform,
    BaseTransform,
    ChainTransform,
    create_transform,
    TransformSystem,
)

class Node(object):

    # Needed to allow subclasses to repr() themselves before Node.__init__()
    _name: None = ...

    def __init__(
        self,
        parent: Node | None = None,
        name: str | None = None,
        transforms: None | TransformSystem = None,
    ): ...
    @property
    def visible(self): ...
    @visible.setter
    def visible(self, val): ...
    @property
    def name(self): ...
    @name.setter
    def name(self, n): ...
    @property
    def opacity(self): ...
    @opacity.setter
    def opacity(self, o): ...
    def _update_opacity(self): ...
    def _set_clipper(self, node, clipper): ...
    @property
    def clip_children(self): ...
    @clip_children.setter
    def clip_children(self, clip): ...
    @property
    def clipper(self): ...
    @property
    def order(self): ...
    @order.setter
    def order(self, o): ...
    @property
    def children(self): ...
    @property
    def parent(self): ...
    @parent.setter
    def parent(self, parent): ...
    def _add_child(self, node): ...
    def _remove_child(self, node): ...
    def on_parent_change(self, event: Event): ...
    def is_child(self, node: Node) -> bool: ...
    @property
    def canvas(self): ...
    @property
    def document_node(self): ...
    @document_node.setter
    def document_node(self, doc): ...
    @property
    def scene_node(self): ...
    @property
    def root_node(self): ...
    def _set_canvas(self, c): ...
    def update(self): ...
    @property
    def document(self): ...
    @document.setter
    def document(self, doc): ...
    @property
    def transform(self): ...
    @transform.setter
    def transform(self, tr): ...
    def set_transform(self, type_: str, *args, **kwargs): ...
    def _update_trsys(self, event): ...
    def parent_chain(self): ...
    def describe_tree(self, with_transform: bool = False) -> str: ...
    def _describe_tree(self, prefix, with_transform): ...
    def common_parent(self, node: Node) -> None | Node: ...
    def node_path_to_child(self, node: Node) -> list | None: ...
    def node_path(self, node: Node) -> tuple[ArrayLike, ArrayLike]: ...
    def node_path_transforms(self, node: Node) -> ArrayLike: ...
    def node_transform(self, node: Node) -> ChainTransform: ...
    def __repr__(self): ...
    @property
    def picking(self): ...
    @picking.setter
    def picking(self, p): ...
