from typing import Any, Callable
from vispy.util.event import Event
from numpy.typing import ArrayLike

# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

from collections import OrderedDict
import inspect
import traceback
import weakref

from .logs import logger, _handle_exception

class Event(object):
    def __init__(self, type: str, native=None, **kwargs): ...
    @property
    def source(self): ...
    @property
    def sources(self): ...
    def _push_source(self, source): ...
    def _pop_source(self): ...
    @property
    def type(self): ...
    @property
    def native(self): ...
    @property
    def handled(self): ...
    @handled.setter
    def handled(self, val): ...
    @property
    def blocked(self): ...
    @blocked.setter
    def blocked(self, val): ...
    def __repr__(self): ...
    def __str__(self): ...

_event_repr_depth: int = ...

class EventEmitter(object):
    def __init__(self, source: Any = None, type: str | None = None, event_class: Event = ...): ...
    @property
    def ignore_callback_errors(self): ...
    @ignore_callback_errors.setter
    def ignore_callback_errors(self, val): ...
    @property
    def print_callback_errors(self): ...
    @print_callback_errors.setter
    def print_callback_errors(self, val): ...
    @property
    def callback_refs(self): ...
    @property
    def callbacks(self): ...
    @property
    def source(self): ...
    @source.setter
    def source(self, s): ...
    def connect(
        self,
        callback: Callable | tuple,
        ref: str | bool = False,
        position: str = "first",
        before: Callable | str | ArrayLike | None = None,
        after: Callable | str | ArrayLike | None = None,
    ): ...
    def disconnect(self, callback=None): ...
    def _normalize_cb(self, callback): ...
    def __call__(self, *args, **kwargs): ...
    def _invoke_callback(self, cb, event): ...
    def _prepare_event(self, *args, **kwargs): ...
    def blocked(self, callback=None): ...
    def block(self, callback=None): ...
    def unblock(self, callback=None): ...
    def blocker(self, callback=None): ...

class WarningEmitter(EventEmitter):
    def __init__(self, message, *args, **kwargs): ...
    def connect(self, cb, *args, **kwargs): ...
    def _invoke_callback(self, cb, event): ...
    def _warn(self, cb): ...

class EmitterGroup(EventEmitter):
    def __init__(self, source: Any = None, auto_connect: bool = True, **emitters): ...
    def __getitem__(self, name): ...
    def __setitem__(self, name, emitter): ...
    def add(self, auto_connect=None, **kwargs): ...
    @property
    def emitters(self): ...
    def __iter__(self): ...
    def block_all(self): ...
    def unblock_all(self): ...
    def connect(self, callback, ref=False, position="first", before=None, after=None): ...
    def disconnect(self, callback=None): ...
    def _connect_emitters(self, connect): ...
    @property
    def ignore_callback_errors(self): ...
    @ignore_callback_errors.setter
    def ignore_callback_errors(self, ignore): ...

class EventBlocker(object):
    def __init__(self, target, callback=None): ...
    def __enter__(self): ...
    def __exit__(self, *args): ...
