from vispy.util.svg.color import Color
from vispy.color.color_array import ColorArray
from numpy.typing import ArrayLike

# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.
# -----------------------------------------------------------------------------

import warnings

import numpy as np

from ..color import ColorArray
from ..gloo import VertexBuffer, _check_valid
from .shaders import Function, Variable
from .visual import Visual

_VERTEX_SHADER: str = ...

_FRAGMENT_SHADER: str = ...

disc: str = ...

arrow: str = ...

ring: str = ...

clobber: str = ...

square: str = ...

x_: str = ...

diamond: str = ...

vbar: str = ...

hbar: str = ...

cross: str = ...

tailed_arrow: str = ...

triangle_up: str = ...

triangle_down: str = ...

star: str = ...

# the following two markers needs x and y sizes
rect: str = ...

ellipse: str = ...

cross_lines: str = ...

class MarkersVisual(Visual):
    _marker_funcs: dict = ...

    _shaders: dict = ...

    def __init__(
        self,
        symbol: str = "o",
        scaling: bool = False,
        alpha: float = 1,
        antialias: float = 1,
        spherical: bool = False,
        light_color: ColorArray | Color = "white",
        light_position: ArrayLike = ...,
        light_ambient: float = 0.3,
        **kwargs,
    ): ...
    def set_data(
        self,
        pos: ArrayLike | None = None,
        size: float | ArrayLike = 10.0,
        edge_width: float | ArrayLike | None = 1.0,
        edge_width_rel: float | ArrayLike | None = None,
        edge_color: ColorArray | Color = "black",
        face_color: ColorArray | Color = "white",
        symbol=None,
        scaling=None,
    ): ...
    @property
    def symbols(self): ...
    @property
    def symbol(self): ...
    @symbol.setter
    def symbol(self, symbol): ...
    @property
    def scaling(self): ...
    @scaling.setter
    def scaling(self, value): ...
    @property
    def antialias(self): ...
    @antialias.setter
    def antialias(self, value): ...
    @property
    def light_position(self): ...
    @light_position.setter
    def light_position(self, value): ...
    @property
    def light_ambient(self): ...
    @light_ambient.setter
    def light_ambient(self, value): ...
    @property
    def light_color(self): ...
    @light_color.setter
    def light_color(self, value): ...
    @property
    def alpha(self): ...
    @alpha.setter
    def alpha(self, value): ...
    @property
    def spherical(self): ...
    @spherical.setter
    def spherical(self, value): ...
    def _prepare_transforms(self, view): ...
    def _prepare_draw(self, view): ...
    def _compute_bounds(self, axis, view): ...
