from typing import Literal

# -*- coding: utf-8 -*-
# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.
import numpy as np
from .shader_object import ShaderObject

VARIABLE_TYPES = ...

class Variable(ShaderObject):

    _vtype_32_conversion: dict = ...
    _vtype_23_conversion: dict = ...

    def __init__(
        self,
        name: str,
        value: float | int | tuple | GLObject | None = None,
        vtype: Literal["const", "uniform", "attribute", "varying", "inout"] | None = None,
        dtype: str | None = None,
    ): ...
    @property
    def name(self): ...
    @name.setter
    def name(self, n): ...
    @property
    def vtype(self): ...
    @property
    def dtype(self): ...
    @property
    def value(self): ...
    @value.setter
    def value(self, value): ...
    @property
    def state_id(self): ...
    def __repr__(self): ...
    def expression(self, names): ...
    def _vtype_for_version(self, version): ...
    def definition(self, names, version, shader): ...

class Varying(Variable):
    def __init__(self, name, dtype=None): ...
    @property
    def value(self): ...
    @value.setter
    def value(self, value): ...
    @property
    def dtype(self): ...
    def link(self, var): ...
    def invar(self, array=False): ...

class InVar(Variable):
    def __init__(self, var, array=False): ...
    @property
    def value(self): ...
    @value.setter
    def value(self, value): ...
    @property
    def dtype(self): ...
    def definition(self, names, version, shader): ...
    def expression(self, names): ...
