"""
ChalkML - Terminal-Based ML Data Engineering
=============================================

A production-grade data manipulation engine with:
- Intuitive position notation (01N, N01)
- 40+ ML operations
- Design patterns (MAP, REDUCE, STENCIL, SCAN, FARM)
- Control flow (IF/ELSE, WHILE)
- Auto-versioning and undo
- Knowledge graph integration

Usage:
    chalkml -rm col 01N data.csv
    chalkml -fillsmart col 03N mean data.csv
    chalkml -map col 05N "x*2" data.csv

Version: 1.0.2
Author: Mankind Research Labs
"""

__version__ = "1.0.2"
__author__ = "Mankind Research Labs"

from .engine import ChalkMLEngine, get_chalkml_engine
from .knowledge_graph import KnowledgeGraph, get_knowledge_graph
from .quantum_engine import QuantumEngine, get_quantum_engine
from .relevance_engine import RelevanceEngine, get_relevance_engine
from .redact_engine import RedactEngine, get_redact_engine
from .scaffold_engine import ScaffoldEngine, get_scaffold_engine
from .bow_engine import BowEngine, get_bow_engine

__all__ = [
    'ChalkMLEngine',
    'get_chalkml_engine',
    'KnowledgeGraph',
    'get_knowledge_graph',
    'QuantumEngine',
    'get_quantum_engine',
    'RelevanceEngine',
    'get_relevance_engine',
    'RedactEngine',
    'get_redact_engine',
    'ScaffoldEngine',
    'get_scaffold_engine',
    'BowEngine',
    'get_bow_engine',
]
