"""
ChalkML Setup Configuration
"""

from setuptools import setup, find_packages
from pathlib import Path

# Read README
readme_path = Path(__file__).parent / "README.md"
long_description = readme_path.read_text(encoding="utf-8") if readme_path.exists() else ""

setup(
    name="chalkml",
    version="1.0.2",
    author="Mankind Research Labs",
    author_email="labs@mankind.research",
    description="Advanced ML data processing with 5 patterns: QUANTUM, RELEVANCE, REDACT, SCAFFOLD, BOW",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/mankind-research/chalkml",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.8",
    install_requires=[
        "pandas>=1.5.0",
        "numpy>=1.21.0",
        "scikit-learn>=1.0.0",
        "Faker>=18.0.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
            "black>=22.0.0",
            "flake8>=5.0.0",
            "mypy>=0.990",
        ],
    },
    entry_points={
        "console_scripts": [
            "chalkml=chalkml.cli_simple:main",
        ],
    },
    keywords=[
        "machine-learning",
        "data-engineering",
        "data-science",
        "pandas",
        "preprocessing",
        "terminal",
        "cli",
        "ml-ops",
        "feature-engineering",
    ],
    project_urls={
        "Bug Reports": "https://github.com/mankind-research/chalkml/issues",
        "Source": "https://github.com/mankind-research/chalkml",
        "Documentation": "https://chalkml.readthedocs.io",
    },
)
