from divinegift import cipher


class Templator:
    def __init__(self):
        # cipher key
        self.cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='
        # file body
        self.console_template = b'gAAAAABhJGup4FQ-UrWm0EY2tzeVDFrloRGzf9kYqsVuubNa4gInhjpY6gYFQEQw6siBw0rQ8Ap70iR24VHcVTUFjYsG-lSMKKcuAxuInM5xTH0VawIUQLp5hAqRKBk_eFLkqUMwege03iC1fR0_dQqcmfW9ARDieNeuUCY-9KH1ZxSLmxVilgcHFhhkrwM1Mx9XBizudsYZ0xUzqzolEETI2O0NMs-s5dkX2XFKq8sPk0ghjST0op7OoGhVt3bGEKscHJ4wcYAkXZMBLiW-wI6JGZkcBP878fKnFa3ROtPcWpBtKLhvNv2qlQQoxfy0RLDv7kYzlODMj98AAAB5wgrRpNFQ2LzZcgOyj87EHlV18PlAexUIV08Z7Ii4itNGhHAz0Xqsh5chK0V7H5g_HtEQw7-JuE4VtfdvdvkinSi1NEBqdTk2fqadvpxFNiJoQlJXwh1et3f0X4suOPtTsF3sK0rg4MMLL88nzg7JdeyjBL_w7Kgc1SbnBT_ayDlqFa27PUfiQL0STnRXaWjFkLvxEYQpnswRMHvmaF5s1DTadjjkHQVZUlPlo1VN_RXrYwkDV7V1cZrc7ef8tx3Phuug7OTi9lO5SG3QceKEAsG6_n-qcUvaUzNStbg4ToZEtDsh8HonmOwlPWJZleskDKA1vTVap07dnf6yS6WQL2zNx38KmSsHSeCzDGQ3tD_XXzTq21c3x_XjGhjU3K1tHBZw4jJts1zIW7FWpHEjB-di1TW3U_VwO_m3L5M44nqkZdod4uuYRuyCr8lZ7105_aAEvh9fgP-QkEhpeNu6ttq1mwGuBgajP3EVEvxYrnAvG3clJQecwRKyLZKpKgmGBrIrai_4fkA8W4lV7AzX0RbTLGQsT4H-rrwmns8QgLOoM0o_SqI4l_RsOldsqTYzWgl226KyR8rV45_fStYflI1jK82yFrLFY2vp5aBUTDX9WgzYmzl-GjxrEphX4YUjIiLLzi_M1xyqxN5-mRW04KoVG395IrKu4PeskB95zHR6PgzIKVhf9PGLsse_VMCpAYfAxlYc8AYpQT8O1TP7981hNN2QSvyr7B6IBe7rm3O8_1lCYViFUVapHAkDaX0AbuKD7MfEjiFKUZ57f-sA2EFE0pzt_1XsMICHuzFI3I80bV-bEMU5bGynz-xzv3H4AIKZTcAYgHIYBW6BMqeF2AKOIjuJZ8iY_T4hYVoEyHeX71WfH-pDhlIV1aSuVf9aaEoC4FbbBmIkkwScQ6uYL5sm0QmvU4rPGRpdBL9ESvIn8sHGfojFaeHvloE0S1Alg3HFhpLbaAsEyT0F8m9z5wPrO6SYxoU-kJr-lmPlVEhBHHMH86C8ov6NCDdyO6i5mEV0df2JG11esZYYvHb_ZysWUMcUxNamtX88SkD98-HaONRYto2Hb_v30ZvfRs_31udgFArGsYHZmwSKQrlepb2YgF7q1eGuAJdmk-AGnP4GFR-VgROkQ0z2hSHRdVd0-1QNjfe7_TBmwrB40iLNLb1m6IcNmBtfT_dRurlGWdf-qFQfQ3wpW9xvUF4z3a3F9inTR496duXBlhjTBbHuPiMUVmaYe8IIaWjAuYkUtqUwFgxOArR3nNnm2NrD0lkPnBUWATgu-MekhgPaMZ7Z5RK1l6mapL4ob7GxzevBhYfzwpQQcqiMu3lxKHr5fksJ7k5GbF0BLZm7FyEhzcETNJBBv3d0KXTdt90aAMKAzk2eX6oqg_TPJl2mOlfXjUWAjVn7Zj1zuoyO5srY_wg9A2oGT7W60lMxx-kNmN4rldmgM7nsTSG60o1Xjb96wGUklvZ55XjqmcpLSxVSRJym0R-5sBtSOiWXD7ahuzZOxBmtfVCm7oV7rFcs9SZqJ8tRwA7NbYMHSS3e8Igy1pC4bi9AyOY18v0uX2H1x3opb6vEApEkv_Y-IUzBg231ofkJp-r5vDBfiWK9M7svsU2C0Hz7y4vWPiWwSILh9jfgjHF72pg2oo3ixqsIkFysbqrIQqkO8nOKOjIoq8y3VTWwnrPp_5dwkBLrYlf8ise7vdtDiOYlmUGLdu-avaXLVLP0zzUU_Ea0LQ-v4N5reII4mfrLANymSGrUetQZNocSVC7gZbom8Zh5CyXE8FuoXIjlVq3fYXAm5sJnSL5WCqPMBxOvwOUDDg4Xi7h94VSrVZZ6zlniqtWD1uAIl8h9thRDJ9QhFXPCVObVGEZJv0IY_vi1jmSiKEGs6KcS-D048Xo7uw-EtMJvv0wuPc4y8BluC1Or09lbw1lI9GI1HDfI2XXtRMvW5RSAEsOZHLU8-z10KXwngxbtGbleTnkHCaagiEnDJOA-DWicXYqBhmNvfDsGwCdAnetrEpj21NFIyeifs9KwAaYW9DRT'
        self.gui_template = b'gAAAAABcc7gmma_Yb6WFUpFArh0PIh_Kgkk-VGDURE7HRlIp81CwZZVBvozjzyFilBJfSM97lu9f3Ouxs1K06BH710g-W3O-HwehrTvTVGvdPloYKqGsI8wWkvdx7vBP0e-KL1dy1Ld_RuXcR0nrxb57dMIKbgc5EWkLHV82Zal1zapjPdwO0nJYKsmRzIomeDR6JrGvZ3ZOZuD7mxXAWxs9QOSfu7ovDYXpd4Zg1AB9MUrWxVLIn0DmYYb0NrCifS122HgGjyPEqMsPzI2X8bxCp0eD-JCczponz3z1_IT8j7jROLVsSFnFhYjwZmOd7bqoUhZ2_hgRpGFouQlLfgjxvFe62OClMNbkp3mkIiaQNhuTR9lWYyNjOQxtdF6hi8pBix5AvjuH5as4lyzlhHke7nsCrQDba8JGowKNeQxgoqWwDlXwWdHkKyCDSFCUbuFnzLUuq8HnV0t_MoHMtAesIE2lB7kOWdmpMhqwAZYfCX49QOyGm0tSPG1EZAoL3p3ozIlboxKd4aP3pVFJQoi4YIcEWImRQ1dfksYmoE87qvQzSwL6tT2hw_lQ03gOqIKAEP58SiYzTJlMoau5M1qXY1wlgLkmsyP_ql7lOn6PlbkJKcAuSm4XHFdlt5vdUjBipIdJfR0o9OxboIzdnp8QKp_zBmKjrp5hq3Maia-pUZLomnzPxo9_R3waP9ARZNT5kSD4hHM6MkM61cqfEn8ev9hPKsikmjDRdGjPnVVVunHmtMj9P6M5TsXD5-sO7ymFaT_pxul3GuxKZGKSrVGF1ceNWmZtUezvlpjUxYx6-TdjbMgHBWWlpNWi9Ffb2_7L8UwBxBs91BiESBnsYvh9WhnD4czwu8DWoNlPRyEVJuaOWVyZjergqywZTbooXXnLIb_PKwtLfyaaQRxBTiDPuIKWnqZgGaZlXlVNwuo5eYBxuZP059cNBRQxe2oJRzCZ94vIvCBhevwuN7Cdgay8ZviU91cByvPFu8OIQ-Ht2QH9MWc0Zdx8uXh9N9KGUKf_9FaAGSlfNiJBxhh4TmhgnhE9lbLBlSG5u7NyB67AHLzIk6b_EH7KcJjvQT7ZQ2DxLT8sRI7BomDanAbRY7lfZCtC1eC0EMJLMe8troNj4T0C37_PPRLl88QmF7BZwezHi-MeVxnqvTxUJQ2Fa0lmQqwM4DqUr8g9rjQ9WBIJ5mOvLbRPxn_M3xaBaGhH7UKLRSW5hStxZ5eBH1tiD2Xbge_iG_bFPS7O8Onfj5S88XwAHhQOSxBMcbKbIRtgXA9p8GROghvlZClnH0WAWr5YkJ9JJEo_BWofG7dxkdl6Rf_-cuygMFY0dCfSF6HWi6kS4iCgqIjsnUxqax-wS07HV3G6U9Lanq6KVsioaNZvD8OtIHDF42fpjpmHSdH1qu1wRZEYASkZsfe8GtqcW6WvPrMOHVtwTlswF9m64Ua4I22Qch-2UuGXqTL5GZYG53FzLrnziQ24nAmHsmNEpNB-0nXElRDzGfqwHbRDeuM0VatWWQDfJ5KHY_U6_i86XrQspTsz_5W6ozMvjxSs4FrodL8EJ1P7GE2tYLW-bRpmF4w1uFBhHWaRSbuY-blXLVqEzpHRw5JQ_iMF7BSymstldLW18P9e4huOoO9fGNpUwyT38c3LJh6Ffq4NcoIwQK-8RuSEzlGCIi3n84rBSR4M9k-Bvxc9FlPchx8Ya-va-4dHy_EarIIT8i3qnmlAs-Y7OL5SX7q59mixDBOgRjCEWuTQNW8YC4bP29gXFyLbhb76vQs-Oi2o9NyLsKmm5HOPuVtxEDzthBEE4_w9K3GmelDsfEliAG2E4F2uw8S4SprEuxeZRN3sPcX9NiqkdFH5i0lnLpXXx5N3Cqnt5kBk6LWmquRTgVV2DpOUJSU2jzSe21Ez-WhrsNqJeOeqK1HIxYrANSynlOUmmwhOHDii1PsoTTWhMvkn1cLL9PadbB0KjS_RudAIMPCbScWviPRoSMnQnRnYlcYi0FbxDymArj3EN394SHEd0eYHrzVvCYTQ5AtqyTmfQW8z0jNIUiFwARxoBNTkxR5Nn26-22ZL615umNIEA0yKXFRYYj39SGaspuZ_toHu1-kKj0P9-Eh_w9gqI2DZymraD3ADFvFP7rO7e7YMqNHQxVIq_jiRiMiUCBOVfptx_lllEKXCObsk0fx8zj6NCwvf5JGCiwXi5tUTClcMPb9gjcSyLF2wFId7yFb5F5VBz3pD_J3M_LS9m3h_NvMOEbBXHwYPgjyxLHSxTe92v9U2Cbyz5YdFrU0ad1RtVR9S2Tnyw3WX-O4abqBm1wd3tZRPqPHiHCke7Fd07BgpBdiY7LTBl-8lIZNTlAIhca1qVVtI93Y1aTg3nkUBasj9HBj3r60d8GKwZaMCDs05pLlU30jqhVVXhlqPGE87lY1T7ONAl2vDfQDyTRevUD1bB52TMgs_1y5c_v95ODRgZ90VAYQyYPJ9lSAmS2YsW8WatH-T07pbskqgFUvSgOJLKtzSh3ZTL3izeztgZv6fZZKcP1CgW8Fh5sJgX8YcQI91wVE23NSFMbPgtD6I36YFi6a8wX91Of_R7K1165om32djMZvq3rIu4rbr6O8tktVbVJTLAcRTbSNLnkIksrVUlXl4F1A0vkSPLrvuBTZ_yHClcOK3ytYSZbONlgbDXBJwVIw-MKBCXABDSC0oKgvDNCvC5KbTnmslpTA0vZjgI_RgoSRwsb5mY4FlCcccmXY57xzak3_ZpjtjLGtquamIC0Zvd_bHIaYsPtVUnHo4fpnrKJDDsUsJKSPcDipNoUdObXhwfKb3Br8mMSozBzJS1noj0huVRzQiRQaMYyTWPJ6qxO7_5gAnujzrpFxmWCieA4lR_u90Va642RFdFBH-2qlIDdSN9l4cfz7sR-NI2f8kL52xCjhEYPe2Nl00VWwUuLly_CTOWtut3qTukVJSTs-h07UeQHAyE5Hnnndefo_g3XzGLAhjblPK2NERSC5zeXIHnMfXoDYuEHr_V2qdyd9k8p1NZxfjPYVu8aTgPq9NmFXWHj_-EWrync460hDCpreBmZ6rcrCGnZrNzBMSRDqLbAvbl58dcWJLNiwfz7LWg5l0BkAIhLga0INdEP32rIOARNZVQOCNCE963CDKVOd0ewYLO1hHPukLJrruqASFhWkfYobzktOtTLSSZBtYRU2sDZ4oqcq8QUSertAtdl44VchQpo_sy0AfZ9MPg9VVvuObWKc6-lq04LGOYwh7fl0jAaOr_fWEuZh_i7kzFNFsMRXOi7Zvw0hLkJ30mQ5gnpZKp2Txl2qYj7CoH02GKkbeoaH6JQkDz1X_YT0z8y6qrWsYQcWWPCt4zYIXSOK0Yv28PuNfOWrnXMb0SWExBHKK5eCPwRi1fR_HpMu7udPvajCs9IfJE6bm8mYlaX8OGxVSAFfzoi0bTvhY7gup8P_pa5buEUE9AP477shoyg-bhx3zVHMGV7Rr3SJn1L0cBcGci5-GGXSAUSgXVLdq11mu5Tfeplm6LSb3LZNVv87OnaVU9ZFUpI-2ePsH0_-6UeNWE1Z79YCA_vuCg5TIMnip7O71rykxU5NdONqPpVybvWoa98vMcRLzwafbKYzX9t9Bj63TRPrIlkQ8jp09BObL_ZHbtkREjmw0R4V4uPxHAtB7nY9SwA-sF3pdrLr9MoLPlFkIkghjhK-ZqaW8Rn-TvTiab0ygserx5hqAgxMzVT008DnXKAEYXjMixLwWdCOpJgq8cQMQYH1DB7rFMFvuypLNjPG56wo6L-yL8tFGBB0CmzH5nfisvBioGQ=='
        self.config_template = b'gAAAAABhJGx4uZc7VXAc-v7tJinG-Ry_vWEXz9jeeZemkgR32-hvkQvXxDUJ-q8BcGWxvh4iX-RjV-hIsA5LXD6tKQaeox-vD_2u0GXDTp8ONWjM_cp0OD3UoqKpb9zOeY9NVzdGddBic25IdA-PyLfgvVoYaj0KZzk5e4DuNX0RyupCgRDodDTCb5ffIKPkmNYORy-fDzdiOB9ovXTrRx_m_Jw_kr4uP33O89utYP9ZDEk5U14et0i_N4hE1lRV-Y1YCldW3N-MsSWmV-20e_DTsiXtES3QFXvwBO7-SV6kf6lTdKj0vYnxJisN2HYnTQTgGdNgTrRlN4SArlAFIloDpUwJ1BhbT679bWhvvz2xh4S2gZQBC9BYplf6yJhz5pC3XuCR83_-eknIDfDm7pWlWsHnzmWbW7VzhGFOq5irQuXm6syDRCrQF8J5hlOA44sbzA-vzOl9o45JJMPOLYiSoDF6aLjRlQbfqwFWYV8oJbFsy713o1rT4Z08XcmZ7ZQdQew6edmsFKnjxE9k4Qv4EDilTBiXo2087mfz7HObYJ6D8_yWoFE='

        self.cipher = cipher.get_cipher(self.cipher_key)

    def create_file(self, filename: str, text: bytes):
        with open(filename, 'w') as f:
            f.write(cipher.decrypt_str(text, self.cipher))

    def create_console(self, filename: str = 'main.py'):
        if not filename.endswith('.py'):
            filename += '.py'
        self.create_file(filename, self.console_template)

    def create_gui(self, filename: str = 'main_gui.py'):
        if not filename.endswith('.py'):
            filename += '.py'
        self.create_file(filename, self.gui_template)

    def create_config(self, filename: str = 'settings.ini'):
        self.create_file(filename, self.config_template)


if __name__ == '__main__':
    pass
