__all__ = [
    "DEFAULT_TRANSLATIONS",
    "add_missing_translations",
]


def add_missing_translations():
    from .translations import _translations_config

    for key, message in DEFAULT_TRANSLATIONS.items():
        if key not in _translations_config:
            _translations_config[key] = message


DEFAULT_TRANSLATIONS = {
    "bot_shutting_down": "bot shutting down...",
    "missing_required_arguments": "missing required arguments",
    "command_not_found": "no command found for \"{name}\"",
    "command_already_disabled": "{name} is already disabled",
    "disabled_command": "disabled command \"{name}\"",
    "command_not_disabled": "{name} is not disabled",
    "command_enabled": "enabled command \"{name}\"",
    "reloaded_disabled_commands_config": "@{user} reloaded disabled commands config",
    "disabled_command_globally": "disabled command \"{name}\" globally",
    "enabled_command_globally": "enabled command \"{name}\" globally",
    "reloaded_command_whitelist": "{mention} reloaded command whitelist",
    "currency_name_set": "this channel's currency name is now \"{currency_name}\"",
    "currency_name_get": "this channel's current currency name is \"{currency_name}\"",
    "bal_current": "@{target} has {balance} {currency_name}",
    "set_bal_negative": "new balance cannot be negative",
    "set_bal_invalid_int": "target balance must be a integer. example: 100",
    "set_bal_success": "@{target} now has {balance} {currency_name}",
    "add_bal_missing_args": "must supply both <user or all> and <amount>",
    "add_bal_invalid_int": "cannot parse \"{value}\" to a int, must be a valid int, ex: 100",
    "add_bal_amount_must_be_positive": "amount must be positive and not zero, ex: 1, 2, 100",
    "add_bal_add_all": "added {amount} {currency} to everyone's balance",
    "add_bal_success": "gave {target} {amount} {currency}, their total is now {balance} {currency}",
    "sub_bal_sub_all": "subtracted {amount} {currency} from everyone's balance",
    "sub_bal_no_balance": "{target} does not exist in the database",
    "sub_bal_insufficient_balance": "{target} does not have {currency} to subtract {amount} {currency} from",
    "sub_bal_success": "subtracted {amount} {currency} from {target}, their total is now {balance} {currency}",
    "give_invalid_amount_int": "give amount must be a integer, example: 100",
    "give_invalid_amount_not_positive": "give amount must be 1 or higher",
    "give_insufficient_balance": "{mention} you don't have enough {currency}",
    "give_success": "@{author} you gave @{target_user} {give} {currency}, @{target_user}'s balance is now {target_balance}",
    "gamble_invalid_bet": "invalid value for bet, must be an integer, ex: 1, 15, 100",
    "gamble_invalid_dice_sides": "invalid value for dice_sides, must be an integer, ex: 2, 5, 8",
    "gamble_bet_less_than_10": "bet cannot be less then 10",
    "gamble_sides_less_than_2": "sides cannot be less than 2",
    "gamble_insufficient_balance": "{mention} you don't have enough {currency}",
    "gamble_won": "you rolled {roll} and won {gain} {currency}",
    "gamble_lost": "you rolled {roll} and lost {loss} {currency}",
    "mine_success": "@{author} you went to work at the mines and came out with {gain} {currency} worth of gold",
    "mine_cooldown": "you cannot mine again for {diff} seconds",
    "reloaded_top_ignored_list": "successfully reloaded top's ignored list!",
    "top_no_results": "no users found",
    "arena_already_entered": "you are already entered the in the arena",
    "arena_insufficient_balance": "{mention} you do not have enough {currency} to join the arena, entry_fee is {entry_fee} {currency}",
    "arena_entered": "{mention} you have been added to the arena, you were charged {entry_fee} {currency} for entry",
    "arena_invalid_entry_fee": "invalid value for entry fee, example: 100",
    "arena_entry_fee_not_high_enough": "entry fee cannot be less than {entry_fee}",
    "arena_cannot_enter_not_enough_balance": "{mention} you do not have {entry_fee} {currency}",
    "duel_self": "you cannot duel yourself",
    "duel_duplicate": "{mention} you already have a pending duel with {target}",
    "duel_invalid_bet": "invalid bet: {bet}, bet must be a number with no decimals, ex: 12",
    "duel_target_no_balance": "{target} does not have a balance",
    "duel_target_insufficient_balance": "{target} does not have enough {currency} to accept this duel!",
    "duel_challenged": "{mention} has challenged @{target} to a duel for {bet} {currency}, do \"{command_prefix}accept {mention}\" to accept the duel",
    "duel_accept_no_duel": "{mention}, you have not been challenged by {challenger}, or the duel might have expired",
    "duel_accept_result": "@{winner} has won the duel, {bet} {currency} went to the winner",
    "add_cmd_invalid_response": "response cannot have . or / as the starting character",
    "add_cmd_duplicate": "custom command already exist by that name",
    "add_cmd_success": "successfully added command \"{name}\", trigger the command using \"{name}\" (without the quotes)",
    "add_cmd_fail": "failed to add command \"{name}\"",
    "update_cmd_not_exists": "custom command \"{name}\" does not exist",
    "update_cmd_success": "successfully updated command \"{name}\"",
    "del_cmd_success": "successfully deleted command \"{name}\"",
    "del_cmd_fail": "failed to delete command \"{name}\"",
    "cmd_cmd_result": "the response for \"{name}\" is \"{response}\"",
    "ping_response": "Pong #{pings}",
    "roll_invalid_sides": "invalid value for sides",
    "roll_result": "{user} you rolled {num}",
    "crashme": "you may not crash me! {mention}",
    "choose_result": "result: {value}",
    "color_set": "set color to {color}",
    "8ball_result": "{mention} {value}",
    "8ball_yes_1": "it is certain",
    "8ball_yes_2": "yes",
    "8ball_no_1": "not happening",
    "8ball_no_2": "no",
    "8ball_maybe_1": "maybe",
    "8ball_maybe_2": "it's possible",
    "commands_usable": "COMMANDS YOU CAN USE: {global_commands}",
    "command_no_usable": "{mention}, you do not have permission to use any commands",
    "command_custom": "CUSTOM: {custom_commands}",
    "help_success": "help for \"{fullname}\" - syntax: \"{syntax}\" - help: {help}",
    "findperm_no_permission": "command \"{fullname}\" does not have require permission to use it",
    "findperm_success": "the permission for \"{fullname}\" is \"{permission}\"",
    "enabledmod_not_found": "could not find mod \"{mod}\"",
    "enabledmod_already_enabled": "mod \"{mod}\" is already enabled",
    "enabledmod_enabled": "mod \"{mod}\" has been enabled for this channel",
    "disablemod_already_disabled": "mod \"{mod}\" is already disabled",
    "disablemod_disabled": "mod \"{mod}\" has been disabled for this channel",
    "disabledmods_list": "disabled mods for \"{channel_name}\": ",
    "reloadmod_failed": "failed to reload mod \"{mod}\"",
    "reloadmod_reloaded_all": "reloaded all mods",
    "reloadmod_success": "reloaded mod \"{mod}\"",
    "listmods_disabled_prefix": "(DISABLED)",
    "listmods_found": "found mods: {mods}",
    "addperm_added": "added permission \"{perm}\" to \"{group}\"",
    "addperm_no_group": "no group found by the \"{group}\"",
    "delperm_deleted": "deleted permission \"{perm}\" from \"{group}\"",
    "addgroup_added": "added permission group \"{group}\"",
    "addgroup_already_exists": "permission group \"{group}\" already exist",
    "delgroup_deleted": "deleted permission group \"{group}\"",
    "reloaded_permissions": "reloaded permissions",
    "reloaded_permissions_failed": "failed to reload permissions",
    "addmember_added": "added \"{member}\" to \"{group}\"",
    "addmember_no_group": "failed to add member, group does not exists",
    "delmember_deleted": "removed \"{member}\" from \"{group}\"",
    "delmember_failed_no_group": "failed to remove member, group does not exist",
    "delmember_member_not_in_group": "\"{member}\" is not in that group",
    "startpoll_invalid": "your poll commands seems to be improperly formatted, example: {command_prefix}startpoll what should i eat? [apples, oranges, potatos]",
    "vote_missing_id": "missing required vote arguments, must provide the id of the choice you want to vote for",
    "vote_no_active_polls": "there are NOT any active polls running right now to vote for",
    "vote_requires_id": "{mention} there are multiple polls active, please specify the poll id, example: {command_prefix}vote {choice} <POLL_ID>",
    "vote_poll_not_found": "Could not find poll by ID {poll_id}",
    "vote_invalid_vote": "{choice} is not a valid choice id for poll#{poll_id}, choices are: {poll_options}",
    "listpolls_no_polls": "There are currently no active polls.",
    "pollinfo_no_polls": "there are not any polls active right now",
    "pollinfo_requires_id": "multiple polls are running, the poll id is required to be passed, example: {command_prefix}pollinfo <POLL_ID>",
    "pollinfo_result": "POLL INFO #{poll_id} ~ {poll_title} ~ {poll_options} ~ seconds left: {poll_seconds_left}",
    "pollhelper_int_error": "{value} is not a valid number",
    "addquote_invalid_user": "invalid user for user=, must be a combination of digits and letters, ex: john_doe17",
    "addquote_invalid_alias": "invalid alias for alias=, must be a combination of digits and letters, ex: my_quote1",
    "addquote_alias_cannot_be_numeric": "invalid alias for alias=, alias cannot exclusively be numeric",
    "addquote_duplicate_alias": "there is already a quote with that alias",
    "addquote_failed": "failed to add quote, already exist",
    "addquote_added": "successfully added quote #{quote_id}",
    "quote_not_found": "quote not found",
    "quote_info": "\"{text}\" user: {user} alias: {alias}",
    "delquote_deleted": "successfully deleted quote, id: {quote_id}, alias: {alias}",
    "timer_helper_invalid_interval": "invalid interval, must be a valid float and be above 10, ex: 10,  11.5, 30",
    "addtimer_duplicate_name": "timer already exist by the name of \"{timer_name}\"",
    "addtimer_created": "created timer successfully",
    "starttimer_timer_not_found": "no timer was found by \"{name}\"",
    "starttimer_timer_already_running": "timer \"{name}\" is already running",
    "starttimer_started": "successfully started the timer \"{name}\"",
    "starttimer_failed": "failed to start the timer \"{name}\"",
    "stoptimer_not_running": "timer \"{name}\" is not running",
    "stoptimer_stopped": "successfully stopped the timer \"{name}\"",
    "stoptimer_failed": "failed to stop the timer \"{name}\"",
    "deltimer_deleted": "successfully deleted timer \"{name}\"",
    "deltimer_failed": "failed to delete timer \"{name}\"",
    "listtimers_no_timers": "no timers found for this channel",
    "listtimers_active": "active timers: {active_timers}",
    "listtimers_inactive": "inactive timers: {inactive_timers}",
    "edittimer_invalid_option": "invalid option, must be `msg` or `interval`",
    "editimer_interval_invalid_int": "interval must be a valid integer, ex: 10",
    "edittimer_updated_interval": "updated timer interval for \"{name}\"",
    "edittimer_updated_msg": "updated timer message for \"{name}\"",
    "addcounter_invalid_alias": "invalid alias, must be a combination of digits and letters, ex: my_counter1",
    "addcounter_duplicate_alias": "there is already a counter with that alias",
    "addcounter_success": "successfully added counter #{counter_id}",
    "addcounter_already_exists": "failed to add counter, already exist",
    "delcounter_not_found": "could not find any counters by \"{query}\"",
    "delcounter_deleted": "successfully deleted counter, id: {counter_id}, alias: {counter_alias}",
    "setcounter_invalid_value": "invalid value, only numbers are allowed",
    "setcounter_success": "The counter {counter} has been updated to {new_val}",
    "listcounters_list": "The following counters are available: {clist}",
    "listcounters_format": "{id}({alias}) -> {value}",
    "mod_event_error": "\nerror has occurred while triggering a event on a mod, details:\nmod: {mod_name}\nevent: {event}\nerror: {error_type}\nreason: {error}\nstack trace:",
    "event_handler_error": "\nerror has occurred while calling an event handler, details:\nevent: {event}\nerror: {error_type}\nreason: {error}\nstack trace:",
    "send_command_help_message": "{reason} - syntax: \"{cmd_syntax}\" - do \"{command_prefix}help {cmd_fullname}\" for more details",
    "bad_twitch_api_response": "bad response received from endpoint: {endpoint}\nextra details: {message}",
    "stream_info_api_error": "[STREAM INFO API] failed to update stream data for {user}\nERROR TYPE: {error}\nERROR DETAILS: {error}\nSTACKTRACE:\n{formatted_exception}",
    "command_server_proper_command_syntax": "\nproper command syntax: {cmd_syntax}. ",
    "command_server_invalid_arguments_error_response": "attempt to run command \"{command}\" with args {args} raised a error. {usage}details:\n\treason: {reason}\n\terror class: {error_type}\n\terror: {error}\n\tstack trace:\n\n================ STACK TRACE FOR: /{command} {joined_args} ================\n{stack_trace}\n================ END STACK TRACE FOR: /{command} {joined_args} ================",
    "command_server_error_executing_command": "COMMAND SERVER [FAILED TO RUN COMMAND]: attempt to run command \"{command}\" with args {args} raised a error. details:\n\terror class: {error_type}\n\terror: {error}\n\tstack trace:\n\n================ STACK TRACE FOR: /{command} {joined_args} ================\n{stack_trace}\n================ END STACK TRACE FOR: /{command} {joined_args} ================",
    "arena_win_message_1": "{winner} fought long and hard, and won {winnings} {currency}!",
    "arena_win_message_2": "{winner} has won the FFA, and walked away with {winnings} {currency}!",
    "arena_not_enough_entries_refund": "not enough users joined the arena to start, everyone that entered was issued a refund",
    "arena_opening_message": "FFA arena has been opened and will start in {delay} seconds! Entry fee is {entry_fee} {curname}. Type {command_prefix}arena to join",
    "builtin_command_help_message_shutdown": "make the bot shutdown",
    "builtin_command_help_message_disablecmd": "disables a command for the current channel",
    "builtin_command_help_message_enablecmd": "enables a command for the current channel",
    "builtin_command_help_message_reloaddisabled": "reloads disable commands config",
    "builtin_command_help_message_disablecmdglobal": "disables a command for all channels the bot is in",
    "builtin_command_help_message_enablecmdglobal": "enables a command for all channels the bot is in",
    "builtin_command_help_message_reloadcmdwhitelist": "reloads whitelisted commands from the config file",
    "builtin_command_help_message_setcurrencyname": "sets the channels currency name",
    "builtin_command_help_message_getcurrencyname": "get the channels current currency name",
    "builtin_command_help_message_bal": "gets the caller's (or target's if specified) balance",
    "builtin_command_help_message_setbal": "sets the callers or targets balance",
    "builtin_command_help_message_addbal": "adds the balance of the target, or all",
    "builtin_command_help_message_subbal": "subtracts the balance of the target, or all",
    "builtin_command_help_message_give": "gives the target the specified amount from the callers currency balance",
    "builtin_command_help_message_gamble": "throws a X sided die, if the dice sides are more than 6 you get more payout on a success X roll, but it is also a lower chance to roll X.",
    "builtin_command_help_message_mine": "mines for currency, gives you a predefined amount (default 50)",
    "builtin_command_help_message_topreloadignored": "reloads the config file for top's ignored usernames",
    "builtin_command_help_message_top": "lists the top 10 balance holders",
    "builtin_command_help_message_arena": "starts a arena match, waits a certain amount of time for ppl to enter, if not enough ppl enter the arena is cancelled and everyone is refunded, the winner gets all of the entry_fee's paid",
    "builtin_command_help_message_duel": "challenges a user to a duel with the bid as the reward",
    "builtin_command_help_message_accept": "accepts a duel issued by the challenger that is passed to this command",
    "builtin_command_help_message_addcmd": "adds a custom command to the database for the this channel, placeholders: %user : the name of the person that triggered the command, %uptime : the channels live uptime, %channel : the channels name, %counter adds and uses a counter starting with the value 0",
    "builtin_command_help_message_updatecmd": "updates a custom command's response message",
    "builtin_command_help_message_delcmd": "deletes a custom commands",
    "builtin_command_help_message_cmd": "gets a custom commmands response",
    "builtin_command_help_message_addcounter": "adds a counter to the database",
    "builtin_command_help_message_delcounter": "deletes the counter from the database",
    "builtin_command_help_message_setcounter": "sets a counters value in the database",
    "builtin_command_help_message_listcounters": "list all counters of the channel",
    "builtin_command_help_message_roll": "rolls a X sided die",
    "builtin_command_help_message_choose": "chooses a random option passed to the command",
    "builtin_command_help_message_color": "sets the bots chat color",
    "builtin_command_help_message_8ball": "prints a random answer to the question",
    "builtin_command_help_message_commands": "lists all commands, add -a or -alias to list aliases",
    "builtin_command_help_message_help": "gets the help text for a command",
    "builtin_command_help_message_findperm": "finds a permission for a given command",
    "builtin_command_help_message_enablemod": "enables a mod for the current channel",
    "builtin_command_help_message_disablemod": "disables a mod for the current channel",
    "builtin_command_help_message_disabledmods": "lists disabled mods for the current channel",
    "builtin_command_help_message_reloadmod": "reloads a specific module (case sensitive) from disk",
    "builtin_command_help_message_listmods": "list all mods currently loaded",
    "builtin_command_help_message_addperm": "adds a permission a group",
    "builtin_command_help_message_delperm": "removes a permission from a group",
    "builtin_command_help_message_addgroup": "adds a permission group",
    "builtin_command_help_message_delgroup": "removes a permission group",
    "builtin_command_help_message_reloadperms": "reloads permissions",
    "builtin_command_help_message_addmember": "adds a member to a permission group",
    "builtin_command_help_message_delmember": "removes a member from a permission group",
    "builtin_command_help_message_startpoll": "starts the poll for the the current channel",
    "builtin_command_help_message_vote": "register a vote for the given choice if inside of the poll specified by <poll_id>",
    "builtin_command_help_message_listpolls": "list all active polls",
    "builtin_command_help_message_pollinfo": "views info about the poll using the passed poll id",
    "builtin_command_help_message_addquote": "adds a quote to the database",
    "builtin_command_help_message_quote": "gets a quote by ID or ALIAS",
    "builtin_command_help_message_delquote": "deletes the quote from the database",
    "builtin_command_help_message_addtimer": "adds a message timer",
    "builtin_command_help_message_starttimer": "starts a message timer",
    "builtin_command_help_message_stoptimer": "stops a message timer",
    "builtin_command_help_message_deltimer": "deletes a message timer",
    "builtin_command_help_message_edittimer": "edits a timer's message or interval",
    "builtin_command_help_message_listtimers": "list all message timers for the current channel",
    "duel_cannot_send_not_enough_balance": "you do not have enough {curname} to send a duel request for {bet} {curname}",
    "duel_negative_or_zero_bet": "bets must must be positive and not zero",
    "auto_cast_fail_number": "\"{arg_value}\" is not a valid number for parameter \"{arg_param_name}\"",
    "args_does_not_fulfill_required_position_args": "missing required arguments, requires: {required_count}, but actually got: {args_len}"
}
