#    Copyright 2023 SECTRA AB
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

"""Json schema for complete WsiMetadata."""

from marshmallow import fields

from wsidicom.metadata.equipment import Equipment
from wsidicom.metadata.image import Image
from wsidicom.metadata.label import Label
from wsidicom.metadata.patient import Patient
from wsidicom.metadata.pyramid import Pyramid
from wsidicom.metadata.schema.common import LoadingSchema
from wsidicom.metadata.schema.json.equipment import EquipmentJsonSchema
from wsidicom.metadata.schema.json.fields import UidJsonField
from wsidicom.metadata.schema.json.label import LabelJsonSchema
from wsidicom.metadata.schema.json.overview import OverviewJsonSchema
from wsidicom.metadata.schema.json.patient import PatientJsonSchema
from wsidicom.metadata.schema.json.pyramid import PyramidJsonSchema
from wsidicom.metadata.schema.json.series import SeriesJsonSchema
from wsidicom.metadata.schema.json.slide import SlideJsonSchema
from wsidicom.metadata.schema.json.study import StudyJsonSchema
from wsidicom.metadata.series import Series
from wsidicom.metadata.slide import Slide
from wsidicom.metadata.study import Study
from wsidicom.metadata.wsi import WsiMetadata


class WsiMetadataJsonSchema(LoadingSchema[WsiMetadata]):
    study = fields.Nested(StudyJsonSchema(), load_default=Study())
    series = fields.Nested(SeriesJsonSchema(), load_default=Series())
    patient = fields.Nested(PatientJsonSchema(), load_default=Patient())
    equipment = fields.Nested(EquipmentJsonSchema(), load_default=Equipment())
    slide = fields.Nested(SlideJsonSchema(), load_default=Slide())
    pyramid = fields.Nested(
        PyramidJsonSchema(), load_default=Pyramid(image=Image(), optical_paths=[])
    )
    label = fields.Nested(LabelJsonSchema(), load_default=Label())
    overview = fields.Nested(OverviewJsonSchema(), load_default=None, allow_none=True)
    frame_of_reference_uid = UidJsonField(allow_none=True)
    dimension_organization_uids = fields.List(UidJsonField(), allow_none=True)

    @property
    def load_type(self):
        return WsiMetadata
