from dataclasses import dataclass
from typing import TypedDict

from dataclasses_json import dataclass_json


class ComposeMessageRequest(TypedDict):
    """
    A request to compose a message.

    Attributes:
        prompt: The prompt that smart compose will use to generate a message suggestion.
    """

    prompt: str


@dataclass_json
@dataclass
class ComposeMessageResponse:
    """
    A response from composing a message.

    Attributes:
        suggestion: The message suggestion generated by smart compose.
    """

    suggestion: str
