# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AddressArgs', 'Address']

@pulumi.input_type
class AddressArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_wildcard: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Address resource.
        :param pulumi.Input[_builtins.str] description: The description of the address object
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] fqdn: Fully qualified domain name
        :param pulumi.Input[_builtins.str] ip_netmask: IP address with or without CIDR notation
        :param pulumi.Input[_builtins.str] ip_range: Ip range
        :param pulumi.Input[_builtins.str] ip_wildcard: IP wildcard mask
        :param pulumi.Input[_builtins.str] name: The name of the address object
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags assocaited with the address object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_netmask is not None:
            pulumi.set(__self__, "ip_netmask", ip_netmask)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if ip_wildcard is not None:
            pulumi.set(__self__, "ip_wildcard", ip_wildcard)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the address object
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="ipNetmask")
    def ip_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address with or without CIDR notation
        """
        return pulumi.get(self, "ip_netmask")

    @ip_netmask.setter
    def ip_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_netmask", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip range
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter(name="ipWildcard")
    def ip_wildcard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP wildcard mask
        """
        return pulumi.get(self, "ip_wildcard")

    @ip_wildcard.setter
    def ip_wildcard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_wildcard", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the address object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags assocaited with the address object
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AddressState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_wildcard: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Address resources.
        :param pulumi.Input[_builtins.str] description: The description of the address object
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] fqdn: Fully qualified domain name
        :param pulumi.Input[_builtins.str] ip_netmask: IP address with or without CIDR notation
        :param pulumi.Input[_builtins.str] ip_range: Ip range
        :param pulumi.Input[_builtins.str] ip_wildcard: IP wildcard mask
        :param pulumi.Input[_builtins.str] name: The name of the address object
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags assocaited with the address object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_netmask is not None:
            pulumi.set(__self__, "ip_netmask", ip_netmask)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if ip_wildcard is not None:
            pulumi.set(__self__, "ip_wildcard", ip_wildcard)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the address object
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="ipNetmask")
    def ip_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address with or without CIDR notation
        """
        return pulumi.get(self, "ip_netmask")

    @ip_netmask.setter
    def ip_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_netmask", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip range
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter(name="ipWildcard")
    def ip_wildcard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP wildcard mask
        """
        return pulumi.get(self, "ip_wildcard")

    @ip_wildcard.setter
    def ip_wildcard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_wildcard", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the address object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags assocaited with the address object
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/address:Address")
class Address(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_wildcard: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Address resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # This file is embedded using go:embed
        scm_addr_tag1 = scm.Tag("scm_addr_tag_1",
            folder="All",
            name="scm_addr_tag_1",
            color="Red")
        scm_addr_tag2 = scm.Tag("scm_addr_tag_2",
            folder="All",
            name="scm_addr_tag_2",
            color="Blue")
        scm_addr_tag3 = scm.Tag("scm_addr_tag_3",
            folder="All",
            name="scm_addr_tag_3",
            color="Orange")
        # IP Netmask
        scm_address1 = scm.Address("scm_address_1",
            folder="Shared",
            name="scm_address_1",
            description="Made by Pulumi",
            ip_netmask="10.2.3.4")
        # IP Range
        scm_address2 = scm.Address("scm_address_2",
            folder="Shared",
            name="scm_address_2",
            description="Small IP range test",
            ip_range="192.168.1.10-192.168.1.20")
        # FQDN
        scm_address3 = scm.Address("scm_address_3",
            folder="Shared",
            name="scm_address_3",
            description="Simple FQDN test",
            fqdn="example.com")
        # Class C wildcard
        scm_address4 = scm.Address("scm_address_4",
            folder="Shared",
            name="scm_address_4",
            description="Class C wildcard test",
            ip_wildcard="192.168.1.0/0.0.0.255")
        # Multiple tags
        scm_address5 = scm.Address("scm_address_5",
            folder="Shared",
            name="scm_address_5",
            description="Multiple tags test",
            ip_netmask="10.10.10.2/32",
            tags=[
                scm_addr_tag1.name,
                scm_addr_tag2.name,
                scm_addr_tag3.name,
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    scm_addr_tag1,
                    scm_addr_tag2,
                    scm_addr_tag3,
                ]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the address object
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] fqdn: Fully qualified domain name
        :param pulumi.Input[_builtins.str] ip_netmask: IP address with or without CIDR notation
        :param pulumi.Input[_builtins.str] ip_range: Ip range
        :param pulumi.Input[_builtins.str] ip_wildcard: IP wildcard mask
        :param pulumi.Input[_builtins.str] name: The name of the address object
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags assocaited with the address object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Address resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # This file is embedded using go:embed
        scm_addr_tag1 = scm.Tag("scm_addr_tag_1",
            folder="All",
            name="scm_addr_tag_1",
            color="Red")
        scm_addr_tag2 = scm.Tag("scm_addr_tag_2",
            folder="All",
            name="scm_addr_tag_2",
            color="Blue")
        scm_addr_tag3 = scm.Tag("scm_addr_tag_3",
            folder="All",
            name="scm_addr_tag_3",
            color="Orange")
        # IP Netmask
        scm_address1 = scm.Address("scm_address_1",
            folder="Shared",
            name="scm_address_1",
            description="Made by Pulumi",
            ip_netmask="10.2.3.4")
        # IP Range
        scm_address2 = scm.Address("scm_address_2",
            folder="Shared",
            name="scm_address_2",
            description="Small IP range test",
            ip_range="192.168.1.10-192.168.1.20")
        # FQDN
        scm_address3 = scm.Address("scm_address_3",
            folder="Shared",
            name="scm_address_3",
            description="Simple FQDN test",
            fqdn="example.com")
        # Class C wildcard
        scm_address4 = scm.Address("scm_address_4",
            folder="Shared",
            name="scm_address_4",
            description="Class C wildcard test",
            ip_wildcard="192.168.1.0/0.0.0.255")
        # Multiple tags
        scm_address5 = scm.Address("scm_address_5",
            folder="Shared",
            name="scm_address_5",
            description="Multiple tags test",
            ip_netmask="10.10.10.2/32",
            tags=[
                scm_addr_tag1.name,
                scm_addr_tag2.name,
                scm_addr_tag3.name,
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    scm_addr_tag1,
                    scm_addr_tag2,
                    scm_addr_tag3,
                ]))
        ```

        :param str resource_name: The name of the resource.
        :param AddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_wildcard: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressArgs.__new__(AddressArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["fqdn"] = fqdn
            __props__.__dict__["ip_netmask"] = ip_netmask
            __props__.__dict__["ip_range"] = ip_range
            __props__.__dict__["ip_wildcard"] = ip_wildcard
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tfid"] = None
        super(Address, __self__).__init__(
            'scm:index/address:Address',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            ip_netmask: Optional[pulumi.Input[_builtins.str]] = None,
            ip_range: Optional[pulumi.Input[_builtins.str]] = None,
            ip_wildcard: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'Address':
        """
        Get an existing Address resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the address object
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] fqdn: Fully qualified domain name
        :param pulumi.Input[_builtins.str] ip_netmask: IP address with or without CIDR notation
        :param pulumi.Input[_builtins.str] ip_range: Ip range
        :param pulumi.Input[_builtins.str] ip_wildcard: IP wildcard mask
        :param pulumi.Input[_builtins.str] name: The name of the address object
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags assocaited with the address object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressState.__new__(_AddressState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["ip_netmask"] = ip_netmask
        __props__.__dict__["ip_range"] = ip_range
        __props__.__dict__["ip_wildcard"] = ip_wildcard
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tfid"] = tfid
        return Address(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the address object
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Fully qualified domain name
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="ipNetmask")
    def ip_netmask(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP address with or without CIDR notation
        """
        return pulumi.get(self, "ip_netmask")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Ip range
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter(name="ipWildcard")
    def ip_wildcard(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP wildcard mask
        """
        return pulumi.get(self, "ip_wildcard")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the address object
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags assocaited with the address object
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

