# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AntiSpywareProfileArgs', 'AntiSpywareProfile']

@pulumi.input_type
class AntiSpywareProfileArgs:
    def __init__(__self__, *,
                 cloud_inline_analysis: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_exception_edl_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_exception_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mica_engine_spyware_enableds: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]]] = None):
        """
        The set of arguments for constructing a AntiSpywareProfile resource.
        :param pulumi.Input[_builtins.bool] cloud_inline_analysis: Cloud inline analysis
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_edl_urls: Inline exception edl url
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_ip_addresses: Inline exception ip address
        :param pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]] mica_engine_spyware_enableds: Mica engine spyware enabled
        :param pulumi.Input[_builtins.str] name: The name of the anti-spyware profile
        :param pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]] threat_exceptions: Threat exception
        """
        if cloud_inline_analysis is not None:
            pulumi.set(__self__, "cloud_inline_analysis", cloud_inline_analysis)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if inline_exception_edl_urls is not None:
            pulumi.set(__self__, "inline_exception_edl_urls", inline_exception_edl_urls)
        if inline_exception_ip_addresses is not None:
            pulumi.set(__self__, "inline_exception_ip_addresses", inline_exception_ip_addresses)
        if mica_engine_spyware_enableds is not None:
            pulumi.set(__self__, "mica_engine_spyware_enableds", mica_engine_spyware_enableds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if threat_exceptions is not None:
            pulumi.set(__self__, "threat_exceptions", threat_exceptions)

    @_builtins.property
    @pulumi.getter(name="cloudInlineAnalysis")
    def cloud_inline_analysis(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cloud inline analysis
        """
        return pulumi.get(self, "cloud_inline_analysis")

    @cloud_inline_analysis.setter
    def cloud_inline_analysis(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_inline_analysis", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="inlineExceptionEdlUrls")
    def inline_exception_edl_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Inline exception edl url
        """
        return pulumi.get(self, "inline_exception_edl_urls")

    @inline_exception_edl_urls.setter
    def inline_exception_edl_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inline_exception_edl_urls", value)

    @_builtins.property
    @pulumi.getter(name="inlineExceptionIpAddresses")
    def inline_exception_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Inline exception ip address
        """
        return pulumi.get(self, "inline_exception_ip_addresses")

    @inline_exception_ip_addresses.setter
    def inline_exception_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inline_exception_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="micaEngineSpywareEnableds")
    def mica_engine_spyware_enableds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]]]:
        """
        Mica engine spyware enabled
        """
        return pulumi.get(self, "mica_engine_spyware_enableds")

    @mica_engine_spyware_enableds.setter
    def mica_engine_spyware_enableds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]]]):
        pulumi.set(self, "mica_engine_spyware_enableds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the anti-spyware profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]]]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]]]:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")

    @threat_exceptions.setter
    def threat_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]]]):
        pulumi.set(self, "threat_exceptions", value)


@pulumi.input_type
class _AntiSpywareProfileState:
    def __init__(__self__, *,
                 cloud_inline_analysis: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_exception_edl_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_exception_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mica_engine_spyware_enableds: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering AntiSpywareProfile resources.
        :param pulumi.Input[_builtins.bool] cloud_inline_analysis: Cloud inline analysis
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_edl_urls: Inline exception edl url
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_ip_addresses: Inline exception ip address
        :param pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]] mica_engine_spyware_enableds: Mica engine spyware enabled
        :param pulumi.Input[_builtins.str] name: The name of the anti-spyware profile
        :param pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]] threat_exceptions: Threat exception
        """
        if cloud_inline_analysis is not None:
            pulumi.set(__self__, "cloud_inline_analysis", cloud_inline_analysis)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if inline_exception_edl_urls is not None:
            pulumi.set(__self__, "inline_exception_edl_urls", inline_exception_edl_urls)
        if inline_exception_ip_addresses is not None:
            pulumi.set(__self__, "inline_exception_ip_addresses", inline_exception_ip_addresses)
        if mica_engine_spyware_enableds is not None:
            pulumi.set(__self__, "mica_engine_spyware_enableds", mica_engine_spyware_enableds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if threat_exceptions is not None:
            pulumi.set(__self__, "threat_exceptions", threat_exceptions)

    @_builtins.property
    @pulumi.getter(name="cloudInlineAnalysis")
    def cloud_inline_analysis(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cloud inline analysis
        """
        return pulumi.get(self, "cloud_inline_analysis")

    @cloud_inline_analysis.setter
    def cloud_inline_analysis(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_inline_analysis", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="inlineExceptionEdlUrls")
    def inline_exception_edl_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Inline exception edl url
        """
        return pulumi.get(self, "inline_exception_edl_urls")

    @inline_exception_edl_urls.setter
    def inline_exception_edl_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inline_exception_edl_urls", value)

    @_builtins.property
    @pulumi.getter(name="inlineExceptionIpAddresses")
    def inline_exception_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Inline exception ip address
        """
        return pulumi.get(self, "inline_exception_ip_addresses")

    @inline_exception_ip_addresses.setter
    def inline_exception_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inline_exception_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="micaEngineSpywareEnableds")
    def mica_engine_spyware_enableds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]]]:
        """
        Mica engine spyware enabled
        """
        return pulumi.get(self, "mica_engine_spyware_enableds")

    @mica_engine_spyware_enableds.setter
    def mica_engine_spyware_enableds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileMicaEngineSpywareEnabledArgs']]]]):
        pulumi.set(self, "mica_engine_spyware_enableds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the anti-spyware profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]]]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]]]:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")

    @threat_exceptions.setter
    def threat_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiSpywareProfileThreatExceptionArgs']]]]):
        pulumi.set(self, "threat_exceptions", value)


@pulumi.type_token("scm:index/antiSpywareProfile:AntiSpywareProfile")
class AntiSpywareProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_inline_analysis: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_exception_edl_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_exception_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mica_engine_spyware_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileMicaEngineSpywareEnabledArgs', 'AntiSpywareProfileMicaEngineSpywareEnabledArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileRuleArgs', 'AntiSpywareProfileRuleArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileThreatExceptionArgs', 'AntiSpywareProfileThreatExceptionArgsDict']]]]] = None,
                 __props__=None):
        """
        AntiSpywareProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # Basic Anti-Spyware Profile
        scm_anti_spyware_profile1 = scm.AntiSpywareProfile("scm_anti_spyware_profile_1",
            folder="All",
            name="scm_anti_spyware_profile_1",
            description="Managed by Pulumi",
            cloud_inline_analysis=True)
        # Required object that will be referenced in examples
        scm_address1 = scm.Address("scm_address_1",
            folder="Shared",
            name="scm_address_1",
            description="Made by Pulumi",
            ip_netmask="10.2.3.4")
        # Anti-Spyware Profile with exception EDL
        scm_anti_spyware_profile2 = scm.AntiSpywareProfile("scm_anti_spyware_profile_2",
            folder="All",
            name="scm_anti_spyware_profile_2",
            description="Managed by Pulumi",
            cloud_inline_analysis=True,
            inline_exception_ip_addresses=["scm_address_1"],
            opts = pulumi.ResourceOptions(depends_on=[scm_address1]))
        # Anti-Spyware Profile with rules
        scm_anti_spyware_profile3 = scm.AntiSpywareProfile("scm_anti_spyware_profile_3",
            folder="All",
            name="scm_anti_spyware_profile_3",
            description="Managed by Pulumi",
            cloud_inline_analysis=True,
            rules=[{
                "name": "Custom Rule",
                "notes": "Managed by Pulumi",
                "packet_capture": "single-packet",
                "category": "net-worm",
                "severity": ["critical"],
                "threat_name": "data-theft",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cloud_inline_analysis: Cloud inline analysis
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_edl_urls: Inline exception edl url
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_ip_addresses: Inline exception ip address
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileMicaEngineSpywareEnabledArgs', 'AntiSpywareProfileMicaEngineSpywareEnabledArgsDict']]]] mica_engine_spyware_enableds: Mica engine spyware enabled
        :param pulumi.Input[_builtins.str] name: The name of the anti-spyware profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileRuleArgs', 'AntiSpywareProfileRuleArgsDict']]]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileThreatExceptionArgs', 'AntiSpywareProfileThreatExceptionArgsDict']]]] threat_exceptions: Threat exception
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AntiSpywareProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AntiSpywareProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # Basic Anti-Spyware Profile
        scm_anti_spyware_profile1 = scm.AntiSpywareProfile("scm_anti_spyware_profile_1",
            folder="All",
            name="scm_anti_spyware_profile_1",
            description="Managed by Pulumi",
            cloud_inline_analysis=True)
        # Required object that will be referenced in examples
        scm_address1 = scm.Address("scm_address_1",
            folder="Shared",
            name="scm_address_1",
            description="Made by Pulumi",
            ip_netmask="10.2.3.4")
        # Anti-Spyware Profile with exception EDL
        scm_anti_spyware_profile2 = scm.AntiSpywareProfile("scm_anti_spyware_profile_2",
            folder="All",
            name="scm_anti_spyware_profile_2",
            description="Managed by Pulumi",
            cloud_inline_analysis=True,
            inline_exception_ip_addresses=["scm_address_1"],
            opts = pulumi.ResourceOptions(depends_on=[scm_address1]))
        # Anti-Spyware Profile with rules
        scm_anti_spyware_profile3 = scm.AntiSpywareProfile("scm_anti_spyware_profile_3",
            folder="All",
            name="scm_anti_spyware_profile_3",
            description="Managed by Pulumi",
            cloud_inline_analysis=True,
            rules=[{
                "name": "Custom Rule",
                "notes": "Managed by Pulumi",
                "packet_capture": "single-packet",
                "category": "net-worm",
                "severity": ["critical"],
                "threat_name": "data-theft",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param AntiSpywareProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AntiSpywareProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_inline_analysis: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_exception_edl_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inline_exception_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mica_engine_spyware_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileMicaEngineSpywareEnabledArgs', 'AntiSpywareProfileMicaEngineSpywareEnabledArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileRuleArgs', 'AntiSpywareProfileRuleArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileThreatExceptionArgs', 'AntiSpywareProfileThreatExceptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AntiSpywareProfileArgs.__new__(AntiSpywareProfileArgs)

            __props__.__dict__["cloud_inline_analysis"] = cloud_inline_analysis
            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["inline_exception_edl_urls"] = inline_exception_edl_urls
            __props__.__dict__["inline_exception_ip_addresses"] = inline_exception_ip_addresses
            __props__.__dict__["mica_engine_spyware_enableds"] = mica_engine_spyware_enableds
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["threat_exceptions"] = threat_exceptions
            __props__.__dict__["tfid"] = None
        super(AntiSpywareProfile, __self__).__init__(
            'scm:index/antiSpywareProfile:AntiSpywareProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_inline_analysis: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            inline_exception_edl_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            inline_exception_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mica_engine_spyware_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileMicaEngineSpywareEnabledArgs', 'AntiSpywareProfileMicaEngineSpywareEnabledArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileRuleArgs', 'AntiSpywareProfileRuleArgsDict']]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileThreatExceptionArgs', 'AntiSpywareProfileThreatExceptionArgsDict']]]]] = None) -> 'AntiSpywareProfile':
        """
        Get an existing AntiSpywareProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cloud_inline_analysis: Cloud inline analysis
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_edl_urls: Inline exception edl url
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inline_exception_ip_addresses: Inline exception ip address
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileMicaEngineSpywareEnabledArgs', 'AntiSpywareProfileMicaEngineSpywareEnabledArgsDict']]]] mica_engine_spyware_enableds: Mica engine spyware enabled
        :param pulumi.Input[_builtins.str] name: The name of the anti-spyware profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileRuleArgs', 'AntiSpywareProfileRuleArgsDict']]]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiSpywareProfileThreatExceptionArgs', 'AntiSpywareProfileThreatExceptionArgsDict']]]] threat_exceptions: Threat exception
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AntiSpywareProfileState.__new__(_AntiSpywareProfileState)

        __props__.__dict__["cloud_inline_analysis"] = cloud_inline_analysis
        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["inline_exception_edl_urls"] = inline_exception_edl_urls
        __props__.__dict__["inline_exception_ip_addresses"] = inline_exception_ip_addresses
        __props__.__dict__["mica_engine_spyware_enableds"] = mica_engine_spyware_enableds
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["threat_exceptions"] = threat_exceptions
        return AntiSpywareProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudInlineAnalysis")
    def cloud_inline_analysis(self) -> pulumi.Output[_builtins.bool]:
        """
        Cloud inline analysis
        """
        return pulumi.get(self, "cloud_inline_analysis")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="inlineExceptionEdlUrls")
    def inline_exception_edl_urls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Inline exception edl url
        """
        return pulumi.get(self, "inline_exception_edl_urls")

    @_builtins.property
    @pulumi.getter(name="inlineExceptionIpAddresses")
    def inline_exception_ip_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Inline exception ip address
        """
        return pulumi.get(self, "inline_exception_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="micaEngineSpywareEnableds")
    def mica_engine_spyware_enableds(self) -> pulumi.Output[Optional[Sequence['outputs.AntiSpywareProfileMicaEngineSpywareEnabled']]]:
        """
        Mica engine spyware enabled
        """
        return pulumi.get(self, "mica_engine_spyware_enableds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the anti-spyware profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.AntiSpywareProfileRule']]]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> pulumi.Output[Optional[Sequence['outputs.AntiSpywareProfileThreatException']]]:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")

