# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AuthenticationRuleArgs', 'AuthenticationRule']

@pulumi.input_type
class AuthenticationRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 froms: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 services: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 tos: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 authentication_enforcement: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 hip_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_authentication_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AuthenticationRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zones
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination ports
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zones
        :param pulumi.Input[_builtins.str] authentication_enforcement: The authentication profile name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL categories
        :param pulumi.Input[_builtins.str] description: The description of the authentication rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The destination Host Integrity Profile (HIP)
        :param pulumi.Input[_builtins.str] device: Device
        :param pulumi.Input[_builtins.bool] disabled: Is the authentication rule disabled?
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[_builtins.str] group_tag: Group tag
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hip_profiles: The source Host Integrity Profile (HIP)
        :param pulumi.Input[_builtins.bool] log_authentication_timeout: Log authentication timeouts?
        :param pulumi.Input[_builtins.str] log_setting: The log forwarding profile name
        :param pulumi.Input[_builtins.str] name: The name of the authentication rule
        :param pulumi.Input[_builtins.bool] negate_destination: Are the destination addresses negated?
        :param pulumi.Input[_builtins.bool] negate_source: Are the source addresses negated?
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[_builtins.str] snippet: Snippet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: The source Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: The source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The authentication rule tags
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[_builtins.int] timeout: The authentication session timeout (seconds)
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "tos", tos)
        if authentication_enforcement is not None:
            pulumi.set(__self__, "authentication_enforcement", authentication_enforcement)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_hips is not None:
            pulumi.set(__self__, "destination_hips", destination_hips)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if group_tag is not None:
            pulumi.set(__self__, "group_tag", group_tag)
        if hip_profiles is not None:
            pulumi.set(__self__, "hip_profiles", hip_profiles)
        if log_authentication_timeout is not None:
            pulumi.set(__self__, "log_authentication_timeout", log_authentication_timeout)
        if log_setting is not None:
            pulumi.set(__self__, "log_setting", log_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if relative_position is not None:
            pulumi.set(__self__, "relative_position", relative_position)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_hips is not None:
            pulumi.set(__self__, "source_hips", source_hips)
        if source_users is not None:
            pulumi.set(__self__, "source_users", source_users)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_rule is not None:
            pulumi.set(__self__, "target_rule", target_rule)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The source security zones
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination ports
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination security zones
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tos", value)

    @_builtins.property
    @pulumi.getter(name="authenticationEnforcement")
    def authentication_enforcement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication profile name
        """
        return pulumi.get(self, "authentication_enforcement")

    @authentication_enforcement.setter
    def authentication_enforcement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_enforcement", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination URL categories
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the authentication rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "destination_hips")

    @destination_hips.setter
    def destination_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_hips", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the authentication rule disabled?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group tag
        """
        return pulumi.get(self, "group_tag")

    @group_tag.setter
    def group_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_tag", value)

    @_builtins.property
    @pulumi.getter(name="hipProfiles")
    def hip_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "hip_profiles")

    @hip_profiles.setter
    def hip_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hip_profiles", value)

    @_builtins.property
    @pulumi.getter(name="logAuthenticationTimeout")
    def log_authentication_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log authentication timeouts?
        """
        return pulumi.get(self, "log_authentication_timeout")

    @log_authentication_timeout.setter
    def log_authentication_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_authentication_timeout", value)

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log forwarding profile name
        """
        return pulumi.get(self, "log_setting")

    @log_setting.setter
    def log_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_setting", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the authentication rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are the destination addresses negated?
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are the source addresses negated?
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @relative_position.setter
    def relative_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relative_position", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snippet
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "source_hips")

    @source_hips.setter
    def source_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_hips", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source users
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The authentication rule tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @target_rule.setter
    def target_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_rule", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The authentication session timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _AuthenticationRuleState:
    def __init__(__self__, *,
                 authentication_enforcement: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 hip_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_authentication_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AuthenticationRule resources.
        :param pulumi.Input[_builtins.str] authentication_enforcement: The authentication profile name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL categories
        :param pulumi.Input[_builtins.str] description: The description of the authentication rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The destination Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[_builtins.str] device: Device
        :param pulumi.Input[_builtins.bool] disabled: Is the authentication rule disabled?
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zones
        :param pulumi.Input[_builtins.str] group_tag: Group tag
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hip_profiles: The source Host Integrity Profile (HIP)
        :param pulumi.Input[_builtins.bool] log_authentication_timeout: Log authentication timeouts?
        :param pulumi.Input[_builtins.str] log_setting: The log forwarding profile name
        :param pulumi.Input[_builtins.str] name: The name of the authentication rule
        :param pulumi.Input[_builtins.bool] negate_destination: Are the destination addresses negated?
        :param pulumi.Input[_builtins.bool] negate_source: Are the source addresses negated?
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination ports
        :param pulumi.Input[_builtins.str] snippet: Snippet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: The source Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: The source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The authentication rule tags
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[_builtins.int] timeout: The authentication session timeout (seconds)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zones
        """
        if authentication_enforcement is not None:
            pulumi.set(__self__, "authentication_enforcement", authentication_enforcement)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_hips is not None:
            pulumi.set(__self__, "destination_hips", destination_hips)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if group_tag is not None:
            pulumi.set(__self__, "group_tag", group_tag)
        if hip_profiles is not None:
            pulumi.set(__self__, "hip_profiles", hip_profiles)
        if log_authentication_timeout is not None:
            pulumi.set(__self__, "log_authentication_timeout", log_authentication_timeout)
        if log_setting is not None:
            pulumi.set(__self__, "log_setting", log_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if relative_position is not None:
            pulumi.set(__self__, "relative_position", relative_position)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_hips is not None:
            pulumi.set(__self__, "source_hips", source_hips)
        if source_users is not None:
            pulumi.set(__self__, "source_users", source_users)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_rule is not None:
            pulumi.set(__self__, "target_rule", target_rule)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter(name="authenticationEnforcement")
    def authentication_enforcement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication profile name
        """
        return pulumi.get(self, "authentication_enforcement")

    @authentication_enforcement.setter
    def authentication_enforcement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_enforcement", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination URL categories
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the authentication rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "destination_hips")

    @destination_hips.setter
    def destination_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_hips", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the authentication rule disabled?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source security zones
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group tag
        """
        return pulumi.get(self, "group_tag")

    @group_tag.setter
    def group_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_tag", value)

    @_builtins.property
    @pulumi.getter(name="hipProfiles")
    def hip_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "hip_profiles")

    @hip_profiles.setter
    def hip_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hip_profiles", value)

    @_builtins.property
    @pulumi.getter(name="logAuthenticationTimeout")
    def log_authentication_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log authentication timeouts?
        """
        return pulumi.get(self, "log_authentication_timeout")

    @log_authentication_timeout.setter
    def log_authentication_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_authentication_timeout", value)

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log forwarding profile name
        """
        return pulumi.get(self, "log_setting")

    @log_setting.setter
    def log_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_setting", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the authentication rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are the destination addresses negated?
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are the source addresses negated?
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @relative_position.setter
    def relative_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relative_position", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination ports
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snippet
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "source_hips")

    @source_hips.setter
    def source_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_hips", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source users
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The authentication rule tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @target_rule.setter
    def target_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_rule", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The authentication session timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination security zones
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tos", value)


@pulumi.type_token("scm:index/authenticationRule:AuthenticationRule")
class AuthenticationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_enforcement: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 hip_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_authentication_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        AuthenticationRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        app_access_tag = scm.Tag("app_access_tag",
            folder="All",
            name="app-access-test_25",
            color="Blue")
        # -----------------------------------------------------------------------------
        # 2. ANCHOR RULE (Used for relative positioning by other rules)
        # -----------------------------------------------------------------------------
        anchor_rule = scm.AuthenticationRule("anchor_rule",
            name="test_anchor_rule_251",
            description="Base rule. Used to test 'before' and 'after' positioning",
            position="pre",
            folder="All",
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=[
                "service-http",
                "service-https",
            ],
            source_users=["any"],
            timeout=1200,
            negate_source=False,
            negate_destination=False,
            tags=[app_access_tag.name],
            categories=["any"],
            destination_hips=["any"],
            log_authentication_timeout=False,
            disabled=False)
        # # -----------------------------------------------------------------------------
        # # 3. ABSOLUTE POSITIONING Examples ("top" and "bottom")
        # # -----------------------------------------------------------------------------
        rule_top_of_list = scm.AuthenticationRule("rule_top_of_list",
            name="test_top_rule_25",
            description="Placed at the very top of the 'pre' rulebase.",
            folder="All",
            position="pre",
            relative_position="top",
            destinations=["any"],
            froms=["untrust"],
            tos=["trust"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        rule_bottom_of_list = scm.AuthenticationRule("rule_bottom_of_list",
            name="test_bottom_rule_25",
            description="Placed at the very bottom of the 'pre' rulebase.",
            folder="All",
            position="pre",
            relative_position="bottom",
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        # -----------------------------------------------------------------------------
        # 4. RELATIVE POSITIONING Examples ("before" and "after")
        # -----------------------------------------------------------------------------
        rule_before_anchor = scm.AuthenticationRule("rule_before_anchor",
            name="test_before_rule_25_updating",
            description="Positioned immediately BEFORE the anchor_rule.",
            folder="All",
            position="pre",
            relative_position="before",
            target_rule=anchor_rule.id,
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        rule_after_anchor = scm.AuthenticationRule("rule_after_anchor",
            name="test_after_rule_25",
            description="Positioned immediately AFTER the anchor_rule.",
            folder="All",
            position="pre",
            relative_position="after",
            target_rule=anchor_rule.id,
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_enforcement: The authentication profile name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL categories
        :param pulumi.Input[_builtins.str] description: The description of the authentication rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The destination Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[_builtins.str] device: Device
        :param pulumi.Input[_builtins.bool] disabled: Is the authentication rule disabled?
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zones
        :param pulumi.Input[_builtins.str] group_tag: Group tag
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hip_profiles: The source Host Integrity Profile (HIP)
        :param pulumi.Input[_builtins.bool] log_authentication_timeout: Log authentication timeouts?
        :param pulumi.Input[_builtins.str] log_setting: The log forwarding profile name
        :param pulumi.Input[_builtins.str] name: The name of the authentication rule
        :param pulumi.Input[_builtins.bool] negate_destination: Are the destination addresses negated?
        :param pulumi.Input[_builtins.bool] negate_source: Are the source addresses negated?
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination ports
        :param pulumi.Input[_builtins.str] snippet: Snippet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: The source Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: The source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The authentication rule tags
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[_builtins.int] timeout: The authentication session timeout (seconds)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zones
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AuthenticationRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        app_access_tag = scm.Tag("app_access_tag",
            folder="All",
            name="app-access-test_25",
            color="Blue")
        # -----------------------------------------------------------------------------
        # 2. ANCHOR RULE (Used for relative positioning by other rules)
        # -----------------------------------------------------------------------------
        anchor_rule = scm.AuthenticationRule("anchor_rule",
            name="test_anchor_rule_251",
            description="Base rule. Used to test 'before' and 'after' positioning",
            position="pre",
            folder="All",
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=[
                "service-http",
                "service-https",
            ],
            source_users=["any"],
            timeout=1200,
            negate_source=False,
            negate_destination=False,
            tags=[app_access_tag.name],
            categories=["any"],
            destination_hips=["any"],
            log_authentication_timeout=False,
            disabled=False)
        # # -----------------------------------------------------------------------------
        # # 3. ABSOLUTE POSITIONING Examples ("top" and "bottom")
        # # -----------------------------------------------------------------------------
        rule_top_of_list = scm.AuthenticationRule("rule_top_of_list",
            name="test_top_rule_25",
            description="Placed at the very top of the 'pre' rulebase.",
            folder="All",
            position="pre",
            relative_position="top",
            destinations=["any"],
            froms=["untrust"],
            tos=["trust"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        rule_bottom_of_list = scm.AuthenticationRule("rule_bottom_of_list",
            name="test_bottom_rule_25",
            description="Placed at the very bottom of the 'pre' rulebase.",
            folder="All",
            position="pre",
            relative_position="bottom",
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        # -----------------------------------------------------------------------------
        # 4. RELATIVE POSITIONING Examples ("before" and "after")
        # -----------------------------------------------------------------------------
        rule_before_anchor = scm.AuthenticationRule("rule_before_anchor",
            name="test_before_rule_25_updating",
            description="Positioned immediately BEFORE the anchor_rule.",
            folder="All",
            position="pre",
            relative_position="before",
            target_rule=anchor_rule.id,
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        rule_after_anchor = scm.AuthenticationRule("rule_after_anchor",
            name="test_after_rule_25",
            description="Positioned immediately AFTER the anchor_rule.",
            folder="All",
            position="pre",
            relative_position="after",
            target_rule=anchor_rule.id,
            destinations=["any"],
            froms=["any"],
            tos=["any"],
            sources=["any"],
            services=["any"],
            source_users=["any"])
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_enforcement: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 hip_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_authentication_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticationRuleArgs.__new__(AuthenticationRuleArgs)

            __props__.__dict__["authentication_enforcement"] = authentication_enforcement
            __props__.__dict__["categories"] = categories
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_hips"] = destination_hips
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["device"] = device
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["folder"] = folder
            if froms is None and not opts.urn:
                raise TypeError("Missing required property 'froms'")
            __props__.__dict__["froms"] = froms
            __props__.__dict__["group_tag"] = group_tag
            __props__.__dict__["hip_profiles"] = hip_profiles
            __props__.__dict__["log_authentication_timeout"] = log_authentication_timeout
            __props__.__dict__["log_setting"] = log_setting
            __props__.__dict__["name"] = name
            __props__.__dict__["negate_destination"] = negate_destination
            __props__.__dict__["negate_source"] = negate_source
            __props__.__dict__["position"] = position
            __props__.__dict__["relative_position"] = relative_position
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["source_hips"] = source_hips
            __props__.__dict__["source_users"] = source_users
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_rule"] = target_rule
            __props__.__dict__["timeout"] = timeout
            if tos is None and not opts.urn:
                raise TypeError("Missing required property 'tos'")
            __props__.__dict__["tos"] = tos
            __props__.__dict__["tfid"] = None
        super(AuthenticationRule, __self__).__init__(
            'scm:index/authenticationRule:AuthenticationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_enforcement: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            group_tag: Optional[pulumi.Input[_builtins.str]] = None,
            hip_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_authentication_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
            log_setting: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
            negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            relative_position: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_rule: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AuthenticationRule':
        """
        Get an existing AuthenticationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_enforcement: The authentication profile name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL categories
        :param pulumi.Input[_builtins.str] description: The description of the authentication rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The destination Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[_builtins.str] device: Device
        :param pulumi.Input[_builtins.bool] disabled: Is the authentication rule disabled?
        :param pulumi.Input[_builtins.str] folder: Folder
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zones
        :param pulumi.Input[_builtins.str] group_tag: Group tag
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hip_profiles: The source Host Integrity Profile (HIP)
        :param pulumi.Input[_builtins.bool] log_authentication_timeout: Log authentication timeouts?
        :param pulumi.Input[_builtins.str] log_setting: The log forwarding profile name
        :param pulumi.Input[_builtins.str] name: The name of the authentication rule
        :param pulumi.Input[_builtins.bool] negate_destination: Are the destination addresses negated?
        :param pulumi.Input[_builtins.bool] negate_source: Are the source addresses negated?
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination ports
        :param pulumi.Input[_builtins.str] snippet: Snippet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: The source Host Integrity Profile (HIP)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: The source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The authentication rule tags
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[_builtins.int] timeout: The authentication session timeout (seconds)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zones
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticationRuleState.__new__(_AuthenticationRuleState)

        __props__.__dict__["authentication_enforcement"] = authentication_enforcement
        __props__.__dict__["categories"] = categories
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_hips"] = destination_hips
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["device"] = device
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["folder"] = folder
        __props__.__dict__["froms"] = froms
        __props__.__dict__["group_tag"] = group_tag
        __props__.__dict__["hip_profiles"] = hip_profiles
        __props__.__dict__["log_authentication_timeout"] = log_authentication_timeout
        __props__.__dict__["log_setting"] = log_setting
        __props__.__dict__["name"] = name
        __props__.__dict__["negate_destination"] = negate_destination
        __props__.__dict__["negate_source"] = negate_source
        __props__.__dict__["position"] = position
        __props__.__dict__["relative_position"] = relative_position
        __props__.__dict__["services"] = services
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["source_hips"] = source_hips
        __props__.__dict__["source_users"] = source_users
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_rule"] = target_rule
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tos"] = tos
        return AuthenticationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationEnforcement")
    def authentication_enforcement(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authentication profile name
        """
        return pulumi.get(self, "authentication_enforcement")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The destination URL categories
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the authentication rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The destination Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "destination_hips")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Device
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Is the authentication rule disabled?
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Folder
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The source security zones
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter(name="groupTag")
    def group_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Group tag
        """
        return pulumi.get(self, "group_tag")

    @_builtins.property
    @pulumi.getter(name="hipProfiles")
    def hip_profiles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The source Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "hip_profiles")

    @_builtins.property
    @pulumi.getter(name="logAuthenticationTimeout")
    def log_authentication_timeout(self) -> pulumi.Output[_builtins.bool]:
        """
        Log authentication timeouts?
        """
        return pulumi.get(self, "log_authentication_timeout")

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The log forwarding profile name
        """
        return pulumi.get(self, "log_setting")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the authentication rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> pulumi.Output[_builtins.bool]:
        """
        Are the destination addresses negated?
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> pulumi.Output[_builtins.bool]:
        """
        Are the source addresses negated?
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination ports
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Snippet
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The source Host Integrity Profile (HIP)
        """
        return pulumi.get(self, "source_hips")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The source users
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The authentication rule tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The authentication session timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination security zones
        """
        return pulumi.get(self, "tos")

