# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsSecurityProfileArgs', 'DnsSecurityProfile']

@pulumi.input_type
class DnsSecurityProfileArgs:
    def __init__(__self__, *,
                 botnet_domains: Optional[pulumi.Input['DnsSecurityProfileBotnetDomainsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DnsSecurityProfile resource.
        :param pulumi.Input['DnsSecurityProfileBotnetDomainsArgs'] botnet_domains: Botnet domains
        :param pulumi.Input[_builtins.str] description: The description of the DNS security profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the DNS security profile
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if botnet_domains is not None:
            pulumi.set(__self__, "botnet_domains", botnet_domains)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter(name="botnetDomains")
    def botnet_domains(self) -> Optional[pulumi.Input['DnsSecurityProfileBotnetDomainsArgs']]:
        """
        Botnet domains
        """
        return pulumi.get(self, "botnet_domains")

    @botnet_domains.setter
    def botnet_domains(self, value: Optional[pulumi.Input['DnsSecurityProfileBotnetDomainsArgs']]):
        pulumi.set(self, "botnet_domains", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the DNS security profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DNS security profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)


@pulumi.input_type
class _DnsSecurityProfileState:
    def __init__(__self__, *,
                 botnet_domains: Optional[pulumi.Input['DnsSecurityProfileBotnetDomainsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsSecurityProfile resources.
        :param pulumi.Input['DnsSecurityProfileBotnetDomainsArgs'] botnet_domains: Botnet domains
        :param pulumi.Input[_builtins.str] description: The description of the DNS security profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the DNS security profile
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if botnet_domains is not None:
            pulumi.set(__self__, "botnet_domains", botnet_domains)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="botnetDomains")
    def botnet_domains(self) -> Optional[pulumi.Input['DnsSecurityProfileBotnetDomainsArgs']]:
        """
        Botnet domains
        """
        return pulumi.get(self, "botnet_domains")

    @botnet_domains.setter
    def botnet_domains(self, value: Optional[pulumi.Input['DnsSecurityProfileBotnetDomainsArgs']]):
        pulumi.set(self, "botnet_domains", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the DNS security profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DNS security profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/dnsSecurityProfile:DnsSecurityProfile")
class DnsSecurityProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 botnet_domains: Optional[pulumi.Input[Union['DnsSecurityProfileBotnetDomainsArgs', 'DnsSecurityProfileBotnetDomainsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        DnsSecurityProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_dns_security_profile_base = scm.DnsSecurityProfile("scm_dns_security_profile_base",
            folder="All",
            name="dns_base")
        scm_dns_security_categories = scm.DnsSecurityProfile("scm_dns_security_categories",
            folder="All",
            name="test_dns_sec_categories",
            description="dns security profile w/ dns security categories",
            botnet_domains={
                "dns_security_categories": [
                    {
                        "name": "pan-dns-sec-recent",
                    },
                    {
                        "name": "pan-dns-sec-grayware",
                        "action": "allow",
                        "log_level": "high",
                        "packet_capture": "disable",
                    },
                    {
                        "name": "pan-dns-sec-proxy",
                        "action": "block",
                        "log_level": "default",
                        "packet_capture": "single-packet",
                    },
                    {
                        "name": "pan-dns-sec-phishing",
                        "action": "sinkhole",
                        "log_level": "critical",
                        "packet_capture": "extended-capture",
                    },
                    {
                        "name": "pan-dns-sec-malware",
                        "action": "default",
                        "log_level": "informational",
                        "packet_capture": "disable",
                    },
                ],
            })
        scm_dns_lists = scm.DnsSecurityProfile("scm_dns_lists",
            folder="All",
            name="test_dns_lists",
            description="dns security profile w/ dns lists",
            botnet_domains={
                "dns_lists": [
                    {
                        "name": "default-paloalto-dns",
                        "packetCapture": "disable",
                        "action": {
                            "alert": {},
                        },
                    },
                    {
                        "name": "update-edl",
                        "packetCapture": "extended-capture",
                        "action": {
                            "allow": {},
                        },
                    },
                ],
            })
        scm_dns_sinkhole = scm.DnsSecurityProfile("scm_dns_sinkhole",
            folder="All",
            name="test_dns_sinkhole",
            description="dns security profile w/ sinkhole",
            botnet_domains={
                "sinkhole": {
                    "ipv4_address": "127.0.0.1",
                    "ipv6_address": "::1",
                },
            })
        scm_dns_whitelist = scm.DnsSecurityProfile("scm_dns_whitelist",
            folder="All",
            name="test_dns_whitelist",
            description="dns security profile w/ whitelist",
            botnet_domains={
                "whitelists": [
                    {
                        "name": "example.com",
                    },
                    {
                        "name": "example2.com",
                        "description": "creating whitelist",
                    },
                ],
            })
        scm_dns_all = scm.DnsSecurityProfile("scm_dns_all",
            folder="All",
            name="test_dns_all_test",
            description="dns security profile w/ all",
            botnet_domains={
                "dns_security_categories": [{
                    "name": "pan-dns-sec-ddns",
                    "action": "block",
                    "log_level": "low",
                    "packet_capture": "disable",
                }],
                "dns_lists": [{
                    "name": "scm_edl_1",
                    "packetCapture": "single-packet",
                    "action": {
                        "block": {},
                    },
                }],
                "sinkhole": {
                    "ipv4_address": "pan-sinkhole-default-ip",
                    "ipv6_address": "::1",
                },
                "whitelists": [{
                    "name": "ebay.com",
                    "description": "creating whitelist",
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DnsSecurityProfileBotnetDomainsArgs', 'DnsSecurityProfileBotnetDomainsArgsDict']] botnet_domains: Botnet domains
        :param pulumi.Input[_builtins.str] description: The description of the DNS security profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the DNS security profile
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DnsSecurityProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DnsSecurityProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_dns_security_profile_base = scm.DnsSecurityProfile("scm_dns_security_profile_base",
            folder="All",
            name="dns_base")
        scm_dns_security_categories = scm.DnsSecurityProfile("scm_dns_security_categories",
            folder="All",
            name="test_dns_sec_categories",
            description="dns security profile w/ dns security categories",
            botnet_domains={
                "dns_security_categories": [
                    {
                        "name": "pan-dns-sec-recent",
                    },
                    {
                        "name": "pan-dns-sec-grayware",
                        "action": "allow",
                        "log_level": "high",
                        "packet_capture": "disable",
                    },
                    {
                        "name": "pan-dns-sec-proxy",
                        "action": "block",
                        "log_level": "default",
                        "packet_capture": "single-packet",
                    },
                    {
                        "name": "pan-dns-sec-phishing",
                        "action": "sinkhole",
                        "log_level": "critical",
                        "packet_capture": "extended-capture",
                    },
                    {
                        "name": "pan-dns-sec-malware",
                        "action": "default",
                        "log_level": "informational",
                        "packet_capture": "disable",
                    },
                ],
            })
        scm_dns_lists = scm.DnsSecurityProfile("scm_dns_lists",
            folder="All",
            name="test_dns_lists",
            description="dns security profile w/ dns lists",
            botnet_domains={
                "dns_lists": [
                    {
                        "name": "default-paloalto-dns",
                        "packetCapture": "disable",
                        "action": {
                            "alert": {},
                        },
                    },
                    {
                        "name": "update-edl",
                        "packetCapture": "extended-capture",
                        "action": {
                            "allow": {},
                        },
                    },
                ],
            })
        scm_dns_sinkhole = scm.DnsSecurityProfile("scm_dns_sinkhole",
            folder="All",
            name="test_dns_sinkhole",
            description="dns security profile w/ sinkhole",
            botnet_domains={
                "sinkhole": {
                    "ipv4_address": "127.0.0.1",
                    "ipv6_address": "::1",
                },
            })
        scm_dns_whitelist = scm.DnsSecurityProfile("scm_dns_whitelist",
            folder="All",
            name="test_dns_whitelist",
            description="dns security profile w/ whitelist",
            botnet_domains={
                "whitelists": [
                    {
                        "name": "example.com",
                    },
                    {
                        "name": "example2.com",
                        "description": "creating whitelist",
                    },
                ],
            })
        scm_dns_all = scm.DnsSecurityProfile("scm_dns_all",
            folder="All",
            name="test_dns_all_test",
            description="dns security profile w/ all",
            botnet_domains={
                "dns_security_categories": [{
                    "name": "pan-dns-sec-ddns",
                    "action": "block",
                    "log_level": "low",
                    "packet_capture": "disable",
                }],
                "dns_lists": [{
                    "name": "scm_edl_1",
                    "packetCapture": "single-packet",
                    "action": {
                        "block": {},
                    },
                }],
                "sinkhole": {
                    "ipv4_address": "pan-sinkhole-default-ip",
                    "ipv6_address": "::1",
                },
                "whitelists": [{
                    "name": "ebay.com",
                    "description": "creating whitelist",
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param DnsSecurityProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsSecurityProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 botnet_domains: Optional[pulumi.Input[Union['DnsSecurityProfileBotnetDomainsArgs', 'DnsSecurityProfileBotnetDomainsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsSecurityProfileArgs.__new__(DnsSecurityProfileArgs)

            __props__.__dict__["botnet_domains"] = botnet_domains
            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tfid"] = None
        super(DnsSecurityProfile, __self__).__init__(
            'scm:index/dnsSecurityProfile:DnsSecurityProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            botnet_domains: Optional[pulumi.Input[Union['DnsSecurityProfileBotnetDomainsArgs', 'DnsSecurityProfileBotnetDomainsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsSecurityProfile':
        """
        Get an existing DnsSecurityProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DnsSecurityProfileBotnetDomainsArgs', 'DnsSecurityProfileBotnetDomainsArgsDict']] botnet_domains: Botnet domains
        :param pulumi.Input[_builtins.str] description: The description of the DNS security profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the DNS security profile
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsSecurityProfileState.__new__(_DnsSecurityProfileState)

        __props__.__dict__["botnet_domains"] = botnet_domains
        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        return DnsSecurityProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="botnetDomains")
    def botnet_domains(self) -> pulumi.Output[Optional['outputs.DnsSecurityProfileBotnetDomains']]:
        """
        Botnet domains
        """
        return pulumi.get(self, "botnet_domains")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the DNS security profile
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the DNS security profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

