# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAddressResult',
    'AwaitableGetAddressResult',
    'get_address',
    'get_address_output',
]

@pulumi.output_type
class GetAddressResult:
    """
    A collection of values returned by getAddress.
    """
    def __init__(__self__, description=None, device=None, folder=None, fqdn=None, id=None, ip_netmask=None, ip_range=None, ip_wildcard=None, name=None, snippet=None, tags=None, tfid=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_netmask and not isinstance(ip_netmask, str):
            raise TypeError("Expected argument 'ip_netmask' to be a str")
        pulumi.set(__self__, "ip_netmask", ip_netmask)
        if ip_range and not isinstance(ip_range, str):
            raise TypeError("Expected argument 'ip_range' to be a str")
        pulumi.set(__self__, "ip_range", ip_range)
        if ip_wildcard and not isinstance(ip_wildcard, str):
            raise TypeError("Expected argument 'ip_wildcard' to be a str")
        pulumi.set(__self__, "ip_wildcard", ip_wildcard)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the address object
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        Fully qualified domain name
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the address object
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipNetmask")
    def ip_netmask(self) -> _builtins.str:
        """
        IP address with or without CIDR notation
        """
        return pulumi.get(self, "ip_netmask")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        Ip range
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter(name="ipWildcard")
    def ip_wildcard(self) -> _builtins.str:
        """
        IP wildcard mask
        """
        return pulumi.get(self, "ip_wildcard")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the address object
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags assocaited with the address object
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetAddressResult(GetAddressResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressResult(
            description=self.description,
            device=self.device,
            folder=self.folder,
            fqdn=self.fqdn,
            id=self.id,
            ip_netmask=self.ip_netmask,
            ip_range=self.ip_range,
            ip_wildcard=self.ip_wildcard,
            name=self.name,
            snippet=self.snippet,
            tags=self.tags,
            tfid=self.tfid)


def get_address(id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressResult:
    """
    Address data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up the IP Netmask address object by its ID.
    scm_address1_ds = scm.get_address(id="f23e1c22-de94-44cd-b67f-36f2516618a7")
    # Look up the IP Range address object by its ID.
    scm_address2_ds = scm.get_address(id="662ef9a5-80d4-40d8-b51a-ec11915895d8")
    # Look up the FQDN address object by its ID.
    scm_address3_ds = scm.get_address(id="1b996b9d-d350-4565-8ace-b319e6ae5a34")
    # Look up the class_c_wildcard address object by its ID.
    scm_address4_ds = scm.get_address(id="933a1646-21fa-4edc-a0ca-868ead783ac0")
    # Look up the multi-tag address object by its ID.
    scm_address5_ds = scm.get_address(id="f10df339-61aa-42a0-aab8-85424bfb2a8f")
    pulumi.export("addressDataSourceResults", {
        "netmaskObject": scm_address1_ds,
        "ipRangeObject": scm_address2_ds,
        "fqdnObject": scm_address3_ds,
        "classCWildcardObject": scm_address4_ds,
        "multiTagTestObject": scm_address5_ds,
    })
    ```


    :param _builtins.str id: The UUID of the address object
    :param _builtins.str name: The name of the address object
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getAddress:getAddress', __args__, opts=opts, typ=GetAddressResult).value

    return AwaitableGetAddressResult(
        description=pulumi.get(__ret__, 'description'),
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        id=pulumi.get(__ret__, 'id'),
        ip_netmask=pulumi.get(__ret__, 'ip_netmask'),
        ip_range=pulumi.get(__ret__, 'ip_range'),
        ip_wildcard=pulumi.get(__ret__, 'ip_wildcard'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tags=pulumi.get(__ret__, 'tags'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_address_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressResult]:
    """
    Address data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up the IP Netmask address object by its ID.
    scm_address1_ds = scm.get_address(id="f23e1c22-de94-44cd-b67f-36f2516618a7")
    # Look up the IP Range address object by its ID.
    scm_address2_ds = scm.get_address(id="662ef9a5-80d4-40d8-b51a-ec11915895d8")
    # Look up the FQDN address object by its ID.
    scm_address3_ds = scm.get_address(id="1b996b9d-d350-4565-8ace-b319e6ae5a34")
    # Look up the class_c_wildcard address object by its ID.
    scm_address4_ds = scm.get_address(id="933a1646-21fa-4edc-a0ca-868ead783ac0")
    # Look up the multi-tag address object by its ID.
    scm_address5_ds = scm.get_address(id="f10df339-61aa-42a0-aab8-85424bfb2a8f")
    pulumi.export("addressDataSourceResults", {
        "netmaskObject": scm_address1_ds,
        "ipRangeObject": scm_address2_ds,
        "fqdnObject": scm_address3_ds,
        "classCWildcardObject": scm_address4_ds,
        "multiTagTestObject": scm_address5_ds,
    })
    ```


    :param _builtins.str id: The UUID of the address object
    :param _builtins.str name: The name of the address object
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getAddress:getAddress', __args__, opts=opts, typ=GetAddressResult)
    return __ret__.apply(lambda __response__: GetAddressResult(
        description=pulumi.get(__response__, 'description'),
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        id=pulumi.get(__response__, 'id'),
        ip_netmask=pulumi.get(__response__, 'ip_netmask'),
        ip_range=pulumi.get(__response__, 'ip_range'),
        ip_wildcard=pulumi.get(__response__, 'ip_wildcard'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        tags=pulumi.get(__response__, 'tags'),
        tfid=pulumi.get(__response__, 'tfid')))
