# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRemoteNetworkResult',
    'AwaitableGetRemoteNetworkResult',
    'get_remote_network',
    'get_remote_network_output',
]

@pulumi.output_type
class GetRemoteNetworkResult:
    """
    A collection of values returned by getRemoteNetwork.
    """
    def __init__(__self__, ecmp_load_balancing=None, ecmp_tunnels=None, encrypted_values=None, folder=None, id=None, ipsec_tunnel=None, license_type=None, name=None, protocol=None, region=None, secondary_ipsec_tunnel=None, spn_name=None, subnets=None, tfid=None):
        if ecmp_load_balancing and not isinstance(ecmp_load_balancing, str):
            raise TypeError("Expected argument 'ecmp_load_balancing' to be a str")
        pulumi.set(__self__, "ecmp_load_balancing", ecmp_load_balancing)
        if ecmp_tunnels and not isinstance(ecmp_tunnels, list):
            raise TypeError("Expected argument 'ecmp_tunnels' to be a list")
        pulumi.set(__self__, "ecmp_tunnels", ecmp_tunnels)
        if encrypted_values and not isinstance(encrypted_values, dict):
            raise TypeError("Expected argument 'encrypted_values' to be a dict")
        pulumi.set(__self__, "encrypted_values", encrypted_values)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_tunnel and not isinstance(ipsec_tunnel, str):
            raise TypeError("Expected argument 'ipsec_tunnel' to be a str")
        pulumi.set(__self__, "ipsec_tunnel", ipsec_tunnel)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocol and not isinstance(protocol, dict):
            raise TypeError("Expected argument 'protocol' to be a dict")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secondary_ipsec_tunnel and not isinstance(secondary_ipsec_tunnel, str):
            raise TypeError("Expected argument 'secondary_ipsec_tunnel' to be a str")
        pulumi.set(__self__, "secondary_ipsec_tunnel", secondary_ipsec_tunnel)
        if spn_name and not isinstance(spn_name, str):
            raise TypeError("Expected argument 'spn_name' to be a str")
        pulumi.set(__self__, "spn_name", spn_name)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="ecmpLoadBalancing")
    def ecmp_load_balancing(self) -> _builtins.str:
        """
        Ecmp load balancing
        """
        return pulumi.get(self, "ecmp_load_balancing")

    @_builtins.property
    @pulumi.getter(name="ecmpTunnels")
    def ecmp_tunnels(self) -> Sequence['outputs.GetRemoteNetworkEcmpTunnelResult']:
        """
        ecmp*tunnels is required when ecmp*load*balancing is enable
        """
        return pulumi.get(self, "ecmp_tunnels")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Mapping[str, _builtins.str]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder that contains the remote network
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the remote network
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> _builtins.str:
        """
        ipsec*tunnel is required when ecmp*load_balancing is disable
        """
        return pulumi.get(self, "ipsec_tunnel")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> _builtins.str:
        """
        New customer will only be on aggregate bandwidth licensing
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the remote network
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> 'outputs.GetRemoteNetworkProtocolResult':
        """
        setup the protocol when ecmp*load*balancing is disable
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secondaryIpsecTunnel")
    def secondary_ipsec_tunnel(self) -> _builtins.str:
        """
        specify secondary ipsec_tunnel if needed
        """
        return pulumi.get(self, "secondary_ipsec_tunnel")

    @_builtins.property
    @pulumi.getter(name="spnName")
    def spn_name(self) -> _builtins.str:
        """
        spn-name is needed when license_type is FWAAS-AGGREGATE
        """
        return pulumi.get(self, "spn_name")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        Subnets
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetRemoteNetworkResult(GetRemoteNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemoteNetworkResult(
            ecmp_load_balancing=self.ecmp_load_balancing,
            ecmp_tunnels=self.ecmp_tunnels,
            encrypted_values=self.encrypted_values,
            folder=self.folder,
            id=self.id,
            ipsec_tunnel=self.ipsec_tunnel,
            license_type=self.license_type,
            name=self.name,
            protocol=self.protocol,
            region=self.region,
            secondary_ipsec_tunnel=self.secondary_ipsec_tunnel,
            spn_name=self.spn_name,
            subnets=self.subnets,
            tfid=self.tfid)


def get_remote_network(id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemoteNetworkResult:
    """
    RemoteNetwork data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single remote_network object.
    #
    # Look up a single Remote Network by its ID.
    # Replace the ID with the UUID of the remote network you want to find.
    example = scm.get_remote_network(id="7fc59ec2-46b3-4a0e-9c86-9b7416426a70")
    pulumi.export("remoteNetworkDetails", example)
    ```


    :param _builtins.str id: The UUID of the remote network
    :param _builtins.str name: The name of the remote network
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getRemoteNetwork:getRemoteNetwork', __args__, opts=opts, typ=GetRemoteNetworkResult).value

    return AwaitableGetRemoteNetworkResult(
        ecmp_load_balancing=pulumi.get(__ret__, 'ecmp_load_balancing'),
        ecmp_tunnels=pulumi.get(__ret__, 'ecmp_tunnels'),
        encrypted_values=pulumi.get(__ret__, 'encrypted_values'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_tunnel=pulumi.get(__ret__, 'ipsec_tunnel'),
        license_type=pulumi.get(__ret__, 'license_type'),
        name=pulumi.get(__ret__, 'name'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        secondary_ipsec_tunnel=pulumi.get(__ret__, 'secondary_ipsec_tunnel'),
        spn_name=pulumi.get(__ret__, 'spn_name'),
        subnets=pulumi.get(__ret__, 'subnets'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_remote_network_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRemoteNetworkResult]:
    """
    RemoteNetwork data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    #
    # Data source to retrieve a single remote_network object.
    #
    # Look up a single Remote Network by its ID.
    # Replace the ID with the UUID of the remote network you want to find.
    example = scm.get_remote_network(id="7fc59ec2-46b3-4a0e-9c86-9b7416426a70")
    pulumi.export("remoteNetworkDetails", example)
    ```


    :param _builtins.str id: The UUID of the remote network
    :param _builtins.str name: The name of the remote network
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getRemoteNetwork:getRemoteNetwork', __args__, opts=opts, typ=GetRemoteNetworkResult)
    return __ret__.apply(lambda __response__: GetRemoteNetworkResult(
        ecmp_load_balancing=pulumi.get(__response__, 'ecmp_load_balancing'),
        ecmp_tunnels=pulumi.get(__response__, 'ecmp_tunnels'),
        encrypted_values=pulumi.get(__response__, 'encrypted_values'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        ipsec_tunnel=pulumi.get(__response__, 'ipsec_tunnel'),
        license_type=pulumi.get(__response__, 'license_type'),
        name=pulumi.get(__response__, 'name'),
        protocol=pulumi.get(__response__, 'protocol'),
        region=pulumi.get(__response__, 'region'),
        secondary_ipsec_tunnel=pulumi.get(__response__, 'secondary_ipsec_tunnel'),
        spn_name=pulumi.get(__response__, 'spn_name'),
        subnets=pulumi.get(__response__, 'subnets'),
        tfid=pulumi.get(__response__, 'tfid')))
