# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSiteResult',
    'AwaitableGetSiteResult',
    'get_site',
    'get_site_output',
]

@pulumi.output_type
class GetSiteResult:
    """
    A collection of values returned by getSite.
    """
    def __init__(__self__, address_line1=None, address_line2=None, city=None, country=None, id=None, latitude=None, longitude=None, members=None, name=None, qos=None, state=None, tfid=None, type=None, zip_code=None):
        if address_line1 and not isinstance(address_line1, str):
            raise TypeError("Expected argument 'address_line1' to be a str")
        pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 and not isinstance(address_line2, str):
            raise TypeError("Expected argument 'address_line2' to be a str")
        pulumi.set(__self__, "address_line2", address_line2)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latitude and not isinstance(latitude, float):
            raise TypeError("Expected argument 'latitude' to be a float")
        pulumi.set(__self__, "latitude", latitude)
        if longitude and not isinstance(longitude, float):
            raise TypeError("Expected argument 'longitude' to be a float")
        pulumi.set(__self__, "longitude", longitude)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if qos and not isinstance(qos, dict):
            raise TypeError("Expected argument 'qos' to be a dict")
        pulumi.set(__self__, "qos", qos)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zip_code and not isinstance(zip_code, str):
            raise TypeError("Expected argument 'zip_code' to be a str")
        pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> _builtins.str:
        """
        The address in which the site exists
        """
        return pulumi.get(self, "address_line1")

    @_builtins.property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> _builtins.str:
        """
        The address in which the site exists (continued)
        """
        return pulumi.get(self, "address_line2")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        The city in which the site exists
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        The country in which the site exists
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the site
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> _builtins.float:
        """
        The latitude coordinate for the site
        """
        return pulumi.get(self, "latitude")

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> _builtins.float:
        """
        The longitude coordinate for the site
        """
        return pulumi.get(self, "longitude")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetSiteMemberResult']:
        """
        Members
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the site
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def qos(self) -> 'outputs.GetSiteQosResult':
        """
        Qos
        """
        return pulumi.get(self, "qos")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state in which the site exists
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The site type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> _builtins.str:
        """
        The postal code in which the site exists
        """
        return pulumi.get(self, "zip_code")


class AwaitableGetSiteResult(GetSiteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSiteResult(
            address_line1=self.address_line1,
            address_line2=self.address_line2,
            city=self.city,
            country=self.country,
            id=self.id,
            latitude=self.latitude,
            longitude=self.longitude,
            members=self.members,
            name=self.name,
            qos=self.qos,
            state=self.state,
            tfid=self.tfid,
            type=self.type,
            zip_code=self.zip_code)


def get_site(id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSiteResult:
    """
    Site data source


    :param _builtins.str id: The UUID of the site
    :param _builtins.str name: The name of the site
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getSite:getSite', __args__, opts=opts, typ=GetSiteResult).value

    return AwaitableGetSiteResult(
        address_line1=pulumi.get(__ret__, 'address_line1'),
        address_line2=pulumi.get(__ret__, 'address_line2'),
        city=pulumi.get(__ret__, 'city'),
        country=pulumi.get(__ret__, 'country'),
        id=pulumi.get(__ret__, 'id'),
        latitude=pulumi.get(__ret__, 'latitude'),
        longitude=pulumi.get(__ret__, 'longitude'),
        members=pulumi.get(__ret__, 'members'),
        name=pulumi.get(__ret__, 'name'),
        qos=pulumi.get(__ret__, 'qos'),
        state=pulumi.get(__ret__, 'state'),
        tfid=pulumi.get(__ret__, 'tfid'),
        type=pulumi.get(__ret__, 'type'),
        zip_code=pulumi.get(__ret__, 'zip_code'))
def get_site_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSiteResult]:
    """
    Site data source


    :param _builtins.str id: The UUID of the site
    :param _builtins.str name: The name of the site
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getSite:getSite', __args__, opts=opts, typ=GetSiteResult)
    return __ret__.apply(lambda __response__: GetSiteResult(
        address_line1=pulumi.get(__response__, 'address_line1'),
        address_line2=pulumi.get(__response__, 'address_line2'),
        city=pulumi.get(__response__, 'city'),
        country=pulumi.get(__response__, 'country'),
        id=pulumi.get(__response__, 'id'),
        latitude=pulumi.get(__response__, 'latitude'),
        longitude=pulumi.get(__response__, 'longitude'),
        members=pulumi.get(__response__, 'members'),
        name=pulumi.get(__response__, 'name'),
        qos=pulumi.get(__response__, 'qos'),
        state=pulumi.get(__response__, 'state'),
        tfid=pulumi.get(__response__, 'tfid'),
        type=pulumi.get(__response__, 'type'),
        zip_code=pulumi.get(__response__, 'zip_code')))
