# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTacacsServerProfileResult',
    'AwaitableGetTacacsServerProfileResult',
    'get_tacacs_server_profile',
    'get_tacacs_server_profile_output',
]

@pulumi.output_type
class GetTacacsServerProfileResult:
    """
    A collection of values returned by getTacacsServerProfile.
    """
    def __init__(__self__, device=None, folder=None, id=None, name=None, protocol=None, servers=None, snippet=None, tfid=None, timeout=None, use_single_connection=None):
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)
        if use_single_connection and not isinstance(use_single_connection, bool):
            raise TypeError("Expected argument 'use_single_connection' to be a bool")
        pulumi.set(__self__, "use_single_connection", use_single_connection)

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the TACACS+ server profile
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the TACACS+ server profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The TACACS+ authentication protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetTacacsServerProfileServerResult']:
        """
        The TACACS+ server configuration
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        The TACACS+ timeout (seconds)
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="useSingleConnection")
    def use_single_connection(self) -> _builtins.bool:
        """
        Use a single TACACS+ connection?
        """
        return pulumi.get(self, "use_single_connection")


class AwaitableGetTacacsServerProfileResult(GetTacacsServerProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTacacsServerProfileResult(
            device=self.device,
            folder=self.folder,
            id=self.id,
            name=self.name,
            protocol=self.protocol,
            servers=self.servers,
            snippet=self.snippet,
            tfid=self.tfid,
            timeout=self.timeout,
            use_single_connection=self.use_single_connection)


def get_tacacs_server_profile(id: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTacacsServerProfileResult:
    """
    TacacsServerProfile data source


    :param _builtins.str id: The UUID of the TACACS+ server profile
    :param _builtins.str name: The name of the TACACS+ server profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getTacacsServerProfile:getTacacsServerProfile', __args__, opts=opts, typ=GetTacacsServerProfileResult).value

    return AwaitableGetTacacsServerProfileResult(
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        protocol=pulumi.get(__ret__, 'protocol'),
        servers=pulumi.get(__ret__, 'servers'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        timeout=pulumi.get(__ret__, 'timeout'),
        use_single_connection=pulumi.get(__ret__, 'use_single_connection'))
def get_tacacs_server_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTacacsServerProfileResult]:
    """
    TacacsServerProfile data source


    :param _builtins.str id: The UUID of the TACACS+ server profile
    :param _builtins.str name: The name of the TACACS+ server profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getTacacsServerProfile:getTacacsServerProfile', __args__, opts=opts, typ=GetTacacsServerProfileResult)
    return __ret__.apply(lambda __response__: GetTacacsServerProfileResult(
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        protocol=pulumi.get(__response__, 'protocol'),
        servers=pulumi.get(__response__, 'servers'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        timeout=pulumi.get(__response__, 'timeout'),
        use_single_connection=pulumi.get(__response__, 'use_single_connection')))
