# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpsecCryptoProfileArgs', 'IpsecCryptoProfile']

@pulumi.input_type
class IpsecCryptoProfileArgs:
    def __init__(__self__, *,
                 lifetime: pulumi.Input['IpsecCryptoProfileLifetimeArgs'],
                 ah: Optional[pulumi.Input['IpsecCryptoProfileAhArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_group: Optional[pulumi.Input[_builtins.str]] = None,
                 esp: Optional[pulumi.Input['IpsecCryptoProfileEspArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 lifesize: Optional[pulumi.Input['IpsecCryptoProfileLifesizeArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpsecCryptoProfile resource.
        :param pulumi.Input['IpsecCryptoProfileLifetimeArgs'] lifetime: Ipsec crypto profile lifetime
        :param pulumi.Input['IpsecCryptoProfileAhArgs'] ah: Ah
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] dh_group: phase-2 DH group (PFS DH group)
        :param pulumi.Input['IpsecCryptoProfileEspArgs'] esp: Esp
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['IpsecCryptoProfileLifesizeArgs'] lifesize: Lifesize
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        pulumi.set(__self__, "lifetime", lifetime)
        if ah is not None:
            pulumi.set(__self__, "ah", ah)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dh_group is not None:
            pulumi.set(__self__, "dh_group", dh_group)
        if esp is not None:
            pulumi.set(__self__, "esp", esp)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if lifesize is not None:
            pulumi.set(__self__, "lifesize", lifesize)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> pulumi.Input['IpsecCryptoProfileLifetimeArgs']:
        """
        Ipsec crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: pulumi.Input['IpsecCryptoProfileLifetimeArgs']):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def ah(self) -> Optional[pulumi.Input['IpsecCryptoProfileAhArgs']]:
        """
        Ah
        """
        return pulumi.get(self, "ah")

    @ah.setter
    def ah(self, value: Optional[pulumi.Input['IpsecCryptoProfileAhArgs']]):
        pulumi.set(self, "ah", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhGroup")
    def dh_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        phase-2 DH group (PFS DH group)
        """
        return pulumi.get(self, "dh_group")

    @dh_group.setter
    def dh_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dh_group", value)

    @_builtins.property
    @pulumi.getter
    def esp(self) -> Optional[pulumi.Input['IpsecCryptoProfileEspArgs']]:
        """
        Esp
        """
        return pulumi.get(self, "esp")

    @esp.setter
    def esp(self, value: Optional[pulumi.Input['IpsecCryptoProfileEspArgs']]):
        pulumi.set(self, "esp", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def lifesize(self) -> Optional[pulumi.Input['IpsecCryptoProfileLifesizeArgs']]:
        """
        Lifesize
        """
        return pulumi.get(self, "lifesize")

    @lifesize.setter
    def lifesize(self, value: Optional[pulumi.Input['IpsecCryptoProfileLifesizeArgs']]):
        pulumi.set(self, "lifesize", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)


@pulumi.input_type
class _IpsecCryptoProfileState:
    def __init__(__self__, *,
                 ah: Optional[pulumi.Input['IpsecCryptoProfileAhArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_group: Optional[pulumi.Input[_builtins.str]] = None,
                 esp: Optional[pulumi.Input['IpsecCryptoProfileEspArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 lifesize: Optional[pulumi.Input['IpsecCryptoProfileLifesizeArgs']] = None,
                 lifetime: Optional[pulumi.Input['IpsecCryptoProfileLifetimeArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpsecCryptoProfile resources.
        :param pulumi.Input['IpsecCryptoProfileAhArgs'] ah: Ah
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] dh_group: phase-2 DH group (PFS DH group)
        :param pulumi.Input['IpsecCryptoProfileEspArgs'] esp: Esp
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['IpsecCryptoProfileLifesizeArgs'] lifesize: Lifesize
        :param pulumi.Input['IpsecCryptoProfileLifetimeArgs'] lifetime: Ipsec crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        if ah is not None:
            pulumi.set(__self__, "ah", ah)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dh_group is not None:
            pulumi.set(__self__, "dh_group", dh_group)
        if esp is not None:
            pulumi.set(__self__, "esp", esp)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if lifesize is not None:
            pulumi.set(__self__, "lifesize", lifesize)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def ah(self) -> Optional[pulumi.Input['IpsecCryptoProfileAhArgs']]:
        """
        Ah
        """
        return pulumi.get(self, "ah")

    @ah.setter
    def ah(self, value: Optional[pulumi.Input['IpsecCryptoProfileAhArgs']]):
        pulumi.set(self, "ah", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhGroup")
    def dh_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        phase-2 DH group (PFS DH group)
        """
        return pulumi.get(self, "dh_group")

    @dh_group.setter
    def dh_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dh_group", value)

    @_builtins.property
    @pulumi.getter
    def esp(self) -> Optional[pulumi.Input['IpsecCryptoProfileEspArgs']]:
        """
        Esp
        """
        return pulumi.get(self, "esp")

    @esp.setter
    def esp(self, value: Optional[pulumi.Input['IpsecCryptoProfileEspArgs']]):
        pulumi.set(self, "esp", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def lifesize(self) -> Optional[pulumi.Input['IpsecCryptoProfileLifesizeArgs']]:
        """
        Lifesize
        """
        return pulumi.get(self, "lifesize")

    @lifesize.setter
    def lifesize(self, value: Optional[pulumi.Input['IpsecCryptoProfileLifesizeArgs']]):
        pulumi.set(self, "lifesize", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input['IpsecCryptoProfileLifetimeArgs']]:
        """
        Ipsec crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input['IpsecCryptoProfileLifetimeArgs']]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/ipsecCryptoProfile:IpsecCryptoProfile")
class IpsecCryptoProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ah: Optional[pulumi.Input[Union['IpsecCryptoProfileAhArgs', 'IpsecCryptoProfileAhArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_group: Optional[pulumi.Input[_builtins.str]] = None,
                 esp: Optional[pulumi.Input[Union['IpsecCryptoProfileEspArgs', 'IpsecCryptoProfileEspArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 lifesize: Optional[pulumi.Input[Union['IpsecCryptoProfileLifesizeArgs', 'IpsecCryptoProfileLifesizeArgsDict']]] = None,
                 lifetime: Optional[pulumi.Input[Union['IpsecCryptoProfileLifetimeArgs', 'IpsecCryptoProfileLifetimeArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        IpsecCryptoProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # The resource block defines a new IPsec Crypto Profile.
        scm_ipsec_crypto_profile2 = scm.IpsecCryptoProfile("scm_ipsec_crypto_profile_2",
            name="scm_ipsec_crypto_profile_2",
            folder="Prisma Access",
            esp={
                "authentications": [
                    "sha256",
                    "sha384",
                ],
                "encryptions": [
                    "aes-256-gcm",
                    "aes-128-cbc",
                ],
            },
            dh_group="group14",
            lifetime={
                "hours": 1,
            },
            lifesize={
                "gb": 10,
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IpsecCryptoProfileAhArgs', 'IpsecCryptoProfileAhArgsDict']] ah: Ah
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] dh_group: phase-2 DH group (PFS DH group)
        :param pulumi.Input[Union['IpsecCryptoProfileEspArgs', 'IpsecCryptoProfileEspArgsDict']] esp: Esp
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['IpsecCryptoProfileLifesizeArgs', 'IpsecCryptoProfileLifesizeArgsDict']] lifesize: Lifesize
        :param pulumi.Input[Union['IpsecCryptoProfileLifetimeArgs', 'IpsecCryptoProfileLifetimeArgsDict']] lifetime: Ipsec crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpsecCryptoProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IpsecCryptoProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # The resource block defines a new IPsec Crypto Profile.
        scm_ipsec_crypto_profile2 = scm.IpsecCryptoProfile("scm_ipsec_crypto_profile_2",
            name="scm_ipsec_crypto_profile_2",
            folder="Prisma Access",
            esp={
                "authentications": [
                    "sha256",
                    "sha384",
                ],
                "encryptions": [
                    "aes-256-gcm",
                    "aes-128-cbc",
                ],
            },
            dh_group="group14",
            lifetime={
                "hours": 1,
            },
            lifesize={
                "gb": 10,
            })
        ```

        :param str resource_name: The name of the resource.
        :param IpsecCryptoProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsecCryptoProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ah: Optional[pulumi.Input[Union['IpsecCryptoProfileAhArgs', 'IpsecCryptoProfileAhArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dh_group: Optional[pulumi.Input[_builtins.str]] = None,
                 esp: Optional[pulumi.Input[Union['IpsecCryptoProfileEspArgs', 'IpsecCryptoProfileEspArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 lifesize: Optional[pulumi.Input[Union['IpsecCryptoProfileLifesizeArgs', 'IpsecCryptoProfileLifesizeArgsDict']]] = None,
                 lifetime: Optional[pulumi.Input[Union['IpsecCryptoProfileLifetimeArgs', 'IpsecCryptoProfileLifetimeArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsecCryptoProfileArgs.__new__(IpsecCryptoProfileArgs)

            __props__.__dict__["ah"] = ah
            __props__.__dict__["device"] = device
            __props__.__dict__["dh_group"] = dh_group
            __props__.__dict__["esp"] = esp
            __props__.__dict__["folder"] = folder
            __props__.__dict__["lifesize"] = lifesize
            if lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'lifetime'")
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tfid"] = None
        super(IpsecCryptoProfile, __self__).__init__(
            'scm:index/ipsecCryptoProfile:IpsecCryptoProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ah: Optional[pulumi.Input[Union['IpsecCryptoProfileAhArgs', 'IpsecCryptoProfileAhArgsDict']]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            dh_group: Optional[pulumi.Input[_builtins.str]] = None,
            esp: Optional[pulumi.Input[Union['IpsecCryptoProfileEspArgs', 'IpsecCryptoProfileEspArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            lifesize: Optional[pulumi.Input[Union['IpsecCryptoProfileLifesizeArgs', 'IpsecCryptoProfileLifesizeArgsDict']]] = None,
            lifetime: Optional[pulumi.Input[Union['IpsecCryptoProfileLifetimeArgs', 'IpsecCryptoProfileLifetimeArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpsecCryptoProfile':
        """
        Get an existing IpsecCryptoProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IpsecCryptoProfileAhArgs', 'IpsecCryptoProfileAhArgsDict']] ah: Ah
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] dh_group: phase-2 DH group (PFS DH group)
        :param pulumi.Input[Union['IpsecCryptoProfileEspArgs', 'IpsecCryptoProfileEspArgsDict']] esp: Esp
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['IpsecCryptoProfileLifesizeArgs', 'IpsecCryptoProfileLifesizeArgsDict']] lifesize: Lifesize
        :param pulumi.Input[Union['IpsecCryptoProfileLifetimeArgs', 'IpsecCryptoProfileLifetimeArgsDict']] lifetime: Ipsec crypto profile lifetime
        :param pulumi.Input[_builtins.str] name: Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsecCryptoProfileState.__new__(_IpsecCryptoProfileState)

        __props__.__dict__["ah"] = ah
        __props__.__dict__["device"] = device
        __props__.__dict__["dh_group"] = dh_group
        __props__.__dict__["esp"] = esp
        __props__.__dict__["folder"] = folder
        __props__.__dict__["lifesize"] = lifesize
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        return IpsecCryptoProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ah(self) -> pulumi.Output[Optional['outputs.IpsecCryptoProfileAh']]:
        """
        Ah
        """
        return pulumi.get(self, "ah")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dhGroup")
    def dh_group(self) -> pulumi.Output[_builtins.str]:
        """
        phase-2 DH group (PFS DH group)
        """
        return pulumi.get(self, "dh_group")

    @_builtins.property
    @pulumi.getter
    def esp(self) -> pulumi.Output[Optional['outputs.IpsecCryptoProfileEsp']]:
        """
        Esp
        """
        return pulumi.get(self, "esp")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def lifesize(self) -> pulumi.Output[Optional['outputs.IpsecCryptoProfileLifesize']]:
        """
        Lifesize
        """
        return pulumi.get(self, "lifesize")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output['outputs.IpsecCryptoProfileLifetime']:
        """
        Ipsec crypto profile lifetime
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Alphanumeric string begin with letter: [0-9a-zA-Z._-]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

