# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['Layer2SubinterfaceArgs', 'Layer2Subinterface']

@pulumi.input_type
class Layer2SubinterfaceArgs:
    def __init__(__self__, *,
                 vlan_tag: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Layer2Subinterface resource.
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: L2 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        """
        pulumi.set(__self__, "vlan_tag", vlan_tag)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_interface is not None:
            pulumi.set(__self__, "parent_interface", parent_interface)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> pulumi.Input[_builtins.str]:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vlan_tag", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        L2 sub-interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentInterface")
    def parent_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent interface
        """
        return pulumi.get(self, "parent_interface")

    @parent_interface.setter
    def parent_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_interface", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)


@pulumi.input_type
class _Layer2SubinterfaceState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Layer2Subinterface resources.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: L2 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_interface is not None:
            pulumi.set(__self__, "parent_interface", parent_interface)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        L2 sub-interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentInterface")
    def parent_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent interface
        """
        return pulumi.get(self, "parent_interface")

    @parent_interface.setter
    def parent_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_interface", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.type_token("scm:index/layer2Subinterface:Layer2Subinterface")
class Layer2Subinterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Layer2Subinterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a ethernet interface used as parent-interface for subsequent examples
        #
        scm_parent_interface = scm.EthernetInterface("scm_parent_interface",
            name="$scm_parent_interface",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            layer2={})
        #
        # Creates a layer2 sub-interface with vlan tag 100
        #
        scm_layer2_subinterface = scm.Layer2Subinterface("scm_layer2_subinterface",
            name="$scm_parent_interface.100",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            vlan_tag="100",
            parent_interface="$scm_parent_interface",
            opts = pulumi.ResourceOptions(depends_on=[scm_parent_interface]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: L2 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Layer2SubinterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Layer2Subinterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a ethernet interface used as parent-interface for subsequent examples
        #
        scm_parent_interface = scm.EthernetInterface("scm_parent_interface",
            name="$scm_parent_interface",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            layer2={})
        #
        # Creates a layer2 sub-interface with vlan tag 100
        #
        scm_layer2_subinterface = scm.Layer2Subinterface("scm_layer2_subinterface",
            name="$scm_parent_interface.100",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            vlan_tag="100",
            parent_interface="$scm_parent_interface",
            opts = pulumi.ResourceOptions(depends_on=[scm_parent_interface]))
        ```

        :param str resource_name: The name of the resource.
        :param Layer2SubinterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Layer2SubinterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Layer2SubinterfaceArgs.__new__(Layer2SubinterfaceArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_interface"] = parent_interface
            __props__.__dict__["snippet"] = snippet
            if vlan_tag is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_tag'")
            __props__.__dict__["vlan_tag"] = vlan_tag
            __props__.__dict__["tfid"] = None
        super(Layer2Subinterface, __self__).__init__(
            'scm:index/layer2Subinterface:Layer2Subinterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_tag: Optional[pulumi.Input[_builtins.str]] = None) -> 'Layer2Subinterface':
        """
        Get an existing Layer2Subinterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: L2 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Layer2SubinterfaceState.__new__(_Layer2SubinterfaceState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_interface"] = parent_interface
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["vlan_tag"] = vlan_tag
        return Layer2Subinterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        L2 sub-interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentInterface")
    def parent_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Parent interface
        """
        return pulumi.get(self, "parent_interface")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> pulumi.Output[_builtins.str]:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")

