# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PbfRuleArgs', 'PbfRule']

@pulumi.input_type
class PbfRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['PbfRuleActionArgs']] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_symmetric_return: Optional[pulumi.Input['PbfRuleEnforceSymmetricReturnArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 from_: Optional[pulumi.Input['PbfRuleFromArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PbfRule resource.
        :param pulumi.Input['PbfRuleActionArgs'] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Applications
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['PbfRuleEnforceSymmetricReturnArgs'] enforce_symmetric_return: Enforce symmetric return
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['PbfRuleFromArgs'] from_: From
        :param pulumi.Input[_builtins.str] name: PBF rule name
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: Source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if enforce_symmetric_return is not None:
            pulumi.set(__self__, "enforce_symmetric_return", enforce_symmetric_return)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_users is not None:
            pulumi.set(__self__, "source_users", source_users)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['PbfRuleActionArgs']]:
        """
        Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['PbfRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Applications
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="enforceSymmetricReturn")
    def enforce_symmetric_return(self) -> Optional[pulumi.Input['PbfRuleEnforceSymmetricReturnArgs']]:
        """
        Enforce symmetric return
        """
        return pulumi.get(self, "enforce_symmetric_return")

    @enforce_symmetric_return.setter
    def enforce_symmetric_return(self, value: Optional[pulumi.Input['PbfRuleEnforceSymmetricReturnArgs']]):
        pulumi.set(self, "enforce_symmetric_return", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input['PbfRuleFromArgs']]:
        """
        From
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input['PbfRuleFromArgs']]):
        pulumi.set(self, "from_", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PBF rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Services
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source users
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PbfRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['PbfRuleActionArgs']] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_symmetric_return: Optional[pulumi.Input['PbfRuleEnforceSymmetricReturnArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 from_: Optional[pulumi.Input['PbfRuleFromArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PbfRule resources.
        :param pulumi.Input['PbfRuleActionArgs'] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Applications
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['PbfRuleEnforceSymmetricReturnArgs'] enforce_symmetric_return: Enforce symmetric return
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['PbfRuleFromArgs'] from_: From
        :param pulumi.Input[_builtins.str] name: PBF rule name
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: Source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if enforce_symmetric_return is not None:
            pulumi.set(__self__, "enforce_symmetric_return", enforce_symmetric_return)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_users is not None:
            pulumi.set(__self__, "source_users", source_users)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['PbfRuleActionArgs']]:
        """
        Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['PbfRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Applications
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="enforceSymmetricReturn")
    def enforce_symmetric_return(self) -> Optional[pulumi.Input['PbfRuleEnforceSymmetricReturnArgs']]:
        """
        Enforce symmetric return
        """
        return pulumi.get(self, "enforce_symmetric_return")

    @enforce_symmetric_return.setter
    def enforce_symmetric_return(self, value: Optional[pulumi.Input['PbfRuleEnforceSymmetricReturnArgs']]):
        pulumi.set(self, "enforce_symmetric_return", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input['PbfRuleFromArgs']]:
        """
        From
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input['PbfRuleFromArgs']]):
        pulumi.set(self, "from_", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PBF rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Services
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source users
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/pbfRule:PbfRule")
class PbfRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['PbfRuleActionArgs', 'PbfRuleActionArgsDict']]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_symmetric_return: Optional[pulumi.Input[Union['PbfRuleEnforceSymmetricReturnArgs', 'PbfRuleEnforceSymmetricReturnArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 from_: Optional[pulumi.Input[Union['PbfRuleFromArgs', 'PbfRuleFromArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        PbfRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        example_tag = scm.Tag("example_tag",
            folder="All",
            name="pbf-rule-tag-test-1",
            color="Red")
        # --- PBF Rule Resource with discard action---
        example_pbf_rule = scm.PbfRule("example_pbf_rule",
            name="pbf-test-rule-discard",
            folder="All",
            description="PBF rule for forwarding specific traffic.",
            from_={
                "zones": ["zone-untrust"],
            },
            sources=["any"],
            destinations=["any"],
            applications=["any"],
            services=["service-http"],
            source_users=["any"],
            action={
                "discard": {},
            },
            tags=[example_tag.name],
            enforce_symmetric_return={
                "enabled": False,
            },
            schedule="non-work-hours")
        # --- PBF Rule Resource with no-pbf action---
        example_no_pbf_rule = scm.PbfRule("example_no_pbf_rule",
            name="pbf-test-rule-no-pbf",
            folder="All",
            description="PBF rule for forwarding specific traffic",
            from_={
                "zones": ["zone-untrust"],
            },
            sources=["any"],
            destinations=["any"],
            applications=["any"],
            services=["service-https"],
            source_users=["any"],
            action={
                "no_pbf": {},
            },
            tags=[example_tag.name],
            enforce_symmetric_return={
                "enabled": False,
            },
            schedule="non-work-hours")
        # --- PBF Rule Resource with forward action---
        example_forward_pbf_rule = scm.PbfRule("example_forward_pbf_rule",
            name="pbf-test-rule-forward",
            folder="All",
            description="PBF rule for forwarding specific traffic",
            from_={
                "zones": ["zone-untrust"],
            },
            sources=["any"],
            destinations=["any"],
            applications=["any"],
            services=["service-http"],
            source_users=["any"],
            action={
                "forward": {
                    "egress_interface": "ethernet1/1",
                    "nexthop": {
                        "ip_address": "192.168.1.254",
                    },
                    "monitor": {
                        "ip_address": "8.8.8.10",
                        "profile": "test_tf_profile",
                        "disable_if_unreachable": True,
                    },
                },
            },
            tags=[example_tag.name],
            enforce_symmetric_return={
                "enabled": True,
            },
            schedule="non-work-hours")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PbfRuleActionArgs', 'PbfRuleActionArgsDict']] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Applications
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['PbfRuleEnforceSymmetricReturnArgs', 'PbfRuleEnforceSymmetricReturnArgsDict']] enforce_symmetric_return: Enforce symmetric return
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['PbfRuleFromArgs', 'PbfRuleFromArgsDict']] from_: From
        :param pulumi.Input[_builtins.str] name: PBF rule name
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: Source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PbfRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        PbfRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        example_tag = scm.Tag("example_tag",
            folder="All",
            name="pbf-rule-tag-test-1",
            color="Red")
        # --- PBF Rule Resource with discard action---
        example_pbf_rule = scm.PbfRule("example_pbf_rule",
            name="pbf-test-rule-discard",
            folder="All",
            description="PBF rule for forwarding specific traffic.",
            from_={
                "zones": ["zone-untrust"],
            },
            sources=["any"],
            destinations=["any"],
            applications=["any"],
            services=["service-http"],
            source_users=["any"],
            action={
                "discard": {},
            },
            tags=[example_tag.name],
            enforce_symmetric_return={
                "enabled": False,
            },
            schedule="non-work-hours")
        # --- PBF Rule Resource with no-pbf action---
        example_no_pbf_rule = scm.PbfRule("example_no_pbf_rule",
            name="pbf-test-rule-no-pbf",
            folder="All",
            description="PBF rule for forwarding specific traffic",
            from_={
                "zones": ["zone-untrust"],
            },
            sources=["any"],
            destinations=["any"],
            applications=["any"],
            services=["service-https"],
            source_users=["any"],
            action={
                "no_pbf": {},
            },
            tags=[example_tag.name],
            enforce_symmetric_return={
                "enabled": False,
            },
            schedule="non-work-hours")
        # --- PBF Rule Resource with forward action---
        example_forward_pbf_rule = scm.PbfRule("example_forward_pbf_rule",
            name="pbf-test-rule-forward",
            folder="All",
            description="PBF rule for forwarding specific traffic",
            from_={
                "zones": ["zone-untrust"],
            },
            sources=["any"],
            destinations=["any"],
            applications=["any"],
            services=["service-http"],
            source_users=["any"],
            action={
                "forward": {
                    "egress_interface": "ethernet1/1",
                    "nexthop": {
                        "ip_address": "192.168.1.254",
                    },
                    "monitor": {
                        "ip_address": "8.8.8.10",
                        "profile": "test_tf_profile",
                        "disable_if_unreachable": True,
                    },
                },
            },
            tags=[example_tag.name],
            enforce_symmetric_return={
                "enabled": True,
            },
            schedule="non-work-hours")
        ```

        :param str resource_name: The name of the resource.
        :param PbfRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PbfRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['PbfRuleActionArgs', 'PbfRuleActionArgsDict']]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce_symmetric_return: Optional[pulumi.Input[Union['PbfRuleEnforceSymmetricReturnArgs', 'PbfRuleEnforceSymmetricReturnArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 from_: Optional[pulumi.Input[Union['PbfRuleFromArgs', 'PbfRuleFromArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PbfRuleArgs.__new__(PbfRuleArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["applications"] = applications
            __props__.__dict__["description"] = description
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["device"] = device
            __props__.__dict__["enforce_symmetric_return"] = enforce_symmetric_return
            __props__.__dict__["folder"] = folder
            __props__.__dict__["from_"] = from_
            __props__.__dict__["name"] = name
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["services"] = services
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["source_users"] = source_users
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tfid"] = None
        super(PbfRule, __self__).__init__(
            'scm:index/pbfRule:PbfRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['PbfRuleActionArgs', 'PbfRuleActionArgsDict']]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            enforce_symmetric_return: Optional[pulumi.Input[Union['PbfRuleEnforceSymmetricReturnArgs', 'PbfRuleEnforceSymmetricReturnArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            from_: Optional[pulumi.Input[Union['PbfRuleFromArgs', 'PbfRuleFromArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'PbfRule':
        """
        Get an existing PbfRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PbfRuleActionArgs', 'PbfRuleActionArgsDict']] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Applications
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['PbfRuleEnforceSymmetricReturnArgs', 'PbfRuleEnforceSymmetricReturnArgsDict']] enforce_symmetric_return: Enforce symmetric return
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['PbfRuleFromArgs', 'PbfRuleFromArgsDict']] from_: From
        :param pulumi.Input[_builtins.str] name: PBF rule name
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: Source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PbfRuleState.__new__(_PbfRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["applications"] = applications
        __props__.__dict__["description"] = description
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["device"] = device
        __props__.__dict__["enforce_symmetric_return"] = enforce_symmetric_return
        __props__.__dict__["folder"] = folder
        __props__.__dict__["from_"] = from_
        __props__.__dict__["name"] = name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["services"] = services
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["source_users"] = source_users
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tfid"] = tfid
        return PbfRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional['outputs.PbfRuleAction']]:
        """
        Action
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Applications
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Destination addresses
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="enforceSymmetricReturn")
    def enforce_symmetric_return(self) -> pulumi.Output[Optional['outputs.PbfRuleEnforceSymmetricReturn']]:
        """
        Enforce symmetric return
        """
        return pulumi.get(self, "enforce_symmetric_return")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Output[Optional['outputs.PbfRuleFrom']]:
        """
        From
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        PBF rule name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Services
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Source users
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Source addresses
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

