# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SdwanRuleArgs', 'SdwanRule']

@pulumi.input_type
class SdwanRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['SdwanRuleActionArgs'],
                 applications: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 destinations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 froms: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 path_quality_profile: pulumi.Input[_builtins.str],
                 position: pulumi.Input[_builtins.str],
                 services: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 source_users: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 tos: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_correction_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 saas_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SdwanRule resource.
        :param pulumi.Input['SdwanRuleActionArgs'] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: List of applications
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: List of destination addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: List of source zones
        :param pulumi.Input[_builtins.str] path_quality_profile: Path quality profile
        :param pulumi.Input[_builtins.str] position: Rule postion relative to device rules
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of services
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: List of source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: List of destination zones
        :param pulumi.Input[_builtins.str] description: Rule description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable rule?
        :param pulumi.Input[_builtins.str] error_correction_profile: Error correction profile
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Rule name
        :param pulumi.Input[_builtins.bool] negate_destination: Negate destination address(es)?
        :param pulumi.Input[_builtins.bool] negate_source: Negate source address(es)?
        :param pulumi.Input[_builtins.str] saas_quality_profile: SaaS quality profile
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "path_quality_profile", path_quality_profile)
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "source_users", source_users)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "tos", tos)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if error_correction_profile is not None:
            pulumi.set(__self__, "error_correction_profile", error_correction_profile)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if saas_quality_profile is not None:
            pulumi.set(__self__, "saas_quality_profile", saas_quality_profile)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['SdwanRuleActionArgs']:
        """
        Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['SdwanRuleActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of applications
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of source zones
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter(name="pathQualityProfile")
    def path_quality_profile(self) -> pulumi.Input[_builtins.str]:
        """
        Path quality profile
        """
        return pulumi.get(self, "path_quality_profile")

    @path_quality_profile.setter
    def path_quality_profile(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path_quality_profile", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Input[_builtins.str]:
        """
        Rule postion relative to device rules
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of services
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of source users
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of destination zones
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tos", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable rule?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="errorCorrectionProfile")
    def error_correction_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error correction profile
        """
        return pulumi.get(self, "error_correction_profile")

    @error_correction_profile.setter
    def error_correction_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_correction_profile", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate destination address(es)?
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate source address(es)?
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter(name="saasQualityProfile")
    def saas_quality_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SaaS quality profile
        """
        return pulumi.get(self, "saas_quality_profile")

    @saas_quality_profile.setter
    def saas_quality_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saas_quality_profile", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SdwanRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['SdwanRuleActionArgs']] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_correction_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 saas_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SdwanRule resources.
        :param pulumi.Input['SdwanRuleActionArgs'] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: List of applications
        :param pulumi.Input[_builtins.str] description: Rule description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: List of destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable rule?
        :param pulumi.Input[_builtins.str] error_correction_profile: Error correction profile
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: List of source zones
        :param pulumi.Input[_builtins.str] name: Rule name
        :param pulumi.Input[_builtins.bool] negate_destination: Negate destination address(es)?
        :param pulumi.Input[_builtins.bool] negate_source: Negate source address(es)?
        :param pulumi.Input[_builtins.str] path_quality_profile: Path quality profile
        :param pulumi.Input[_builtins.str] position: Rule postion relative to device rules
        :param pulumi.Input[_builtins.str] saas_quality_profile: SaaS quality profile
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: List of source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: List of destination zones
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if error_correction_profile is not None:
            pulumi.set(__self__, "error_correction_profile", error_correction_profile)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if path_quality_profile is not None:
            pulumi.set(__self__, "path_quality_profile", path_quality_profile)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if saas_quality_profile is not None:
            pulumi.set(__self__, "saas_quality_profile", saas_quality_profile)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_users is not None:
            pulumi.set(__self__, "source_users", source_users)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['SdwanRuleActionArgs']]:
        """
        Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['SdwanRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of applications
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable rule?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="errorCorrectionProfile")
    def error_correction_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error correction profile
        """
        return pulumi.get(self, "error_correction_profile")

    @error_correction_profile.setter
    def error_correction_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_correction_profile", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source zones
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate destination address(es)?
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate source address(es)?
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter(name="pathQualityProfile")
    def path_quality_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path quality profile
        """
        return pulumi.get(self, "path_quality_profile")

    @path_quality_profile.setter
    def path_quality_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_quality_profile", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule postion relative to device rules
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="saasQualityProfile")
    def saas_quality_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SaaS quality profile
        """
        return pulumi.get(self, "saas_quality_profile")

    @saas_quality_profile.setter
    def saas_quality_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saas_quality_profile", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of services
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source users
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of destination zones
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tos", value)


@pulumi.type_token("scm:index/sdwanRule:SdwanRule")
class SdwanRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['SdwanRuleActionArgs', 'SdwanRuleActionArgsDict']]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_correction_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 saas_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        SdwanRule resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SdwanRuleActionArgs', 'SdwanRuleActionArgsDict']] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: List of applications
        :param pulumi.Input[_builtins.str] description: Rule description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: List of destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable rule?
        :param pulumi.Input[_builtins.str] error_correction_profile: Error correction profile
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: List of source zones
        :param pulumi.Input[_builtins.str] name: Rule name
        :param pulumi.Input[_builtins.bool] negate_destination: Negate destination address(es)?
        :param pulumi.Input[_builtins.bool] negate_source: Negate source address(es)?
        :param pulumi.Input[_builtins.str] path_quality_profile: Path quality profile
        :param pulumi.Input[_builtins.str] position: Rule postion relative to device rules
        :param pulumi.Input[_builtins.str] saas_quality_profile: SaaS quality profile
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: List of source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: List of destination zones
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SdwanRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        SdwanRule resource

        :param str resource_name: The name of the resource.
        :param SdwanRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SdwanRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['SdwanRuleActionArgs', 'SdwanRuleActionArgsDict']]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_correction_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 saas_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SdwanRuleArgs.__new__(SdwanRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            __props__.__dict__["description"] = description
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["device"] = device
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["error_correction_profile"] = error_correction_profile
            __props__.__dict__["folder"] = folder
            if froms is None and not opts.urn:
                raise TypeError("Missing required property 'froms'")
            __props__.__dict__["froms"] = froms
            __props__.__dict__["name"] = name
            __props__.__dict__["negate_destination"] = negate_destination
            __props__.__dict__["negate_source"] = negate_source
            if path_quality_profile is None and not opts.urn:
                raise TypeError("Missing required property 'path_quality_profile'")
            __props__.__dict__["path_quality_profile"] = path_quality_profile
            if position is None and not opts.urn:
                raise TypeError("Missing required property 'position'")
            __props__.__dict__["position"] = position
            __props__.__dict__["saas_quality_profile"] = saas_quality_profile
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            __props__.__dict__["snippet"] = snippet
            if source_users is None and not opts.urn:
                raise TypeError("Missing required property 'source_users'")
            __props__.__dict__["source_users"] = source_users
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            if tos is None and not opts.urn:
                raise TypeError("Missing required property 'tos'")
            __props__.__dict__["tos"] = tos
            __props__.__dict__["tfid"] = None
        super(SdwanRule, __self__).__init__(
            'scm:index/sdwanRule:SdwanRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['SdwanRuleActionArgs', 'SdwanRuleActionArgsDict']]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            error_correction_profile: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
            negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
            path_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            saas_quality_profile: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SdwanRule':
        """
        Get an existing SdwanRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SdwanRuleActionArgs', 'SdwanRuleActionArgsDict']] action: Action
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: List of applications
        :param pulumi.Input[_builtins.str] description: Rule description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: List of destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable rule?
        :param pulumi.Input[_builtins.str] error_correction_profile: Error correction profile
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: List of source zones
        :param pulumi.Input[_builtins.str] name: Rule name
        :param pulumi.Input[_builtins.bool] negate_destination: Negate destination address(es)?
        :param pulumi.Input[_builtins.bool] negate_source: Negate source address(es)?
        :param pulumi.Input[_builtins.str] path_quality_profile: Path quality profile
        :param pulumi.Input[_builtins.str] position: Rule postion relative to device rules
        :param pulumi.Input[_builtins.str] saas_quality_profile: SaaS quality profile
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of services
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: List of source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: List of destination zones
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SdwanRuleState.__new__(_SdwanRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["applications"] = applications
        __props__.__dict__["description"] = description
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["device"] = device
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["error_correction_profile"] = error_correction_profile
        __props__.__dict__["folder"] = folder
        __props__.__dict__["froms"] = froms
        __props__.__dict__["name"] = name
        __props__.__dict__["negate_destination"] = negate_destination
        __props__.__dict__["negate_source"] = negate_source
        __props__.__dict__["path_quality_profile"] = path_quality_profile
        __props__.__dict__["position"] = position
        __props__.__dict__["saas_quality_profile"] = saas_quality_profile
        __props__.__dict__["services"] = services
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["source_users"] = source_users
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["tos"] = tos
        return SdwanRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.SdwanRuleAction']:
        """
        Action
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of applications
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of destination addresses
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Disable rule?
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="errorCorrectionProfile")
    def error_correction_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Error correction profile
        """
        return pulumi.get(self, "error_correction_profile")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of source zones
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> pulumi.Output[_builtins.bool]:
        """
        Negate destination address(es)?
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> pulumi.Output[_builtins.bool]:
        """
        Negate source address(es)?
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter(name="pathQualityProfile")
    def path_quality_profile(self) -> pulumi.Output[_builtins.str]:
        """
        Path quality profile
        """
        return pulumi.get(self, "path_quality_profile")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        Rule postion relative to device rules
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="saasQualityProfile")
    def saas_quality_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SaaS quality profile
        """
        return pulumi.get(self, "saas_quality_profile")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of services
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of source users
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of source addresses
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of destination zones
        """
        return pulumi.get(self, "tos")

