# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceConnectionGroupArgs', 'ServiceConnectionGroup']

@pulumi.input_type
class ServiceConnectionGroupArgs:
    def __init__(__self__, *,
                 targets: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 disable_snat: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pbf_only: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ServiceConnectionGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: Target
        :param pulumi.Input[_builtins.bool] disable_snat: Disable snat
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.bool] pbf_only: Pbf only
        """
        pulumi.set(__self__, "targets", targets)
        if disable_snat is not None:
            pulumi.set(__self__, "disable_snat", disable_snat)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pbf_only is not None:
            pulumi.set(__self__, "pbf_only", pbf_only)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Target
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter(name="disableSnat")
    def disable_snat(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable snat
        """
        return pulumi.get(self, "disable_snat")

    @disable_snat.setter
    def disable_snat(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_snat", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pbfOnly")
    def pbf_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Pbf only
        """
        return pulumi.get(self, "pbf_only")

    @pbf_only.setter
    def pbf_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pbf_only", value)


@pulumi.input_type
class _ServiceConnectionGroupState:
    def __init__(__self__, *,
                 disable_snat: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pbf_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceConnectionGroup resources.
        :param pulumi.Input[_builtins.bool] disable_snat: Disable snat
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.bool] pbf_only: Pbf only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: Target
        """
        if disable_snat is not None:
            pulumi.set(__self__, "disable_snat", disable_snat)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pbf_only is not None:
            pulumi.set(__self__, "pbf_only", pbf_only)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="disableSnat")
    def disable_snat(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable snat
        """
        return pulumi.get(self, "disable_snat")

    @disable_snat.setter
    def disable_snat(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_snat", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pbfOnly")
    def pbf_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Pbf only
        """
        return pulumi.get(self, "pbf_only")

    @pbf_only.setter
    def pbf_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pbf_only", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Target
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/serviceConnectionGroup:ServiceConnectionGroup")
class ServiceConnectionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_snat: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pbf_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ServiceConnectionGroup resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        config = pulumi.Config()
        # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
        folder_scope = config.get("folderScope")
        if folder_scope is None:
            folder_scope = "Service Connections"
        ## 1. IKE Crypto Profile (IKE Phase 1)
        example = scm.IkeCryptoProfile("example",
            name="example-ike-crypto_sc_grp",
            folder=folder_scope,
            hashes=["sha256"],
            dh_groups=["group14"],
            encryptions=["aes-256-cbc"])
        ## 2. IPsec Crypto Profile (IKE Phase 2)
        example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
            name="panw-IPSec-Crypto_sc_grp",
            folder=folder_scope,
            esp={
                "encryptions": ["aes-256-gcm"],
                "authentications": ["sha256"],
            },
            dh_group="group14",
            lifetime={
                "hours": 8,
            })
        ## 3. IKE Gateway
        example_ike_gateway = scm.IkeGateway("example",
            name="example-gateway_sc_grp",
            folder=folder_scope,
            peer_address={
                "ip": "1.1.1.1",
            },
            authentication={
                "pre_shared_key": {
                    "key": "secret",
                },
            },
            protocol={
                "ikev1": {
                    "ike_crypto_profile": example.name,
                },
            })
        ## 4. IPsec Tunnel
        example_ipsec_tunnel = scm.IpsecTunnel("example",
            name="example-tunnel_sc_grp",
            folder=folder_scope,
            tunnel_interface="tunnel",
            anti_replay=True,
            copy_tos=False,
            enable_gre_encapsulation=False,
            auto_key={
                "ike_gateways": [{
                    "name": example_ike_gateway.name,
                }],
                "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
            },
            opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
        ## 5. Service Connection (The target for the group)
        site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
            name="creating_a_service_connection_sc_grp",
            region="us-west-1a",
            ipsec_tunnel=example_ipsec_tunnel.name,
            subnets=[
                "10.1.0.0/16",
                "172.16.0.0/24",
            ],
            source_nat=False)
        ## 5. Service Connection (The target for the group)
        site_a_vpn_sc2 = scm.ServiceConnection("site_a_vpn_sc_2",
            name="creating_a_service_connection_sc_grp_2",
            region="us-west-1a",
            ipsec_tunnel=example_ipsec_tunnel.name,
            subnets=[
                "10.1.0.0/16",
                "172.16.0.0/24",
            ],
            source_nat=True)
        # ------------------------------------------------------------------
        # II. SERVICE CONNECTION GROUP RESOURCE
        # ------------------------------------------------------------------
        ## 6. Service Connection Group (Groups the Service Connection created above)
        example_group = scm.ServiceConnectionGroup("example_group",
            name="service-connection-group-app_sc_grp",
            targets=[
                site_a_vpn_sc.name,
                site_a_vpn_sc2.name,
            ],
            disable_snat=True,
            pbf_only=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disable_snat: Disable snat
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.bool] pbf_only: Pbf only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: Target
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceConnectionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ServiceConnectionGroup resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        config = pulumi.Config()
        # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
        folder_scope = config.get("folderScope")
        if folder_scope is None:
            folder_scope = "Service Connections"
        ## 1. IKE Crypto Profile (IKE Phase 1)
        example = scm.IkeCryptoProfile("example",
            name="example-ike-crypto_sc_grp",
            folder=folder_scope,
            hashes=["sha256"],
            dh_groups=["group14"],
            encryptions=["aes-256-cbc"])
        ## 2. IPsec Crypto Profile (IKE Phase 2)
        example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
            name="panw-IPSec-Crypto_sc_grp",
            folder=folder_scope,
            esp={
                "encryptions": ["aes-256-gcm"],
                "authentications": ["sha256"],
            },
            dh_group="group14",
            lifetime={
                "hours": 8,
            })
        ## 3. IKE Gateway
        example_ike_gateway = scm.IkeGateway("example",
            name="example-gateway_sc_grp",
            folder=folder_scope,
            peer_address={
                "ip": "1.1.1.1",
            },
            authentication={
                "pre_shared_key": {
                    "key": "secret",
                },
            },
            protocol={
                "ikev1": {
                    "ike_crypto_profile": example.name,
                },
            })
        ## 4. IPsec Tunnel
        example_ipsec_tunnel = scm.IpsecTunnel("example",
            name="example-tunnel_sc_grp",
            folder=folder_scope,
            tunnel_interface="tunnel",
            anti_replay=True,
            copy_tos=False,
            enable_gre_encapsulation=False,
            auto_key={
                "ike_gateways": [{
                    "name": example_ike_gateway.name,
                }],
                "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
            },
            opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
        ## 5. Service Connection (The target for the group)
        site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
            name="creating_a_service_connection_sc_grp",
            region="us-west-1a",
            ipsec_tunnel=example_ipsec_tunnel.name,
            subnets=[
                "10.1.0.0/16",
                "172.16.0.0/24",
            ],
            source_nat=False)
        ## 5. Service Connection (The target for the group)
        site_a_vpn_sc2 = scm.ServiceConnection("site_a_vpn_sc_2",
            name="creating_a_service_connection_sc_grp_2",
            region="us-west-1a",
            ipsec_tunnel=example_ipsec_tunnel.name,
            subnets=[
                "10.1.0.0/16",
                "172.16.0.0/24",
            ],
            source_nat=True)
        # ------------------------------------------------------------------
        # II. SERVICE CONNECTION GROUP RESOURCE
        # ------------------------------------------------------------------
        ## 6. Service Connection Group (Groups the Service Connection created above)
        example_group = scm.ServiceConnectionGroup("example_group",
            name="service-connection-group-app_sc_grp",
            targets=[
                site_a_vpn_sc.name,
                site_a_vpn_sc2.name,
            ],
            disable_snat=True,
            pbf_only=False)
        ```

        :param str resource_name: The name of the resource.
        :param ServiceConnectionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceConnectionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_snat: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pbf_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceConnectionGroupArgs.__new__(ServiceConnectionGroupArgs)

            __props__.__dict__["disable_snat"] = disable_snat
            __props__.__dict__["name"] = name
            __props__.__dict__["pbf_only"] = pbf_only
            if targets is None and not opts.urn:
                raise TypeError("Missing required property 'targets'")
            __props__.__dict__["targets"] = targets
            __props__.__dict__["tfid"] = None
        super(ServiceConnectionGroup, __self__).__init__(
            'scm:index/serviceConnectionGroup:ServiceConnectionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disable_snat: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pbf_only: Optional[pulumi.Input[_builtins.bool]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceConnectionGroup':
        """
        Get an existing ServiceConnectionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disable_snat: Disable snat
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.bool] pbf_only: Pbf only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: Target
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceConnectionGroupState.__new__(_ServiceConnectionGroupState)

        __props__.__dict__["disable_snat"] = disable_snat
        __props__.__dict__["name"] = name
        __props__.__dict__["pbf_only"] = pbf_only
        __props__.__dict__["targets"] = targets
        __props__.__dict__["tfid"] = tfid
        return ServiceConnectionGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="disableSnat")
    def disable_snat(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disable snat
        """
        return pulumi.get(self, "disable_snat")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pbfOnly")
    def pbf_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Pbf only
        """
        return pulumi.get(self, "pbf_only")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Target
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

