# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VulnerabilityProtectionProfileArgs', 'VulnerabilityProtectionProfile']

@pulumi.input_type
class VulnerabilityProtectionProfileArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]]] = None):
        """
        The set of arguments for constructing a VulnerabilityProtectionProfile resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]] threat_exceptions: Threat exception
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if threat_exceptions is not None:
            pulumi.set(__self__, "threat_exceptions", threat_exceptions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]]]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]]]:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")

    @threat_exceptions.setter
    def threat_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]]]):
        pulumi.set(self, "threat_exceptions", value)


@pulumi.input_type
class _VulnerabilityProtectionProfileState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering VulnerabilityProtectionProfile resources.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]] threat_exceptions: Threat exception
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if threat_exceptions is not None:
            pulumi.set(__self__, "threat_exceptions", threat_exceptions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]]]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]]]:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")

    @threat_exceptions.setter
    def threat_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VulnerabilityProtectionProfileThreatExceptionArgs']]]]):
        pulumi.set(self, "threat_exceptions", value)


@pulumi.type_token("scm:index/vulnerabilityProtectionProfile:VulnerabilityProtectionProfile")
class VulnerabilityProtectionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileRuleArgs', 'VulnerabilityProtectionProfileRuleArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileThreatExceptionArgs', 'VulnerabilityProtectionProfileThreatExceptionArgsDict']]]]] = None,
                 __props__=None):
        """
        VulnerabilityProtectionProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_vp_profile1_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_1_test",
            folder="Shared",
            name="vp-profile-1-test",
            description="basic profile")
        scm_vp_profile2_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_2_test",
            folder="Shared",
            name="vp-profile-2-test",
            description="rules: allow, alert, and drop",
            rules=[
                {
                    "name": "Rule-Informational-Allow",
                    "action": {
                        "allow": {},
                    },
                    "packet_capture": "extended-capture",
                    "severity": ["informational"],
                    "category": "scan",
                    "cve": ["N/A"],
                    "host": "client",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "30000",
                },
                {
                    "name": "Rule-Medium-Alert",
                    "action": {
                        "alert": {},
                    },
                    "packet_capture": "single-packet",
                    "severity": ["medium"],
                    "category": "info-leak",
                    "cve": ["Match Any CVE"],
                    "host": "server",
                    "vendor_id": ["MS08-037"],
                    "threat_name": "OpenSSL Threat",
                },
                {
                    "name": "Rule-Critical-High-Drop",
                    "action": {
                        "drop": {},
                    },
                    "packet_capture": "disable",
                    "severity": [
                        "critical",
                        "high",
                    ],
                    "category": "overflow",
                    "cve": ["CVE-2008-1147"],
                    "host": "any",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "any",
                },
            ])
        scm_vp_profile3_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_3_test",
            folder="Shared",
            name="vp-profile-3-test",
            description="rules: reset client, reset server, reset both",
            rules=[
                {
                    "name": "Rule-Low-Reset_Client",
                    "action": {
                        "reset_client": {},
                    },
                    "severity": ["low"],
                    "category": "protocol-anomaly",
                    "cve": [
                        "CVE-2010-3332",
                        "CVE-2019-14537",
                    ],
                    "host": "client",
                    "vendor_id": [
                        "MSO5-032",
                        "IZ18434",
                    ],
                    "threat_name": "30261",
                },
                {
                    "name": "Rule-Info-Low-Reset_Server",
                    "action": {
                        "reset_server": {},
                    },
                    "packet_capture": "disable",
                    "severity": [
                        "informational",
                        "low",
                    ],
                    "category": "insecure-credentials",
                    "cve": ["N/A"],
                    "host": "server",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "Zone Bypass",
                },
                {
                    "name": "Rule-Medium-Reset_Both",
                    "action": {
                        "reset_both": {},
                    },
                    "packet_capture": "single-packet",
                    "severity": ["medium"],
                    "category": "brute-force",
                    "cve": [
                        "CVE-2012-0175",
                        "CVE-2024-6387",
                        "CVE-2017-14473",
                    ],
                    "host": "any",
                    "vendor_id": [
                        "CORE-1009-0227",
                        "SHIRO-550",
                        "AST-2012-008",
                    ],
                    "threat_name": "any",
                },
            ])
        scm_vp_profile4_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_4_test",
            folder="Shared",
            name="vp-profile-4-test",
            description="rules: block ip",
            rules=[
                {
                    "name": "Rule-High-Critical-Block_IP",
                    "action": {
                        "block_ip": {
                            "duration": 3600,
                            "track_by": "source-and-destination",
                        },
                    },
                    "severity": [
                        "high",
                        "critical",
                    ],
                    "category": "insecure-credentials",
                    "cve": ["N/A"],
                    "host": "server",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "Zone Credentials",
                },
                {
                    "name": "Rule-Low-Medium-Block_IP",
                    "action": {
                        "block_ip": {
                            "duration": 2400,
                            "track_by": "source-and-destination",
                        },
                    },
                    "severity": [
                        "low",
                        "medium",
                    ],
                    "category": "command-execution",
                    "cve": ["N/A"],
                    "host": "server",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "any",
                },
            ])
        scm_vp_profile5_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_5_test",
            folder="Shared",
            name="vp-profile-5-test",
            description="override",
            threat_exceptions=[{
                "name": "12345",
                "action": {
                    "allow": {},
                },
                "severity": ["informational"],
                "category": "command-execution",
                "exempt_ip": [{
                    "name": "192.14.3.100",
                }],
                "time_attribute": {
                    "interval": 3600,
                    "threshold": 24000,
                    "track_by": "source",
                },
            }])
        scm_vp_profile6_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_6_test",
            folder="Shared",
            name="vp-profile-6-test",
            description="mixed",
            rules=[
                {
                    "name": "Rule-Info-Rest_Both",
                    "action": {
                        "allow": {},
                    },
                    "packet_capture": "disable",
                    "severity": ["informational"],
                    "category": "exploit-kit",
                    "cve": ["N/A"],
                    "host": "client",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "30000",
                },
                {
                    "name": "Rule-Low-Alert",
                    "action": {
                        "alert": {},
                    },
                    "packet_capture": "single-packet",
                    "severity": ["low"],
                    "category": "dos",
                    "cve": ["CVE-2020-8790"],
                    "host": "server",
                    "vendor_id": ["MS09-036"],
                    "threat_name": "Memory Corruption",
                },
                {
                    "name": "Rule-Medium-Drop",
                    "action": {
                        "drop": {},
                    },
                    "packet_capture": "disable",
                    "severity": [
                        "medium",
                        "high",
                    ],
                    "category": "insecure-credentials",
                    "cve": ["N/A"],
                    "host": "any",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "any",
                },
            ],
            threat_exceptions=[{
                "name": "12345",
                "action": {
                    "drop": {},
                },
                "packet_capture": "single-packet",
                "host": "any",
                "category": "scan",
                "cve": [
                    "CVE-2011-2663",
                    "CVE-2016-9949",
                ],
                "exempt_ip": [{
                    "name": "192.14.3.100",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileRuleArgs', 'VulnerabilityProtectionProfileRuleArgsDict']]]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileThreatExceptionArgs', 'VulnerabilityProtectionProfileThreatExceptionArgsDict']]]] threat_exceptions: Threat exception
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VulnerabilityProtectionProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VulnerabilityProtectionProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_vp_profile1_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_1_test",
            folder="Shared",
            name="vp-profile-1-test",
            description="basic profile")
        scm_vp_profile2_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_2_test",
            folder="Shared",
            name="vp-profile-2-test",
            description="rules: allow, alert, and drop",
            rules=[
                {
                    "name": "Rule-Informational-Allow",
                    "action": {
                        "allow": {},
                    },
                    "packet_capture": "extended-capture",
                    "severity": ["informational"],
                    "category": "scan",
                    "cve": ["N/A"],
                    "host": "client",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "30000",
                },
                {
                    "name": "Rule-Medium-Alert",
                    "action": {
                        "alert": {},
                    },
                    "packet_capture": "single-packet",
                    "severity": ["medium"],
                    "category": "info-leak",
                    "cve": ["Match Any CVE"],
                    "host": "server",
                    "vendor_id": ["MS08-037"],
                    "threat_name": "OpenSSL Threat",
                },
                {
                    "name": "Rule-Critical-High-Drop",
                    "action": {
                        "drop": {},
                    },
                    "packet_capture": "disable",
                    "severity": [
                        "critical",
                        "high",
                    ],
                    "category": "overflow",
                    "cve": ["CVE-2008-1147"],
                    "host": "any",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "any",
                },
            ])
        scm_vp_profile3_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_3_test",
            folder="Shared",
            name="vp-profile-3-test",
            description="rules: reset client, reset server, reset both",
            rules=[
                {
                    "name": "Rule-Low-Reset_Client",
                    "action": {
                        "reset_client": {},
                    },
                    "severity": ["low"],
                    "category": "protocol-anomaly",
                    "cve": [
                        "CVE-2010-3332",
                        "CVE-2019-14537",
                    ],
                    "host": "client",
                    "vendor_id": [
                        "MSO5-032",
                        "IZ18434",
                    ],
                    "threat_name": "30261",
                },
                {
                    "name": "Rule-Info-Low-Reset_Server",
                    "action": {
                        "reset_server": {},
                    },
                    "packet_capture": "disable",
                    "severity": [
                        "informational",
                        "low",
                    ],
                    "category": "insecure-credentials",
                    "cve": ["N/A"],
                    "host": "server",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "Zone Bypass",
                },
                {
                    "name": "Rule-Medium-Reset_Both",
                    "action": {
                        "reset_both": {},
                    },
                    "packet_capture": "single-packet",
                    "severity": ["medium"],
                    "category": "brute-force",
                    "cve": [
                        "CVE-2012-0175",
                        "CVE-2024-6387",
                        "CVE-2017-14473",
                    ],
                    "host": "any",
                    "vendor_id": [
                        "CORE-1009-0227",
                        "SHIRO-550",
                        "AST-2012-008",
                    ],
                    "threat_name": "any",
                },
            ])
        scm_vp_profile4_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_4_test",
            folder="Shared",
            name="vp-profile-4-test",
            description="rules: block ip",
            rules=[
                {
                    "name": "Rule-High-Critical-Block_IP",
                    "action": {
                        "block_ip": {
                            "duration": 3600,
                            "track_by": "source-and-destination",
                        },
                    },
                    "severity": [
                        "high",
                        "critical",
                    ],
                    "category": "insecure-credentials",
                    "cve": ["N/A"],
                    "host": "server",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "Zone Credentials",
                },
                {
                    "name": "Rule-Low-Medium-Block_IP",
                    "action": {
                        "block_ip": {
                            "duration": 2400,
                            "track_by": "source-and-destination",
                        },
                    },
                    "severity": [
                        "low",
                        "medium",
                    ],
                    "category": "command-execution",
                    "cve": ["N/A"],
                    "host": "server",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "any",
                },
            ])
        scm_vp_profile5_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_5_test",
            folder="Shared",
            name="vp-profile-5-test",
            description="override",
            threat_exceptions=[{
                "name": "12345",
                "action": {
                    "allow": {},
                },
                "severity": ["informational"],
                "category": "command-execution",
                "exempt_ip": [{
                    "name": "192.14.3.100",
                }],
                "time_attribute": {
                    "interval": 3600,
                    "threshold": 24000,
                    "track_by": "source",
                },
            }])
        scm_vp_profile6_test = scm.VulnerabilityProtectionProfile("scm_vp_profile_6_test",
            folder="Shared",
            name="vp-profile-6-test",
            description="mixed",
            rules=[
                {
                    "name": "Rule-Info-Rest_Both",
                    "action": {
                        "allow": {},
                    },
                    "packet_capture": "disable",
                    "severity": ["informational"],
                    "category": "exploit-kit",
                    "cve": ["N/A"],
                    "host": "client",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "30000",
                },
                {
                    "name": "Rule-Low-Alert",
                    "action": {
                        "alert": {},
                    },
                    "packet_capture": "single-packet",
                    "severity": ["low"],
                    "category": "dos",
                    "cve": ["CVE-2020-8790"],
                    "host": "server",
                    "vendor_id": ["MS09-036"],
                    "threat_name": "Memory Corruption",
                },
                {
                    "name": "Rule-Medium-Drop",
                    "action": {
                        "drop": {},
                    },
                    "packet_capture": "disable",
                    "severity": [
                        "medium",
                        "high",
                    ],
                    "category": "insecure-credentials",
                    "cve": ["N/A"],
                    "host": "any",
                    "vendor_id": ["Match Any Vendor"],
                    "threat_name": "any",
                },
            ],
            threat_exceptions=[{
                "name": "12345",
                "action": {
                    "drop": {},
                },
                "packet_capture": "single-packet",
                "host": "any",
                "category": "scan",
                "cve": [
                    "CVE-2011-2663",
                    "CVE-2016-9949",
                ],
                "exempt_ip": [{
                    "name": "192.14.3.100",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param VulnerabilityProtectionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityProtectionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileRuleArgs', 'VulnerabilityProtectionProfileRuleArgsDict']]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileThreatExceptionArgs', 'VulnerabilityProtectionProfileThreatExceptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityProtectionProfileArgs.__new__(VulnerabilityProtectionProfileArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["threat_exceptions"] = threat_exceptions
            __props__.__dict__["tfid"] = None
        super(VulnerabilityProtectionProfile, __self__).__init__(
            'scm:index/vulnerabilityProtectionProfile:VulnerabilityProtectionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileRuleArgs', 'VulnerabilityProtectionProfileRuleArgsDict']]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            threat_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileThreatExceptionArgs', 'VulnerabilityProtectionProfileThreatExceptionArgsDict']]]]] = None) -> 'VulnerabilityProtectionProfile':
        """
        Get an existing VulnerabilityProtectionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileRuleArgs', 'VulnerabilityProtectionProfileRuleArgsDict']]]] rules: Rules
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[Union['VulnerabilityProtectionProfileThreatExceptionArgs', 'VulnerabilityProtectionProfileThreatExceptionArgsDict']]]] threat_exceptions: Threat exception
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityProtectionProfileState.__new__(_VulnerabilityProtectionProfileState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["threat_exceptions"] = threat_exceptions
        return VulnerabilityProtectionProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.VulnerabilityProtectionProfileRule']]]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="threatExceptions")
    def threat_exceptions(self) -> pulumi.Output[Optional[Sequence['outputs.VulnerabilityProtectionProfileThreatException']]]:
        """
        Threat exception
        """
        return pulumi.get(self, "threat_exceptions")

