# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneProtectionProfileArgs', 'ZoneProtectionProfile']

@pulumi.input_type
class ZoneProtectionProfileArgs:
    def __init__(__self__, *,
                 asymmetric_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_icmp_embedded_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 flood: Optional[pulumi.Input['ZoneProtectionProfileFloodArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fragmented_traffic_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_frag_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_large_packet_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_ping_zero_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input['ZoneProtectionProfileIpv6Args']] = None,
                 l2_sec_group_tag_protection: Optional[pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs']] = None,
                 loose_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 malformed_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mismatched_overlapping_tcp_segment_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mptcp_option_strip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ip_protocol: Optional[pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs']] = None,
                 record_route_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 reject_non_syn_tcp: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]]] = None,
                 security_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 spoofed_ip_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_ip_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_needfrag: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_timeexceeded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_fast_open_and_data_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_handshake_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_syn_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_synack_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_timestamp_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 unknown_option_discard: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ZoneProtectionProfile resource.
        :param pulumi.Input[_builtins.str] asymmetric_path: Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
               * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
               * `drop` — Drop packets that contain an asymmetric path.
               * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        :param pulumi.Input[_builtins.str] description: The description of the profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] discard_icmp_embedded_error: Discard ICMP packets that are embedded with an error message.
        :param pulumi.Input['ZoneProtectionProfileFloodArgs'] flood: Flood
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] fragmented_traffic_discard: Discard fragmented IP packets.
        :param pulumi.Input[_builtins.bool] icmp_frag_discard: Discard packets that consist of ICMP fragments.
        :param pulumi.Input[_builtins.bool] icmp_large_packet_discard: Discard ICMP packets that are larger than 1024 bytes.
        :param pulumi.Input[_builtins.bool] icmp_ping_zero_id_discard: Discard packets if the ICMP ping packet has an identifier value of 0.
        :param pulumi.Input['ZoneProtectionProfileIpv6Args'] ipv6: Ipv6
        :param pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs'] l2_sec_group_tag_protection: L2 sec group tag protection
        :param pulumi.Input[_builtins.bool] loose_source_routing_discard: Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        :param pulumi.Input[_builtins.bool] malformed_option_discard: Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        :param pulumi.Input[_builtins.bool] mismatched_overlapping_tcp_segment_discard: Drop packets with mismatched overlapping TCP segments.
        :param pulumi.Input[_builtins.str] mptcp_option_strip: MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
               * `no` — Enable MPTCP support (do not strip the MPTCP option).
               * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
               * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        :param pulumi.Input[_builtins.str] name: The profile name
        :param pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs'] non_ip_protocol: Non ip protocol
        :param pulumi.Input[_builtins.bool] record_route_discard: Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        :param pulumi.Input[_builtins.str] reject_non_syn_tcp: Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
               * `global` — Use system-wide setting that is assigned through the CLI.
               * `yes` — Reject non-SYN TCP.
               * `no` — Accept non-SYN TCP.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]] scan_white_lists: Scan white list
        :param pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]] scans: Scan
        :param pulumi.Input[_builtins.bool] security_discard: Discard packets if the security option is defined.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.bool] spoofed_ip_discard: Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] stream_id_discard: Discard packets if the Stream ID option is defined.
        :param pulumi.Input[_builtins.bool] strict_ip_check: Check that both conditions are true:
               * The source IP address is not the subnet broadcast IP address of the ingress interface.
               * The source IP address is routable over the exact ingress interface.
               If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] strict_source_routing_discard: Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        :param pulumi.Input[_builtins.bool] suppress_icmp_needfrag: Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        :param pulumi.Input[_builtins.bool] suppress_icmp_timeexceeded: Stop sending ICMP TTL expired messages.
        :param pulumi.Input[_builtins.bool] tcp_fast_open_and_data_strip: Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_handshake_discard: Drop packets with split handshakes.
        :param pulumi.Input[_builtins.bool] tcp_syn_with_data_discard: Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_synack_with_data_discard: Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_timestamp_strip: Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        :param pulumi.Input[_builtins.bool] timestamp_discard: Discard packets with the Timestamp IP option set.
        :param pulumi.Input[_builtins.bool] unknown_option_discard: Discard packets if the class and number are unknown.
        """
        if asymmetric_path is not None:
            pulumi.set(__self__, "asymmetric_path", asymmetric_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if discard_icmp_embedded_error is not None:
            pulumi.set(__self__, "discard_icmp_embedded_error", discard_icmp_embedded_error)
        if flood is not None:
            pulumi.set(__self__, "flood", flood)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if fragmented_traffic_discard is not None:
            pulumi.set(__self__, "fragmented_traffic_discard", fragmented_traffic_discard)
        if icmp_frag_discard is not None:
            pulumi.set(__self__, "icmp_frag_discard", icmp_frag_discard)
        if icmp_large_packet_discard is not None:
            pulumi.set(__self__, "icmp_large_packet_discard", icmp_large_packet_discard)
        if icmp_ping_zero_id_discard is not None:
            pulumi.set(__self__, "icmp_ping_zero_id_discard", icmp_ping_zero_id_discard)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if l2_sec_group_tag_protection is not None:
            pulumi.set(__self__, "l2_sec_group_tag_protection", l2_sec_group_tag_protection)
        if loose_source_routing_discard is not None:
            pulumi.set(__self__, "loose_source_routing_discard", loose_source_routing_discard)
        if malformed_option_discard is not None:
            pulumi.set(__self__, "malformed_option_discard", malformed_option_discard)
        if mismatched_overlapping_tcp_segment_discard is not None:
            pulumi.set(__self__, "mismatched_overlapping_tcp_segment_discard", mismatched_overlapping_tcp_segment_discard)
        if mptcp_option_strip is not None:
            pulumi.set(__self__, "mptcp_option_strip", mptcp_option_strip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_ip_protocol is not None:
            pulumi.set(__self__, "non_ip_protocol", non_ip_protocol)
        if record_route_discard is not None:
            pulumi.set(__self__, "record_route_discard", record_route_discard)
        if reject_non_syn_tcp is not None:
            pulumi.set(__self__, "reject_non_syn_tcp", reject_non_syn_tcp)
        if scan_white_lists is not None:
            pulumi.set(__self__, "scan_white_lists", scan_white_lists)
        if scans is not None:
            pulumi.set(__self__, "scans", scans)
        if security_discard is not None:
            pulumi.set(__self__, "security_discard", security_discard)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if spoofed_ip_discard is not None:
            pulumi.set(__self__, "spoofed_ip_discard", spoofed_ip_discard)
        if stream_id_discard is not None:
            pulumi.set(__self__, "stream_id_discard", stream_id_discard)
        if strict_ip_check is not None:
            pulumi.set(__self__, "strict_ip_check", strict_ip_check)
        if strict_source_routing_discard is not None:
            pulumi.set(__self__, "strict_source_routing_discard", strict_source_routing_discard)
        if suppress_icmp_needfrag is not None:
            pulumi.set(__self__, "suppress_icmp_needfrag", suppress_icmp_needfrag)
        if suppress_icmp_timeexceeded is not None:
            pulumi.set(__self__, "suppress_icmp_timeexceeded", suppress_icmp_timeexceeded)
        if tcp_fast_open_and_data_strip is not None:
            pulumi.set(__self__, "tcp_fast_open_and_data_strip", tcp_fast_open_and_data_strip)
        if tcp_handshake_discard is not None:
            pulumi.set(__self__, "tcp_handshake_discard", tcp_handshake_discard)
        if tcp_syn_with_data_discard is not None:
            pulumi.set(__self__, "tcp_syn_with_data_discard", tcp_syn_with_data_discard)
        if tcp_synack_with_data_discard is not None:
            pulumi.set(__self__, "tcp_synack_with_data_discard", tcp_synack_with_data_discard)
        if tcp_timestamp_strip is not None:
            pulumi.set(__self__, "tcp_timestamp_strip", tcp_timestamp_strip)
        if timestamp_discard is not None:
            pulumi.set(__self__, "timestamp_discard", timestamp_discard)
        if unknown_option_discard is not None:
            pulumi.set(__self__, "unknown_option_discard", unknown_option_discard)

    @_builtins.property
    @pulumi.getter(name="asymmetricPath")
    def asymmetric_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
        * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
        * `drop` — Drop packets that contain an asymmetric path.
        * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        """
        return pulumi.get(self, "asymmetric_path")

    @asymmetric_path.setter
    def asymmetric_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asymmetric_path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="discardIcmpEmbeddedError")
    def discard_icmp_embedded_error(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard ICMP packets that are embedded with an error message.
        """
        return pulumi.get(self, "discard_icmp_embedded_error")

    @discard_icmp_embedded_error.setter
    def discard_icmp_embedded_error(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "discard_icmp_embedded_error", value)

    @_builtins.property
    @pulumi.getter
    def flood(self) -> Optional[pulumi.Input['ZoneProtectionProfileFloodArgs']]:
        """
        Flood
        """
        return pulumi.get(self, "flood")

    @flood.setter
    def flood(self, value: Optional[pulumi.Input['ZoneProtectionProfileFloodArgs']]):
        pulumi.set(self, "flood", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="fragmentedTrafficDiscard")
    def fragmented_traffic_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard fragmented IP packets.
        """
        return pulumi.get(self, "fragmented_traffic_discard")

    @fragmented_traffic_discard.setter
    def fragmented_traffic_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fragmented_traffic_discard", value)

    @_builtins.property
    @pulumi.getter(name="icmpFragDiscard")
    def icmp_frag_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets that consist of ICMP fragments.
        """
        return pulumi.get(self, "icmp_frag_discard")

    @icmp_frag_discard.setter
    def icmp_frag_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_frag_discard", value)

    @_builtins.property
    @pulumi.getter(name="icmpLargePacketDiscard")
    def icmp_large_packet_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard ICMP packets that are larger than 1024 bytes.
        """
        return pulumi.get(self, "icmp_large_packet_discard")

    @icmp_large_packet_discard.setter
    def icmp_large_packet_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_large_packet_discard", value)

    @_builtins.property
    @pulumi.getter(name="icmpPingZeroIdDiscard")
    def icmp_ping_zero_id_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the ICMP ping packet has an identifier value of 0.
        """
        return pulumi.get(self, "icmp_ping_zero_id_discard")

    @icmp_ping_zero_id_discard.setter
    def icmp_ping_zero_id_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_ping_zero_id_discard", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ZoneProtectionProfileIpv6Args']]:
        """
        Ipv6
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ZoneProtectionProfileIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="l2SecGroupTagProtection")
    def l2_sec_group_tag_protection(self) -> Optional[pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs']]:
        """
        L2 sec group tag protection
        """
        return pulumi.get(self, "l2_sec_group_tag_protection")

    @l2_sec_group_tag_protection.setter
    def l2_sec_group_tag_protection(self, value: Optional[pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs']]):
        pulumi.set(self, "l2_sec_group_tag_protection", value)

    @_builtins.property
    @pulumi.getter(name="looseSourceRoutingDiscard")
    def loose_source_routing_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        """
        return pulumi.get(self, "loose_source_routing_discard")

    @loose_source_routing_discard.setter
    def loose_source_routing_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "loose_source_routing_discard", value)

    @_builtins.property
    @pulumi.getter(name="malformedOptionDiscard")
    def malformed_option_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        """
        return pulumi.get(self, "malformed_option_discard")

    @malformed_option_discard.setter
    def malformed_option_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "malformed_option_discard", value)

    @_builtins.property
    @pulumi.getter(name="mismatchedOverlappingTcpSegmentDiscard")
    def mismatched_overlapping_tcp_segment_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Drop packets with mismatched overlapping TCP segments.
        """
        return pulumi.get(self, "mismatched_overlapping_tcp_segment_discard")

    @mismatched_overlapping_tcp_segment_discard.setter
    def mismatched_overlapping_tcp_segment_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mismatched_overlapping_tcp_segment_discard", value)

    @_builtins.property
    @pulumi.getter(name="mptcpOptionStrip")
    def mptcp_option_strip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
        * `no` — Enable MPTCP support (do not strip the MPTCP option).
        * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
        * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        """
        return pulumi.get(self, "mptcp_option_strip")

    @mptcp_option_strip.setter
    def mptcp_option_strip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mptcp_option_strip", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The profile name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonIpProtocol")
    def non_ip_protocol(self) -> Optional[pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs']]:
        """
        Non ip protocol
        """
        return pulumi.get(self, "non_ip_protocol")

    @non_ip_protocol.setter
    def non_ip_protocol(self, value: Optional[pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs']]):
        pulumi.set(self, "non_ip_protocol", value)

    @_builtins.property
    @pulumi.getter(name="recordRouteDiscard")
    def record_route_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        """
        return pulumi.get(self, "record_route_discard")

    @record_route_discard.setter
    def record_route_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "record_route_discard", value)

    @_builtins.property
    @pulumi.getter(name="rejectNonSynTcp")
    def reject_non_syn_tcp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
        * `global` — Use system-wide setting that is assigned through the CLI.
        * `yes` — Reject non-SYN TCP.
        * `no` — Accept non-SYN TCP.
        """
        return pulumi.get(self, "reject_non_syn_tcp")

    @reject_non_syn_tcp.setter
    def reject_non_syn_tcp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reject_non_syn_tcp", value)

    @_builtins.property
    @pulumi.getter(name="scanWhiteLists")
    def scan_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]]]:
        """
        Scan white list
        """
        return pulumi.get(self, "scan_white_lists")

    @scan_white_lists.setter
    def scan_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]]]):
        pulumi.set(self, "scan_white_lists", value)

    @_builtins.property
    @pulumi.getter
    def scans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]]]:
        """
        Scan
        """
        return pulumi.get(self, "scans")

    @scans.setter
    def scans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]]]):
        pulumi.set(self, "scans", value)

    @_builtins.property
    @pulumi.getter(name="securityDiscard")
    def security_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the security option is defined.
        """
        return pulumi.get(self, "security_discard")

    @security_discard.setter
    def security_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_discard", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="spoofedIpDiscard")
    def spoofed_ip_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        """
        return pulumi.get(self, "spoofed_ip_discard")

    @spoofed_ip_discard.setter
    def spoofed_ip_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spoofed_ip_discard", value)

    @_builtins.property
    @pulumi.getter(name="streamIdDiscard")
    def stream_id_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the Stream ID option is defined.
        """
        return pulumi.get(self, "stream_id_discard")

    @stream_id_discard.setter
    def stream_id_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stream_id_discard", value)

    @_builtins.property
    @pulumi.getter(name="strictIpCheck")
    def strict_ip_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check that both conditions are true:
        * The source IP address is not the subnet broadcast IP address of the ingress interface.
        * The source IP address is routable over the exact ingress interface.
        If either condition is not true, discard the packet.
        """
        return pulumi.get(self, "strict_ip_check")

    @strict_ip_check.setter
    def strict_ip_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strict_ip_check", value)

    @_builtins.property
    @pulumi.getter(name="strictSourceRoutingDiscard")
    def strict_source_routing_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        """
        return pulumi.get(self, "strict_source_routing_discard")

    @strict_source_routing_discard.setter
    def strict_source_routing_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strict_source_routing_discard", value)

    @_builtins.property
    @pulumi.getter(name="suppressIcmpNeedfrag")
    def suppress_icmp_needfrag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        """
        return pulumi.get(self, "suppress_icmp_needfrag")

    @suppress_icmp_needfrag.setter
    def suppress_icmp_needfrag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppress_icmp_needfrag", value)

    @_builtins.property
    @pulumi.getter(name="suppressIcmpTimeexceeded")
    def suppress_icmp_timeexceeded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Stop sending ICMP TTL expired messages.
        """
        return pulumi.get(self, "suppress_icmp_timeexceeded")

    @suppress_icmp_timeexceeded.setter
    def suppress_icmp_timeexceeded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppress_icmp_timeexceeded", value)

    @_builtins.property
    @pulumi.getter(name="tcpFastOpenAndDataStrip")
    def tcp_fast_open_and_data_strip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        """
        return pulumi.get(self, "tcp_fast_open_and_data_strip")

    @tcp_fast_open_and_data_strip.setter
    def tcp_fast_open_and_data_strip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_fast_open_and_data_strip", value)

    @_builtins.property
    @pulumi.getter(name="tcpHandshakeDiscard")
    def tcp_handshake_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Drop packets with split handshakes.
        """
        return pulumi.get(self, "tcp_handshake_discard")

    @tcp_handshake_discard.setter
    def tcp_handshake_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_handshake_discard", value)

    @_builtins.property
    @pulumi.getter(name="tcpSynWithDataDiscard")
    def tcp_syn_with_data_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        """
        return pulumi.get(self, "tcp_syn_with_data_discard")

    @tcp_syn_with_data_discard.setter
    def tcp_syn_with_data_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_syn_with_data_discard", value)

    @_builtins.property
    @pulumi.getter(name="tcpSynackWithDataDiscard")
    def tcp_synack_with_data_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        """
        return pulumi.get(self, "tcp_synack_with_data_discard")

    @tcp_synack_with_data_discard.setter
    def tcp_synack_with_data_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_synack_with_data_discard", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimestampStrip")
    def tcp_timestamp_strip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        """
        return pulumi.get(self, "tcp_timestamp_strip")

    @tcp_timestamp_strip.setter
    def tcp_timestamp_strip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_timestamp_strip", value)

    @_builtins.property
    @pulumi.getter(name="timestampDiscard")
    def timestamp_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Timestamp IP option set.
        """
        return pulumi.get(self, "timestamp_discard")

    @timestamp_discard.setter
    def timestamp_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "timestamp_discard", value)

    @_builtins.property
    @pulumi.getter(name="unknownOptionDiscard")
    def unknown_option_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the class and number are unknown.
        """
        return pulumi.get(self, "unknown_option_discard")

    @unknown_option_discard.setter
    def unknown_option_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unknown_option_discard", value)


@pulumi.input_type
class _ZoneProtectionProfileState:
    def __init__(__self__, *,
                 asymmetric_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_icmp_embedded_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 flood: Optional[pulumi.Input['ZoneProtectionProfileFloodArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fragmented_traffic_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_frag_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_large_packet_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_ping_zero_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input['ZoneProtectionProfileIpv6Args']] = None,
                 l2_sec_group_tag_protection: Optional[pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs']] = None,
                 loose_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 malformed_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mismatched_overlapping_tcp_segment_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mptcp_option_strip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ip_protocol: Optional[pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs']] = None,
                 record_route_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 reject_non_syn_tcp: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]]] = None,
                 security_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 spoofed_ip_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_ip_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_needfrag: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_timeexceeded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_fast_open_and_data_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_handshake_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_syn_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_synack_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_timestamp_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 unknown_option_discard: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ZoneProtectionProfile resources.
        :param pulumi.Input[_builtins.str] asymmetric_path: Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
               * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
               * `drop` — Drop packets that contain an asymmetric path.
               * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        :param pulumi.Input[_builtins.str] description: The description of the profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] discard_icmp_embedded_error: Discard ICMP packets that are embedded with an error message.
        :param pulumi.Input['ZoneProtectionProfileFloodArgs'] flood: Flood
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] fragmented_traffic_discard: Discard fragmented IP packets.
        :param pulumi.Input[_builtins.bool] icmp_frag_discard: Discard packets that consist of ICMP fragments.
        :param pulumi.Input[_builtins.bool] icmp_large_packet_discard: Discard ICMP packets that are larger than 1024 bytes.
        :param pulumi.Input[_builtins.bool] icmp_ping_zero_id_discard: Discard packets if the ICMP ping packet has an identifier value of 0.
        :param pulumi.Input['ZoneProtectionProfileIpv6Args'] ipv6: Ipv6
        :param pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs'] l2_sec_group_tag_protection: L2 sec group tag protection
        :param pulumi.Input[_builtins.bool] loose_source_routing_discard: Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        :param pulumi.Input[_builtins.bool] malformed_option_discard: Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        :param pulumi.Input[_builtins.bool] mismatched_overlapping_tcp_segment_discard: Drop packets with mismatched overlapping TCP segments.
        :param pulumi.Input[_builtins.str] mptcp_option_strip: MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
               * `no` — Enable MPTCP support (do not strip the MPTCP option).
               * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
               * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        :param pulumi.Input[_builtins.str] name: The profile name
        :param pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs'] non_ip_protocol: Non ip protocol
        :param pulumi.Input[_builtins.bool] record_route_discard: Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        :param pulumi.Input[_builtins.str] reject_non_syn_tcp: Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
               * `global` — Use system-wide setting that is assigned through the CLI.
               * `yes` — Reject non-SYN TCP.
               * `no` — Accept non-SYN TCP.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]] scan_white_lists: Scan white list
        :param pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]] scans: Scan
        :param pulumi.Input[_builtins.bool] security_discard: Discard packets if the security option is defined.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.bool] spoofed_ip_discard: Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] stream_id_discard: Discard packets if the Stream ID option is defined.
        :param pulumi.Input[_builtins.bool] strict_ip_check: Check that both conditions are true:
               * The source IP address is not the subnet broadcast IP address of the ingress interface.
               * The source IP address is routable over the exact ingress interface.
               If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] strict_source_routing_discard: Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        :param pulumi.Input[_builtins.bool] suppress_icmp_needfrag: Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        :param pulumi.Input[_builtins.bool] suppress_icmp_timeexceeded: Stop sending ICMP TTL expired messages.
        :param pulumi.Input[_builtins.bool] tcp_fast_open_and_data_strip: Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_handshake_discard: Drop packets with split handshakes.
        :param pulumi.Input[_builtins.bool] tcp_syn_with_data_discard: Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_synack_with_data_discard: Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_timestamp_strip: Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        :param pulumi.Input[_builtins.bool] timestamp_discard: Discard packets with the Timestamp IP option set.
        :param pulumi.Input[_builtins.bool] unknown_option_discard: Discard packets if the class and number are unknown.
        """
        if asymmetric_path is not None:
            pulumi.set(__self__, "asymmetric_path", asymmetric_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if discard_icmp_embedded_error is not None:
            pulumi.set(__self__, "discard_icmp_embedded_error", discard_icmp_embedded_error)
        if flood is not None:
            pulumi.set(__self__, "flood", flood)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if fragmented_traffic_discard is not None:
            pulumi.set(__self__, "fragmented_traffic_discard", fragmented_traffic_discard)
        if icmp_frag_discard is not None:
            pulumi.set(__self__, "icmp_frag_discard", icmp_frag_discard)
        if icmp_large_packet_discard is not None:
            pulumi.set(__self__, "icmp_large_packet_discard", icmp_large_packet_discard)
        if icmp_ping_zero_id_discard is not None:
            pulumi.set(__self__, "icmp_ping_zero_id_discard", icmp_ping_zero_id_discard)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if l2_sec_group_tag_protection is not None:
            pulumi.set(__self__, "l2_sec_group_tag_protection", l2_sec_group_tag_protection)
        if loose_source_routing_discard is not None:
            pulumi.set(__self__, "loose_source_routing_discard", loose_source_routing_discard)
        if malformed_option_discard is not None:
            pulumi.set(__self__, "malformed_option_discard", malformed_option_discard)
        if mismatched_overlapping_tcp_segment_discard is not None:
            pulumi.set(__self__, "mismatched_overlapping_tcp_segment_discard", mismatched_overlapping_tcp_segment_discard)
        if mptcp_option_strip is not None:
            pulumi.set(__self__, "mptcp_option_strip", mptcp_option_strip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_ip_protocol is not None:
            pulumi.set(__self__, "non_ip_protocol", non_ip_protocol)
        if record_route_discard is not None:
            pulumi.set(__self__, "record_route_discard", record_route_discard)
        if reject_non_syn_tcp is not None:
            pulumi.set(__self__, "reject_non_syn_tcp", reject_non_syn_tcp)
        if scan_white_lists is not None:
            pulumi.set(__self__, "scan_white_lists", scan_white_lists)
        if scans is not None:
            pulumi.set(__self__, "scans", scans)
        if security_discard is not None:
            pulumi.set(__self__, "security_discard", security_discard)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if spoofed_ip_discard is not None:
            pulumi.set(__self__, "spoofed_ip_discard", spoofed_ip_discard)
        if stream_id_discard is not None:
            pulumi.set(__self__, "stream_id_discard", stream_id_discard)
        if strict_ip_check is not None:
            pulumi.set(__self__, "strict_ip_check", strict_ip_check)
        if strict_source_routing_discard is not None:
            pulumi.set(__self__, "strict_source_routing_discard", strict_source_routing_discard)
        if suppress_icmp_needfrag is not None:
            pulumi.set(__self__, "suppress_icmp_needfrag", suppress_icmp_needfrag)
        if suppress_icmp_timeexceeded is not None:
            pulumi.set(__self__, "suppress_icmp_timeexceeded", suppress_icmp_timeexceeded)
        if tcp_fast_open_and_data_strip is not None:
            pulumi.set(__self__, "tcp_fast_open_and_data_strip", tcp_fast_open_and_data_strip)
        if tcp_handshake_discard is not None:
            pulumi.set(__self__, "tcp_handshake_discard", tcp_handshake_discard)
        if tcp_syn_with_data_discard is not None:
            pulumi.set(__self__, "tcp_syn_with_data_discard", tcp_syn_with_data_discard)
        if tcp_synack_with_data_discard is not None:
            pulumi.set(__self__, "tcp_synack_with_data_discard", tcp_synack_with_data_discard)
        if tcp_timestamp_strip is not None:
            pulumi.set(__self__, "tcp_timestamp_strip", tcp_timestamp_strip)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if timestamp_discard is not None:
            pulumi.set(__self__, "timestamp_discard", timestamp_discard)
        if unknown_option_discard is not None:
            pulumi.set(__self__, "unknown_option_discard", unknown_option_discard)

    @_builtins.property
    @pulumi.getter(name="asymmetricPath")
    def asymmetric_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
        * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
        * `drop` — Drop packets that contain an asymmetric path.
        * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        """
        return pulumi.get(self, "asymmetric_path")

    @asymmetric_path.setter
    def asymmetric_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asymmetric_path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="discardIcmpEmbeddedError")
    def discard_icmp_embedded_error(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard ICMP packets that are embedded with an error message.
        """
        return pulumi.get(self, "discard_icmp_embedded_error")

    @discard_icmp_embedded_error.setter
    def discard_icmp_embedded_error(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "discard_icmp_embedded_error", value)

    @_builtins.property
    @pulumi.getter
    def flood(self) -> Optional[pulumi.Input['ZoneProtectionProfileFloodArgs']]:
        """
        Flood
        """
        return pulumi.get(self, "flood")

    @flood.setter
    def flood(self, value: Optional[pulumi.Input['ZoneProtectionProfileFloodArgs']]):
        pulumi.set(self, "flood", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="fragmentedTrafficDiscard")
    def fragmented_traffic_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard fragmented IP packets.
        """
        return pulumi.get(self, "fragmented_traffic_discard")

    @fragmented_traffic_discard.setter
    def fragmented_traffic_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fragmented_traffic_discard", value)

    @_builtins.property
    @pulumi.getter(name="icmpFragDiscard")
    def icmp_frag_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets that consist of ICMP fragments.
        """
        return pulumi.get(self, "icmp_frag_discard")

    @icmp_frag_discard.setter
    def icmp_frag_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_frag_discard", value)

    @_builtins.property
    @pulumi.getter(name="icmpLargePacketDiscard")
    def icmp_large_packet_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard ICMP packets that are larger than 1024 bytes.
        """
        return pulumi.get(self, "icmp_large_packet_discard")

    @icmp_large_packet_discard.setter
    def icmp_large_packet_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_large_packet_discard", value)

    @_builtins.property
    @pulumi.getter(name="icmpPingZeroIdDiscard")
    def icmp_ping_zero_id_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the ICMP ping packet has an identifier value of 0.
        """
        return pulumi.get(self, "icmp_ping_zero_id_discard")

    @icmp_ping_zero_id_discard.setter
    def icmp_ping_zero_id_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_ping_zero_id_discard", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ZoneProtectionProfileIpv6Args']]:
        """
        Ipv6
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ZoneProtectionProfileIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="l2SecGroupTagProtection")
    def l2_sec_group_tag_protection(self) -> Optional[pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs']]:
        """
        L2 sec group tag protection
        """
        return pulumi.get(self, "l2_sec_group_tag_protection")

    @l2_sec_group_tag_protection.setter
    def l2_sec_group_tag_protection(self, value: Optional[pulumi.Input['ZoneProtectionProfileL2SecGroupTagProtectionArgs']]):
        pulumi.set(self, "l2_sec_group_tag_protection", value)

    @_builtins.property
    @pulumi.getter(name="looseSourceRoutingDiscard")
    def loose_source_routing_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        """
        return pulumi.get(self, "loose_source_routing_discard")

    @loose_source_routing_discard.setter
    def loose_source_routing_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "loose_source_routing_discard", value)

    @_builtins.property
    @pulumi.getter(name="malformedOptionDiscard")
    def malformed_option_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        """
        return pulumi.get(self, "malformed_option_discard")

    @malformed_option_discard.setter
    def malformed_option_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "malformed_option_discard", value)

    @_builtins.property
    @pulumi.getter(name="mismatchedOverlappingTcpSegmentDiscard")
    def mismatched_overlapping_tcp_segment_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Drop packets with mismatched overlapping TCP segments.
        """
        return pulumi.get(self, "mismatched_overlapping_tcp_segment_discard")

    @mismatched_overlapping_tcp_segment_discard.setter
    def mismatched_overlapping_tcp_segment_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mismatched_overlapping_tcp_segment_discard", value)

    @_builtins.property
    @pulumi.getter(name="mptcpOptionStrip")
    def mptcp_option_strip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
        * `no` — Enable MPTCP support (do not strip the MPTCP option).
        * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
        * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        """
        return pulumi.get(self, "mptcp_option_strip")

    @mptcp_option_strip.setter
    def mptcp_option_strip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mptcp_option_strip", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The profile name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonIpProtocol")
    def non_ip_protocol(self) -> Optional[pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs']]:
        """
        Non ip protocol
        """
        return pulumi.get(self, "non_ip_protocol")

    @non_ip_protocol.setter
    def non_ip_protocol(self, value: Optional[pulumi.Input['ZoneProtectionProfileNonIpProtocolArgs']]):
        pulumi.set(self, "non_ip_protocol", value)

    @_builtins.property
    @pulumi.getter(name="recordRouteDiscard")
    def record_route_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        """
        return pulumi.get(self, "record_route_discard")

    @record_route_discard.setter
    def record_route_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "record_route_discard", value)

    @_builtins.property
    @pulumi.getter(name="rejectNonSynTcp")
    def reject_non_syn_tcp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
        * `global` — Use system-wide setting that is assigned through the CLI.
        * `yes` — Reject non-SYN TCP.
        * `no` — Accept non-SYN TCP.
        """
        return pulumi.get(self, "reject_non_syn_tcp")

    @reject_non_syn_tcp.setter
    def reject_non_syn_tcp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reject_non_syn_tcp", value)

    @_builtins.property
    @pulumi.getter(name="scanWhiteLists")
    def scan_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]]]:
        """
        Scan white list
        """
        return pulumi.get(self, "scan_white_lists")

    @scan_white_lists.setter
    def scan_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanWhiteListArgs']]]]):
        pulumi.set(self, "scan_white_lists", value)

    @_builtins.property
    @pulumi.getter
    def scans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]]]:
        """
        Scan
        """
        return pulumi.get(self, "scans")

    @scans.setter
    def scans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneProtectionProfileScanArgs']]]]):
        pulumi.set(self, "scans", value)

    @_builtins.property
    @pulumi.getter(name="securityDiscard")
    def security_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the security option is defined.
        """
        return pulumi.get(self, "security_discard")

    @security_discard.setter
    def security_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_discard", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="spoofedIpDiscard")
    def spoofed_ip_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        """
        return pulumi.get(self, "spoofed_ip_discard")

    @spoofed_ip_discard.setter
    def spoofed_ip_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spoofed_ip_discard", value)

    @_builtins.property
    @pulumi.getter(name="streamIdDiscard")
    def stream_id_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the Stream ID option is defined.
        """
        return pulumi.get(self, "stream_id_discard")

    @stream_id_discard.setter
    def stream_id_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stream_id_discard", value)

    @_builtins.property
    @pulumi.getter(name="strictIpCheck")
    def strict_ip_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check that both conditions are true:
        * The source IP address is not the subnet broadcast IP address of the ingress interface.
        * The source IP address is routable over the exact ingress interface.
        If either condition is not true, discard the packet.
        """
        return pulumi.get(self, "strict_ip_check")

    @strict_ip_check.setter
    def strict_ip_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strict_ip_check", value)

    @_builtins.property
    @pulumi.getter(name="strictSourceRoutingDiscard")
    def strict_source_routing_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        """
        return pulumi.get(self, "strict_source_routing_discard")

    @strict_source_routing_discard.setter
    def strict_source_routing_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "strict_source_routing_discard", value)

    @_builtins.property
    @pulumi.getter(name="suppressIcmpNeedfrag")
    def suppress_icmp_needfrag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        """
        return pulumi.get(self, "suppress_icmp_needfrag")

    @suppress_icmp_needfrag.setter
    def suppress_icmp_needfrag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppress_icmp_needfrag", value)

    @_builtins.property
    @pulumi.getter(name="suppressIcmpTimeexceeded")
    def suppress_icmp_timeexceeded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Stop sending ICMP TTL expired messages.
        """
        return pulumi.get(self, "suppress_icmp_timeexceeded")

    @suppress_icmp_timeexceeded.setter
    def suppress_icmp_timeexceeded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppress_icmp_timeexceeded", value)

    @_builtins.property
    @pulumi.getter(name="tcpFastOpenAndDataStrip")
    def tcp_fast_open_and_data_strip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        """
        return pulumi.get(self, "tcp_fast_open_and_data_strip")

    @tcp_fast_open_and_data_strip.setter
    def tcp_fast_open_and_data_strip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_fast_open_and_data_strip", value)

    @_builtins.property
    @pulumi.getter(name="tcpHandshakeDiscard")
    def tcp_handshake_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Drop packets with split handshakes.
        """
        return pulumi.get(self, "tcp_handshake_discard")

    @tcp_handshake_discard.setter
    def tcp_handshake_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_handshake_discard", value)

    @_builtins.property
    @pulumi.getter(name="tcpSynWithDataDiscard")
    def tcp_syn_with_data_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        """
        return pulumi.get(self, "tcp_syn_with_data_discard")

    @tcp_syn_with_data_discard.setter
    def tcp_syn_with_data_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_syn_with_data_discard", value)

    @_builtins.property
    @pulumi.getter(name="tcpSynackWithDataDiscard")
    def tcp_synack_with_data_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        """
        return pulumi.get(self, "tcp_synack_with_data_discard")

    @tcp_synack_with_data_discard.setter
    def tcp_synack_with_data_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_synack_with_data_discard", value)

    @_builtins.property
    @pulumi.getter(name="tcpTimestampStrip")
    def tcp_timestamp_strip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        """
        return pulumi.get(self, "tcp_timestamp_strip")

    @tcp_timestamp_strip.setter
    def tcp_timestamp_strip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tcp_timestamp_strip", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="timestampDiscard")
    def timestamp_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets with the Timestamp IP option set.
        """
        return pulumi.get(self, "timestamp_discard")

    @timestamp_discard.setter
    def timestamp_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "timestamp_discard", value)

    @_builtins.property
    @pulumi.getter(name="unknownOptionDiscard")
    def unknown_option_discard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Discard packets if the class and number are unknown.
        """
        return pulumi.get(self, "unknown_option_discard")

    @unknown_option_discard.setter
    def unknown_option_discard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unknown_option_discard", value)


@pulumi.type_token("scm:index/zoneProtectionProfile:ZoneProtectionProfile")
class ZoneProtectionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asymmetric_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_icmp_embedded_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 flood: Optional[pulumi.Input[Union['ZoneProtectionProfileFloodArgs', 'ZoneProtectionProfileFloodArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fragmented_traffic_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_frag_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_large_packet_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_ping_zero_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input[Union['ZoneProtectionProfileIpv6Args', 'ZoneProtectionProfileIpv6ArgsDict']]] = None,
                 l2_sec_group_tag_protection: Optional[pulumi.Input[Union['ZoneProtectionProfileL2SecGroupTagProtectionArgs', 'ZoneProtectionProfileL2SecGroupTagProtectionArgsDict']]] = None,
                 loose_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 malformed_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mismatched_overlapping_tcp_segment_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mptcp_option_strip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ip_protocol: Optional[pulumi.Input[Union['ZoneProtectionProfileNonIpProtocolArgs', 'ZoneProtectionProfileNonIpProtocolArgsDict']]] = None,
                 record_route_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 reject_non_syn_tcp: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanWhiteListArgs', 'ZoneProtectionProfileScanWhiteListArgsDict']]]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanArgs', 'ZoneProtectionProfileScanArgsDict']]]]] = None,
                 security_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 spoofed_ip_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_ip_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_needfrag: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_timeexceeded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_fast_open_and_data_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_handshake_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_syn_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_synack_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_timestamp_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 unknown_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ZoneProtectionProfile resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asymmetric_path: Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
               * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
               * `drop` — Drop packets that contain an asymmetric path.
               * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        :param pulumi.Input[_builtins.str] description: The description of the profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] discard_icmp_embedded_error: Discard ICMP packets that are embedded with an error message.
        :param pulumi.Input[Union['ZoneProtectionProfileFloodArgs', 'ZoneProtectionProfileFloodArgsDict']] flood: Flood
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] fragmented_traffic_discard: Discard fragmented IP packets.
        :param pulumi.Input[_builtins.bool] icmp_frag_discard: Discard packets that consist of ICMP fragments.
        :param pulumi.Input[_builtins.bool] icmp_large_packet_discard: Discard ICMP packets that are larger than 1024 bytes.
        :param pulumi.Input[_builtins.bool] icmp_ping_zero_id_discard: Discard packets if the ICMP ping packet has an identifier value of 0.
        :param pulumi.Input[Union['ZoneProtectionProfileIpv6Args', 'ZoneProtectionProfileIpv6ArgsDict']] ipv6: Ipv6
        :param pulumi.Input[Union['ZoneProtectionProfileL2SecGroupTagProtectionArgs', 'ZoneProtectionProfileL2SecGroupTagProtectionArgsDict']] l2_sec_group_tag_protection: L2 sec group tag protection
        :param pulumi.Input[_builtins.bool] loose_source_routing_discard: Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        :param pulumi.Input[_builtins.bool] malformed_option_discard: Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        :param pulumi.Input[_builtins.bool] mismatched_overlapping_tcp_segment_discard: Drop packets with mismatched overlapping TCP segments.
        :param pulumi.Input[_builtins.str] mptcp_option_strip: MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
               * `no` — Enable MPTCP support (do not strip the MPTCP option).
               * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
               * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        :param pulumi.Input[_builtins.str] name: The profile name
        :param pulumi.Input[Union['ZoneProtectionProfileNonIpProtocolArgs', 'ZoneProtectionProfileNonIpProtocolArgsDict']] non_ip_protocol: Non ip protocol
        :param pulumi.Input[_builtins.bool] record_route_discard: Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        :param pulumi.Input[_builtins.str] reject_non_syn_tcp: Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
               * `global` — Use system-wide setting that is assigned through the CLI.
               * `yes` — Reject non-SYN TCP.
               * `no` — Accept non-SYN TCP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanWhiteListArgs', 'ZoneProtectionProfileScanWhiteListArgsDict']]]] scan_white_lists: Scan white list
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanArgs', 'ZoneProtectionProfileScanArgsDict']]]] scans: Scan
        :param pulumi.Input[_builtins.bool] security_discard: Discard packets if the security option is defined.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.bool] spoofed_ip_discard: Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] stream_id_discard: Discard packets if the Stream ID option is defined.
        :param pulumi.Input[_builtins.bool] strict_ip_check: Check that both conditions are true:
               * The source IP address is not the subnet broadcast IP address of the ingress interface.
               * The source IP address is routable over the exact ingress interface.
               If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] strict_source_routing_discard: Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        :param pulumi.Input[_builtins.bool] suppress_icmp_needfrag: Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        :param pulumi.Input[_builtins.bool] suppress_icmp_timeexceeded: Stop sending ICMP TTL expired messages.
        :param pulumi.Input[_builtins.bool] tcp_fast_open_and_data_strip: Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_handshake_discard: Drop packets with split handshakes.
        :param pulumi.Input[_builtins.bool] tcp_syn_with_data_discard: Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_synack_with_data_discard: Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_timestamp_strip: Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        :param pulumi.Input[_builtins.bool] timestamp_discard: Discard packets with the Timestamp IP option set.
        :param pulumi.Input[_builtins.bool] unknown_option_discard: Discard packets if the class and number are unknown.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ZoneProtectionProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ZoneProtectionProfile resource

        :param str resource_name: The name of the resource.
        :param ZoneProtectionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneProtectionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asymmetric_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_icmp_embedded_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 flood: Optional[pulumi.Input[Union['ZoneProtectionProfileFloodArgs', 'ZoneProtectionProfileFloodArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 fragmented_traffic_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_frag_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_large_packet_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_ping_zero_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input[Union['ZoneProtectionProfileIpv6Args', 'ZoneProtectionProfileIpv6ArgsDict']]] = None,
                 l2_sec_group_tag_protection: Optional[pulumi.Input[Union['ZoneProtectionProfileL2SecGroupTagProtectionArgs', 'ZoneProtectionProfileL2SecGroupTagProtectionArgsDict']]] = None,
                 loose_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 malformed_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mismatched_overlapping_tcp_segment_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 mptcp_option_strip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ip_protocol: Optional[pulumi.Input[Union['ZoneProtectionProfileNonIpProtocolArgs', 'ZoneProtectionProfileNonIpProtocolArgsDict']]] = None,
                 record_route_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 reject_non_syn_tcp: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanWhiteListArgs', 'ZoneProtectionProfileScanWhiteListArgsDict']]]]] = None,
                 scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanArgs', 'ZoneProtectionProfileScanArgsDict']]]]] = None,
                 security_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 spoofed_ip_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 stream_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_ip_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 strict_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_needfrag: Optional[pulumi.Input[_builtins.bool]] = None,
                 suppress_icmp_timeexceeded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_fast_open_and_data_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_handshake_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_syn_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_synack_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 tcp_timestamp_strip: Optional[pulumi.Input[_builtins.bool]] = None,
                 timestamp_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 unknown_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneProtectionProfileArgs.__new__(ZoneProtectionProfileArgs)

            __props__.__dict__["asymmetric_path"] = asymmetric_path
            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["discard_icmp_embedded_error"] = discard_icmp_embedded_error
            __props__.__dict__["flood"] = flood
            __props__.__dict__["folder"] = folder
            __props__.__dict__["fragmented_traffic_discard"] = fragmented_traffic_discard
            __props__.__dict__["icmp_frag_discard"] = icmp_frag_discard
            __props__.__dict__["icmp_large_packet_discard"] = icmp_large_packet_discard
            __props__.__dict__["icmp_ping_zero_id_discard"] = icmp_ping_zero_id_discard
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["l2_sec_group_tag_protection"] = l2_sec_group_tag_protection
            __props__.__dict__["loose_source_routing_discard"] = loose_source_routing_discard
            __props__.__dict__["malformed_option_discard"] = malformed_option_discard
            __props__.__dict__["mismatched_overlapping_tcp_segment_discard"] = mismatched_overlapping_tcp_segment_discard
            __props__.__dict__["mptcp_option_strip"] = mptcp_option_strip
            __props__.__dict__["name"] = name
            __props__.__dict__["non_ip_protocol"] = non_ip_protocol
            __props__.__dict__["record_route_discard"] = record_route_discard
            __props__.__dict__["reject_non_syn_tcp"] = reject_non_syn_tcp
            __props__.__dict__["scan_white_lists"] = scan_white_lists
            __props__.__dict__["scans"] = scans
            __props__.__dict__["security_discard"] = security_discard
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["spoofed_ip_discard"] = spoofed_ip_discard
            __props__.__dict__["stream_id_discard"] = stream_id_discard
            __props__.__dict__["strict_ip_check"] = strict_ip_check
            __props__.__dict__["strict_source_routing_discard"] = strict_source_routing_discard
            __props__.__dict__["suppress_icmp_needfrag"] = suppress_icmp_needfrag
            __props__.__dict__["suppress_icmp_timeexceeded"] = suppress_icmp_timeexceeded
            __props__.__dict__["tcp_fast_open_and_data_strip"] = tcp_fast_open_and_data_strip
            __props__.__dict__["tcp_handshake_discard"] = tcp_handshake_discard
            __props__.__dict__["tcp_syn_with_data_discard"] = tcp_syn_with_data_discard
            __props__.__dict__["tcp_synack_with_data_discard"] = tcp_synack_with_data_discard
            __props__.__dict__["tcp_timestamp_strip"] = tcp_timestamp_strip
            __props__.__dict__["timestamp_discard"] = timestamp_discard
            __props__.__dict__["unknown_option_discard"] = unknown_option_discard
            __props__.__dict__["tfid"] = None
        super(ZoneProtectionProfile, __self__).__init__(
            'scm:index/zoneProtectionProfile:ZoneProtectionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asymmetric_path: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            discard_icmp_embedded_error: Optional[pulumi.Input[_builtins.bool]] = None,
            flood: Optional[pulumi.Input[Union['ZoneProtectionProfileFloodArgs', 'ZoneProtectionProfileFloodArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            fragmented_traffic_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            icmp_frag_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            icmp_large_packet_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            icmp_ping_zero_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6: Optional[pulumi.Input[Union['ZoneProtectionProfileIpv6Args', 'ZoneProtectionProfileIpv6ArgsDict']]] = None,
            l2_sec_group_tag_protection: Optional[pulumi.Input[Union['ZoneProtectionProfileL2SecGroupTagProtectionArgs', 'ZoneProtectionProfileL2SecGroupTagProtectionArgsDict']]] = None,
            loose_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            malformed_option_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            mismatched_overlapping_tcp_segment_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            mptcp_option_strip: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            non_ip_protocol: Optional[pulumi.Input[Union['ZoneProtectionProfileNonIpProtocolArgs', 'ZoneProtectionProfileNonIpProtocolArgsDict']]] = None,
            record_route_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            reject_non_syn_tcp: Optional[pulumi.Input[_builtins.str]] = None,
            scan_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanWhiteListArgs', 'ZoneProtectionProfileScanWhiteListArgsDict']]]]] = None,
            scans: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanArgs', 'ZoneProtectionProfileScanArgsDict']]]]] = None,
            security_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            spoofed_ip_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            stream_id_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            strict_ip_check: Optional[pulumi.Input[_builtins.bool]] = None,
            strict_source_routing_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            suppress_icmp_needfrag: Optional[pulumi.Input[_builtins.bool]] = None,
            suppress_icmp_timeexceeded: Optional[pulumi.Input[_builtins.bool]] = None,
            tcp_fast_open_and_data_strip: Optional[pulumi.Input[_builtins.bool]] = None,
            tcp_handshake_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            tcp_syn_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            tcp_synack_with_data_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            tcp_timestamp_strip: Optional[pulumi.Input[_builtins.bool]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp_discard: Optional[pulumi.Input[_builtins.bool]] = None,
            unknown_option_discard: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ZoneProtectionProfile':
        """
        Get an existing ZoneProtectionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asymmetric_path: Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
               * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
               * `drop` — Drop packets that contain an asymmetric path.
               * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        :param pulumi.Input[_builtins.str] description: The description of the profile
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] discard_icmp_embedded_error: Discard ICMP packets that are embedded with an error message.
        :param pulumi.Input[Union['ZoneProtectionProfileFloodArgs', 'ZoneProtectionProfileFloodArgsDict']] flood: Flood
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] fragmented_traffic_discard: Discard fragmented IP packets.
        :param pulumi.Input[_builtins.bool] icmp_frag_discard: Discard packets that consist of ICMP fragments.
        :param pulumi.Input[_builtins.bool] icmp_large_packet_discard: Discard ICMP packets that are larger than 1024 bytes.
        :param pulumi.Input[_builtins.bool] icmp_ping_zero_id_discard: Discard packets if the ICMP ping packet has an identifier value of 0.
        :param pulumi.Input[Union['ZoneProtectionProfileIpv6Args', 'ZoneProtectionProfileIpv6ArgsDict']] ipv6: Ipv6
        :param pulumi.Input[Union['ZoneProtectionProfileL2SecGroupTagProtectionArgs', 'ZoneProtectionProfileL2SecGroupTagProtectionArgsDict']] l2_sec_group_tag_protection: L2 sec group tag protection
        :param pulumi.Input[_builtins.bool] loose_source_routing_discard: Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        :param pulumi.Input[_builtins.bool] malformed_option_discard: Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        :param pulumi.Input[_builtins.bool] mismatched_overlapping_tcp_segment_discard: Drop packets with mismatched overlapping TCP segments.
        :param pulumi.Input[_builtins.str] mptcp_option_strip: MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
               * `no` — Enable MPTCP support (do not strip the MPTCP option).
               * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
               * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        :param pulumi.Input[_builtins.str] name: The profile name
        :param pulumi.Input[Union['ZoneProtectionProfileNonIpProtocolArgs', 'ZoneProtectionProfileNonIpProtocolArgsDict']] non_ip_protocol: Non ip protocol
        :param pulumi.Input[_builtins.bool] record_route_discard: Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        :param pulumi.Input[_builtins.str] reject_non_syn_tcp: Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
               * `global` — Use system-wide setting that is assigned through the CLI.
               * `yes` — Reject non-SYN TCP.
               * `no` — Accept non-SYN TCP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanWhiteListArgs', 'ZoneProtectionProfileScanWhiteListArgsDict']]]] scan_white_lists: Scan white list
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneProtectionProfileScanArgs', 'ZoneProtectionProfileScanArgsDict']]]] scans: Scan
        :param pulumi.Input[_builtins.bool] security_discard: Discard packets if the security option is defined.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.bool] spoofed_ip_discard: Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] stream_id_discard: Discard packets if the Stream ID option is defined.
        :param pulumi.Input[_builtins.bool] strict_ip_check: Check that both conditions are true:
               * The source IP address is not the subnet broadcast IP address of the ingress interface.
               * The source IP address is routable over the exact ingress interface.
               If either condition is not true, discard the packet.
        :param pulumi.Input[_builtins.bool] strict_source_routing_discard: Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        :param pulumi.Input[_builtins.bool] suppress_icmp_needfrag: Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        :param pulumi.Input[_builtins.bool] suppress_icmp_timeexceeded: Stop sending ICMP TTL expired messages.
        :param pulumi.Input[_builtins.bool] tcp_fast_open_and_data_strip: Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_handshake_discard: Drop packets with split handshakes.
        :param pulumi.Input[_builtins.bool] tcp_syn_with_data_discard: Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_synack_with_data_discard: Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        :param pulumi.Input[_builtins.bool] tcp_timestamp_strip: Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        :param pulumi.Input[_builtins.bool] timestamp_discard: Discard packets with the Timestamp IP option set.
        :param pulumi.Input[_builtins.bool] unknown_option_discard: Discard packets if the class and number are unknown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneProtectionProfileState.__new__(_ZoneProtectionProfileState)

        __props__.__dict__["asymmetric_path"] = asymmetric_path
        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["discard_icmp_embedded_error"] = discard_icmp_embedded_error
        __props__.__dict__["flood"] = flood
        __props__.__dict__["folder"] = folder
        __props__.__dict__["fragmented_traffic_discard"] = fragmented_traffic_discard
        __props__.__dict__["icmp_frag_discard"] = icmp_frag_discard
        __props__.__dict__["icmp_large_packet_discard"] = icmp_large_packet_discard
        __props__.__dict__["icmp_ping_zero_id_discard"] = icmp_ping_zero_id_discard
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["l2_sec_group_tag_protection"] = l2_sec_group_tag_protection
        __props__.__dict__["loose_source_routing_discard"] = loose_source_routing_discard
        __props__.__dict__["malformed_option_discard"] = malformed_option_discard
        __props__.__dict__["mismatched_overlapping_tcp_segment_discard"] = mismatched_overlapping_tcp_segment_discard
        __props__.__dict__["mptcp_option_strip"] = mptcp_option_strip
        __props__.__dict__["name"] = name
        __props__.__dict__["non_ip_protocol"] = non_ip_protocol
        __props__.__dict__["record_route_discard"] = record_route_discard
        __props__.__dict__["reject_non_syn_tcp"] = reject_non_syn_tcp
        __props__.__dict__["scan_white_lists"] = scan_white_lists
        __props__.__dict__["scans"] = scans
        __props__.__dict__["security_discard"] = security_discard
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["spoofed_ip_discard"] = spoofed_ip_discard
        __props__.__dict__["stream_id_discard"] = stream_id_discard
        __props__.__dict__["strict_ip_check"] = strict_ip_check
        __props__.__dict__["strict_source_routing_discard"] = strict_source_routing_discard
        __props__.__dict__["suppress_icmp_needfrag"] = suppress_icmp_needfrag
        __props__.__dict__["suppress_icmp_timeexceeded"] = suppress_icmp_timeexceeded
        __props__.__dict__["tcp_fast_open_and_data_strip"] = tcp_fast_open_and_data_strip
        __props__.__dict__["tcp_handshake_discard"] = tcp_handshake_discard
        __props__.__dict__["tcp_syn_with_data_discard"] = tcp_syn_with_data_discard
        __props__.__dict__["tcp_synack_with_data_discard"] = tcp_synack_with_data_discard
        __props__.__dict__["tcp_timestamp_strip"] = tcp_timestamp_strip
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["timestamp_discard"] = timestamp_discard
        __props__.__dict__["unknown_option_discard"] = unknown_option_discard
        return ZoneProtectionProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="asymmetricPath")
    def asymmetric_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determine whether to drop or bypass packets that contain out-of-sync ACKs or out-of-window sequence numbers:
        * `global` — Use system-wide setting that is assigned through TCP Settings or the CLI.
        * `drop` — Drop packets that contain an asymmetric path.
        * `bypass` — Bypass scanning on packets that contain an asymmetric path.
        """
        return pulumi.get(self, "asymmetric_path")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the profile
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="discardIcmpEmbeddedError")
    def discard_icmp_embedded_error(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard ICMP packets that are embedded with an error message.
        """
        return pulumi.get(self, "discard_icmp_embedded_error")

    @_builtins.property
    @pulumi.getter
    def flood(self) -> pulumi.Output[Optional['outputs.ZoneProtectionProfileFlood']]:
        """
        Flood
        """
        return pulumi.get(self, "flood")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="fragmentedTrafficDiscard")
    def fragmented_traffic_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard fragmented IP packets.
        """
        return pulumi.get(self, "fragmented_traffic_discard")

    @_builtins.property
    @pulumi.getter(name="icmpFragDiscard")
    def icmp_frag_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets that consist of ICMP fragments.
        """
        return pulumi.get(self, "icmp_frag_discard")

    @_builtins.property
    @pulumi.getter(name="icmpLargePacketDiscard")
    def icmp_large_packet_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard ICMP packets that are larger than 1024 bytes.
        """
        return pulumi.get(self, "icmp_large_packet_discard")

    @_builtins.property
    @pulumi.getter(name="icmpPingZeroIdDiscard")
    def icmp_ping_zero_id_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets if the ICMP ping packet has an identifier value of 0.
        """
        return pulumi.get(self, "icmp_ping_zero_id_discard")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[Optional['outputs.ZoneProtectionProfileIpv6']]:
        """
        Ipv6
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="l2SecGroupTagProtection")
    def l2_sec_group_tag_protection(self) -> pulumi.Output[Optional['outputs.ZoneProtectionProfileL2SecGroupTagProtection']]:
        """
        L2 sec group tag protection
        """
        return pulumi.get(self, "l2_sec_group_tag_protection")

    @_builtins.property
    @pulumi.getter(name="looseSourceRoutingDiscard")
    def loose_source_routing_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets with the Loose Source Routing IP option set. Loose Source Routing is an option whereby a source of a datagram provides routing information and a gateway or host is allowed to choose any route of a number of intermediate gateways to get the datagram to the next address in the route.
        """
        return pulumi.get(self, "loose_source_routing_discard")

    @_builtins.property
    @pulumi.getter(name="malformedOptionDiscard")
    def malformed_option_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets if they have incorrect combinations of class, number, and length based on RFCs 791, 1108, 1393, and 2113.
        """
        return pulumi.get(self, "malformed_option_discard")

    @_builtins.property
    @pulumi.getter(name="mismatchedOverlappingTcpSegmentDiscard")
    def mismatched_overlapping_tcp_segment_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Drop packets with mismatched overlapping TCP segments.
        """
        return pulumi.get(self, "mismatched_overlapping_tcp_segment_discard")

    @_builtins.property
    @pulumi.getter(name="mptcpOptionStrip")
    def mptcp_option_strip(self) -> pulumi.Output[_builtins.str]:
        """
        MPTCP is an extension of TCP that allows a client to maintain a connection by simultaneously using multiple paths to connect to the destination host. By default, MPTCP support is disabled, based on the global MPTCP setting.  Review or adjust the MPTCP settings for the security zones associated with this profile:
        * `no` — Enable MPTCP support (do not strip the MPTCP option).
        * `yes` — Disable MPTCP support (strip the MPTCP option). With this configured, MPTCP connections are converted to standard TCP connections, as MPTCP is backwards compatible with TCP.
        * `global` — Support MPTCP based on the global MPTCP setting. By default, the global MPTCP setting is set to yes so that MPTCP is disabled (the MPTCP option is stripped from the packet).
        """
        return pulumi.get(self, "mptcp_option_strip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The profile name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nonIpProtocol")
    def non_ip_protocol(self) -> pulumi.Output[Optional['outputs.ZoneProtectionProfileNonIpProtocol']]:
        """
        Non ip protocol
        """
        return pulumi.get(self, "non_ip_protocol")

    @_builtins.property
    @pulumi.getter(name="recordRouteDiscard")
    def record_route_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets with the Record Route IP option set. When a datagram has this option, each router that routes the datagram adds its own IP address to the header, thus providing the path to the recipient.
        """
        return pulumi.get(self, "record_route_discard")

    @_builtins.property
    @pulumi.getter(name="rejectNonSynTcp")
    def reject_non_syn_tcp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determine whether to reject the packet if the first packet for the TCP session setup is not a SYN packet:
        * `global` — Use system-wide setting that is assigned through the CLI.
        * `yes` — Reject non-SYN TCP.
        * `no` — Accept non-SYN TCP.
        """
        return pulumi.get(self, "reject_non_syn_tcp")

    @_builtins.property
    @pulumi.getter(name="scanWhiteLists")
    def scan_white_lists(self) -> pulumi.Output[Optional[Sequence['outputs.ZoneProtectionProfileScanWhiteList']]]:
        """
        Scan white list
        """
        return pulumi.get(self, "scan_white_lists")

    @_builtins.property
    @pulumi.getter
    def scans(self) -> pulumi.Output[Optional[Sequence['outputs.ZoneProtectionProfileScan']]]:
        """
        Scan
        """
        return pulumi.get(self, "scans")

    @_builtins.property
    @pulumi.getter(name="securityDiscard")
    def security_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets if the security option is defined.
        """
        return pulumi.get(self, "security_discard")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="spoofedIpDiscard")
    def spoofed_ip_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Check that the source IP address of the ingress packet is routable and the routing interface is in the same zone as the ingress interface. If either condition is not true, discard the packet.
        """
        return pulumi.get(self, "spoofed_ip_discard")

    @_builtins.property
    @pulumi.getter(name="streamIdDiscard")
    def stream_id_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets if the Stream ID option is defined.
        """
        return pulumi.get(self, "stream_id_discard")

    @_builtins.property
    @pulumi.getter(name="strictIpCheck")
    def strict_ip_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Check that both conditions are true:
        * The source IP address is not the subnet broadcast IP address of the ingress interface.
        * The source IP address is routable over the exact ingress interface.
        If either condition is not true, discard the packet.
        """
        return pulumi.get(self, "strict_ip_check")

    @_builtins.property
    @pulumi.getter(name="strictSourceRoutingDiscard")
    def strict_source_routing_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets with the Strict Source Routing IP option set. Strict Source Routing is an option whereby a source of a datagram provides routing information through which a gateway or host must send the datagram.
        """
        return pulumi.get(self, "strict_source_routing_discard")

    @_builtins.property
    @pulumi.getter(name="suppressIcmpNeedfrag")
    def suppress_icmp_needfrag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Stop sending ICMP fragmentation needed messages in response to packets that exceed the interface MTU and have the do not fragment (DF) bit set. This setting will interfere with the PMTUD process performed by hosts behind the firewall.
        """
        return pulumi.get(self, "suppress_icmp_needfrag")

    @_builtins.property
    @pulumi.getter(name="suppressIcmpTimeexceeded")
    def suppress_icmp_timeexceeded(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Stop sending ICMP TTL expired messages.
        """
        return pulumi.get(self, "suppress_icmp_timeexceeded")

    @_builtins.property
    @pulumi.getter(name="tcpFastOpenAndDataStrip")
    def tcp_fast_open_and_data_strip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Strip the TCP Fast Open option (and data payload, if any) from the TCP SYN or SYN-ACK packet during a TCP three-way handshake.
        """
        return pulumi.get(self, "tcp_fast_open_and_data_strip")

    @_builtins.property
    @pulumi.getter(name="tcpHandshakeDiscard")
    def tcp_handshake_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Drop packets with split handshakes.
        """
        return pulumi.get(self, "tcp_handshake_discard")

    @_builtins.property
    @pulumi.getter(name="tcpSynWithDataDiscard")
    def tcp_syn_with_data_discard(self) -> pulumi.Output[_builtins.bool]:
        """
        Prevent a TCP session from being established if the TCP SYN packet contains data during a three-way handshake.
        """
        return pulumi.get(self, "tcp_syn_with_data_discard")

    @_builtins.property
    @pulumi.getter(name="tcpSynackWithDataDiscard")
    def tcp_synack_with_data_discard(self) -> pulumi.Output[_builtins.bool]:
        """
        Prevent a TCP session from being established if the TCP SYN-ACK packet contains data during a three-way handshake.
        """
        return pulumi.get(self, "tcp_synack_with_data_discard")

    @_builtins.property
    @pulumi.getter(name="tcpTimestampStrip")
    def tcp_timestamp_strip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determine whether the packet has a TCP timestamp in the header and, if it does, strip the timestamp from the header.
        """
        return pulumi.get(self, "tcp_timestamp_strip")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="timestampDiscard")
    def timestamp_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets with the Timestamp IP option set.
        """
        return pulumi.get(self, "timestamp_discard")

    @_builtins.property
    @pulumi.getter(name="unknownOptionDiscard")
    def unknown_option_discard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Discard packets if the class and number are unknown.
        """
        return pulumi.get(self, "unknown_option_discard")

