from enum import Enum
from typing import TypedDict, TypeAlias, NewType, Optional

# >>>
# Scalars
# >>>
String: TypeAlias = str
Int: TypeAlias = int
Float: TypeAlias = float
Boolean: TypeAlias = bool
ID: TypeAlias = str
BigInt = NewType("BigInt", str)
BigFloat = NewType("BigFloat", str)
Cursor = NewType("Cursor", str)
Datetime = NewType("Datetime", str)
JwtToken = NewType("JwtToken", str)
Base64EncodedBinary = NewType("Base64EncodedBinary", str)
JSON = NewType("JSON", str)

# >>>
# Enums
# >>>
class LdataNodeType(Enum):
    account_root = "ACCOUNT_ROOT"
    dir = "DIR"
    obj = "OBJ"
    mount = "MOUNT"
    link = "LINK"
    mount_gcp = "MOUNT_GCP"
    mount_azure = "MOUNT_AZURE"

class AccountInfosOrderBy(Enum):
    """
    Methods to use when ordering `AccountInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    ldata_root_asc = "LDATA_ROOT_ASC"
    ldata_root_desc = "LDATA_ROOT_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_root__id_asc = "LDATA_NODE_BY_LDATA_ROOT__ID_ASC"
    ldata_node_by_ldata_root__id_desc = "LDATA_NODE_BY_LDATA_ROOT__ID_DESC"
    ldata_node_by_ldata_root__name_asc = "LDATA_NODE_BY_LDATA_ROOT__NAME_ASC"
    ldata_node_by_ldata_root__name_desc = "LDATA_NODE_BY_LDATA_ROOT__NAME_DESC"
    ldata_node_by_ldata_root__share_link_asc = "LDATA_NODE_BY_LDATA_ROOT__SHARE_LINK_ASC"
    ldata_node_by_ldata_root__share_link_desc = "LDATA_NODE_BY_LDATA_ROOT__SHARE_LINK_DESC"
    ldata_node_by_ldata_root__removed_asc = "LDATA_NODE_BY_LDATA_ROOT__REMOVED_ASC"
    ldata_node_by_ldata_root__removed_desc = "LDATA_NODE_BY_LDATA_ROOT__REMOVED_DESC"
    ldata_node_by_ldata_root__data_removed_asc = "LDATA_NODE_BY_LDATA_ROOT__DATA_REMOVED_ASC"
    ldata_node_by_ldata_root__data_removed_desc = "LDATA_NODE_BY_LDATA_ROOT__DATA_REMOVED_DESC"
    ldata_node_by_ldata_root__pending_asc = "LDATA_NODE_BY_LDATA_ROOT__PENDING_ASC"
    ldata_node_by_ldata_root__pending_desc = "LDATA_NODE_BY_LDATA_ROOT__PENDING_DESC"
    ldata_node_by_ldata_root__copied_from_asc = "LDATA_NODE_BY_LDATA_ROOT__COPIED_FROM_ASC"
    ldata_node_by_ldata_root__copied_from_desc = "LDATA_NODE_BY_LDATA_ROOT__COPIED_FROM_DESC"
    basespace_api_tokens_by_account_id__count_asc = "BASESPACE_API_TOKENS_BY_ACCOUNT_ID__COUNT_ASC"
    basespace_api_tokens_by_account_id__count_desc = "BASESPACE_API_TOKENS_BY_ACCOUNT_ID__COUNT_DESC"
    credits_by_account_id__count_asc = "CREDITS_BY_ACCOUNT_ID__COUNT_ASC"
    credits_by_account_id__count_desc = "CREDITS_BY_ACCOUNT_ID__COUNT_DESC"
    dataset_download_infos_by_account_id__count_asc = "DATASET_DOWNLOAD_INFOS_BY_ACCOUNT_ID__COUNT_ASC"
    dataset_download_infos_by_account_id__count_desc = "DATASET_DOWNLOAD_INFOS_BY_ACCOUNT_ID__COUNT_DESC"
    execution_creators_by_created_by__count_asc = "EXECUTION_CREATORS_BY_CREATED_BY__COUNT_ASC"
    execution_creators_by_created_by__count_desc = "EXECUTION_CREATORS_BY_CREATED_BY__COUNT_DESC"
    github_personal_access_token_by_account_id__account_id_asc = "GITHUB_PERSONAL_ACCESS_TOKEN_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    github_personal_access_token_by_account_id__account_id_desc = "GITHUB_PERSONAL_ACCESS_TOKEN_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    ldata_node_events_by_cause_account_id__count_asc = "LDATA_NODE_EVENTS_BY_CAUSE_ACCOUNT_ID__COUNT_ASC"
    ldata_node_events_by_cause_account_id__count_desc = "LDATA_NODE_EVENTS_BY_CAUSE_ACCOUNT_ID__COUNT_DESC"
    ldata_s3_mount_configurator_roles_by_account_id__count_asc = "LDATA_S3_MOUNT_CONFIGURATOR_ROLES_BY_ACCOUNT_ID__COUNT_ASC"
    ldata_s3_mount_configurator_roles_by_account_id__count_desc = "LDATA_S3_MOUNT_CONFIGURATOR_ROLES_BY_ACCOUNT_ID__COUNT_DESC"
    ldata_share_invites_by_sender_id__count_asc = "LDATA_SHARE_INVITES_BY_SENDER_ID__COUNT_ASC"
    ldata_share_invites_by_sender_id__count_desc = "LDATA_SHARE_INVITES_BY_SENDER_ID__COUNT_DESC"
    ldata_share_link_nodes_by_receiver_id__count_asc = "LDATA_SHARE_LINK_NODES_BY_RECEIVER_ID__COUNT_ASC"
    ldata_share_link_nodes_by_receiver_id__count_desc = "LDATA_SHARE_LINK_NODES_BY_RECEIVER_ID__COUNT_DESC"
    ldata_share_permissions_by_receiver_id__count_asc = "LDATA_SHARE_PERMISSIONS_BY_RECEIVER_ID__COUNT_ASC"
    ldata_share_permissions_by_receiver_id__count_desc = "LDATA_SHARE_PERMISSIONS_BY_RECEIVER_ID__COUNT_DESC"
    pod_infos_by_account_id__count_asc = "POD_INFOS_BY_ACCOUNT_ID__COUNT_ASC"
    pod_infos_by_account_id__count_desc = "POD_INFOS_BY_ACCOUNT_ID__COUNT_DESC"
    public_key_infos_by_account_id__count_asc = "PUBLIC_KEY_INFOS_BY_ACCOUNT_ID__COUNT_ASC"
    public_key_infos_by_account_id__count_desc = "PUBLIC_KEY_INFOS_BY_ACCOUNT_ID__COUNT_DESC"
    task_infos_by_owner_id__count_asc = "TASK_INFOS_BY_OWNER_ID__COUNT_ASC"
    task_infos_by_owner_id__count_desc = "TASK_INFOS_BY_OWNER_ID__COUNT_DESC"
    team_info_by_account_id__id_asc = "TEAM_INFO_BY_ACCOUNT_ID__ID_ASC"
    team_info_by_account_id__id_desc = "TEAM_INFO_BY_ACCOUNT_ID__ID_DESC"
    team_info_by_account_id__account_id_asc = "TEAM_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    team_info_by_account_id__account_id_desc = "TEAM_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    team_info_by_account_id__owner_id_asc = "TEAM_INFO_BY_ACCOUNT_ID__OWNER_ID_ASC"
    team_info_by_account_id__owner_id_desc = "TEAM_INFO_BY_ACCOUNT_ID__OWNER_ID_DESC"
    team_member_shared_data_type_by_account_id__account_id_asc = "TEAM_MEMBER_SHARED_DATA_TYPE_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    team_member_shared_data_type_by_account_id__account_id_desc = "TEAM_MEMBER_SHARED_DATA_TYPE_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    user_info_by_account_id__id_asc = "USER_INFO_BY_ACCOUNT_ID__ID_ASC"
    user_info_by_account_id__id_desc = "USER_INFO_BY_ACCOUNT_ID__ID_DESC"
    user_info_by_account_id__account_id_asc = "USER_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    user_info_by_account_id__account_id_desc = "USER_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    user_info_by_account_id__auth0_sub_asc = "USER_INFO_BY_ACCOUNT_ID__AUTH0_SUB_ASC"
    user_info_by_account_id__auth0_sub_desc = "USER_INFO_BY_ACCOUNT_ID__AUTH0_SUB_DESC"
    workflow_infos_by_owner_id__count_asc = "WORKFLOW_INFOS_BY_OWNER_ID__COUNT_ASC"
    workflow_infos_by_owner_id__count_desc = "WORKFLOW_INFOS_BY_OWNER_ID__COUNT_DESC"
    workflow_pins_by_account_id__count_asc = "WORKFLOW_PINS_BY_ACCOUNT_ID__COUNT_ASC"
    workflow_pins_by_account_id__count_desc = "WORKFLOW_PINS_BY_ACCOUNT_ID__COUNT_DESC"
    workflow_preview_by_account_id__account_id_asc = "WORKFLOW_PREVIEW_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    workflow_preview_by_account_id__account_id_desc = "WORKFLOW_PREVIEW_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    workflow_subscriptions_by_account_id__count_asc = "WORKFLOW_SUBSCRIPTIONS_BY_ACCOUNT_ID__COUNT_ASC"
    workflow_subscriptions_by_account_id__count_desc = "WORKFLOW_SUBSCRIPTIONS_BY_ACCOUNT_ID__COUNT_DESC"
    catalog_projects_by_owner_id__count_asc = "CATALOG_PROJECTS_BY_OWNER_ID__COUNT_ASC"
    catalog_projects_by_owner_id__count_desc = "CATALOG_PROJECTS_BY_OWNER_ID__COUNT_DESC"
    account_access_policies_by_workspace_id__count_asc = "ACCOUNT_ACCESS_POLICIES_BY_WORKSPACE_ID__COUNT_ASC"
    account_access_policies_by_workspace_id__count_desc = "ACCOUNT_ACCESS_POLICIES_BY_WORKSPACE_ID__COUNT_DESC"
    dataset_purchases_by_billed_to__count_asc = "DATASET_PURCHASES_BY_BILLED_TO__COUNT_ASC"
    dataset_purchases_by_billed_to__count_desc = "DATASET_PURCHASES_BY_BILLED_TO__COUNT_DESC"
    account_secrets_by_workspace_id__count_asc = "ACCOUNT_SECRETS_BY_WORKSPACE_ID__COUNT_ASC"
    account_secrets_by_workspace_id__count_desc = "ACCOUNT_SECRETS_BY_WORKSPACE_ID__COUNT_DESC"
    pod_templates_by_owner_id__count_asc = "POD_TEMPLATES_BY_OWNER_ID__COUNT_ASC"
    pod_templates_by_owner_id__count_desc = "POD_TEMPLATES_BY_OWNER_ID__COUNT_DESC"
    execution_batch_infos_by_owned_by__count_asc = "EXECUTION_BATCH_INFOS_BY_OWNED_BY__COUNT_ASC"
    execution_batch_infos_by_owned_by__count_desc = "EXECUTION_BATCH_INFOS_BY_OWNED_BY__COUNT_DESC"
    verified_emails_by_owner_id__count_asc = "VERIFIED_EMAILS_BY_OWNER_ID__COUNT_ASC"
    verified_emails_by_owner_id__count_desc = "VERIFIED_EMAILS_BY_OWNER_ID__COUNT_DESC"
    pod_group_infos_by_owner_id__count_asc = "POD_GROUP_INFOS_BY_OWNER_ID__COUNT_ASC"
    pod_group_infos_by_owner_id__count_desc = "POD_GROUP_INFOS_BY_OWNER_ID__COUNT_DESC"
    automation_infos_by_owner_id__count_asc = "AUTOMATION_INFOS_BY_OWNER_ID__COUNT_ASC"
    automation_infos_by_owner_id__count_desc = "AUTOMATION_INFOS_BY_OWNER_ID__COUNT_DESC"
    plot_infos_by_owner_id__count_asc = "PLOT_INFOS_BY_OWNER_ID__COUNT_ASC"
    plot_infos_by_owner_id__count_desc = "PLOT_INFOS_BY_OWNER_ID__COUNT_DESC"
    stripe_subscription_info_by_account_id__account_id_asc = "STRIPE_SUBSCRIPTION_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    stripe_subscription_info_by_account_id__account_id_desc = "STRIPE_SUBSCRIPTION_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    stripe_subscription_info_by_account_id__customer_id_asc = "STRIPE_SUBSCRIPTION_INFO_BY_ACCOUNT_ID__CUSTOMER_ID_ASC"
    stripe_subscription_info_by_account_id__customer_id_desc = "STRIPE_SUBSCRIPTION_INFO_BY_ACCOUNT_ID__CUSTOMER_ID_DESC"
    stripe_subscription_info_by_account_id__subscription_id_asc = "STRIPE_SUBSCRIPTION_INFO_BY_ACCOUNT_ID__SUBSCRIPTION_ID_ASC"
    stripe_subscription_info_by_account_id__subscription_id_desc = "STRIPE_SUBSCRIPTION_INFO_BY_ACCOUNT_ID__SUBSCRIPTION_ID_DESC"
    report_groups_by_workspace_id__count_asc = "REPORT_GROUPS_BY_WORKSPACE_ID__COUNT_ASC"
    report_groups_by_workspace_id__count_desc = "REPORT_GROUPS_BY_WORKSPACE_ID__COUNT_DESC"
    benchling_import_runs_by_account_id__count_asc = "BENCHLING_IMPORT_RUNS_BY_ACCOUNT_ID__COUNT_ASC"
    benchling_import_runs_by_account_id__count_desc = "BENCHLING_IMPORT_RUNS_BY_ACCOUNT_ID__COUNT_DESC"
    benchling_api_token_by_account_id__account_id_asc = "BENCHLING_API_TOKEN_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    benchling_api_token_by_account_id__account_id_desc = "BENCHLING_API_TOKEN_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    benchling_import_by_account_id__account_id_asc = "BENCHLING_IMPORT_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    benchling_import_by_account_id__account_id_desc = "BENCHLING_IMPORT_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    benchling_import_by_account_id__project_id_asc = "BENCHLING_IMPORT_BY_ACCOUNT_ID__PROJECT_ID_ASC"
    benchling_import_by_account_id__project_id_desc = "BENCHLING_IMPORT_BY_ACCOUNT_ID__PROJECT_ID_DESC"
    plot_data_source_infos_by_owner_id__count_asc = "PLOT_DATA_SOURCE_INFOS_BY_OWNER_ID__COUNT_ASC"
    plot_data_source_infos_by_owner_id__count_desc = "PLOT_DATA_SOURCE_INFOS_BY_OWNER_ID__COUNT_DESC"
    plot_layout_infos_by_owner_id__count_asc = "PLOT_LAYOUT_INFOS_BY_OWNER_ID__COUNT_ASC"
    plot_layout_infos_by_owner_id__count_desc = "PLOT_LAYOUT_INFOS_BY_OWNER_ID__COUNT_DESC"
    integrations_google_auth_by_account_id__account_id_asc = "INTEGRATIONS_GOOGLE_AUTH_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    integrations_google_auth_by_account_id__account_id_desc = "INTEGRATIONS_GOOGLE_AUTH_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    nextflow_node_infos_by_owner_id__count_asc = "NEXTFLOW_NODE_INFOS_BY_OWNER_ID__COUNT_ASC"
    nextflow_node_infos_by_owner_id__count_desc = "NEXTFLOW_NODE_INFOS_BY_OWNER_ID__COUNT_DESC"
    plot_transform_infos_by_owner_id__count_asc = "PLOT_TRANSFORM_INFOS_BY_OWNER_ID__COUNT_ASC"
    plot_transform_infos_by_owner_id__count_desc = "PLOT_TRANSFORM_INFOS_BY_OWNER_ID__COUNT_DESC"
    ldata_gcp_mount_projects_by_account_id__count_asc = "LDATA_GCP_MOUNT_PROJECTS_BY_ACCOUNT_ID__COUNT_ASC"
    ldata_gcp_mount_projects_by_account_id__count_desc = "LDATA_GCP_MOUNT_PROJECTS_BY_ACCOUNT_ID__COUNT_DESC"
    plot_notebook_infos_by_owner_id__count_asc = "PLOT_NOTEBOOK_INFOS_BY_OWNER_ID__COUNT_ASC"
    plot_notebook_infos_by_owner_id__count_desc = "PLOT_NOTEBOOK_INFOS_BY_OWNER_ID__COUNT_DESC"
    ldata_google_verified_projects_by_account_id__count_asc = "LDATA_GOOGLE_VERIFIED_PROJECTS_BY_ACCOUNT_ID__COUNT_ASC"
    ldata_google_verified_projects_by_account_id__count_desc = "LDATA_GOOGLE_VERIFIED_PROJECTS_BY_ACCOUNT_ID__COUNT_DESC"

class DatasetDownloadStatus(Enum):
    pending = "PENDING"
    success = "SUCCESS"
    error = "ERROR"

class LdataEventType(Enum):
    ingress = "INGRESS"
    egress = "EGRESS"
    remove = "REMOVE"
    child_remove = "CHILD_REMOVE"
    move = "MOVE"

class PermLevel(Enum):
    none = "NONE"
    viewer = "VIEWER"
    member = "MEMBER"
    admin = "ADMIN"
    owner = "OWNER"

class LdataTagType(Enum):
    user = "USER"
    execution_input = "EXECUTION_INPUT"
    execution_output = "EXECUTION_OUTPUT"

class LdataWfExStatus(Enum):
    pending = "PENDING"
    success = "SUCCESS"
    error = "ERROR"

class ExecutionStatus(Enum):
    undefined = "UNDEFINED"
    queued = "QUEUED"
    running = "RUNNING"
    succeeding = "SUCCEEDING"
    succeeded = "SUCCEEDED"
    failing = "FAILING"
    failed = "FAILED"
    aborted = "ABORTED"
    timed_out = "TIMED_OUT"
    aborting = "ABORTING"

class ExecutionNodeStatus(Enum):
    undefined = "UNDEFINED"
    queued = "QUEUED"
    running = "RUNNING"
    succeeded = "SUCCEEDED"
    failing = "FAILING"
    failed = "FAILED"
    aborted = "ABORTED"
    skipped = "SKIPPED"
    timed_out = "TIMED_OUT"
    aborting = "ABORTING"
    recovered = "RECOVERED"

class TeamRole(Enum):
    admin = "ADMIN"
    member = "MEMBER"
    viewer = "VIEWER"

class DatasetAvailability(Enum):
    available = "AVAILABLE"
    waitlist = "WAITLIST"
    external = "EXTERNAL"

class PodBackupStatus(Enum):
    pending = "PENDING"
    success = "SUCCESS"
    error = "ERROR"

class IgvGenomesOrderBy(Enum):
    """
    Methods to use when ordering `IgvGenome`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    execution_flytedb_id_asc = "EXECUTION_FLYTEDB_ID_ASC"
    execution_flytedb_id_desc = "EXECUTION_FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"
    execution_creator_by_execution_flytedb_id__created_by_asc = "EXECUTION_CREATOR_BY_EXECUTION_FLYTEDB_ID__CREATED_BY_ASC"
    execution_creator_by_execution_flytedb_id__created_by_desc = "EXECUTION_CREATOR_BY_EXECUTION_FLYTEDB_ID__CREATED_BY_DESC"
    execution_creator_by_execution_flytedb_id__token_asc = "EXECUTION_CREATOR_BY_EXECUTION_FLYTEDB_ID__TOKEN_ASC"
    execution_creator_by_execution_flytedb_id__token_desc = "EXECUTION_CREATOR_BY_EXECUTION_FLYTEDB_ID__TOKEN_DESC"
    execution_creator_by_execution_flytedb_id__flytedb_id_asc = "EXECUTION_CREATOR_BY_EXECUTION_FLYTEDB_ID__FLYTEDB_ID_ASC"
    execution_creator_by_execution_flytedb_id__flytedb_id_desc = "EXECUTION_CREATOR_BY_EXECUTION_FLYTEDB_ID__FLYTEDB_ID_DESC"

class ExecutionInfosOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    status_asc = "STATUS_ASC"
    status_desc = "STATUS_DESC"
    creation_time_asc = "CREATION_TIME_ASC"
    creation_time_desc = "CREATION_TIME_DESC"
    parent_execution_graph_node_flytedb_id_asc = "PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    parent_execution_graph_node_flytedb_id_desc = "PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"
    execution_graph_nodes_by_execution_id__count_asc = "EXECUTION_GRAPH_NODES_BY_EXECUTION_ID__COUNT_ASC"
    execution_graph_nodes_by_execution_id__count_desc = "EXECUTION_GRAPH_NODES_BY_EXECUTION_ID__COUNT_DESC"
    task_execution_messages_by_execution_id__count_asc = "TASK_EXECUTION_MESSAGES_BY_EXECUTION_ID__COUNT_ASC"
    task_execution_messages_by_execution_id__count_desc = "TASK_EXECUTION_MESSAGES_BY_EXECUTION_ID__COUNT_DESC"
    snakemake_execution_info_by_jit_execution_id__jit_execution_id_asc = "SNAKEMAKE_EXECUTION_INFO_BY_JIT_EXECUTION_ID__JIT_EXECUTION_ID_ASC"
    snakemake_execution_info_by_jit_execution_id__jit_execution_id_desc = "SNAKEMAKE_EXECUTION_INFO_BY_JIT_EXECUTION_ID__JIT_EXECUTION_ID_DESC"
    snakemake_execution_info_by_jit_execution_id__real_execution_id_asc = "SNAKEMAKE_EXECUTION_INFO_BY_JIT_EXECUTION_ID__REAL_EXECUTION_ID_ASC"
    snakemake_execution_info_by_jit_execution_id__real_execution_id_desc = "SNAKEMAKE_EXECUTION_INFO_BY_JIT_EXECUTION_ID__REAL_EXECUTION_ID_DESC"
    snakemake_execution_infos_by_real_execution_id__count_asc = "SNAKEMAKE_EXECUTION_INFOS_BY_REAL_EXECUTION_ID__COUNT_ASC"
    snakemake_execution_infos_by_real_execution_id__count_desc = "SNAKEMAKE_EXECUTION_INFOS_BY_REAL_EXECUTION_ID__COUNT_DESC"
    automation_run_ldata_event_by_execution_flytedb_id__trigger_id_asc = "AUTOMATION_RUN_LDATA_EVENT_BY_EXECUTION_FLYTEDB_ID__TRIGGER_ID_ASC"
    automation_run_ldata_event_by_execution_flytedb_id__trigger_id_desc = "AUTOMATION_RUN_LDATA_EVENT_BY_EXECUTION_FLYTEDB_ID__TRIGGER_ID_DESC"
    automation_run_ldata_event_by_execution_flytedb_id__execution_flytedb_id_asc = "AUTOMATION_RUN_LDATA_EVENT_BY_EXECUTION_FLYTEDB_ID__EXECUTION_FLYTEDB_ID_ASC"
    automation_run_ldata_event_by_execution_flytedb_id__execution_flytedb_id_desc = "AUTOMATION_RUN_LDATA_EVENT_BY_EXECUTION_FLYTEDB_ID__EXECUTION_FLYTEDB_ID_DESC"
    automation_run_interval_event_by_execution_flytedb_id__trigger_id_asc = "AUTOMATION_RUN_INTERVAL_EVENT_BY_EXECUTION_FLYTEDB_ID__TRIGGER_ID_ASC"
    automation_run_interval_event_by_execution_flytedb_id__trigger_id_desc = "AUTOMATION_RUN_INTERVAL_EVENT_BY_EXECUTION_FLYTEDB_ID__TRIGGER_ID_DESC"
    automation_run_interval_event_by_execution_flytedb_id__launch_attempt_time_asc = "AUTOMATION_RUN_INTERVAL_EVENT_BY_EXECUTION_FLYTEDB_ID__LAUNCH_ATTEMPT_TIME_ASC"
    automation_run_interval_event_by_execution_flytedb_id__launch_attempt_time_desc = "AUTOMATION_RUN_INTERVAL_EVENT_BY_EXECUTION_FLYTEDB_ID__LAUNCH_ATTEMPT_TIME_DESC"
    automation_run_interval_event_by_execution_flytedb_id__execution_flytedb_id_asc = "AUTOMATION_RUN_INTERVAL_EVENT_BY_EXECUTION_FLYTEDB_ID__EXECUTION_FLYTEDB_ID_ASC"
    automation_run_interval_event_by_execution_flytedb_id__execution_flytedb_id_desc = "AUTOMATION_RUN_INTERVAL_EVENT_BY_EXECUTION_FLYTEDB_ID__EXECUTION_FLYTEDB_ID_DESC"

class LpInfosOrderBy(Enum):
    """
    Methods to use when ordering `LpInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"

class WorkflowGraphEdgesOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowGraphEdge`.
    """
    natural = "NATURAL"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"

class WorkflowGraphNodeType(Enum):
    python_task = "PYTHON_TASK"
    conditional = "CONDITIONAL"
    launchplan_ref = "LAUNCHPLAN_REF"
    container_array = "CONTAINER_ARRAY"
    workflow = "WORKFLOW"

class WorkflowGraphBranchType(Enum):
    if_else = "IF_ELSE"
    else_kv = "ELSE"

class WorkflowGraphBranchesOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowGraphBranch`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    workflow_graph_node_id_asc = "WORKFLOW_GRAPH_NODE_ID_ASC"
    workflow_graph_node_id_desc = "WORKFLOW_GRAPH_NODE_ID_DESC"
    task_info_id_asc = "TASK_INFO_ID_ASC"
    task_info_id_desc = "TASK_INFO_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_graph_node_by_workflow_graph_node_id__id_asc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__ID_ASC"
    workflow_graph_node_by_workflow_graph_node_id__id_desc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__ID_DESC"
    workflow_graph_node_by_workflow_graph_node_id__workflow_id_asc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__WORKFLOW_ID_ASC"
    workflow_graph_node_by_workflow_graph_node_id__workflow_id_desc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__WORKFLOW_ID_DESC"
    workflow_graph_node_by_workflow_graph_node_id__task_info_id_asc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__TASK_INFO_ID_ASC"
    workflow_graph_node_by_workflow_graph_node_id__task_info_id_desc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__TASK_INFO_ID_DESC"
    task_info_by_task_info_id__id_asc = "TASK_INFO_BY_TASK_INFO_ID__ID_ASC"
    task_info_by_task_info_id__id_desc = "TASK_INFO_BY_TASK_INFO_ID__ID_DESC"
    task_info_by_task_info_id__owner_id_asc = "TASK_INFO_BY_TASK_INFO_ID__OWNER_ID_ASC"
    task_info_by_task_info_id__owner_id_desc = "TASK_INFO_BY_TASK_INFO_ID__OWNER_ID_DESC"
    task_info_by_task_info_id__project_asc = "TASK_INFO_BY_TASK_INFO_ID__PROJECT_ASC"
    task_info_by_task_info_id__project_desc = "TASK_INFO_BY_TASK_INFO_ID__PROJECT_DESC"
    task_info_by_task_info_id__flytedb_id_asc = "TASK_INFO_BY_TASK_INFO_ID__FLYTEDB_ID_ASC"
    task_info_by_task_info_id__flytedb_id_desc = "TASK_INFO_BY_TASK_INFO_ID__FLYTEDB_ID_DESC"

class WorkflowGraphNodesOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowGraphNode`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    task_info_id_asc = "TASK_INFO_ID_ASC"
    task_info_id_desc = "TASK_INFO_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"
    task_info_by_task_info_id__id_asc = "TASK_INFO_BY_TASK_INFO_ID__ID_ASC"
    task_info_by_task_info_id__id_desc = "TASK_INFO_BY_TASK_INFO_ID__ID_DESC"
    task_info_by_task_info_id__owner_id_asc = "TASK_INFO_BY_TASK_INFO_ID__OWNER_ID_ASC"
    task_info_by_task_info_id__owner_id_desc = "TASK_INFO_BY_TASK_INFO_ID__OWNER_ID_DESC"
    task_info_by_task_info_id__project_asc = "TASK_INFO_BY_TASK_INFO_ID__PROJECT_ASC"
    task_info_by_task_info_id__project_desc = "TASK_INFO_BY_TASK_INFO_ID__PROJECT_DESC"
    task_info_by_task_info_id__flytedb_id_asc = "TASK_INFO_BY_TASK_INFO_ID__FLYTEDB_ID_ASC"
    task_info_by_task_info_id__flytedb_id_desc = "TASK_INFO_BY_TASK_INFO_ID__FLYTEDB_ID_DESC"
    execution_graph_nodes_by_workflow_graph_node_id__count_asc = "EXECUTION_GRAPH_NODES_BY_WORKFLOW_GRAPH_NODE_ID__COUNT_ASC"
    execution_graph_nodes_by_workflow_graph_node_id__count_desc = "EXECUTION_GRAPH_NODES_BY_WORKFLOW_GRAPH_NODE_ID__COUNT_DESC"
    workflow_graph_branches_by_workflow_graph_node_id__count_asc = "WORKFLOW_GRAPH_BRANCHES_BY_WORKFLOW_GRAPH_NODE_ID__COUNT_ASC"
    workflow_graph_branches_by_workflow_graph_node_id__count_desc = "WORKFLOW_GRAPH_BRANCHES_BY_WORKFLOW_GRAPH_NODE_ID__COUNT_DESC"
    workflow_graph_sub_wf_by_wgn_id__wgn_id_asc = "WORKFLOW_GRAPH_SUB_WF_BY_WGN_ID__WGN_ID_ASC"
    workflow_graph_sub_wf_by_wgn_id__wgn_id_desc = "WORKFLOW_GRAPH_SUB_WF_BY_WGN_ID__WGN_ID_DESC"

class TaskExecutionStatus(Enum):
    undefined = "UNDEFINED"
    queued = "QUEUED"
    running = "RUNNING"
    succeeded = "SUCCEEDED"
    aborted = "ABORTED"
    failed = "FAILED"
    initializing = "INITIALIZING"
    waiting_for_resources = "WAITING_FOR_RESOURCES"

class ContainerInfosOrderBy(Enum):
    """
    Methods to use when ordering `ContainerInfo`.
    """
    natural = "NATURAL"
    execution_graph_node_flytedb_id_asc = "EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_graph_node_flytedb_id_desc = "EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    index_asc = "INDEX_ASC"
    index_desc = "INDEX_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class TaskExecutionInfosOrderBy(Enum):
    """
    Methods to use when ordering `TaskExecutionInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    execution_graph_node_flytedb_id_asc = "EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_graph_node_flytedb_id_desc = "EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    retry_asc = "RETRY_ASC"
    retry_desc = "RETRY_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class ExecutionGraphNodesOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionGraphNode`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    execution_id_asc = "EXECUTION_ID_ASC"
    execution_id_desc = "EXECUTION_ID_DESC"
    workflow_graph_node_id_asc = "WORKFLOW_GRAPH_NODE_ID_ASC"
    workflow_graph_node_id_desc = "WORKFLOW_GRAPH_NODE_ID_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    status_asc = "STATUS_ASC"
    status_desc = "STATUS_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    execution_info_by_execution_id__id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__ID_ASC"
    execution_info_by_execution_id__id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__ID_DESC"
    execution_info_by_execution_id__workflow_id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__WORKFLOW_ID_ASC"
    execution_info_by_execution_id__workflow_id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__WORKFLOW_ID_DESC"
    execution_info_by_execution_id__flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__FLYTEDB_ID_ASC"
    execution_info_by_execution_id__flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__FLYTEDB_ID_DESC"
    execution_info_by_execution_id__status_asc = "EXECUTION_INFO_BY_EXECUTION_ID__STATUS_ASC"
    execution_info_by_execution_id__status_desc = "EXECUTION_INFO_BY_EXECUTION_ID__STATUS_DESC"
    execution_info_by_execution_id__creation_time_asc = "EXECUTION_INFO_BY_EXECUTION_ID__CREATION_TIME_ASC"
    execution_info_by_execution_id__creation_time_desc = "EXECUTION_INFO_BY_EXECUTION_ID__CREATION_TIME_DESC"
    execution_info_by_execution_id__parent_execution_graph_node_flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_info_by_execution_id__parent_execution_graph_node_flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    execution_info_by_execution_id__removed_asc = "EXECUTION_INFO_BY_EXECUTION_ID__REMOVED_ASC"
    execution_info_by_execution_id__removed_desc = "EXECUTION_INFO_BY_EXECUTION_ID__REMOVED_DESC"
    workflow_graph_node_by_workflow_graph_node_id__id_asc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__ID_ASC"
    workflow_graph_node_by_workflow_graph_node_id__id_desc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__ID_DESC"
    workflow_graph_node_by_workflow_graph_node_id__workflow_id_asc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__WORKFLOW_ID_ASC"
    workflow_graph_node_by_workflow_graph_node_id__workflow_id_desc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__WORKFLOW_ID_DESC"
    workflow_graph_node_by_workflow_graph_node_id__task_info_id_asc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__TASK_INFO_ID_ASC"
    workflow_graph_node_by_workflow_graph_node_id__task_info_id_desc = "WORKFLOW_GRAPH_NODE_BY_WORKFLOW_GRAPH_NODE_ID__TASK_INFO_ID_DESC"
    execution_ref_lp_info_by_egn_id__egn_id_asc = "EXECUTION_REF_LP_INFO_BY_EGN_ID__EGN_ID_ASC"
    execution_ref_lp_info_by_egn_id__egn_id_desc = "EXECUTION_REF_LP_INFO_BY_EGN_ID__EGN_ID_DESC"
    execution_ref_lp_info_by_egn_id__token_asc = "EXECUTION_REF_LP_INFO_BY_EGN_ID__TOKEN_ASC"
    execution_ref_lp_info_by_egn_id__token_desc = "EXECUTION_REF_LP_INFO_BY_EGN_ID__TOKEN_DESC"

class WorkflowSubscriptionsOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowSubscription`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"

class WorkflowTagsOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowTag`.
    """
    natural = "NATURAL"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"

class AutomationVersionsOrderBy(Enum):
    """
    Methods to use when ordering `AutomationVersion`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    automation_id_asc = "AUTOMATION_ID_ASC"
    automation_id_desc = "AUTOMATION_ID_DESC"
    workflow_id_asc = "WORKFLOW_ID_ASC"
    workflow_id_desc = "WORKFLOW_ID_DESC"
    creation_time_asc = "CREATION_TIME_ASC"
    creation_time_desc = "CREATION_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    automation_info_by_automation_id__id_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__ID_ASC"
    automation_info_by_automation_id__id_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__ID_DESC"
    automation_info_by_automation_id__owner_id_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__OWNER_ID_ASC"
    automation_info_by_automation_id__owner_id_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__OWNER_ID_DESC"
    automation_info_by_automation_id__removal_time_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__REMOVAL_TIME_ASC"
    automation_info_by_automation_id__removal_time_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__REMOVAL_TIME_DESC"
    workflow_info_by_workflow_id__id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_ASC"
    workflow_info_by_workflow_id__id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__ID_DESC"
    workflow_info_by_workflow_id__owner_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_ASC"
    workflow_info_by_workflow_id__owner_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__OWNER_ID_DESC"
    workflow_info_by_workflow_id__display_name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_ASC"
    workflow_info_by_workflow_id__display_name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__DISPLAY_NAME_DESC"
    workflow_info_by_workflow_id__version_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_ASC"
    workflow_info_by_workflow_id__version_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__VERSION_DESC"
    workflow_info_by_workflow_id__name_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_ASC"
    workflow_info_by_workflow_id__name_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__NAME_DESC"
    workflow_info_by_workflow_id__flytedb_id_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_ASC"
    workflow_info_by_workflow_id__flytedb_id_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__FLYTEDB_ID_DESC"
    workflow_info_by_workflow_id__removed_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_ASC"
    workflow_info_by_workflow_id__removed_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__REMOVED_DESC"
    workflow_info_by_workflow_id__available_in_explore_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_ASC"
    workflow_info_by_workflow_id__available_in_explore_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__AVAILABLE_IN_EXPLORE_DESC"
    workflow_info_by_workflow_id__creation_date_asc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_ASC"
    workflow_info_by_workflow_id__creation_date_desc = "WORKFLOW_INFO_BY_WORKFLOW_ID__CREATION_DATE_DESC"

class AutomationRunLdataEventsOrderBy(Enum):
    """
    Methods to use when ordering `AutomationRunLdataEvent`.
    """
    natural = "NATURAL"
    trigger_id_asc = "TRIGGER_ID_ASC"
    trigger_id_desc = "TRIGGER_ID_DESC"
    execution_flytedb_id_asc = "EXECUTION_FLYTEDB_ID_ASC"
    execution_flytedb_id_desc = "EXECUTION_FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    automation_trigger_ldata_event_by_trigger_id__id_asc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__ID_ASC"
    automation_trigger_ldata_event_by_trigger_id__id_desc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__ID_DESC"
    automation_trigger_ldata_event_by_trigger_id__automation_id_asc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__AUTOMATION_ID_ASC"
    automation_trigger_ldata_event_by_trigger_id__automation_id_desc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__AUTOMATION_ID_DESC"
    automation_trigger_ldata_event_by_trigger_id__target_node_id_asc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__TARGET_NODE_ID_ASC"
    automation_trigger_ldata_event_by_trigger_id__target_node_id_desc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__TARGET_NODE_ID_DESC"
    automation_trigger_ldata_event_by_trigger_id__removal_time_asc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__REMOVAL_TIME_ASC"
    automation_trigger_ldata_event_by_trigger_id__removal_time_desc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__REMOVAL_TIME_DESC"
    automation_trigger_ldata_event_by_trigger_id__creation_time_asc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__CREATION_TIME_ASC"
    automation_trigger_ldata_event_by_trigger_id__creation_time_desc = "AUTOMATION_TRIGGER_LDATA_EVENT_BY_TRIGGER_ID__CREATION_TIME_DESC"
    execution_info_by_execution_flytedb_id__id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__ID_ASC"
    execution_info_by_execution_flytedb_id__id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__ID_DESC"
    execution_info_by_execution_flytedb_id__workflow_id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__WORKFLOW_ID_ASC"
    execution_info_by_execution_flytedb_id__workflow_id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__WORKFLOW_ID_DESC"
    execution_info_by_execution_flytedb_id__flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__FLYTEDB_ID_ASC"
    execution_info_by_execution_flytedb_id__flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__FLYTEDB_ID_DESC"
    execution_info_by_execution_flytedb_id__status_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__STATUS_ASC"
    execution_info_by_execution_flytedb_id__status_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__STATUS_DESC"
    execution_info_by_execution_flytedb_id__creation_time_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__CREATION_TIME_ASC"
    execution_info_by_execution_flytedb_id__creation_time_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__CREATION_TIME_DESC"
    execution_info_by_execution_flytedb_id__parent_execution_graph_node_flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_info_by_execution_flytedb_id__parent_execution_graph_node_flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    execution_info_by_execution_flytedb_id__removed_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__REMOVED_ASC"
    execution_info_by_execution_flytedb_id__removed_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__REMOVED_DESC"

class AutomationTriggerLdataEventsOrderBy(Enum):
    """
    Methods to use when ordering `AutomationTriggerLdataEvent`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    automation_id_asc = "AUTOMATION_ID_ASC"
    automation_id_desc = "AUTOMATION_ID_DESC"
    target_node_id_asc = "TARGET_NODE_ID_ASC"
    target_node_id_desc = "TARGET_NODE_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    creation_time_asc = "CREATION_TIME_ASC"
    creation_time_desc = "CREATION_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    automation_info_by_automation_id__id_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__ID_ASC"
    automation_info_by_automation_id__id_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__ID_DESC"
    automation_info_by_automation_id__owner_id_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__OWNER_ID_ASC"
    automation_info_by_automation_id__owner_id_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__OWNER_ID_DESC"
    automation_info_by_automation_id__removal_time_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__REMOVAL_TIME_ASC"
    automation_info_by_automation_id__removal_time_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__REMOVAL_TIME_DESC"
    ldata_node_by_target_node_id__id_asc = "LDATA_NODE_BY_TARGET_NODE_ID__ID_ASC"
    ldata_node_by_target_node_id__id_desc = "LDATA_NODE_BY_TARGET_NODE_ID__ID_DESC"
    ldata_node_by_target_node_id__name_asc = "LDATA_NODE_BY_TARGET_NODE_ID__NAME_ASC"
    ldata_node_by_target_node_id__name_desc = "LDATA_NODE_BY_TARGET_NODE_ID__NAME_DESC"
    ldata_node_by_target_node_id__share_link_asc = "LDATA_NODE_BY_TARGET_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_target_node_id__share_link_desc = "LDATA_NODE_BY_TARGET_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_target_node_id__removed_asc = "LDATA_NODE_BY_TARGET_NODE_ID__REMOVED_ASC"
    ldata_node_by_target_node_id__removed_desc = "LDATA_NODE_BY_TARGET_NODE_ID__REMOVED_DESC"
    ldata_node_by_target_node_id__data_removed_asc = "LDATA_NODE_BY_TARGET_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_target_node_id__data_removed_desc = "LDATA_NODE_BY_TARGET_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_target_node_id__pending_asc = "LDATA_NODE_BY_TARGET_NODE_ID__PENDING_ASC"
    ldata_node_by_target_node_id__pending_desc = "LDATA_NODE_BY_TARGET_NODE_ID__PENDING_DESC"
    ldata_node_by_target_node_id__copied_from_asc = "LDATA_NODE_BY_TARGET_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_target_node_id__copied_from_desc = "LDATA_NODE_BY_TARGET_NODE_ID__COPIED_FROM_DESC"
    automation_run_ldata_events_by_trigger_id__count_asc = "AUTOMATION_RUN_LDATA_EVENTS_BY_TRIGGER_ID__COUNT_ASC"
    automation_run_ldata_events_by_trigger_id__count_desc = "AUTOMATION_RUN_LDATA_EVENTS_BY_TRIGGER_ID__COUNT_DESC"

class AutomationRunIntervalEventsOrderBy(Enum):
    """
    Methods to use when ordering `AutomationRunIntervalEvent`.
    """
    natural = "NATURAL"
    trigger_id_asc = "TRIGGER_ID_ASC"
    trigger_id_desc = "TRIGGER_ID_DESC"
    launch_attempt_time_asc = "LAUNCH_ATTEMPT_TIME_ASC"
    launch_attempt_time_desc = "LAUNCH_ATTEMPT_TIME_DESC"
    execution_flytedb_id_asc = "EXECUTION_FLYTEDB_ID_ASC"
    execution_flytedb_id_desc = "EXECUTION_FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    automation_trigger_interval_event_by_trigger_id__id_asc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__ID_ASC"
    automation_trigger_interval_event_by_trigger_id__id_desc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__ID_DESC"
    automation_trigger_interval_event_by_trigger_id__automation_id_asc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__AUTOMATION_ID_ASC"
    automation_trigger_interval_event_by_trigger_id__automation_id_desc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__AUTOMATION_ID_DESC"
    automation_trigger_interval_event_by_trigger_id__removal_time_asc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__REMOVAL_TIME_ASC"
    automation_trigger_interval_event_by_trigger_id__removal_time_desc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__REMOVAL_TIME_DESC"
    automation_trigger_interval_event_by_trigger_id__creation_time_asc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__CREATION_TIME_ASC"
    automation_trigger_interval_event_by_trigger_id__creation_time_desc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__CREATION_TIME_DESC"
    automation_trigger_interval_event_by_trigger_id__failed_override_time_asc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__FAILED_OVERRIDE_TIME_ASC"
    automation_trigger_interval_event_by_trigger_id__failed_override_time_desc = "AUTOMATION_TRIGGER_INTERVAL_EVENT_BY_TRIGGER_ID__FAILED_OVERRIDE_TIME_DESC"
    execution_info_by_execution_flytedb_id__id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__ID_ASC"
    execution_info_by_execution_flytedb_id__id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__ID_DESC"
    execution_info_by_execution_flytedb_id__workflow_id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__WORKFLOW_ID_ASC"
    execution_info_by_execution_flytedb_id__workflow_id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__WORKFLOW_ID_DESC"
    execution_info_by_execution_flytedb_id__flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__FLYTEDB_ID_ASC"
    execution_info_by_execution_flytedb_id__flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__FLYTEDB_ID_DESC"
    execution_info_by_execution_flytedb_id__status_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__STATUS_ASC"
    execution_info_by_execution_flytedb_id__status_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__STATUS_DESC"
    execution_info_by_execution_flytedb_id__creation_time_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__CREATION_TIME_ASC"
    execution_info_by_execution_flytedb_id__creation_time_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__CREATION_TIME_DESC"
    execution_info_by_execution_flytedb_id__parent_execution_graph_node_flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_info_by_execution_flytedb_id__parent_execution_graph_node_flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    execution_info_by_execution_flytedb_id__removed_asc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__REMOVED_ASC"
    execution_info_by_execution_flytedb_id__removed_desc = "EXECUTION_INFO_BY_EXECUTION_FLYTEDB_ID__REMOVED_DESC"

class AutomationTriggerIntervalEventsOrderBy(Enum):
    """
    Methods to use when ordering `AutomationTriggerIntervalEvent`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    automation_id_asc = "AUTOMATION_ID_ASC"
    automation_id_desc = "AUTOMATION_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    creation_time_asc = "CREATION_TIME_ASC"
    creation_time_desc = "CREATION_TIME_DESC"
    failed_override_time_asc = "FAILED_OVERRIDE_TIME_ASC"
    failed_override_time_desc = "FAILED_OVERRIDE_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    automation_info_by_automation_id__id_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__ID_ASC"
    automation_info_by_automation_id__id_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__ID_DESC"
    automation_info_by_automation_id__owner_id_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__OWNER_ID_ASC"
    automation_info_by_automation_id__owner_id_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__OWNER_ID_DESC"
    automation_info_by_automation_id__removal_time_asc = "AUTOMATION_INFO_BY_AUTOMATION_ID__REMOVAL_TIME_ASC"
    automation_info_by_automation_id__removal_time_desc = "AUTOMATION_INFO_BY_AUTOMATION_ID__REMOVAL_TIME_DESC"
    automation_run_interval_events_by_trigger_id__count_asc = "AUTOMATION_RUN_INTERVAL_EVENTS_BY_TRIGGER_ID__COUNT_ASC"
    automation_run_interval_events_by_trigger_id__count_desc = "AUTOMATION_RUN_INTERVAL_EVENTS_BY_TRIGGER_ID__COUNT_DESC"

class WorkflowInfosOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    display_name_asc = "DISPLAY_NAME_ASC"
    display_name_desc = "DISPLAY_NAME_DESC"
    version_asc = "VERSION_ASC"
    version_desc = "VERSION_DESC"
    name_asc = "NAME_ASC"
    name_desc = "NAME_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    available_in_explore_asc = "AVAILABLE_IN_EXPLORE_ASC"
    available_in_explore_desc = "AVAILABLE_IN_EXPLORE_DESC"
    creation_date_asc = "CREATION_DATE_ASC"
    creation_date_desc = "CREATION_DATE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    execution_infos_by_workflow_id__count_asc = "EXECUTION_INFOS_BY_WORKFLOW_ID__COUNT_ASC"
    execution_infos_by_workflow_id__count_desc = "EXECUTION_INFOS_BY_WORKFLOW_ID__COUNT_DESC"
    lp_infos_by_workflow_id__count_asc = "LP_INFOS_BY_WORKFLOW_ID__COUNT_ASC"
    lp_infos_by_workflow_id__count_desc = "LP_INFOS_BY_WORKFLOW_ID__COUNT_DESC"
    workflow_graph_edges_by_workflow_id__count_asc = "WORKFLOW_GRAPH_EDGES_BY_WORKFLOW_ID__COUNT_ASC"
    workflow_graph_edges_by_workflow_id__count_desc = "WORKFLOW_GRAPH_EDGES_BY_WORKFLOW_ID__COUNT_DESC"
    workflow_graph_nodes_by_workflow_id__count_asc = "WORKFLOW_GRAPH_NODES_BY_WORKFLOW_ID__COUNT_ASC"
    workflow_graph_nodes_by_workflow_id__count_desc = "WORKFLOW_GRAPH_NODES_BY_WORKFLOW_ID__COUNT_DESC"
    workflow_subscriptions_by_workflow_id__count_asc = "WORKFLOW_SUBSCRIPTIONS_BY_WORKFLOW_ID__COUNT_ASC"
    workflow_subscriptions_by_workflow_id__count_desc = "WORKFLOW_SUBSCRIPTIONS_BY_WORKFLOW_ID__COUNT_DESC"
    workflow_tags_by_workflow_id__count_asc = "WORKFLOW_TAGS_BY_WORKFLOW_ID__COUNT_ASC"
    workflow_tags_by_workflow_id__count_desc = "WORKFLOW_TAGS_BY_WORKFLOW_ID__COUNT_DESC"
    automation_versions_by_workflow_id__count_asc = "AUTOMATION_VERSIONS_BY_WORKFLOW_ID__COUNT_ASC"
    automation_versions_by_workflow_id__count_desc = "AUTOMATION_VERSIONS_BY_WORKFLOW_ID__COUNT_DESC"

class TaskExecutionMessagesOrderBy(Enum):
    """
    Methods to use when ordering `TaskExecutionMessage`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    execution_id_asc = "EXECUTION_ID_ASC"
    execution_id_desc = "EXECUTION_ID_DESC"
    creation_time_asc = "CREATION_TIME_ASC"
    creation_time_desc = "CREATION_TIME_DESC"
    type_asc = "TYPE_ASC"
    type_desc = "TYPE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    execution_info_by_execution_id__id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__ID_ASC"
    execution_info_by_execution_id__id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__ID_DESC"
    execution_info_by_execution_id__workflow_id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__WORKFLOW_ID_ASC"
    execution_info_by_execution_id__workflow_id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__WORKFLOW_ID_DESC"
    execution_info_by_execution_id__flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__FLYTEDB_ID_ASC"
    execution_info_by_execution_id__flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__FLYTEDB_ID_DESC"
    execution_info_by_execution_id__status_asc = "EXECUTION_INFO_BY_EXECUTION_ID__STATUS_ASC"
    execution_info_by_execution_id__status_desc = "EXECUTION_INFO_BY_EXECUTION_ID__STATUS_DESC"
    execution_info_by_execution_id__creation_time_asc = "EXECUTION_INFO_BY_EXECUTION_ID__CREATION_TIME_ASC"
    execution_info_by_execution_id__creation_time_desc = "EXECUTION_INFO_BY_EXECUTION_ID__CREATION_TIME_DESC"
    execution_info_by_execution_id__parent_execution_graph_node_flytedb_id_asc = "EXECUTION_INFO_BY_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_info_by_execution_id__parent_execution_graph_node_flytedb_id_desc = "EXECUTION_INFO_BY_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    execution_info_by_execution_id__removed_asc = "EXECUTION_INFO_BY_EXECUTION_ID__REMOVED_ASC"
    execution_info_by_execution_id__removed_desc = "EXECUTION_INFO_BY_EXECUTION_ID__REMOVED_DESC"

class SnakemakeExecutionInfosOrderBy(Enum):
    """
    Methods to use when ordering `SnakemakeExecutionInfo`.
    """
    natural = "NATURAL"
    jit_execution_id_asc = "JIT_EXECUTION_ID_ASC"
    jit_execution_id_desc = "JIT_EXECUTION_ID_DESC"
    real_execution_id_asc = "REAL_EXECUTION_ID_ASC"
    real_execution_id_desc = "REAL_EXECUTION_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    execution_info_by_jit_execution_id__id_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__ID_ASC"
    execution_info_by_jit_execution_id__id_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__ID_DESC"
    execution_info_by_jit_execution_id__workflow_id_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__WORKFLOW_ID_ASC"
    execution_info_by_jit_execution_id__workflow_id_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__WORKFLOW_ID_DESC"
    execution_info_by_jit_execution_id__flytedb_id_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__FLYTEDB_ID_ASC"
    execution_info_by_jit_execution_id__flytedb_id_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__FLYTEDB_ID_DESC"
    execution_info_by_jit_execution_id__status_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__STATUS_ASC"
    execution_info_by_jit_execution_id__status_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__STATUS_DESC"
    execution_info_by_jit_execution_id__creation_time_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__CREATION_TIME_ASC"
    execution_info_by_jit_execution_id__creation_time_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__CREATION_TIME_DESC"
    execution_info_by_jit_execution_id__parent_execution_graph_node_flytedb_id_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_info_by_jit_execution_id__parent_execution_graph_node_flytedb_id_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    execution_info_by_jit_execution_id__removed_asc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__REMOVED_ASC"
    execution_info_by_jit_execution_id__removed_desc = "EXECUTION_INFO_BY_JIT_EXECUTION_ID__REMOVED_DESC"
    execution_info_by_real_execution_id__id_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__ID_ASC"
    execution_info_by_real_execution_id__id_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__ID_DESC"
    execution_info_by_real_execution_id__workflow_id_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__WORKFLOW_ID_ASC"
    execution_info_by_real_execution_id__workflow_id_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__WORKFLOW_ID_DESC"
    execution_info_by_real_execution_id__flytedb_id_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__FLYTEDB_ID_ASC"
    execution_info_by_real_execution_id__flytedb_id_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__FLYTEDB_ID_DESC"
    execution_info_by_real_execution_id__status_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__STATUS_ASC"
    execution_info_by_real_execution_id__status_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__STATUS_DESC"
    execution_info_by_real_execution_id__creation_time_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__CREATION_TIME_ASC"
    execution_info_by_real_execution_id__creation_time_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__CREATION_TIME_DESC"
    execution_info_by_real_execution_id__parent_execution_graph_node_flytedb_id_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_ASC"
    execution_info_by_real_execution_id__parent_execution_graph_node_flytedb_id_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__PARENT_EXECUTION_GRAPH_NODE_FLYTEDB_ID_DESC"
    execution_info_by_real_execution_id__removed_asc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__REMOVED_ASC"
    execution_info_by_real_execution_id__removed_desc = "EXECUTION_INFO_BY_REAL_EXECUTION_ID__REMOVED_DESC"

class NotificationStatus(Enum):
    pending = "PENDING"
    success = "SUCCESS"
    cancelled = "CANCELLED"
    error = "ERROR"
    no_action = "NO_ACTION"

class ExecutionBatchMembersOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionBatchMember`.
    """
    natural = "NATURAL"
    batch_id_asc = "BATCH_ID_ASC"
    batch_id_desc = "BATCH_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    execution_batch_info_by_batch_id__id_asc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__ID_ASC"
    execution_batch_info_by_batch_id__id_desc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__ID_DESC"
    execution_batch_info_by_batch_id__owned_by_asc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__OWNED_BY_ASC"
    execution_batch_info_by_batch_id__owned_by_desc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__OWNED_BY_DESC"

class NotificationType(Enum):
    on_completion = "ON_COMPLETION"
    per_failure = "PER_FAILURE"

class ExecutionNotificationInfosOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionNotificationInfo`.
    """
    natural = "NATURAL"
    batch_id_asc = "BATCH_ID_ASC"
    batch_id_desc = "BATCH_ID_DESC"
    receiver_email_asc = "RECEIVER_EMAIL_ASC"
    receiver_email_desc = "RECEIVER_EMAIL_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    execution_batch_info_by_batch_id__id_asc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__ID_ASC"
    execution_batch_info_by_batch_id__id_desc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__ID_DESC"
    execution_batch_info_by_batch_id__owned_by_asc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__OWNED_BY_ASC"
    execution_batch_info_by_batch_id__owned_by_desc = "EXECUTION_BATCH_INFO_BY_BATCH_ID__OWNED_BY_DESC"

class IgvTracksOrderBy(Enum):
    """
    Methods to use when ordering `IgvTrack`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"

class LdataLinkDataOrderBy(Enum):
    """
    Methods to use when ordering `LdataLinkDatum`.
    """
    natural = "NATURAL"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    target_node_id_asc = "TARGET_NODE_ID_ASC"
    target_node_id_desc = "TARGET_NODE_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"
    ldata_node_by_target_node_id__id_asc = "LDATA_NODE_BY_TARGET_NODE_ID__ID_ASC"
    ldata_node_by_target_node_id__id_desc = "LDATA_NODE_BY_TARGET_NODE_ID__ID_DESC"
    ldata_node_by_target_node_id__name_asc = "LDATA_NODE_BY_TARGET_NODE_ID__NAME_ASC"
    ldata_node_by_target_node_id__name_desc = "LDATA_NODE_BY_TARGET_NODE_ID__NAME_DESC"
    ldata_node_by_target_node_id__share_link_asc = "LDATA_NODE_BY_TARGET_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_target_node_id__share_link_desc = "LDATA_NODE_BY_TARGET_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_target_node_id__removed_asc = "LDATA_NODE_BY_TARGET_NODE_ID__REMOVED_ASC"
    ldata_node_by_target_node_id__removed_desc = "LDATA_NODE_BY_TARGET_NODE_ID__REMOVED_DESC"
    ldata_node_by_target_node_id__data_removed_asc = "LDATA_NODE_BY_TARGET_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_target_node_id__data_removed_desc = "LDATA_NODE_BY_TARGET_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_target_node_id__pending_asc = "LDATA_NODE_BY_TARGET_NODE_ID__PENDING_ASC"
    ldata_node_by_target_node_id__pending_desc = "LDATA_NODE_BY_TARGET_NODE_ID__PENDING_DESC"
    ldata_node_by_target_node_id__copied_from_asc = "LDATA_NODE_BY_TARGET_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_target_node_id__copied_from_desc = "LDATA_NODE_BY_TARGET_NODE_ID__COPIED_FROM_DESC"

class LdataNodesOrderBy(Enum):
    """
    Methods to use when ordering `LdataNode`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    name_asc = "NAME_ASC"
    name_desc = "NAME_DESC"
    share_link_asc = "SHARE_LINK_ASC"
    share_link_desc = "SHARE_LINK_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    data_removed_asc = "DATA_REMOVED_ASC"
    data_removed_desc = "DATA_REMOVED_DESC"
    pending_asc = "PENDING_ASC"
    pending_desc = "PENDING_DESC"
    copied_from_asc = "COPIED_FROM_ASC"
    copied_from_desc = "COPIED_FROM_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_copied_from__id_asc = "LDATA_NODE_BY_COPIED_FROM__ID_ASC"
    ldata_node_by_copied_from__id_desc = "LDATA_NODE_BY_COPIED_FROM__ID_DESC"
    ldata_node_by_copied_from__name_asc = "LDATA_NODE_BY_COPIED_FROM__NAME_ASC"
    ldata_node_by_copied_from__name_desc = "LDATA_NODE_BY_COPIED_FROM__NAME_DESC"
    ldata_node_by_copied_from__share_link_asc = "LDATA_NODE_BY_COPIED_FROM__SHARE_LINK_ASC"
    ldata_node_by_copied_from__share_link_desc = "LDATA_NODE_BY_COPIED_FROM__SHARE_LINK_DESC"
    ldata_node_by_copied_from__removed_asc = "LDATA_NODE_BY_COPIED_FROM__REMOVED_ASC"
    ldata_node_by_copied_from__removed_desc = "LDATA_NODE_BY_COPIED_FROM__REMOVED_DESC"
    ldata_node_by_copied_from__data_removed_asc = "LDATA_NODE_BY_COPIED_FROM__DATA_REMOVED_ASC"
    ldata_node_by_copied_from__data_removed_desc = "LDATA_NODE_BY_COPIED_FROM__DATA_REMOVED_DESC"
    ldata_node_by_copied_from__pending_asc = "LDATA_NODE_BY_COPIED_FROM__PENDING_ASC"
    ldata_node_by_copied_from__pending_desc = "LDATA_NODE_BY_COPIED_FROM__PENDING_DESC"
    ldata_node_by_copied_from__copied_from_asc = "LDATA_NODE_BY_COPIED_FROM__COPIED_FROM_ASC"
    ldata_node_by_copied_from__copied_from_desc = "LDATA_NODE_BY_COPIED_FROM__COPIED_FROM_DESC"
    account_infos_by_ldata_root__count_asc = "ACCOUNT_INFOS_BY_LDATA_ROOT__COUNT_ASC"
    account_infos_by_ldata_root__count_desc = "ACCOUNT_INFOS_BY_LDATA_ROOT__COUNT_DESC"
    igv_genomes_by_ldata_node_id__count_asc = "IGV_GENOMES_BY_LDATA_NODE_ID__COUNT_ASC"
    igv_genomes_by_ldata_node_id__count_desc = "IGV_GENOMES_BY_LDATA_NODE_ID__COUNT_DESC"
    igv_tracks_by_ldata_node_id__count_asc = "IGV_TRACKS_BY_LDATA_NODE_ID__COUNT_ASC"
    igv_tracks_by_ldata_node_id__count_desc = "IGV_TRACKS_BY_LDATA_NODE_ID__COUNT_DESC"
    ldata_link_datum_by_ldata_node_id__ldata_node_id_asc = "LDATA_LINK_DATUM_BY_LDATA_NODE_ID__LDATA_NODE_ID_ASC"
    ldata_link_datum_by_ldata_node_id__ldata_node_id_desc = "LDATA_LINK_DATUM_BY_LDATA_NODE_ID__LDATA_NODE_ID_DESC"
    ldata_link_datum_by_ldata_node_id__target_node_id_asc = "LDATA_LINK_DATUM_BY_LDATA_NODE_ID__TARGET_NODE_ID_ASC"
    ldata_link_datum_by_ldata_node_id__target_node_id_desc = "LDATA_LINK_DATUM_BY_LDATA_NODE_ID__TARGET_NODE_ID_DESC"
    ldata_link_data_by_target_node_id__count_asc = "LDATA_LINK_DATA_BY_TARGET_NODE_ID__COUNT_ASC"
    ldata_link_data_by_target_node_id__count_desc = "LDATA_LINK_DATA_BY_TARGET_NODE_ID__COUNT_DESC"
    ldata_nodes_by_copied_from__count_asc = "LDATA_NODES_BY_COPIED_FROM__COUNT_ASC"
    ldata_nodes_by_copied_from__count_desc = "LDATA_NODES_BY_COPIED_FROM__COUNT_DESC"
    ldata_node_events_by_ldata_node_id__count_asc = "LDATA_NODE_EVENTS_BY_LDATA_NODE_ID__COUNT_ASC"
    ldata_node_events_by_ldata_node_id__count_desc = "LDATA_NODE_EVENTS_BY_LDATA_NODE_ID__COUNT_DESC"
    ldata_node_tags_by_ldata_node_id__count_asc = "LDATA_NODE_TAGS_BY_LDATA_NODE_ID__COUNT_ASC"
    ldata_node_tags_by_ldata_node_id__count_desc = "LDATA_NODE_TAGS_BY_LDATA_NODE_ID__COUNT_DESC"
    ldata_object_meta_by_ldata_node_id__ldata_node_id_asc = "LDATA_OBJECT_META_BY_LDATA_NODE_ID__LDATA_NODE_ID_ASC"
    ldata_object_meta_by_ldata_node_id__ldata_node_id_desc = "LDATA_OBJECT_META_BY_LDATA_NODE_ID__LDATA_NODE_ID_DESC"
    ldata_object_meta_by_ldata_node_id__current_root_asc = "LDATA_OBJECT_META_BY_LDATA_NODE_ID__CURRENT_ROOT_ASC"
    ldata_object_meta_by_ldata_node_id__current_root_desc = "LDATA_OBJECT_META_BY_LDATA_NODE_ID__CURRENT_ROOT_DESC"
    ldata_object_metas_by_current_root__count_asc = "LDATA_OBJECT_METAS_BY_CURRENT_ROOT__COUNT_ASC"
    ldata_object_metas_by_current_root__count_desc = "LDATA_OBJECT_METAS_BY_CURRENT_ROOT__COUNT_DESC"
    ldata_share_invites_by_object_id__count_asc = "LDATA_SHARE_INVITES_BY_OBJECT_ID__COUNT_ASC"
    ldata_share_invites_by_object_id__count_desc = "LDATA_SHARE_INVITES_BY_OBJECT_ID__COUNT_DESC"
    ldata_share_link_node_by_link_node_id__link_node_id_asc = "LDATA_SHARE_LINK_NODE_BY_LINK_NODE_ID__LINK_NODE_ID_ASC"
    ldata_share_link_node_by_link_node_id__link_node_id_desc = "LDATA_SHARE_LINK_NODE_BY_LINK_NODE_ID__LINK_NODE_ID_DESC"
    ldata_share_link_node_by_link_node_id__receiver_id_asc = "LDATA_SHARE_LINK_NODE_BY_LINK_NODE_ID__RECEIVER_ID_ASC"
    ldata_share_link_node_by_link_node_id__receiver_id_desc = "LDATA_SHARE_LINK_NODE_BY_LINK_NODE_ID__RECEIVER_ID_DESC"
    ldata_share_permissions_by_object_id__count_asc = "LDATA_SHARE_PERMISSIONS_BY_OBJECT_ID__COUNT_ASC"
    ldata_share_permissions_by_object_id__count_desc = "LDATA_SHARE_PERMISSIONS_BY_OBJECT_ID__COUNT_DESC"
    ldata_tree_edges_by_parent_id__count_asc = "LDATA_TREE_EDGES_BY_PARENT_ID__COUNT_ASC"
    ldata_tree_edges_by_parent_id__count_desc = "LDATA_TREE_EDGES_BY_PARENT_ID__COUNT_DESC"
    ldata_tree_edge_by_child_id__parent_id_asc = "LDATA_TREE_EDGE_BY_CHILD_ID__PARENT_ID_ASC"
    ldata_tree_edge_by_child_id__parent_id_desc = "LDATA_TREE_EDGE_BY_CHILD_ID__PARENT_ID_DESC"
    ldata_tree_edge_by_child_id__child_id_asc = "LDATA_TREE_EDGE_BY_CHILD_ID__CHILD_ID_ASC"
    ldata_tree_edge_by_child_id__child_id_desc = "LDATA_TREE_EDGE_BY_CHILD_ID__CHILD_ID_DESC"
    ldata_wf_exes_by_ldata_node_id__count_asc = "LDATA_WF_EXES_BY_LDATA_NODE_ID__COUNT_ASC"
    ldata_wf_exes_by_ldata_node_id__count_desc = "LDATA_WF_EXES_BY_LDATA_NODE_ID__COUNT_DESC"
    automation_trigger_ldata_events_by_target_node_id__count_asc = "AUTOMATION_TRIGGER_LDATA_EVENTS_BY_TARGET_NODE_ID__COUNT_ASC"
    automation_trigger_ldata_events_by_target_node_id__count_desc = "AUTOMATION_TRIGGER_LDATA_EVENTS_BY_TARGET_NODE_ID__COUNT_DESC"
    plot_data_source_infos_by_ldata_node_id__count_asc = "PLOT_DATA_SOURCE_INFOS_BY_LDATA_NODE_ID__COUNT_ASC"
    plot_data_source_infos_by_ldata_node_id__count_desc = "PLOT_DATA_SOURCE_INFOS_BY_LDATA_NODE_ID__COUNT_DESC"

class DatasetDownloadInfosOrderBy(Enum):
    """
    Methods to use when ordering `DatasetDownloadInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    execution_name_asc = "EXECUTION_NAME_ASC"
    execution_name_desc = "EXECUTION_NAME_DESC"
    dataset_id_asc = "DATASET_ID_ASC"
    dataset_id_desc = "DATASET_ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    status_asc = "STATUS_ASC"
    status_desc = "STATUS_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    dataset_info_by_dataset_id__id_asc = "DATASET_INFO_BY_DATASET_ID__ID_ASC"
    dataset_info_by_dataset_id__id_desc = "DATASET_INFO_BY_DATASET_ID__ID_DESC"
    dataset_info_by_dataset_id__provider_asc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_ASC"
    dataset_info_by_dataset_id__provider_desc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_DESC"
    dataset_info_by_dataset_id__display_name_asc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_ASC"
    dataset_info_by_dataset_id__display_name_desc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_DESC"
    dataset_info_by_dataset_id__description_asc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_ASC"
    dataset_info_by_dataset_id__description_desc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_DESC"
    dataset_info_by_dataset_id__availability_asc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_ASC"
    dataset_info_by_dataset_id__availability_desc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_DESC"
    dataset_info_by_dataset_id__price_asc = "DATASET_INFO_BY_DATASET_ID__PRICE_ASC"
    dataset_info_by_dataset_id__price_desc = "DATASET_INFO_BY_DATASET_ID__PRICE_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    ldata_node_events_by_cause_dataset_download_id__count_asc = "LDATA_NODE_EVENTS_BY_CAUSE_DATASET_DOWNLOAD_ID__COUNT_ASC"
    ldata_node_events_by_cause_dataset_download_id__count_desc = "LDATA_NODE_EVENTS_BY_CAUSE_DATASET_DOWNLOAD_ID__COUNT_DESC"

class DatasetInfoTagsOrderBy(Enum):
    """
    Methods to use when ordering `DatasetInfoTag`.
    """
    natural = "NATURAL"
    dataset_id_asc = "DATASET_ID_ASC"
    dataset_id_desc = "DATASET_ID_DESC"
    key_asc = "KEY_ASC"
    key_desc = "KEY_DESC"
    value_asc = "VALUE_ASC"
    value_desc = "VALUE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    dataset_info_by_dataset_id__id_asc = "DATASET_INFO_BY_DATASET_ID__ID_ASC"
    dataset_info_by_dataset_id__id_desc = "DATASET_INFO_BY_DATASET_ID__ID_DESC"
    dataset_info_by_dataset_id__provider_asc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_ASC"
    dataset_info_by_dataset_id__provider_desc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_DESC"
    dataset_info_by_dataset_id__display_name_asc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_ASC"
    dataset_info_by_dataset_id__display_name_desc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_DESC"
    dataset_info_by_dataset_id__description_asc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_ASC"
    dataset_info_by_dataset_id__description_desc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_DESC"
    dataset_info_by_dataset_id__availability_asc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_ASC"
    dataset_info_by_dataset_id__availability_desc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_DESC"
    dataset_info_by_dataset_id__price_asc = "DATASET_INFO_BY_DATASET_ID__PRICE_ASC"
    dataset_info_by_dataset_id__price_desc = "DATASET_INFO_BY_DATASET_ID__PRICE_DESC"

class DatasetPurchasesOrderBy(Enum):
    """
    Methods to use when ordering `DatasetPurchase`.
    """
    natural = "NATURAL"
    dataset_id_asc = "DATASET_ID_ASC"
    dataset_id_desc = "DATASET_ID_DESC"
    billed_to_asc = "BILLED_TO_ASC"
    billed_to_desc = "BILLED_TO_DESC"
    purchased_by_asc = "PURCHASED_BY_ASC"
    purchased_by_desc = "PURCHASED_BY_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    dataset_info_by_dataset_id__id_asc = "DATASET_INFO_BY_DATASET_ID__ID_ASC"
    dataset_info_by_dataset_id__id_desc = "DATASET_INFO_BY_DATASET_ID__ID_DESC"
    dataset_info_by_dataset_id__provider_asc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_ASC"
    dataset_info_by_dataset_id__provider_desc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_DESC"
    dataset_info_by_dataset_id__display_name_asc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_ASC"
    dataset_info_by_dataset_id__display_name_desc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_DESC"
    dataset_info_by_dataset_id__description_asc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_ASC"
    dataset_info_by_dataset_id__description_desc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_DESC"
    dataset_info_by_dataset_id__availability_asc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_ASC"
    dataset_info_by_dataset_id__availability_desc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_DESC"
    dataset_info_by_dataset_id__price_asc = "DATASET_INFO_BY_DATASET_ID__PRICE_ASC"
    dataset_info_by_dataset_id__price_desc = "DATASET_INFO_BY_DATASET_ID__PRICE_DESC"
    account_info_by_billed_to__id_asc = "ACCOUNT_INFO_BY_BILLED_TO__ID_ASC"
    account_info_by_billed_to__id_desc = "ACCOUNT_INFO_BY_BILLED_TO__ID_DESC"
    account_info_by_billed_to__ldata_root_asc = "ACCOUNT_INFO_BY_BILLED_TO__LDATA_ROOT_ASC"
    account_info_by_billed_to__ldata_root_desc = "ACCOUNT_INFO_BY_BILLED_TO__LDATA_ROOT_DESC"
    account_info_by_billed_to__removed_asc = "ACCOUNT_INFO_BY_BILLED_TO__REMOVED_ASC"
    account_info_by_billed_to__removed_desc = "ACCOUNT_INFO_BY_BILLED_TO__REMOVED_DESC"
    user_info_by_purchased_by__id_asc = "USER_INFO_BY_PURCHASED_BY__ID_ASC"
    user_info_by_purchased_by__id_desc = "USER_INFO_BY_PURCHASED_BY__ID_DESC"
    user_info_by_purchased_by__account_id_asc = "USER_INFO_BY_PURCHASED_BY__ACCOUNT_ID_ASC"
    user_info_by_purchased_by__account_id_desc = "USER_INFO_BY_PURCHASED_BY__ACCOUNT_ID_DESC"
    user_info_by_purchased_by__auth0_sub_asc = "USER_INFO_BY_PURCHASED_BY__AUTH0_SUB_ASC"
    user_info_by_purchased_by__auth0_sub_desc = "USER_INFO_BY_PURCHASED_BY__AUTH0_SUB_DESC"

class DatasetRequestsOrderBy(Enum):
    """
    Methods to use when ordering `DatasetRequest`.
    """
    natural = "NATURAL"
    dataset_id_asc = "DATASET_ID_ASC"
    dataset_id_desc = "DATASET_ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    dataset_info_by_dataset_id__id_asc = "DATASET_INFO_BY_DATASET_ID__ID_ASC"
    dataset_info_by_dataset_id__id_desc = "DATASET_INFO_BY_DATASET_ID__ID_DESC"
    dataset_info_by_dataset_id__provider_asc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_ASC"
    dataset_info_by_dataset_id__provider_desc = "DATASET_INFO_BY_DATASET_ID__PROVIDER_DESC"
    dataset_info_by_dataset_id__display_name_asc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_ASC"
    dataset_info_by_dataset_id__display_name_desc = "DATASET_INFO_BY_DATASET_ID__DISPLAY_NAME_DESC"
    dataset_info_by_dataset_id__description_asc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_ASC"
    dataset_info_by_dataset_id__description_desc = "DATASET_INFO_BY_DATASET_ID__DESCRIPTION_DESC"
    dataset_info_by_dataset_id__availability_asc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_ASC"
    dataset_info_by_dataset_id__availability_desc = "DATASET_INFO_BY_DATASET_ID__AVAILABILITY_DESC"
    dataset_info_by_dataset_id__price_asc = "DATASET_INFO_BY_DATASET_ID__PRICE_ASC"
    dataset_info_by_dataset_id__price_desc = "DATASET_INFO_BY_DATASET_ID__PRICE_DESC"
    user_info_by_account_id__id_asc = "USER_INFO_BY_ACCOUNT_ID__ID_ASC"
    user_info_by_account_id__id_desc = "USER_INFO_BY_ACCOUNT_ID__ID_DESC"
    user_info_by_account_id__account_id_asc = "USER_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    user_info_by_account_id__account_id_desc = "USER_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    user_info_by_account_id__auth0_sub_asc = "USER_INFO_BY_ACCOUNT_ID__AUTH0_SUB_ASC"
    user_info_by_account_id__auth0_sub_desc = "USER_INFO_BY_ACCOUNT_ID__AUTH0_SUB_DESC"

class LdataNodeEventsOrderBy(Enum):
    """
    Methods to use when ordering `LdataNodeEvent`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    type_asc = "TYPE_ASC"
    type_desc = "TYPE_DESC"
    time_asc = "TIME_ASC"
    time_desc = "TIME_DESC"
    cause_account_id_asc = "CAUSE_ACCOUNT_ID_ASC"
    cause_account_id_desc = "CAUSE_ACCOUNT_ID_DESC"
    cause_execution_flytedb_id_asc = "CAUSE_EXECUTION_FLYTEDB_ID_ASC"
    cause_execution_flytedb_id_desc = "CAUSE_EXECUTION_FLYTEDB_ID_DESC"
    cause_dataset_download_id_asc = "CAUSE_DATASET_DOWNLOAD_ID_ASC"
    cause_dataset_download_id_desc = "CAUSE_DATASET_DOWNLOAD_ID_DESC"
    cause_ldata_process_id_asc = "CAUSE_LDATA_PROCESS_ID_ASC"
    cause_ldata_process_id_desc = "CAUSE_LDATA_PROCESS_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"
    account_info_by_cause_account_id__id_asc = "ACCOUNT_INFO_BY_CAUSE_ACCOUNT_ID__ID_ASC"
    account_info_by_cause_account_id__id_desc = "ACCOUNT_INFO_BY_CAUSE_ACCOUNT_ID__ID_DESC"
    account_info_by_cause_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_CAUSE_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_cause_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_CAUSE_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_cause_account_id__removed_asc = "ACCOUNT_INFO_BY_CAUSE_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_cause_account_id__removed_desc = "ACCOUNT_INFO_BY_CAUSE_ACCOUNT_ID__REMOVED_DESC"
    dataset_download_info_by_cause_dataset_download_id__id_asc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__ID_ASC"
    dataset_download_info_by_cause_dataset_download_id__id_desc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__ID_DESC"
    dataset_download_info_by_cause_dataset_download_id__execution_name_asc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__EXECUTION_NAME_ASC"
    dataset_download_info_by_cause_dataset_download_id__execution_name_desc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__EXECUTION_NAME_DESC"
    dataset_download_info_by_cause_dataset_download_id__dataset_id_asc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__DATASET_ID_ASC"
    dataset_download_info_by_cause_dataset_download_id__dataset_id_desc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__DATASET_ID_DESC"
    dataset_download_info_by_cause_dataset_download_id__account_id_asc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__ACCOUNT_ID_ASC"
    dataset_download_info_by_cause_dataset_download_id__account_id_desc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__ACCOUNT_ID_DESC"
    dataset_download_info_by_cause_dataset_download_id__status_asc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__STATUS_ASC"
    dataset_download_info_by_cause_dataset_download_id__status_desc = "DATASET_DOWNLOAD_INFO_BY_CAUSE_DATASET_DOWNLOAD_ID__STATUS_DESC"
    ldata_wf_ex_by_cause_ldata_process_id__id_asc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__ID_ASC"
    ldata_wf_ex_by_cause_ldata_process_id__id_desc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__ID_DESC"
    ldata_wf_ex_by_cause_ldata_process_id__ldata_node_id_asc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__LDATA_NODE_ID_ASC"
    ldata_wf_ex_by_cause_ldata_process_id__ldata_node_id_desc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__LDATA_NODE_ID_DESC"
    ldata_wf_ex_by_cause_ldata_process_id__name_asc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__NAME_ASC"
    ldata_wf_ex_by_cause_ldata_process_id__name_desc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__NAME_DESC"
    ldata_wf_ex_by_cause_ldata_process_id__status_asc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__STATUS_ASC"
    ldata_wf_ex_by_cause_ldata_process_id__status_desc = "LDATA_WF_EX_BY_CAUSE_LDATA_PROCESS_ID__STATUS_DESC"
    ldata_node_event_child_remove_by_event_id__event_id_asc = "LDATA_NODE_EVENT_CHILD_REMOVE_BY_EVENT_ID__EVENT_ID_ASC"
    ldata_node_event_child_remove_by_event_id__event_id_desc = "LDATA_NODE_EVENT_CHILD_REMOVE_BY_EVENT_ID__EVENT_ID_DESC"
    ldata_node_event_ingress_by_event_id__event_id_asc = "LDATA_NODE_EVENT_INGRESS_BY_EVENT_ID__EVENT_ID_ASC"
    ldata_node_event_ingress_by_event_id__event_id_desc = "LDATA_NODE_EVENT_INGRESS_BY_EVENT_ID__EVENT_ID_DESC"
    ldata_node_event_move_by_event_id__event_id_asc = "LDATA_NODE_EVENT_MOVE_BY_EVENT_ID__EVENT_ID_ASC"
    ldata_node_event_move_by_event_id__event_id_desc = "LDATA_NODE_EVENT_MOVE_BY_EVENT_ID__EVENT_ID_DESC"
    ldata_node_event_remove_by_event_id__event_id_asc = "LDATA_NODE_EVENT_REMOVE_BY_EVENT_ID__EVENT_ID_ASC"
    ldata_node_event_remove_by_event_id__event_id_desc = "LDATA_NODE_EVENT_REMOVE_BY_EVENT_ID__EVENT_ID_DESC"

class LdataNodeTagsOrderBy(Enum):
    """
    Methods to use when ordering `LdataNodeTag`.
    """
    natural = "NATURAL"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    tag_asc = "TAG_ASC"
    tag_desc = "TAG_DESC"
    type_asc = "TYPE_ASC"
    type_desc = "TYPE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"

class LdataDataCreator(Enum):
    user = "USER"
    user_copy = "USER_COPY"
    execution = "EXECUTION"
    system = "SYSTEM"

class LdataObjectMetasOrderBy(Enum):
    """
    Methods to use when ordering `LdataObjectMeta`.
    """
    natural = "NATURAL"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    current_root_asc = "CURRENT_ROOT_ASC"
    current_root_desc = "CURRENT_ROOT_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"
    ldata_node_by_current_root__id_asc = "LDATA_NODE_BY_CURRENT_ROOT__ID_ASC"
    ldata_node_by_current_root__id_desc = "LDATA_NODE_BY_CURRENT_ROOT__ID_DESC"
    ldata_node_by_current_root__name_asc = "LDATA_NODE_BY_CURRENT_ROOT__NAME_ASC"
    ldata_node_by_current_root__name_desc = "LDATA_NODE_BY_CURRENT_ROOT__NAME_DESC"
    ldata_node_by_current_root__share_link_asc = "LDATA_NODE_BY_CURRENT_ROOT__SHARE_LINK_ASC"
    ldata_node_by_current_root__share_link_desc = "LDATA_NODE_BY_CURRENT_ROOT__SHARE_LINK_DESC"
    ldata_node_by_current_root__removed_asc = "LDATA_NODE_BY_CURRENT_ROOT__REMOVED_ASC"
    ldata_node_by_current_root__removed_desc = "LDATA_NODE_BY_CURRENT_ROOT__REMOVED_DESC"
    ldata_node_by_current_root__data_removed_asc = "LDATA_NODE_BY_CURRENT_ROOT__DATA_REMOVED_ASC"
    ldata_node_by_current_root__data_removed_desc = "LDATA_NODE_BY_CURRENT_ROOT__DATA_REMOVED_DESC"
    ldata_node_by_current_root__pending_asc = "LDATA_NODE_BY_CURRENT_ROOT__PENDING_ASC"
    ldata_node_by_current_root__pending_desc = "LDATA_NODE_BY_CURRENT_ROOT__PENDING_DESC"
    ldata_node_by_current_root__copied_from_asc = "LDATA_NODE_BY_CURRENT_ROOT__COPIED_FROM_ASC"
    ldata_node_by_current_root__copied_from_desc = "LDATA_NODE_BY_CURRENT_ROOT__COPIED_FROM_DESC"

class LdataShareInvitesOrderBy(Enum):
    """
    Methods to use when ordering `LdataShareInvite`.
    """
    natural = "NATURAL"
    sender_id_asc = "SENDER_ID_ASC"
    sender_id_desc = "SENDER_ID_DESC"
    object_id_asc = "OBJECT_ID_ASC"
    object_id_desc = "OBJECT_ID_DESC"
    code_asc = "CODE_ASC"
    code_desc = "CODE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_sender_id__id_asc = "ACCOUNT_INFO_BY_SENDER_ID__ID_ASC"
    account_info_by_sender_id__id_desc = "ACCOUNT_INFO_BY_SENDER_ID__ID_DESC"
    account_info_by_sender_id__ldata_root_asc = "ACCOUNT_INFO_BY_SENDER_ID__LDATA_ROOT_ASC"
    account_info_by_sender_id__ldata_root_desc = "ACCOUNT_INFO_BY_SENDER_ID__LDATA_ROOT_DESC"
    account_info_by_sender_id__removed_asc = "ACCOUNT_INFO_BY_SENDER_ID__REMOVED_ASC"
    account_info_by_sender_id__removed_desc = "ACCOUNT_INFO_BY_SENDER_ID__REMOVED_DESC"
    ldata_node_by_object_id__id_asc = "LDATA_NODE_BY_OBJECT_ID__ID_ASC"
    ldata_node_by_object_id__id_desc = "LDATA_NODE_BY_OBJECT_ID__ID_DESC"
    ldata_node_by_object_id__name_asc = "LDATA_NODE_BY_OBJECT_ID__NAME_ASC"
    ldata_node_by_object_id__name_desc = "LDATA_NODE_BY_OBJECT_ID__NAME_DESC"
    ldata_node_by_object_id__share_link_asc = "LDATA_NODE_BY_OBJECT_ID__SHARE_LINK_ASC"
    ldata_node_by_object_id__share_link_desc = "LDATA_NODE_BY_OBJECT_ID__SHARE_LINK_DESC"
    ldata_node_by_object_id__removed_asc = "LDATA_NODE_BY_OBJECT_ID__REMOVED_ASC"
    ldata_node_by_object_id__removed_desc = "LDATA_NODE_BY_OBJECT_ID__REMOVED_DESC"
    ldata_node_by_object_id__data_removed_asc = "LDATA_NODE_BY_OBJECT_ID__DATA_REMOVED_ASC"
    ldata_node_by_object_id__data_removed_desc = "LDATA_NODE_BY_OBJECT_ID__DATA_REMOVED_DESC"
    ldata_node_by_object_id__pending_asc = "LDATA_NODE_BY_OBJECT_ID__PENDING_ASC"
    ldata_node_by_object_id__pending_desc = "LDATA_NODE_BY_OBJECT_ID__PENDING_DESC"
    ldata_node_by_object_id__copied_from_asc = "LDATA_NODE_BY_OBJECT_ID__COPIED_FROM_ASC"
    ldata_node_by_object_id__copied_from_desc = "LDATA_NODE_BY_OBJECT_ID__COPIED_FROM_DESC"

class LdataSharePermissionsOrderBy(Enum):
    """
    Methods to use when ordering `LdataSharePermission`.
    """
    natural = "NATURAL"
    object_id_asc = "OBJECT_ID_ASC"
    object_id_desc = "OBJECT_ID_DESC"
    receiver_id_asc = "RECEIVER_ID_ASC"
    receiver_id_desc = "RECEIVER_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_object_id__id_asc = "LDATA_NODE_BY_OBJECT_ID__ID_ASC"
    ldata_node_by_object_id__id_desc = "LDATA_NODE_BY_OBJECT_ID__ID_DESC"
    ldata_node_by_object_id__name_asc = "LDATA_NODE_BY_OBJECT_ID__NAME_ASC"
    ldata_node_by_object_id__name_desc = "LDATA_NODE_BY_OBJECT_ID__NAME_DESC"
    ldata_node_by_object_id__share_link_asc = "LDATA_NODE_BY_OBJECT_ID__SHARE_LINK_ASC"
    ldata_node_by_object_id__share_link_desc = "LDATA_NODE_BY_OBJECT_ID__SHARE_LINK_DESC"
    ldata_node_by_object_id__removed_asc = "LDATA_NODE_BY_OBJECT_ID__REMOVED_ASC"
    ldata_node_by_object_id__removed_desc = "LDATA_NODE_BY_OBJECT_ID__REMOVED_DESC"
    ldata_node_by_object_id__data_removed_asc = "LDATA_NODE_BY_OBJECT_ID__DATA_REMOVED_ASC"
    ldata_node_by_object_id__data_removed_desc = "LDATA_NODE_BY_OBJECT_ID__DATA_REMOVED_DESC"
    ldata_node_by_object_id__pending_asc = "LDATA_NODE_BY_OBJECT_ID__PENDING_ASC"
    ldata_node_by_object_id__pending_desc = "LDATA_NODE_BY_OBJECT_ID__PENDING_DESC"
    ldata_node_by_object_id__copied_from_asc = "LDATA_NODE_BY_OBJECT_ID__COPIED_FROM_ASC"
    ldata_node_by_object_id__copied_from_desc = "LDATA_NODE_BY_OBJECT_ID__COPIED_FROM_DESC"
    account_info_by_receiver_id__id_asc = "ACCOUNT_INFO_BY_RECEIVER_ID__ID_ASC"
    account_info_by_receiver_id__id_desc = "ACCOUNT_INFO_BY_RECEIVER_ID__ID_DESC"
    account_info_by_receiver_id__ldata_root_asc = "ACCOUNT_INFO_BY_RECEIVER_ID__LDATA_ROOT_ASC"
    account_info_by_receiver_id__ldata_root_desc = "ACCOUNT_INFO_BY_RECEIVER_ID__LDATA_ROOT_DESC"
    account_info_by_receiver_id__removed_asc = "ACCOUNT_INFO_BY_RECEIVER_ID__REMOVED_ASC"
    account_info_by_receiver_id__removed_desc = "ACCOUNT_INFO_BY_RECEIVER_ID__REMOVED_DESC"

class LdataTreeEdgesOrderBy(Enum):
    """
    Methods to use when ordering `LdataTreeEdge`.
    """
    natural = "NATURAL"
    parent_id_asc = "PARENT_ID_ASC"
    parent_id_desc = "PARENT_ID_DESC"
    child_id_asc = "CHILD_ID_ASC"
    child_id_desc = "CHILD_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_parent_id__id_asc = "LDATA_NODE_BY_PARENT_ID__ID_ASC"
    ldata_node_by_parent_id__id_desc = "LDATA_NODE_BY_PARENT_ID__ID_DESC"
    ldata_node_by_parent_id__name_asc = "LDATA_NODE_BY_PARENT_ID__NAME_ASC"
    ldata_node_by_parent_id__name_desc = "LDATA_NODE_BY_PARENT_ID__NAME_DESC"
    ldata_node_by_parent_id__share_link_asc = "LDATA_NODE_BY_PARENT_ID__SHARE_LINK_ASC"
    ldata_node_by_parent_id__share_link_desc = "LDATA_NODE_BY_PARENT_ID__SHARE_LINK_DESC"
    ldata_node_by_parent_id__removed_asc = "LDATA_NODE_BY_PARENT_ID__REMOVED_ASC"
    ldata_node_by_parent_id__removed_desc = "LDATA_NODE_BY_PARENT_ID__REMOVED_DESC"
    ldata_node_by_parent_id__data_removed_asc = "LDATA_NODE_BY_PARENT_ID__DATA_REMOVED_ASC"
    ldata_node_by_parent_id__data_removed_desc = "LDATA_NODE_BY_PARENT_ID__DATA_REMOVED_DESC"
    ldata_node_by_parent_id__pending_asc = "LDATA_NODE_BY_PARENT_ID__PENDING_ASC"
    ldata_node_by_parent_id__pending_desc = "LDATA_NODE_BY_PARENT_ID__PENDING_DESC"
    ldata_node_by_parent_id__copied_from_asc = "LDATA_NODE_BY_PARENT_ID__COPIED_FROM_ASC"
    ldata_node_by_parent_id__copied_from_desc = "LDATA_NODE_BY_PARENT_ID__COPIED_FROM_DESC"
    ldata_node_by_child_id__id_asc = "LDATA_NODE_BY_CHILD_ID__ID_ASC"
    ldata_node_by_child_id__id_desc = "LDATA_NODE_BY_CHILD_ID__ID_DESC"
    ldata_node_by_child_id__name_asc = "LDATA_NODE_BY_CHILD_ID__NAME_ASC"
    ldata_node_by_child_id__name_desc = "LDATA_NODE_BY_CHILD_ID__NAME_DESC"
    ldata_node_by_child_id__share_link_asc = "LDATA_NODE_BY_CHILD_ID__SHARE_LINK_ASC"
    ldata_node_by_child_id__share_link_desc = "LDATA_NODE_BY_CHILD_ID__SHARE_LINK_DESC"
    ldata_node_by_child_id__removed_asc = "LDATA_NODE_BY_CHILD_ID__REMOVED_ASC"
    ldata_node_by_child_id__removed_desc = "LDATA_NODE_BY_CHILD_ID__REMOVED_DESC"
    ldata_node_by_child_id__data_removed_asc = "LDATA_NODE_BY_CHILD_ID__DATA_REMOVED_ASC"
    ldata_node_by_child_id__data_removed_desc = "LDATA_NODE_BY_CHILD_ID__DATA_REMOVED_DESC"
    ldata_node_by_child_id__pending_asc = "LDATA_NODE_BY_CHILD_ID__PENDING_ASC"
    ldata_node_by_child_id__pending_desc = "LDATA_NODE_BY_CHILD_ID__PENDING_DESC"
    ldata_node_by_child_id__copied_from_asc = "LDATA_NODE_BY_CHILD_ID__COPIED_FROM_ASC"
    ldata_node_by_child_id__copied_from_desc = "LDATA_NODE_BY_CHILD_ID__COPIED_FROM_DESC"

class LdataWfExesOrderBy(Enum):
    """
    Methods to use when ordering `LdataWfEx`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    name_asc = "NAME_ASC"
    name_desc = "NAME_DESC"
    status_asc = "STATUS_ASC"
    status_desc = "STATUS_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"
    ldata_node_events_by_cause_ldata_process_id__count_asc = "LDATA_NODE_EVENTS_BY_CAUSE_LDATA_PROCESS_ID__COUNT_ASC"
    ldata_node_events_by_cause_ldata_process_id__count_desc = "LDATA_NODE_EVENTS_BY_CAUSE_LDATA_PROCESS_ID__COUNT_DESC"

class CatalogEventType(Enum):
    create = "CREATE"
    update = "UPDATE"
    remove = "REMOVE"
    column_create = "COLUMN_CREATE"
    column_update = "COLUMN_UPDATE"
    column_remove = "COLUMN_REMOVE"
    data_update = "DATA_UPDATE"

class CatalogEventsOrderBy(Enum):
    """
    Methods to use when ordering `CatalogEvent`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    project_id_asc = "PROJECT_ID_ASC"
    project_id_desc = "PROJECT_ID_DESC"
    experiment_id_asc = "EXPERIMENT_ID_ASC"
    experiment_id_desc = "EXPERIMENT_ID_DESC"
    sample_id_asc = "SAMPLE_ID_ASC"
    sample_id_desc = "SAMPLE_ID_DESC"
    cause_account_id_asc = "CAUSE_ACCOUNT_ID_ASC"
    cause_account_id_desc = "CAUSE_ACCOUNT_ID_DESC"
    time_asc = "TIME_ASC"
    time_desc = "TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    catalog_project_by_project_id__id_asc = "CATALOG_PROJECT_BY_PROJECT_ID__ID_ASC"
    catalog_project_by_project_id__id_desc = "CATALOG_PROJECT_BY_PROJECT_ID__ID_DESC"
    catalog_project_by_project_id__owner_id_asc = "CATALOG_PROJECT_BY_PROJECT_ID__OWNER_ID_ASC"
    catalog_project_by_project_id__owner_id_desc = "CATALOG_PROJECT_BY_PROJECT_ID__OWNER_ID_DESC"
    catalog_project_by_project_id__removed_asc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVED_ASC"
    catalog_project_by_project_id__removed_desc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVED_DESC"
    catalog_project_by_project_id__display_name_asc = "CATALOG_PROJECT_BY_PROJECT_ID__DISPLAY_NAME_ASC"
    catalog_project_by_project_id__display_name_desc = "CATALOG_PROJECT_BY_PROJECT_ID__DISPLAY_NAME_DESC"
    catalog_project_by_project_id__removal_time_asc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVAL_TIME_ASC"
    catalog_project_by_project_id__removal_time_desc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVAL_TIME_DESC"
    catalog_experiment_by_experiment_id__id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_ASC"
    catalog_experiment_by_experiment_id__id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_DESC"
    catalog_experiment_by_experiment_id__project_id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_ASC"
    catalog_experiment_by_experiment_id__project_id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_DESC"
    catalog_experiment_by_experiment_id__removed_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_ASC"
    catalog_experiment_by_experiment_id__removed_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_DESC"
    catalog_experiment_by_experiment_id__display_name_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_ASC"
    catalog_experiment_by_experiment_id__display_name_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_DESC"
    catalog_experiment_by_experiment_id__removal_time_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_ASC"
    catalog_experiment_by_experiment_id__removal_time_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_DESC"
    catalog_sample_by_sample_id__id_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__ID_ASC"
    catalog_sample_by_sample_id__id_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__ID_DESC"
    catalog_sample_by_sample_id__experiment_id_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__EXPERIMENT_ID_ASC"
    catalog_sample_by_sample_id__experiment_id_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__EXPERIMENT_ID_DESC"
    catalog_sample_by_sample_id__name_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__NAME_ASC"
    catalog_sample_by_sample_id__name_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__NAME_DESC"
    catalog_sample_by_sample_id__removed_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVED_ASC"
    catalog_sample_by_sample_id__removed_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVED_DESC"
    catalog_sample_by_sample_id__creation_time_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__CREATION_TIME_ASC"
    catalog_sample_by_sample_id__creation_time_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__CREATION_TIME_DESC"
    catalog_sample_by_sample_id__removal_time_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVAL_TIME_ASC"
    catalog_sample_by_sample_id__removal_time_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVAL_TIME_DESC"
    user_info_by_cause_account_id__id_asc = "USER_INFO_BY_CAUSE_ACCOUNT_ID__ID_ASC"
    user_info_by_cause_account_id__id_desc = "USER_INFO_BY_CAUSE_ACCOUNT_ID__ID_DESC"
    user_info_by_cause_account_id__account_id_asc = "USER_INFO_BY_CAUSE_ACCOUNT_ID__ACCOUNT_ID_ASC"
    user_info_by_cause_account_id__account_id_desc = "USER_INFO_BY_CAUSE_ACCOUNT_ID__ACCOUNT_ID_DESC"
    user_info_by_cause_account_id__auth0_sub_asc = "USER_INFO_BY_CAUSE_ACCOUNT_ID__AUTH0_SUB_ASC"
    user_info_by_cause_account_id__auth0_sub_desc = "USER_INFO_BY_CAUSE_ACCOUNT_ID__AUTH0_SUB_DESC"

class CatalogSampleColumnDataOrderBy(Enum):
    """
    Methods to use when ordering `CatalogSampleColumnDatum`.
    """
    natural = "NATURAL"
    sample_id_asc = "SAMPLE_ID_ASC"
    sample_id_desc = "SAMPLE_ID_DESC"
    key_asc = "KEY_ASC"
    key_desc = "KEY_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    catalog_sample_by_sample_id__id_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__ID_ASC"
    catalog_sample_by_sample_id__id_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__ID_DESC"
    catalog_sample_by_sample_id__experiment_id_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__EXPERIMENT_ID_ASC"
    catalog_sample_by_sample_id__experiment_id_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__EXPERIMENT_ID_DESC"
    catalog_sample_by_sample_id__name_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__NAME_ASC"
    catalog_sample_by_sample_id__name_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__NAME_DESC"
    catalog_sample_by_sample_id__removed_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVED_ASC"
    catalog_sample_by_sample_id__removed_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVED_DESC"
    catalog_sample_by_sample_id__creation_time_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__CREATION_TIME_ASC"
    catalog_sample_by_sample_id__creation_time_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__CREATION_TIME_DESC"
    catalog_sample_by_sample_id__removal_time_asc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVAL_TIME_ASC"
    catalog_sample_by_sample_id__removal_time_desc = "CATALOG_SAMPLE_BY_SAMPLE_ID__REMOVAL_TIME_DESC"

class CatalogExperimentsOrderBy(Enum):
    """
    Methods to use when ordering `CatalogExperiment`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    project_id_asc = "PROJECT_ID_ASC"
    project_id_desc = "PROJECT_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    display_name_asc = "DISPLAY_NAME_ASC"
    display_name_desc = "DISPLAY_NAME_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    catalog_project_by_project_id__id_asc = "CATALOG_PROJECT_BY_PROJECT_ID__ID_ASC"
    catalog_project_by_project_id__id_desc = "CATALOG_PROJECT_BY_PROJECT_ID__ID_DESC"
    catalog_project_by_project_id__owner_id_asc = "CATALOG_PROJECT_BY_PROJECT_ID__OWNER_ID_ASC"
    catalog_project_by_project_id__owner_id_desc = "CATALOG_PROJECT_BY_PROJECT_ID__OWNER_ID_DESC"
    catalog_project_by_project_id__removed_asc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVED_ASC"
    catalog_project_by_project_id__removed_desc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVED_DESC"
    catalog_project_by_project_id__display_name_asc = "CATALOG_PROJECT_BY_PROJECT_ID__DISPLAY_NAME_ASC"
    catalog_project_by_project_id__display_name_desc = "CATALOG_PROJECT_BY_PROJECT_ID__DISPLAY_NAME_DESC"
    catalog_project_by_project_id__removal_time_asc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVAL_TIME_ASC"
    catalog_project_by_project_id__removal_time_desc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVAL_TIME_DESC"
    catalog_events_by_experiment_id__count_asc = "CATALOG_EVENTS_BY_EXPERIMENT_ID__COUNT_ASC"
    catalog_events_by_experiment_id__count_desc = "CATALOG_EVENTS_BY_EXPERIMENT_ID__COUNT_DESC"
    catalog_experiment_column_definitions_by_experiment_id__count_asc = "CATALOG_EXPERIMENT_COLUMN_DEFINITIONS_BY_EXPERIMENT_ID__COUNT_ASC"
    catalog_experiment_column_definitions_by_experiment_id__count_desc = "CATALOG_EXPERIMENT_COLUMN_DEFINITIONS_BY_EXPERIMENT_ID__COUNT_DESC"
    catalog_samples_by_experiment_id__count_asc = "CATALOG_SAMPLES_BY_EXPERIMENT_ID__COUNT_ASC"
    catalog_samples_by_experiment_id__count_desc = "CATALOG_SAMPLES_BY_EXPERIMENT_ID__COUNT_DESC"
    catalog_experiment_views_by_experiment_id__count_asc = "CATALOG_EXPERIMENT_VIEWS_BY_EXPERIMENT_ID__COUNT_ASC"
    catalog_experiment_views_by_experiment_id__count_desc = "CATALOG_EXPERIMENT_VIEWS_BY_EXPERIMENT_ID__COUNT_DESC"
    plot_infos_by_table_id__count_asc = "PLOT_INFOS_BY_TABLE_ID__COUNT_ASC"
    plot_infos_by_table_id__count_desc = "PLOT_INFOS_BY_TABLE_ID__COUNT_DESC"
    plot_data_source_infos_by_table_id__count_asc = "PLOT_DATA_SOURCE_INFOS_BY_TABLE_ID__COUNT_ASC"
    plot_data_source_infos_by_table_id__count_desc = "PLOT_DATA_SOURCE_INFOS_BY_TABLE_ID__COUNT_DESC"

class BenchlingImportsOrderBy(Enum):
    """
    Methods to use when ordering `BenchlingImport`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    project_id_asc = "PROJECT_ID_ASC"
    project_id_desc = "PROJECT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    catalog_project_by_project_id__id_asc = "CATALOG_PROJECT_BY_PROJECT_ID__ID_ASC"
    catalog_project_by_project_id__id_desc = "CATALOG_PROJECT_BY_PROJECT_ID__ID_DESC"
    catalog_project_by_project_id__owner_id_asc = "CATALOG_PROJECT_BY_PROJECT_ID__OWNER_ID_ASC"
    catalog_project_by_project_id__owner_id_desc = "CATALOG_PROJECT_BY_PROJECT_ID__OWNER_ID_DESC"
    catalog_project_by_project_id__removed_asc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVED_ASC"
    catalog_project_by_project_id__removed_desc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVED_DESC"
    catalog_project_by_project_id__display_name_asc = "CATALOG_PROJECT_BY_PROJECT_ID__DISPLAY_NAME_ASC"
    catalog_project_by_project_id__display_name_desc = "CATALOG_PROJECT_BY_PROJECT_ID__DISPLAY_NAME_DESC"
    catalog_project_by_project_id__removal_time_asc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVAL_TIME_ASC"
    catalog_project_by_project_id__removal_time_desc = "CATALOG_PROJECT_BY_PROJECT_ID__REMOVAL_TIME_DESC"

class CatalogExperimentColumnDefinitionsOrderBy(Enum):
    """
    Methods to use when ordering `CatalogExperimentColumnDefinition`.
    """
    natural = "NATURAL"
    experiment_id_asc = "EXPERIMENT_ID_ASC"
    experiment_id_desc = "EXPERIMENT_ID_DESC"
    key_asc = "KEY_ASC"
    key_desc = "KEY_DESC"
    display_name_asc = "DISPLAY_NAME_ASC"
    display_name_desc = "DISPLAY_NAME_DESC"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    catalog_experiment_by_experiment_id__id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_ASC"
    catalog_experiment_by_experiment_id__id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_DESC"
    catalog_experiment_by_experiment_id__project_id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_ASC"
    catalog_experiment_by_experiment_id__project_id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_DESC"
    catalog_experiment_by_experiment_id__removed_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_ASC"
    catalog_experiment_by_experiment_id__removed_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_DESC"
    catalog_experiment_by_experiment_id__display_name_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_ASC"
    catalog_experiment_by_experiment_id__display_name_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_DESC"
    catalog_experiment_by_experiment_id__removal_time_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_ASC"
    catalog_experiment_by_experiment_id__removal_time_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_DESC"

class CatalogSamplesOrderBy(Enum):
    """
    Methods to use when ordering `CatalogSample`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    experiment_id_asc = "EXPERIMENT_ID_ASC"
    experiment_id_desc = "EXPERIMENT_ID_DESC"
    name_asc = "NAME_ASC"
    name_desc = "NAME_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    creation_time_asc = "CREATION_TIME_ASC"
    creation_time_desc = "CREATION_TIME_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    catalog_experiment_by_experiment_id__id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_ASC"
    catalog_experiment_by_experiment_id__id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_DESC"
    catalog_experiment_by_experiment_id__project_id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_ASC"
    catalog_experiment_by_experiment_id__project_id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_DESC"
    catalog_experiment_by_experiment_id__removed_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_ASC"
    catalog_experiment_by_experiment_id__removed_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_DESC"
    catalog_experiment_by_experiment_id__display_name_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_ASC"
    catalog_experiment_by_experiment_id__display_name_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_DESC"
    catalog_experiment_by_experiment_id__removal_time_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_ASC"
    catalog_experiment_by_experiment_id__removal_time_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_DESC"
    catalog_events_by_sample_id__count_asc = "CATALOG_EVENTS_BY_SAMPLE_ID__COUNT_ASC"
    catalog_events_by_sample_id__count_desc = "CATALOG_EVENTS_BY_SAMPLE_ID__COUNT_DESC"
    catalog_sample_column_data_by_sample_id__count_asc = "CATALOG_SAMPLE_COLUMN_DATA_BY_SAMPLE_ID__COUNT_ASC"
    catalog_sample_column_data_by_sample_id__count_desc = "CATALOG_SAMPLE_COLUMN_DATA_BY_SAMPLE_ID__COUNT_DESC"

class CatalogExperimentViewsOrderBy(Enum):
    """
    Methods to use when ordering `CatalogExperimentView`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    experiment_id_asc = "EXPERIMENT_ID_ASC"
    experiment_id_desc = "EXPERIMENT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    catalog_experiment_by_experiment_id__id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_ASC"
    catalog_experiment_by_experiment_id__id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__ID_DESC"
    catalog_experiment_by_experiment_id__project_id_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_ASC"
    catalog_experiment_by_experiment_id__project_id_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__PROJECT_ID_DESC"
    catalog_experiment_by_experiment_id__removed_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_ASC"
    catalog_experiment_by_experiment_id__removed_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVED_DESC"
    catalog_experiment_by_experiment_id__display_name_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_ASC"
    catalog_experiment_by_experiment_id__display_name_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__DISPLAY_NAME_DESC"
    catalog_experiment_by_experiment_id__removal_time_asc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_ASC"
    catalog_experiment_by_experiment_id__removal_time_desc = "CATALOG_EXPERIMENT_BY_EXPERIMENT_ID__REMOVAL_TIME_DESC"

class PlotInfosOrderBy(Enum):
    """
    Methods to use when ordering `PlotInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    table_id_asc = "TABLE_ID_ASC"
    table_id_desc = "TABLE_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    parent_notebook_id_asc = "PARENT_NOTEBOOK_ID_ASC"
    parent_notebook_id_desc = "PARENT_NOTEBOOK_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    catalog_experiment_by_table_id__id_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__ID_ASC"
    catalog_experiment_by_table_id__id_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__ID_DESC"
    catalog_experiment_by_table_id__project_id_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__PROJECT_ID_ASC"
    catalog_experiment_by_table_id__project_id_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__PROJECT_ID_DESC"
    catalog_experiment_by_table_id__removed_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVED_ASC"
    catalog_experiment_by_table_id__removed_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVED_DESC"
    catalog_experiment_by_table_id__display_name_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__DISPLAY_NAME_ASC"
    catalog_experiment_by_table_id__display_name_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__DISPLAY_NAME_DESC"
    catalog_experiment_by_table_id__removal_time_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVAL_TIME_ASC"
    catalog_experiment_by_table_id__removal_time_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVAL_TIME_DESC"
    plot_notebook_info_by_parent_notebook_id__id_asc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__ID_ASC"
    plot_notebook_info_by_parent_notebook_id__id_desc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__ID_DESC"
    plot_notebook_info_by_parent_notebook_id__owner_id_asc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__OWNER_ID_ASC"
    plot_notebook_info_by_parent_notebook_id__owner_id_desc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__OWNER_ID_DESC"
    plot_notebook_info_by_parent_notebook_id__removal_time_asc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__REMOVAL_TIME_ASC"
    plot_notebook_info_by_parent_notebook_id__removal_time_desc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__REMOVAL_TIME_DESC"

class PlotTransformInfosOrderBy(Enum):
    """
    Methods to use when ordering `PlotTransformInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    parent_id_asc = "PARENT_ID_ASC"
    parent_id_desc = "PARENT_ID_DESC"
    parent_notebook_id_asc = "PARENT_NOTEBOOK_ID_ASC"
    parent_notebook_id_desc = "PARENT_NOTEBOOK_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    plot_transform_info_by_parent_id__id_asc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__ID_ASC"
    plot_transform_info_by_parent_id__id_desc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__ID_DESC"
    plot_transform_info_by_parent_id__owner_id_asc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__OWNER_ID_ASC"
    plot_transform_info_by_parent_id__owner_id_desc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__OWNER_ID_DESC"
    plot_transform_info_by_parent_id__removal_time_asc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__REMOVAL_TIME_ASC"
    plot_transform_info_by_parent_id__removal_time_desc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__REMOVAL_TIME_DESC"
    plot_transform_info_by_parent_id__parent_id_asc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__PARENT_ID_ASC"
    plot_transform_info_by_parent_id__parent_id_desc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__PARENT_ID_DESC"
    plot_transform_info_by_parent_id__parent_notebook_id_asc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__PARENT_NOTEBOOK_ID_ASC"
    plot_transform_info_by_parent_id__parent_notebook_id_desc = "PLOT_TRANSFORM_INFO_BY_PARENT_ID__PARENT_NOTEBOOK_ID_DESC"
    plot_notebook_info_by_parent_notebook_id__id_asc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__ID_ASC"
    plot_notebook_info_by_parent_notebook_id__id_desc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__ID_DESC"
    plot_notebook_info_by_parent_notebook_id__owner_id_asc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__OWNER_ID_ASC"
    plot_notebook_info_by_parent_notebook_id__owner_id_desc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__OWNER_ID_DESC"
    plot_notebook_info_by_parent_notebook_id__removal_time_asc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__REMOVAL_TIME_ASC"
    plot_notebook_info_by_parent_notebook_id__removal_time_desc = "PLOT_NOTEBOOK_INFO_BY_PARENT_NOTEBOOK_ID__REMOVAL_TIME_DESC"
    plot_transform_infos_by_parent_id__count_asc = "PLOT_TRANSFORM_INFOS_BY_PARENT_ID__COUNT_ASC"
    plot_transform_infos_by_parent_id__count_desc = "PLOT_TRANSFORM_INFOS_BY_PARENT_ID__COUNT_DESC"
    plot_transform_source_codes_by_transform_id__count_asc = "PLOT_TRANSFORM_SOURCE_CODES_BY_TRANSFORM_ID__COUNT_ASC"
    plot_transform_source_codes_by_transform_id__count_desc = "PLOT_TRANSFORM_SOURCE_CODES_BY_TRANSFORM_ID__COUNT_DESC"
    plot_transform_executions_by_transform_id__count_asc = "PLOT_TRANSFORM_EXECUTIONS_BY_TRANSFORM_ID__COUNT_ASC"
    plot_transform_executions_by_transform_id__count_desc = "PLOT_TRANSFORM_EXECUTIONS_BY_TRANSFORM_ID__COUNT_DESC"

class PlotTransformSourceCodesOrderBy(Enum):
    """
    Methods to use when ordering `PlotTransformSourceCode`.
    """
    natural = "NATURAL"
    transform_id_asc = "TRANSFORM_ID_ASC"
    transform_id_desc = "TRANSFORM_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    plot_transform_info_by_transform_id__id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__ID_ASC"
    plot_transform_info_by_transform_id__id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__ID_DESC"
    plot_transform_info_by_transform_id__owner_id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__OWNER_ID_ASC"
    plot_transform_info_by_transform_id__owner_id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__OWNER_ID_DESC"
    plot_transform_info_by_transform_id__removal_time_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__REMOVAL_TIME_ASC"
    plot_transform_info_by_transform_id__removal_time_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__REMOVAL_TIME_DESC"
    plot_transform_info_by_transform_id__parent_id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_ID_ASC"
    plot_transform_info_by_transform_id__parent_id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_ID_DESC"
    plot_transform_info_by_transform_id__parent_notebook_id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_NOTEBOOK_ID_ASC"
    plot_transform_info_by_transform_id__parent_notebook_id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_NOTEBOOK_ID_DESC"

class PlotTransformExecutionsOrderBy(Enum):
    """
    Methods to use when ordering `PlotTransformExecution`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    transform_id_asc = "TRANSFORM_ID_ASC"
    transform_id_desc = "TRANSFORM_ID_DESC"
    start_time_asc = "START_TIME_ASC"
    start_time_desc = "START_TIME_DESC"
    end_time_asc = "END_TIME_ASC"
    end_time_desc = "END_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    plot_transform_info_by_transform_id__id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__ID_ASC"
    plot_transform_info_by_transform_id__id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__ID_DESC"
    plot_transform_info_by_transform_id__owner_id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__OWNER_ID_ASC"
    plot_transform_info_by_transform_id__owner_id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__OWNER_ID_DESC"
    plot_transform_info_by_transform_id__removal_time_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__REMOVAL_TIME_ASC"
    plot_transform_info_by_transform_id__removal_time_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__REMOVAL_TIME_DESC"
    plot_transform_info_by_transform_id__parent_id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_ID_ASC"
    plot_transform_info_by_transform_id__parent_id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_ID_DESC"
    plot_transform_info_by_transform_id__parent_notebook_id_asc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_NOTEBOOK_ID_ASC"
    plot_transform_info_by_transform_id__parent_notebook_id_desc = "PLOT_TRANSFORM_INFO_BY_TRANSFORM_ID__PARENT_NOTEBOOK_ID_DESC"

class PlotNotebookCrdtUpdatesOrderBy(Enum):
    """
    Methods to use when ordering `PlotNotebookCrdtUpdate`.
    """
    natural = "NATURAL"
    notebook_id_asc = "NOTEBOOK_ID_ASC"
    notebook_id_desc = "NOTEBOOK_ID_DESC"
    plot_notebook_info_by_notebook_id__id_asc = "PLOT_NOTEBOOK_INFO_BY_NOTEBOOK_ID__ID_ASC"
    plot_notebook_info_by_notebook_id__id_desc = "PLOT_NOTEBOOK_INFO_BY_NOTEBOOK_ID__ID_DESC"
    plot_notebook_info_by_notebook_id__owner_id_asc = "PLOT_NOTEBOOK_INFO_BY_NOTEBOOK_ID__OWNER_ID_ASC"
    plot_notebook_info_by_notebook_id__owner_id_desc = "PLOT_NOTEBOOK_INFO_BY_NOTEBOOK_ID__OWNER_ID_DESC"
    plot_notebook_info_by_notebook_id__removal_time_asc = "PLOT_NOTEBOOK_INFO_BY_NOTEBOOK_ID__REMOVAL_TIME_ASC"
    plot_notebook_info_by_notebook_id__removal_time_desc = "PLOT_NOTEBOOK_INFO_BY_NOTEBOOK_ID__REMOVAL_TIME_DESC"

class PlotDataSourceInfosOrderBy(Enum):
    """
    Methods to use when ordering `PlotDataSourceInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    table_id_asc = "TABLE_ID_ASC"
    table_id_desc = "TABLE_ID_DESC"
    ldata_node_id_asc = "LDATA_NODE_ID_ASC"
    ldata_node_id_desc = "LDATA_NODE_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    catalog_experiment_by_table_id__id_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__ID_ASC"
    catalog_experiment_by_table_id__id_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__ID_DESC"
    catalog_experiment_by_table_id__project_id_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__PROJECT_ID_ASC"
    catalog_experiment_by_table_id__project_id_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__PROJECT_ID_DESC"
    catalog_experiment_by_table_id__removed_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVED_ASC"
    catalog_experiment_by_table_id__removed_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVED_DESC"
    catalog_experiment_by_table_id__display_name_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__DISPLAY_NAME_ASC"
    catalog_experiment_by_table_id__display_name_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__DISPLAY_NAME_DESC"
    catalog_experiment_by_table_id__removal_time_asc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVAL_TIME_ASC"
    catalog_experiment_by_table_id__removal_time_desc = "CATALOG_EXPERIMENT_BY_TABLE_ID__REMOVAL_TIME_DESC"
    ldata_node_by_ldata_node_id__id_asc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_ASC"
    ldata_node_by_ldata_node_id__id_desc = "LDATA_NODE_BY_LDATA_NODE_ID__ID_DESC"
    ldata_node_by_ldata_node_id__name_asc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_ASC"
    ldata_node_by_ldata_node_id__name_desc = "LDATA_NODE_BY_LDATA_NODE_ID__NAME_DESC"
    ldata_node_by_ldata_node_id__share_link_asc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_ldata_node_id__share_link_desc = "LDATA_NODE_BY_LDATA_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_ldata_node_id__removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_ASC"
    ldata_node_by_ldata_node_id__removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__REMOVED_DESC"
    ldata_node_by_ldata_node_id__data_removed_asc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_ldata_node_id__data_removed_desc = "LDATA_NODE_BY_LDATA_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_ldata_node_id__pending_asc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_ASC"
    ldata_node_by_ldata_node_id__pending_desc = "LDATA_NODE_BY_LDATA_NODE_ID__PENDING_DESC"
    ldata_node_by_ldata_node_id__copied_from_asc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_ldata_node_id__copied_from_desc = "LDATA_NODE_BY_LDATA_NODE_ID__COPIED_FROM_DESC"

class BasespaceApiTokensOrderBy(Enum):
    """
    Methods to use when ordering `BasespaceApiToken`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    last_auto_import_asc = "LAST_AUTO_IMPORT_ASC"
    last_auto_import_desc = "LAST_AUTO_IMPORT_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class CreditsOrderBy(Enum):
    """
    Methods to use when ordering `Credit`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    deposit_time_asc = "DEPOSIT_TIME_ASC"
    deposit_time_desc = "DEPOSIT_TIME_DESC"
    metadata_asc = "METADATA_ASC"
    metadata_desc = "METADATA_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class ExecutionCreatorsOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionCreator`.
    """
    natural = "NATURAL"
    created_by_asc = "CREATED_BY_ASC"
    created_by_desc = "CREATED_BY_DESC"
    token_asc = "TOKEN_ASC"
    token_desc = "TOKEN_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_created_by__id_asc = "ACCOUNT_INFO_BY_CREATED_BY__ID_ASC"
    account_info_by_created_by__id_desc = "ACCOUNT_INFO_BY_CREATED_BY__ID_DESC"
    account_info_by_created_by__ldata_root_asc = "ACCOUNT_INFO_BY_CREATED_BY__LDATA_ROOT_ASC"
    account_info_by_created_by__ldata_root_desc = "ACCOUNT_INFO_BY_CREATED_BY__LDATA_ROOT_DESC"
    account_info_by_created_by__removed_asc = "ACCOUNT_INFO_BY_CREATED_BY__REMOVED_ASC"
    account_info_by_created_by__removed_desc = "ACCOUNT_INFO_BY_CREATED_BY__REMOVED_DESC"
    igv_genomes_by_execution_flytedb_id__count_asc = "IGV_GENOMES_BY_EXECUTION_FLYTEDB_ID__COUNT_ASC"
    igv_genomes_by_execution_flytedb_id__count_desc = "IGV_GENOMES_BY_EXECUTION_FLYTEDB_ID__COUNT_DESC"

class LdataS3MountAccessProvensOrderBy(Enum):
    """
    Methods to use when ordering `LdataS3MountAccessProven`.
    """
    natural = "NATURAL"
    generated_using_asc = "GENERATED_USING_ASC"
    generated_using_desc = "GENERATED_USING_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_s3_mount_configurator_role_by_generated_using__id_asc = "LDATA_S3_MOUNT_CONFIGURATOR_ROLE_BY_GENERATED_USING__ID_ASC"
    ldata_s3_mount_configurator_role_by_generated_using__id_desc = "LDATA_S3_MOUNT_CONFIGURATOR_ROLE_BY_GENERATED_USING__ID_DESC"
    ldata_s3_mount_configurator_role_by_generated_using__account_id_asc = "LDATA_S3_MOUNT_CONFIGURATOR_ROLE_BY_GENERATED_USING__ACCOUNT_ID_ASC"
    ldata_s3_mount_configurator_role_by_generated_using__account_id_desc = "LDATA_S3_MOUNT_CONFIGURATOR_ROLE_BY_GENERATED_USING__ACCOUNT_ID_DESC"

class LdataS3MountConfiguratorRolesOrderBy(Enum):
    """
    Methods to use when ordering `LdataS3MountConfiguratorRole`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    ldata_s3_mount_access_provens_by_generated_using__count_asc = "LDATA_S3_MOUNT_ACCESS_PROVENS_BY_GENERATED_USING__COUNT_ASC"
    ldata_s3_mount_access_provens_by_generated_using__count_desc = "LDATA_S3_MOUNT_ACCESS_PROVENS_BY_GENERATED_USING__COUNT_DESC"

class LdataShareLinkNodesOrderBy(Enum):
    """
    Methods to use when ordering `LdataShareLinkNode`.
    """
    natural = "NATURAL"
    link_node_id_asc = "LINK_NODE_ID_ASC"
    link_node_id_desc = "LINK_NODE_ID_DESC"
    receiver_id_asc = "RECEIVER_ID_ASC"
    receiver_id_desc = "RECEIVER_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_by_link_node_id__id_asc = "LDATA_NODE_BY_LINK_NODE_ID__ID_ASC"
    ldata_node_by_link_node_id__id_desc = "LDATA_NODE_BY_LINK_NODE_ID__ID_DESC"
    ldata_node_by_link_node_id__name_asc = "LDATA_NODE_BY_LINK_NODE_ID__NAME_ASC"
    ldata_node_by_link_node_id__name_desc = "LDATA_NODE_BY_LINK_NODE_ID__NAME_DESC"
    ldata_node_by_link_node_id__share_link_asc = "LDATA_NODE_BY_LINK_NODE_ID__SHARE_LINK_ASC"
    ldata_node_by_link_node_id__share_link_desc = "LDATA_NODE_BY_LINK_NODE_ID__SHARE_LINK_DESC"
    ldata_node_by_link_node_id__removed_asc = "LDATA_NODE_BY_LINK_NODE_ID__REMOVED_ASC"
    ldata_node_by_link_node_id__removed_desc = "LDATA_NODE_BY_LINK_NODE_ID__REMOVED_DESC"
    ldata_node_by_link_node_id__data_removed_asc = "LDATA_NODE_BY_LINK_NODE_ID__DATA_REMOVED_ASC"
    ldata_node_by_link_node_id__data_removed_desc = "LDATA_NODE_BY_LINK_NODE_ID__DATA_REMOVED_DESC"
    ldata_node_by_link_node_id__pending_asc = "LDATA_NODE_BY_LINK_NODE_ID__PENDING_ASC"
    ldata_node_by_link_node_id__pending_desc = "LDATA_NODE_BY_LINK_NODE_ID__PENDING_DESC"
    ldata_node_by_link_node_id__copied_from_asc = "LDATA_NODE_BY_LINK_NODE_ID__COPIED_FROM_ASC"
    ldata_node_by_link_node_id__copied_from_desc = "LDATA_NODE_BY_LINK_NODE_ID__COPIED_FROM_DESC"
    account_info_by_receiver_id__id_asc = "ACCOUNT_INFO_BY_RECEIVER_ID__ID_ASC"
    account_info_by_receiver_id__id_desc = "ACCOUNT_INFO_BY_RECEIVER_ID__ID_DESC"
    account_info_by_receiver_id__ldata_root_asc = "ACCOUNT_INFO_BY_RECEIVER_ID__LDATA_ROOT_ASC"
    account_info_by_receiver_id__ldata_root_desc = "ACCOUNT_INFO_BY_RECEIVER_ID__LDATA_ROOT_DESC"
    account_info_by_receiver_id__removed_asc = "ACCOUNT_INFO_BY_RECEIVER_ID__REMOVED_ASC"
    account_info_by_receiver_id__removed_desc = "ACCOUNT_INFO_BY_RECEIVER_ID__REMOVED_DESC"

class PodStatus(Enum):
    error = "ERROR"
    stopped = "STOPPED"
    starting = "STARTING"
    running = "RUNNING"
    stopping = "STOPPING"
    updating = "UPDATING"
    pod_scheduled = "POD_SCHEDULED"
    pod_has_network = "POD_HAS_NETWORK"
    containers_ready = "CONTAINERS_READY"
    initialized = "INITIALIZED"

class InstanceSize(Enum):
    small = "SMALL"
    medium = "MEDIUM"
    large = "LARGE"
    large2 = "LARGE2"
    large3 = "LARGE3"
    xl = "XL"

class PodInfosOrderBy(Enum):
    """
    Methods to use when ordering `PodInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    creation_date_asc = "CREATION_DATE_ASC"
    creation_date_desc = "CREATION_DATE_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    group_id_asc = "GROUP_ID_ASC"
    group_id_desc = "GROUP_ID_DESC"
    template_version_id_asc = "TEMPLATE_VERSION_ID_ASC"
    template_version_id_desc = "TEMPLATE_VERSION_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    pod_group_info_by_group_id__id_asc = "POD_GROUP_INFO_BY_GROUP_ID__ID_ASC"
    pod_group_info_by_group_id__id_desc = "POD_GROUP_INFO_BY_GROUP_ID__ID_DESC"
    pod_group_info_by_group_id__owner_id_asc = "POD_GROUP_INFO_BY_GROUP_ID__OWNER_ID_ASC"
    pod_group_info_by_group_id__owner_id_desc = "POD_GROUP_INFO_BY_GROUP_ID__OWNER_ID_DESC"
    pod_template_version_by_template_version_id__id_asc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__ID_ASC"
    pod_template_version_by_template_version_id__id_desc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__ID_DESC"
    pod_template_version_by_template_version_id__template_id_asc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__TEMPLATE_ID_ASC"
    pod_template_version_by_template_version_id__template_id_desc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__TEMPLATE_ID_DESC"
    pod_template_version_by_template_version_id__source_id_asc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__SOURCE_ID_ASC"
    pod_template_version_by_template_version_id__source_id_desc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__SOURCE_ID_DESC"
    pod_template_version_by_template_version_id__creation_date_asc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__CREATION_DATE_ASC"
    pod_template_version_by_template_version_id__creation_date_desc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__CREATION_DATE_DESC"
    pod_template_version_by_template_version_id__removed_asc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__REMOVED_ASC"
    pod_template_version_by_template_version_id__removed_desc = "POD_TEMPLATE_VERSION_BY_TEMPLATE_VERSION_ID__REMOVED_DESC"
    ebs_sessions_by_pod_id__count_asc = "EBS_SESSIONS_BY_POD_ID__COUNT_ASC"
    ebs_sessions_by_pod_id__count_desc = "EBS_SESSIONS_BY_POD_ID__COUNT_DESC"
    pod_sessions_by_pod_id__count_asc = "POD_SESSIONS_BY_POD_ID__COUNT_ASC"
    pod_sessions_by_pod_id__count_desc = "POD_SESSIONS_BY_POD_ID__COUNT_DESC"
    pod_backups_by_pod_id__count_asc = "POD_BACKUPS_BY_POD_ID__COUNT_ASC"
    pod_backups_by_pod_id__count_desc = "POD_BACKUPS_BY_POD_ID__COUNT_DESC"

class PodTemplateVersionsOrderBy(Enum):
    """
    Methods to use when ordering `PodTemplateVersion`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    template_id_asc = "TEMPLATE_ID_ASC"
    template_id_desc = "TEMPLATE_ID_DESC"
    source_id_asc = "SOURCE_ID_ASC"
    source_id_desc = "SOURCE_ID_DESC"
    creation_date_asc = "CREATION_DATE_ASC"
    creation_date_desc = "CREATION_DATE_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    pod_template_by_template_id__id_asc = "POD_TEMPLATE_BY_TEMPLATE_ID__ID_ASC"
    pod_template_by_template_id__id_desc = "POD_TEMPLATE_BY_TEMPLATE_ID__ID_DESC"
    pod_template_by_template_id__owner_id_asc = "POD_TEMPLATE_BY_TEMPLATE_ID__OWNER_ID_ASC"
    pod_template_by_template_id__owner_id_desc = "POD_TEMPLATE_BY_TEMPLATE_ID__OWNER_ID_DESC"
    pod_template_by_template_id__available_in_explore_asc = "POD_TEMPLATE_BY_TEMPLATE_ID__AVAILABLE_IN_EXPLORE_ASC"
    pod_template_by_template_id__available_in_explore_desc = "POD_TEMPLATE_BY_TEMPLATE_ID__AVAILABLE_IN_EXPLORE_DESC"
    pod_template_by_template_id__removed_asc = "POD_TEMPLATE_BY_TEMPLATE_ID__REMOVED_ASC"
    pod_template_by_template_id__removed_desc = "POD_TEMPLATE_BY_TEMPLATE_ID__REMOVED_DESC"
    pod_template_by_template_id__creation_date_asc = "POD_TEMPLATE_BY_TEMPLATE_ID__CREATION_DATE_ASC"
    pod_template_by_template_id__creation_date_desc = "POD_TEMPLATE_BY_TEMPLATE_ID__CREATION_DATE_DESC"
    pod_backup_by_source_id__pod_id_asc = "POD_BACKUP_BY_SOURCE_ID__POD_ID_ASC"
    pod_backup_by_source_id__pod_id_desc = "POD_BACKUP_BY_SOURCE_ID__POD_ID_DESC"
    pod_backup_by_source_id__provider_id_asc = "POD_BACKUP_BY_SOURCE_ID__PROVIDER_ID_ASC"
    pod_backup_by_source_id__provider_id_desc = "POD_BACKUP_BY_SOURCE_ID__PROVIDER_ID_DESC"
    pod_backup_by_source_id__start_time_asc = "POD_BACKUP_BY_SOURCE_ID__START_TIME_ASC"
    pod_backup_by_source_id__start_time_desc = "POD_BACKUP_BY_SOURCE_ID__START_TIME_DESC"
    pod_infos_by_template_version_id__count_asc = "POD_INFOS_BY_TEMPLATE_VERSION_ID__COUNT_ASC"
    pod_infos_by_template_version_id__count_desc = "POD_INFOS_BY_TEMPLATE_VERSION_ID__COUNT_DESC"

class EbsSessionsOrderBy(Enum):
    """
    Methods to use when ordering `EbsSession`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    pod_id_asc = "POD_ID_ASC"
    pod_id_desc = "POD_ID_DESC"
    start_time_asc = "START_TIME_ASC"
    start_time_desc = "START_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    pod_info_by_pod_id__id_asc = "POD_INFO_BY_POD_ID__ID_ASC"
    pod_info_by_pod_id__id_desc = "POD_INFO_BY_POD_ID__ID_DESC"
    pod_info_by_pod_id__creation_date_asc = "POD_INFO_BY_POD_ID__CREATION_DATE_ASC"
    pod_info_by_pod_id__creation_date_desc = "POD_INFO_BY_POD_ID__CREATION_DATE_DESC"
    pod_info_by_pod_id__account_id_asc = "POD_INFO_BY_POD_ID__ACCOUNT_ID_ASC"
    pod_info_by_pod_id__account_id_desc = "POD_INFO_BY_POD_ID__ACCOUNT_ID_DESC"
    pod_info_by_pod_id__removed_asc = "POD_INFO_BY_POD_ID__REMOVED_ASC"
    pod_info_by_pod_id__removed_desc = "POD_INFO_BY_POD_ID__REMOVED_DESC"
    pod_info_by_pod_id__group_id_asc = "POD_INFO_BY_POD_ID__GROUP_ID_ASC"
    pod_info_by_pod_id__group_id_desc = "POD_INFO_BY_POD_ID__GROUP_ID_DESC"
    pod_info_by_pod_id__template_version_id_asc = "POD_INFO_BY_POD_ID__TEMPLATE_VERSION_ID_ASC"
    pod_info_by_pod_id__template_version_id_desc = "POD_INFO_BY_POD_ID__TEMPLATE_VERSION_ID_DESC"

class PodSessionsOrderBy(Enum):
    """
    Methods to use when ordering `PodSession`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    pod_id_asc = "POD_ID_ASC"
    pod_id_desc = "POD_ID_DESC"
    start_time_asc = "START_TIME_ASC"
    start_time_desc = "START_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    pod_info_by_pod_id__id_asc = "POD_INFO_BY_POD_ID__ID_ASC"
    pod_info_by_pod_id__id_desc = "POD_INFO_BY_POD_ID__ID_DESC"
    pod_info_by_pod_id__creation_date_asc = "POD_INFO_BY_POD_ID__CREATION_DATE_ASC"
    pod_info_by_pod_id__creation_date_desc = "POD_INFO_BY_POD_ID__CREATION_DATE_DESC"
    pod_info_by_pod_id__account_id_asc = "POD_INFO_BY_POD_ID__ACCOUNT_ID_ASC"
    pod_info_by_pod_id__account_id_desc = "POD_INFO_BY_POD_ID__ACCOUNT_ID_DESC"
    pod_info_by_pod_id__removed_asc = "POD_INFO_BY_POD_ID__REMOVED_ASC"
    pod_info_by_pod_id__removed_desc = "POD_INFO_BY_POD_ID__REMOVED_DESC"
    pod_info_by_pod_id__group_id_asc = "POD_INFO_BY_POD_ID__GROUP_ID_ASC"
    pod_info_by_pod_id__group_id_desc = "POD_INFO_BY_POD_ID__GROUP_ID_DESC"
    pod_info_by_pod_id__template_version_id_asc = "POD_INFO_BY_POD_ID__TEMPLATE_VERSION_ID_ASC"
    pod_info_by_pod_id__template_version_id_desc = "POD_INFO_BY_POD_ID__TEMPLATE_VERSION_ID_DESC"

class PodBackupsOrderBy(Enum):
    """
    Methods to use when ordering `PodBackup`.
    """
    natural = "NATURAL"
    pod_id_asc = "POD_ID_ASC"
    pod_id_desc = "POD_ID_DESC"
    provider_id_asc = "PROVIDER_ID_ASC"
    provider_id_desc = "PROVIDER_ID_DESC"
    start_time_asc = "START_TIME_ASC"
    start_time_desc = "START_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    pod_info_by_pod_id__id_asc = "POD_INFO_BY_POD_ID__ID_ASC"
    pod_info_by_pod_id__id_desc = "POD_INFO_BY_POD_ID__ID_DESC"
    pod_info_by_pod_id__creation_date_asc = "POD_INFO_BY_POD_ID__CREATION_DATE_ASC"
    pod_info_by_pod_id__creation_date_desc = "POD_INFO_BY_POD_ID__CREATION_DATE_DESC"
    pod_info_by_pod_id__account_id_asc = "POD_INFO_BY_POD_ID__ACCOUNT_ID_ASC"
    pod_info_by_pod_id__account_id_desc = "POD_INFO_BY_POD_ID__ACCOUNT_ID_DESC"
    pod_info_by_pod_id__removed_asc = "POD_INFO_BY_POD_ID__REMOVED_ASC"
    pod_info_by_pod_id__removed_desc = "POD_INFO_BY_POD_ID__REMOVED_DESC"
    pod_info_by_pod_id__group_id_asc = "POD_INFO_BY_POD_ID__GROUP_ID_ASC"
    pod_info_by_pod_id__group_id_desc = "POD_INFO_BY_POD_ID__GROUP_ID_DESC"
    pod_info_by_pod_id__template_version_id_asc = "POD_INFO_BY_POD_ID__TEMPLATE_VERSION_ID_ASC"
    pod_info_by_pod_id__template_version_id_desc = "POD_INFO_BY_POD_ID__TEMPLATE_VERSION_ID_DESC"
    pod_template_versions_by_source_id__count_asc = "POD_TEMPLATE_VERSIONS_BY_SOURCE_ID__COUNT_ASC"
    pod_template_versions_by_source_id__count_desc = "POD_TEMPLATE_VERSIONS_BY_SOURCE_ID__COUNT_DESC"

class PublicKeyInfosOrderBy(Enum):
    """
    Methods to use when ordering `PublicKeyInfo`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class TaskInfosOrderBy(Enum):
    """
    Methods to use when ordering `TaskInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    project_asc = "PROJECT_ASC"
    project_desc = "PROJECT_DESC"
    flytedb_id_asc = "FLYTEDB_ID_ASC"
    flytedb_id_desc = "FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    workflow_graph_branches_by_task_info_id__count_asc = "WORKFLOW_GRAPH_BRANCHES_BY_TASK_INFO_ID__COUNT_ASC"
    workflow_graph_branches_by_task_info_id__count_desc = "WORKFLOW_GRAPH_BRANCHES_BY_TASK_INFO_ID__COUNT_DESC"
    workflow_graph_nodes_by_task_info_id__count_asc = "WORKFLOW_GRAPH_NODES_BY_TASK_INFO_ID__COUNT_ASC"
    workflow_graph_nodes_by_task_info_id__count_desc = "WORKFLOW_GRAPH_NODES_BY_TASK_INFO_ID__COUNT_DESC"

class TeamInvitesOrderBy(Enum):
    """
    Methods to use when ordering `TeamInvite`.
    """
    natural = "NATURAL"
    invite_code_asc = "INVITE_CODE_ASC"
    invite_code_desc = "INVITE_CODE_DESC"
    team_id_asc = "TEAM_ID_ASC"
    team_id_desc = "TEAM_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    team_info_by_team_id__id_asc = "TEAM_INFO_BY_TEAM_ID__ID_ASC"
    team_info_by_team_id__id_desc = "TEAM_INFO_BY_TEAM_ID__ID_DESC"
    team_info_by_team_id__account_id_asc = "TEAM_INFO_BY_TEAM_ID__ACCOUNT_ID_ASC"
    team_info_by_team_id__account_id_desc = "TEAM_INFO_BY_TEAM_ID__ACCOUNT_ID_DESC"
    team_info_by_team_id__owner_id_asc = "TEAM_INFO_BY_TEAM_ID__OWNER_ID_ASC"
    team_info_by_team_id__owner_id_desc = "TEAM_INFO_BY_TEAM_ID__OWNER_ID_DESC"

class TeamMembersOrderBy(Enum):
    """
    Methods to use when ordering `TeamMember`.
    """
    natural = "NATURAL"
    team_id_asc = "TEAM_ID_ASC"
    team_id_desc = "TEAM_ID_DESC"
    user_id_asc = "USER_ID_ASC"
    user_id_desc = "USER_ID_DESC"
    role_asc = "ROLE_ASC"
    role_desc = "ROLE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    team_info_by_team_id__id_asc = "TEAM_INFO_BY_TEAM_ID__ID_ASC"
    team_info_by_team_id__id_desc = "TEAM_INFO_BY_TEAM_ID__ID_DESC"
    team_info_by_team_id__account_id_asc = "TEAM_INFO_BY_TEAM_ID__ACCOUNT_ID_ASC"
    team_info_by_team_id__account_id_desc = "TEAM_INFO_BY_TEAM_ID__ACCOUNT_ID_DESC"
    team_info_by_team_id__owner_id_asc = "TEAM_INFO_BY_TEAM_ID__OWNER_ID_ASC"
    team_info_by_team_id__owner_id_desc = "TEAM_INFO_BY_TEAM_ID__OWNER_ID_DESC"
    user_info_by_user_id__id_asc = "USER_INFO_BY_USER_ID__ID_ASC"
    user_info_by_user_id__id_desc = "USER_INFO_BY_USER_ID__ID_DESC"
    user_info_by_user_id__account_id_asc = "USER_INFO_BY_USER_ID__ACCOUNT_ID_ASC"
    user_info_by_user_id__account_id_desc = "USER_INFO_BY_USER_ID__ACCOUNT_ID_DESC"
    user_info_by_user_id__auth0_sub_asc = "USER_INFO_BY_USER_ID__AUTH0_SUB_ASC"
    user_info_by_user_id__auth0_sub_desc = "USER_INFO_BY_USER_ID__AUTH0_SUB_DESC"

class WorkflowPinsOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowPin`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class CatalogProjectsOrderBy(Enum):
    """
    Methods to use when ordering `CatalogProject`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    display_name_asc = "DISPLAY_NAME_ASC"
    display_name_desc = "DISPLAY_NAME_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    catalog_events_by_project_id__count_asc = "CATALOG_EVENTS_BY_PROJECT_ID__COUNT_ASC"
    catalog_events_by_project_id__count_desc = "CATALOG_EVENTS_BY_PROJECT_ID__COUNT_DESC"
    catalog_experiments_by_project_id__count_asc = "CATALOG_EXPERIMENTS_BY_PROJECT_ID__COUNT_ASC"
    catalog_experiments_by_project_id__count_desc = "CATALOG_EXPERIMENTS_BY_PROJECT_ID__COUNT_DESC"
    benchling_imports_by_project_id__count_asc = "BENCHLING_IMPORTS_BY_PROJECT_ID__COUNT_ASC"
    benchling_imports_by_project_id__count_desc = "BENCHLING_IMPORTS_BY_PROJECT_ID__COUNT_DESC"

class AccountAccessPoliciesOrderBy(Enum):
    """
    Methods to use when ordering `AccountAccessPolicy`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    user_account_id_asc = "USER_ACCOUNT_ID_ASC"
    user_account_id_desc = "USER_ACCOUNT_ID_DESC"
    workspace_id_asc = "WORKSPACE_ID_ASC"
    workspace_id_desc = "WORKSPACE_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    user_info_by_user_account_id__id_asc = "USER_INFO_BY_USER_ACCOUNT_ID__ID_ASC"
    user_info_by_user_account_id__id_desc = "USER_INFO_BY_USER_ACCOUNT_ID__ID_DESC"
    user_info_by_user_account_id__account_id_asc = "USER_INFO_BY_USER_ACCOUNT_ID__ACCOUNT_ID_ASC"
    user_info_by_user_account_id__account_id_desc = "USER_INFO_BY_USER_ACCOUNT_ID__ACCOUNT_ID_DESC"
    user_info_by_user_account_id__auth0_sub_asc = "USER_INFO_BY_USER_ACCOUNT_ID__AUTH0_SUB_ASC"
    user_info_by_user_account_id__auth0_sub_desc = "USER_INFO_BY_USER_ACCOUNT_ID__AUTH0_SUB_DESC"
    account_info_by_workspace_id__id_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__ID_ASC"
    account_info_by_workspace_id__id_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__ID_DESC"
    account_info_by_workspace_id__ldata_root_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__LDATA_ROOT_ASC"
    account_info_by_workspace_id__ldata_root_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__LDATA_ROOT_DESC"
    account_info_by_workspace_id__removed_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__REMOVED_ASC"
    account_info_by_workspace_id__removed_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__REMOVED_DESC"

class AccountSecretsOrderBy(Enum):
    """
    Methods to use when ordering `AccountSecret`.
    """
    natural = "NATURAL"
    workspace_id_asc = "WORKSPACE_ID_ASC"
    workspace_id_desc = "WORKSPACE_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_workspace_id__id_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__ID_ASC"
    account_info_by_workspace_id__id_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__ID_DESC"
    account_info_by_workspace_id__ldata_root_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__LDATA_ROOT_ASC"
    account_info_by_workspace_id__ldata_root_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__LDATA_ROOT_DESC"
    account_info_by_workspace_id__removed_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__REMOVED_ASC"
    account_info_by_workspace_id__removed_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__REMOVED_DESC"

class PodTemplatesOrderBy(Enum):
    """
    Methods to use when ordering `PodTemplate`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    available_in_explore_asc = "AVAILABLE_IN_EXPLORE_ASC"
    available_in_explore_desc = "AVAILABLE_IN_EXPLORE_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    creation_date_asc = "CREATION_DATE_ASC"
    creation_date_desc = "CREATION_DATE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    pod_template_versions_by_template_id__count_asc = "POD_TEMPLATE_VERSIONS_BY_TEMPLATE_ID__COUNT_ASC"
    pod_template_versions_by_template_id__count_desc = "POD_TEMPLATE_VERSIONS_BY_TEMPLATE_ID__COUNT_DESC"

class ExecutionBatchInfosOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionBatchInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owned_by_asc = "OWNED_BY_ASC"
    owned_by_desc = "OWNED_BY_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owned_by__id_asc = "ACCOUNT_INFO_BY_OWNED_BY__ID_ASC"
    account_info_by_owned_by__id_desc = "ACCOUNT_INFO_BY_OWNED_BY__ID_DESC"
    account_info_by_owned_by__ldata_root_asc = "ACCOUNT_INFO_BY_OWNED_BY__LDATA_ROOT_ASC"
    account_info_by_owned_by__ldata_root_desc = "ACCOUNT_INFO_BY_OWNED_BY__LDATA_ROOT_DESC"
    account_info_by_owned_by__removed_asc = "ACCOUNT_INFO_BY_OWNED_BY__REMOVED_ASC"
    account_info_by_owned_by__removed_desc = "ACCOUNT_INFO_BY_OWNED_BY__REMOVED_DESC"
    execution_batch_members_by_batch_id__count_asc = "EXECUTION_BATCH_MEMBERS_BY_BATCH_ID__COUNT_ASC"
    execution_batch_members_by_batch_id__count_desc = "EXECUTION_BATCH_MEMBERS_BY_BATCH_ID__COUNT_DESC"
    execution_notification_infos_by_batch_id__count_asc = "EXECUTION_NOTIFICATION_INFOS_BY_BATCH_ID__COUNT_ASC"
    execution_notification_infos_by_batch_id__count_desc = "EXECUTION_NOTIFICATION_INFOS_BY_BATCH_ID__COUNT_DESC"

class VerifiedEmailsOrderBy(Enum):
    """
    Methods to use when ordering `VerifiedEmail`.
    """
    natural = "NATURAL"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    requested_at_asc = "REQUESTED_AT_ASC"
    requested_at_desc = "REQUESTED_AT_DESC"
    verified_asc = "VERIFIED_ASC"
    verified_desc = "VERIFIED_DESC"
    verification_resent_at_asc = "VERIFICATION_RESENT_AT_ASC"
    verification_resent_at_desc = "VERIFICATION_RESENT_AT_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"

class PodGroupInfosOrderBy(Enum):
    """
    Methods to use when ordering `PodGroupInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    pod_infos_by_group_id__count_asc = "POD_INFOS_BY_GROUP_ID__COUNT_ASC"
    pod_infos_by_group_id__count_desc = "POD_INFOS_BY_GROUP_ID__COUNT_DESC"

class AutomationInfosOrderBy(Enum):
    """
    Methods to use when ordering `AutomationInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    automation_versions_by_automation_id__count_asc = "AUTOMATION_VERSIONS_BY_AUTOMATION_ID__COUNT_ASC"
    automation_versions_by_automation_id__count_desc = "AUTOMATION_VERSIONS_BY_AUTOMATION_ID__COUNT_DESC"
    automation_trigger_ldata_events_by_automation_id__count_asc = "AUTOMATION_TRIGGER_LDATA_EVENTS_BY_AUTOMATION_ID__COUNT_ASC"
    automation_trigger_ldata_events_by_automation_id__count_desc = "AUTOMATION_TRIGGER_LDATA_EVENTS_BY_AUTOMATION_ID__COUNT_DESC"
    automation_trigger_interval_events_by_automation_id__count_asc = "AUTOMATION_TRIGGER_INTERVAL_EVENTS_BY_AUTOMATION_ID__COUNT_ASC"
    automation_trigger_interval_events_by_automation_id__count_desc = "AUTOMATION_TRIGGER_INTERVAL_EVENTS_BY_AUTOMATION_ID__COUNT_DESC"

class ReportsOrderBy(Enum):
    """
    Methods to use when ordering `Report`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    group_id_asc = "GROUP_ID_ASC"
    group_id_desc = "GROUP_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    report_group_by_group_id__id_asc = "REPORT_GROUP_BY_GROUP_ID__ID_ASC"
    report_group_by_group_id__id_desc = "REPORT_GROUP_BY_GROUP_ID__ID_DESC"
    report_group_by_group_id__workspace_id_asc = "REPORT_GROUP_BY_GROUP_ID__WORKSPACE_ID_ASC"
    report_group_by_group_id__workspace_id_desc = "REPORT_GROUP_BY_GROUP_ID__WORKSPACE_ID_DESC"
    report_group_by_group_id__removed_asc = "REPORT_GROUP_BY_GROUP_ID__REMOVED_ASC"
    report_group_by_group_id__removed_desc = "REPORT_GROUP_BY_GROUP_ID__REMOVED_DESC"

class ReportGroupsOrderBy(Enum):
    """
    Methods to use when ordering `ReportGroup`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    workspace_id_asc = "WORKSPACE_ID_ASC"
    workspace_id_desc = "WORKSPACE_ID_DESC"
    removed_asc = "REMOVED_ASC"
    removed_desc = "REMOVED_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_workspace_id__id_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__ID_ASC"
    account_info_by_workspace_id__id_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__ID_DESC"
    account_info_by_workspace_id__ldata_root_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__LDATA_ROOT_ASC"
    account_info_by_workspace_id__ldata_root_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__LDATA_ROOT_DESC"
    account_info_by_workspace_id__removed_asc = "ACCOUNT_INFO_BY_WORKSPACE_ID__REMOVED_ASC"
    account_info_by_workspace_id__removed_desc = "ACCOUNT_INFO_BY_WORKSPACE_ID__REMOVED_DESC"
    reports_by_group_id__count_asc = "REPORTS_BY_GROUP_ID__COUNT_ASC"
    reports_by_group_id__count_desc = "REPORTS_BY_GROUP_ID__COUNT_DESC"

class BenchlingImportRunsOrderBy(Enum):
    """
    Methods to use when ordering `BenchlingImportRun`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class PlotLayoutInfosOrderBy(Enum):
    """
    Methods to use when ordering `PlotLayoutInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"

class NextflowTaskType(Enum):
    process = "PROCESS"
    operator = "OPERATOR"
    sub_workflow = "SUB_WORKFLOW"
    generator = "GENERATOR"
    conditional = "CONDITIONAL"
    merge = "MERGE"
    adapter = "ADAPTER"

class NextflowNodeInfosOrderBy(Enum):
    """
    Methods to use when ordering `NextflowNodeInfo`.
    """
    natural = "NATURAL"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    workflow_name_asc = "WORKFLOW_NAME_ASC"
    workflow_name_desc = "WORKFLOW_NAME_DESC"
    version_asc = "VERSION_ASC"
    version_desc = "VERSION_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"

class LdataGcpMountProjectsOrderBy(Enum):
    """
    Methods to use when ordering `LdataGcpMountProject`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class PlotNotebookInfosOrderBy(Enum):
    """
    Methods to use when ordering `PlotNotebookInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    removal_time_asc = "REMOVAL_TIME_ASC"
    removal_time_desc = "REMOVAL_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_owner_id__id_asc = "ACCOUNT_INFO_BY_OWNER_ID__ID_ASC"
    account_info_by_owner_id__id_desc = "ACCOUNT_INFO_BY_OWNER_ID__ID_DESC"
    account_info_by_owner_id__ldata_root_asc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_ASC"
    account_info_by_owner_id__ldata_root_desc = "ACCOUNT_INFO_BY_OWNER_ID__LDATA_ROOT_DESC"
    account_info_by_owner_id__removed_asc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_ASC"
    account_info_by_owner_id__removed_desc = "ACCOUNT_INFO_BY_OWNER_ID__REMOVED_DESC"
    plot_infos_by_parent_notebook_id__count_asc = "PLOT_INFOS_BY_PARENT_NOTEBOOK_ID__COUNT_ASC"
    plot_infos_by_parent_notebook_id__count_desc = "PLOT_INFOS_BY_PARENT_NOTEBOOK_ID__COUNT_DESC"
    plot_transform_infos_by_parent_notebook_id__count_asc = "PLOT_TRANSFORM_INFOS_BY_PARENT_NOTEBOOK_ID__COUNT_ASC"
    plot_transform_infos_by_parent_notebook_id__count_desc = "PLOT_TRANSFORM_INFOS_BY_PARENT_NOTEBOOK_ID__COUNT_DESC"
    plot_notebook_crdt_updates_by_notebook_id__count_asc = "PLOT_NOTEBOOK_CRDT_UPDATES_BY_NOTEBOOK_ID__COUNT_ASC"
    plot_notebook_crdt_updates_by_notebook_id__count_desc = "PLOT_NOTEBOOK_CRDT_UPDATES_BY_NOTEBOOK_ID__COUNT_DESC"

class LdataGoogleVerifiedBucketsOrderBy(Enum):
    """
    Methods to use when ordering `LdataGoogleVerifiedBucket`.
    """
    natural = "NATURAL"
    project_id_asc = "PROJECT_ID_ASC"
    project_id_desc = "PROJECT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_google_verified_project_by_project_id__id_asc = "LDATA_GOOGLE_VERIFIED_PROJECT_BY_PROJECT_ID__ID_ASC"
    ldata_google_verified_project_by_project_id__id_desc = "LDATA_GOOGLE_VERIFIED_PROJECT_BY_PROJECT_ID__ID_DESC"
    ldata_google_verified_project_by_project_id__account_id_asc = "LDATA_GOOGLE_VERIFIED_PROJECT_BY_PROJECT_ID__ACCOUNT_ID_ASC"
    ldata_google_verified_project_by_project_id__account_id_desc = "LDATA_GOOGLE_VERIFIED_PROJECT_BY_PROJECT_ID__ACCOUNT_ID_DESC"

class LdataGoogleVerifiedProjectsOrderBy(Enum):
    """
    Methods to use when ordering `LdataGoogleVerifiedProject`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    ldata_google_verified_buckets_by_project_id__count_asc = "LDATA_GOOGLE_VERIFIED_BUCKETS_BY_PROJECT_ID__COUNT_ASC"
    ldata_google_verified_buckets_by_project_id__count_desc = "LDATA_GOOGLE_VERIFIED_BUCKETS_BY_PROJECT_ID__COUNT_DESC"

class TeamInfosOrderBy(Enum):
    """
    Methods to use when ordering `TeamInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    owner_id_asc = "OWNER_ID_ASC"
    owner_id_desc = "OWNER_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    user_info_by_owner_id__id_asc = "USER_INFO_BY_OWNER_ID__ID_ASC"
    user_info_by_owner_id__id_desc = "USER_INFO_BY_OWNER_ID__ID_DESC"
    user_info_by_owner_id__account_id_asc = "USER_INFO_BY_OWNER_ID__ACCOUNT_ID_ASC"
    user_info_by_owner_id__account_id_desc = "USER_INFO_BY_OWNER_ID__ACCOUNT_ID_DESC"
    user_info_by_owner_id__auth0_sub_asc = "USER_INFO_BY_OWNER_ID__AUTH0_SUB_ASC"
    user_info_by_owner_id__auth0_sub_desc = "USER_INFO_BY_OWNER_ID__AUTH0_SUB_DESC"
    team_invites_by_team_id__count_asc = "TEAM_INVITES_BY_TEAM_ID__COUNT_ASC"
    team_invites_by_team_id__count_desc = "TEAM_INVITES_BY_TEAM_ID__COUNT_DESC"
    team_members_by_team_id__count_asc = "TEAM_MEMBERS_BY_TEAM_ID__COUNT_ASC"
    team_members_by_team_id__count_desc = "TEAM_MEMBERS_BY_TEAM_ID__COUNT_DESC"

class WorkflowPersonalizationsOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowPersonalization`.
    """
    natural = "NATURAL"
    user_id_asc = "USER_ID_ASC"
    user_id_desc = "USER_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    user_info_by_user_id__id_asc = "USER_INFO_BY_USER_ID__ID_ASC"
    user_info_by_user_id__id_desc = "USER_INFO_BY_USER_ID__ID_DESC"
    user_info_by_user_id__account_id_asc = "USER_INFO_BY_USER_ID__ACCOUNT_ID_ASC"
    user_info_by_user_id__account_id_desc = "USER_INFO_BY_USER_ID__ACCOUNT_ID_DESC"
    user_info_by_user_id__auth0_sub_asc = "USER_INFO_BY_USER_ID__AUTH0_SUB_ASC"
    user_info_by_user_id__auth0_sub_desc = "USER_INFO_BY_USER_ID__AUTH0_SUB_DESC"

class BenchlingApiTokensOrderBy(Enum):
    """
    Methods to use when ordering `BenchlingApiToken`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class DatasetAgreementActivatedsOrderBy(Enum):
    """
    Methods to use when ordering `DatasetAgreementActivated`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    user_info_by_account_id__id_asc = "USER_INFO_BY_ACCOUNT_ID__ID_ASC"
    user_info_by_account_id__id_desc = "USER_INFO_BY_ACCOUNT_ID__ID_DESC"
    user_info_by_account_id__account_id_asc = "USER_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    user_info_by_account_id__account_id_desc = "USER_INFO_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    user_info_by_account_id__auth0_sub_asc = "USER_INFO_BY_ACCOUNT_ID__AUTH0_SUB_ASC"
    user_info_by_account_id__auth0_sub_desc = "USER_INFO_BY_ACCOUNT_ID__AUTH0_SUB_DESC"

class DatasetInfosOrderBy(Enum):
    """
    Methods to use when ordering `DatasetInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    provider_asc = "PROVIDER_ASC"
    provider_desc = "PROVIDER_DESC"
    display_name_asc = "DISPLAY_NAME_ASC"
    display_name_desc = "DISPLAY_NAME_DESC"
    description_asc = "DESCRIPTION_ASC"
    description_desc = "DESCRIPTION_DESC"
    availability_asc = "AVAILABILITY_ASC"
    availability_desc = "AVAILABILITY_DESC"
    price_asc = "PRICE_ASC"
    price_desc = "PRICE_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    dataset_download_infos_by_dataset_id__count_asc = "DATASET_DOWNLOAD_INFOS_BY_DATASET_ID__COUNT_ASC"
    dataset_download_infos_by_dataset_id__count_desc = "DATASET_DOWNLOAD_INFOS_BY_DATASET_ID__COUNT_DESC"
    dataset_info_tags_by_dataset_id__count_asc = "DATASET_INFO_TAGS_BY_DATASET_ID__COUNT_ASC"
    dataset_info_tags_by_dataset_id__count_desc = "DATASET_INFO_TAGS_BY_DATASET_ID__COUNT_DESC"
    dataset_purchases_by_dataset_id__count_asc = "DATASET_PURCHASES_BY_DATASET_ID__COUNT_ASC"
    dataset_purchases_by_dataset_id__count_desc = "DATASET_PURCHASES_BY_DATASET_ID__COUNT_DESC"
    dataset_requests_by_dataset_id__count_asc = "DATASET_REQUESTS_BY_DATASET_ID__COUNT_ASC"
    dataset_requests_by_dataset_id__count_desc = "DATASET_REQUESTS_BY_DATASET_ID__COUNT_DESC"

class ExecutionRefLpInfosOrderBy(Enum):
    """
    Methods to use when ordering `ExecutionRefLpInfo`.
    """
    natural = "NATURAL"
    egn_id_asc = "EGN_ID_ASC"
    egn_id_desc = "EGN_ID_DESC"
    token_asc = "TOKEN_ASC"
    token_desc = "TOKEN_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    execution_graph_node_by_egn_id__id_asc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__ID_ASC"
    execution_graph_node_by_egn_id__id_desc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__ID_DESC"
    execution_graph_node_by_egn_id__execution_id_asc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__EXECUTION_ID_ASC"
    execution_graph_node_by_egn_id__execution_id_desc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__EXECUTION_ID_DESC"
    execution_graph_node_by_egn_id__workflow_graph_node_id_asc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__WORKFLOW_GRAPH_NODE_ID_ASC"
    execution_graph_node_by_egn_id__workflow_graph_node_id_desc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__WORKFLOW_GRAPH_NODE_ID_DESC"
    execution_graph_node_by_egn_id__flytedb_id_asc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__FLYTEDB_ID_ASC"
    execution_graph_node_by_egn_id__flytedb_id_desc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__FLYTEDB_ID_DESC"
    execution_graph_node_by_egn_id__status_asc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__STATUS_ASC"
    execution_graph_node_by_egn_id__status_desc = "EXECUTION_GRAPH_NODE_BY_EGN_ID__STATUS_DESC"

class GithubPersonalAccessTokensOrderBy(Enum):
    """
    Methods to use when ordering `GithubPersonalAccessToken`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class IncidentInfosOrderBy(Enum):
    """
    Methods to use when ordering `IncidentInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    start_time_asc = "START_TIME_ASC"
    start_time_desc = "START_TIME_DESC"
    resolution_time_asc = "RESOLUTION_TIME_ASC"
    resolution_time_desc = "RESOLUTION_TIME_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class IntegrationsGoogleAuthsOrderBy(Enum):
    """
    Methods to use when ordering `IntegrationsGoogleAuth`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class LdataGcpMountAccessProvensOrderBy(Enum):
    """
    Methods to use when ordering `LdataGcpMountAccessProven`.
    """
    natural = "NATURAL"
    project_id_asc = "PROJECT_ID_ASC"
    project_id_desc = "PROJECT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class LdataNodeEventChildRemovesOrderBy(Enum):
    """
    Methods to use when ordering `LdataNodeEventChildRemove`.
    """
    natural = "NATURAL"
    event_id_asc = "EVENT_ID_ASC"
    event_id_desc = "EVENT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_event_by_event_id__id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_ASC"
    ldata_node_event_by_event_id__id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_DESC"
    ldata_node_event_by_event_id__ldata_node_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_ASC"
    ldata_node_event_by_event_id__ldata_node_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_DESC"
    ldata_node_event_by_event_id__type_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_ASC"
    ldata_node_event_by_event_id__type_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_DESC"
    ldata_node_event_by_event_id__time_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_ASC"
    ldata_node_event_by_event_id__time_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_DESC"
    ldata_node_event_by_event_id__cause_account_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_ASC"
    ldata_node_event_by_event_id__cause_account_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_DESC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_ASC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_DESC"
    ldata_node_event_by_event_id__cause_dataset_download_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_ASC"
    ldata_node_event_by_event_id__cause_dataset_download_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_DESC"
    ldata_node_event_by_event_id__cause_ldata_process_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_ASC"
    ldata_node_event_by_event_id__cause_ldata_process_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_DESC"

class LdataNodeEventIngressesOrderBy(Enum):
    """
    Methods to use when ordering `LdataNodeEventIngress`.
    """
    natural = "NATURAL"
    event_id_asc = "EVENT_ID_ASC"
    event_id_desc = "EVENT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_event_by_event_id__id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_ASC"
    ldata_node_event_by_event_id__id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_DESC"
    ldata_node_event_by_event_id__ldata_node_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_ASC"
    ldata_node_event_by_event_id__ldata_node_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_DESC"
    ldata_node_event_by_event_id__type_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_ASC"
    ldata_node_event_by_event_id__type_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_DESC"
    ldata_node_event_by_event_id__time_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_ASC"
    ldata_node_event_by_event_id__time_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_DESC"
    ldata_node_event_by_event_id__cause_account_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_ASC"
    ldata_node_event_by_event_id__cause_account_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_DESC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_ASC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_DESC"
    ldata_node_event_by_event_id__cause_dataset_download_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_ASC"
    ldata_node_event_by_event_id__cause_dataset_download_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_DESC"
    ldata_node_event_by_event_id__cause_ldata_process_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_ASC"
    ldata_node_event_by_event_id__cause_ldata_process_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_DESC"

class LdataNodeEventMovesOrderBy(Enum):
    """
    Methods to use when ordering `LdataNodeEventMove`.
    """
    natural = "NATURAL"
    event_id_asc = "EVENT_ID_ASC"
    event_id_desc = "EVENT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_event_by_event_id__id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_ASC"
    ldata_node_event_by_event_id__id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_DESC"
    ldata_node_event_by_event_id__ldata_node_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_ASC"
    ldata_node_event_by_event_id__ldata_node_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_DESC"
    ldata_node_event_by_event_id__type_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_ASC"
    ldata_node_event_by_event_id__type_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_DESC"
    ldata_node_event_by_event_id__time_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_ASC"
    ldata_node_event_by_event_id__time_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_DESC"
    ldata_node_event_by_event_id__cause_account_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_ASC"
    ldata_node_event_by_event_id__cause_account_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_DESC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_ASC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_DESC"
    ldata_node_event_by_event_id__cause_dataset_download_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_ASC"
    ldata_node_event_by_event_id__cause_dataset_download_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_DESC"
    ldata_node_event_by_event_id__cause_ldata_process_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_ASC"
    ldata_node_event_by_event_id__cause_ldata_process_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_DESC"

class LdataNodeEventRemovesOrderBy(Enum):
    """
    Methods to use when ordering `LdataNodeEventRemove`.
    """
    natural = "NATURAL"
    event_id_asc = "EVENT_ID_ASC"
    event_id_desc = "EVENT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    ldata_node_event_by_event_id__id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_ASC"
    ldata_node_event_by_event_id__id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__ID_DESC"
    ldata_node_event_by_event_id__ldata_node_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_ASC"
    ldata_node_event_by_event_id__ldata_node_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__LDATA_NODE_ID_DESC"
    ldata_node_event_by_event_id__type_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_ASC"
    ldata_node_event_by_event_id__type_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TYPE_DESC"
    ldata_node_event_by_event_id__time_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_ASC"
    ldata_node_event_by_event_id__time_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__TIME_DESC"
    ldata_node_event_by_event_id__cause_account_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_ASC"
    ldata_node_event_by_event_id__cause_account_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_ACCOUNT_ID_DESC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_ASC"
    ldata_node_event_by_event_id__cause_execution_flytedb_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_EXECUTION_FLYTEDB_ID_DESC"
    ldata_node_event_by_event_id__cause_dataset_download_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_ASC"
    ldata_node_event_by_event_id__cause_dataset_download_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_DATASET_DOWNLOAD_ID_DESC"
    ldata_node_event_by_event_id__cause_ldata_process_id_asc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_ASC"
    ldata_node_event_by_event_id__cause_ldata_process_id_desc = "LDATA_NODE_EVENT_BY_EVENT_ID__CAUSE_LDATA_PROCESS_ID_DESC"

class LdataS3MountRolesOrderBy(Enum):
    """
    Methods to use when ordering `LdataS3MountRole`.
    """
    natural = "NATURAL"
    bucket_name_asc = "BUCKET_NAME_ASC"
    bucket_name_desc = "BUCKET_NAME_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    aws_account_id_asc = "AWS_ACCOUNT_ID_ASC"
    aws_account_id_desc = "AWS_ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class SharingReceiverSharedDataTypesOrderBy(Enum):
    """
    Methods to use when ordering `SharingReceiverSharedDataType`.
    """
    natural = "NATURAL"

class StripeSubscriptionInfosOrderBy(Enum):
    """
    Methods to use when ordering `StripeSubscriptionInfo`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    customer_id_asc = "CUSTOMER_ID_ASC"
    customer_id_desc = "CUSTOMER_ID_DESC"
    subscription_id_asc = "SUBSCRIPTION_ID_ASC"
    subscription_id_desc = "SUBSCRIPTION_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class TaskExecutionRuntimeInfosOrderBy(Enum):
    """
    Methods to use when ordering `TaskExecutionRuntimeInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    execution_flytedb_id_asc = "EXECUTION_FLYTEDB_ID_ASC"
    execution_flytedb_id_desc = "EXECUTION_FLYTEDB_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class TeamMemberSharedDataTypesOrderBy(Enum):
    """
    Methods to use when ordering `TeamMemberSharedDataType`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class UserInfosOrderBy(Enum):
    """
    Methods to use when ordering `UserInfo`.
    """
    natural = "NATURAL"
    id_asc = "ID_ASC"
    id_desc = "ID_DESC"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    auth0_sub_asc = "AUTH0_SUB_ASC"
    auth0_sub_desc = "AUTH0_SUB_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"
    team_infos_by_owner_id__count_asc = "TEAM_INFOS_BY_OWNER_ID__COUNT_ASC"
    team_infos_by_owner_id__count_desc = "TEAM_INFOS_BY_OWNER_ID__COUNT_DESC"
    team_members_by_user_id__count_asc = "TEAM_MEMBERS_BY_USER_ID__COUNT_ASC"
    team_members_by_user_id__count_desc = "TEAM_MEMBERS_BY_USER_ID__COUNT_DESC"
    workflow_personalizations_by_user_id__count_asc = "WORKFLOW_PERSONALIZATIONS_BY_USER_ID__COUNT_ASC"
    workflow_personalizations_by_user_id__count_desc = "WORKFLOW_PERSONALIZATIONS_BY_USER_ID__COUNT_DESC"
    catalog_events_by_cause_account_id__count_asc = "CATALOG_EVENTS_BY_CAUSE_ACCOUNT_ID__COUNT_ASC"
    catalog_events_by_cause_account_id__count_desc = "CATALOG_EVENTS_BY_CAUSE_ACCOUNT_ID__COUNT_DESC"
    account_access_policies_by_user_account_id__count_asc = "ACCOUNT_ACCESS_POLICIES_BY_USER_ACCOUNT_ID__COUNT_ASC"
    account_access_policies_by_user_account_id__count_desc = "ACCOUNT_ACCESS_POLICIES_BY_USER_ACCOUNT_ID__COUNT_DESC"
    dataset_agreement_activated_by_account_id__account_id_asc = "DATASET_AGREEMENT_ACTIVATED_BY_ACCOUNT_ID__ACCOUNT_ID_ASC"
    dataset_agreement_activated_by_account_id__account_id_desc = "DATASET_AGREEMENT_ACTIVATED_BY_ACCOUNT_ID__ACCOUNT_ID_DESC"
    dataset_purchases_by_purchased_by__count_asc = "DATASET_PURCHASES_BY_PURCHASED_BY__COUNT_ASC"
    dataset_purchases_by_purchased_by__count_desc = "DATASET_PURCHASES_BY_PURCHASED_BY__COUNT_DESC"
    dataset_requests_by_account_id__count_asc = "DATASET_REQUESTS_BY_ACCOUNT_ID__COUNT_ASC"
    dataset_requests_by_account_id__count_desc = "DATASET_REQUESTS_BY_ACCOUNT_ID__COUNT_DESC"

class WorkflowFamilyInfosOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowFamilyInfo`.
    """
    natural = "NATURAL"
    workflow_name_asc = "WORKFLOW_NAME_ASC"
    workflow_name_desc = "WORKFLOW_NAME_DESC"
    link_asc = "LINK_ASC"
    link_desc = "LINK_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"

class WorkflowGraphSubWfsOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowGraphSubWf`.
    """
    natural = "NATURAL"
    wgn_id_asc = "WGN_ID_ASC"
    wgn_id_desc = "WGN_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    workflow_graph_node_by_wgn_id__id_asc = "WORKFLOW_GRAPH_NODE_BY_WGN_ID__ID_ASC"
    workflow_graph_node_by_wgn_id__id_desc = "WORKFLOW_GRAPH_NODE_BY_WGN_ID__ID_DESC"
    workflow_graph_node_by_wgn_id__workflow_id_asc = "WORKFLOW_GRAPH_NODE_BY_WGN_ID__WORKFLOW_ID_ASC"
    workflow_graph_node_by_wgn_id__workflow_id_desc = "WORKFLOW_GRAPH_NODE_BY_WGN_ID__WORKFLOW_ID_DESC"
    workflow_graph_node_by_wgn_id__task_info_id_asc = "WORKFLOW_GRAPH_NODE_BY_WGN_ID__TASK_INFO_ID_ASC"
    workflow_graph_node_by_wgn_id__task_info_id_desc = "WORKFLOW_GRAPH_NODE_BY_WGN_ID__TASK_INFO_ID_DESC"

class WorkflowPreviewsOrderBy(Enum):
    """
    Methods to use when ordering `WorkflowPreview`.
    """
    natural = "NATURAL"
    account_id_asc = "ACCOUNT_ID_ASC"
    account_id_desc = "ACCOUNT_ID_DESC"
    primary_key_asc = "PRIMARY_KEY_ASC"
    primary_key_desc = "PRIMARY_KEY_DESC"
    account_info_by_account_id__id_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_ASC"
    account_info_by_account_id__id_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__ID_DESC"
    account_info_by_account_id__ldata_root_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_ASC"
    account_info_by_account_id__ldata_root_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__LDATA_ROOT_DESC"
    account_info_by_account_id__removed_asc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_ASC"
    account_info_by_account_id__removed_desc = "ACCOUNT_INFO_BY_ACCOUNT_ID__REMOVED_DESC"

class AutomationTriggerType(Enum):
    data_addition = "DATA_ADDITION"
    interval = "INTERVAL"

