# mypy-boto3-firehose

[![PyPI - mypy-boto3-firehose](https://img.shields.io/pypi/v/mypy-boto3-firehose.svg?color=blue)](https://pypi.org/project/mypy-boto3-firehose)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-firehose.svg?color=blue)](https://pypi.org/project/mypy-boto3-firehose)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Firehose 1.16.35](https://boto3.amazonaws.com/v1/documentation/api/1.16.35/reference/services/firehose.html#Firehose) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-firehose](#mypy-boto3-firehose)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Firehose` service.

```bash
python -m pip install boto3-stubs[firehose]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[firehose]` in your environment: `python -m pip install 'boto3-stubs[firehose]'`

Both type checking and auto-complete should work for `Firehose` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[firehose]` in your environment: `python -m pip install 'boto3-stubs[firehose]'`

Both type checking and auto-complete should work for `Firehose` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[firehose]` in your environment: `python -m pip install 'boto3-stubs[firehose]'`
- Run `mypy` as usual

Type checking should work for `Firehose` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[firehose]` in your environment: `python -m pip install 'boto3-stubs[firehose]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Firehose` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`FirehoseClient` provides annotations for `boto3.client("firehose")`.

```python
import boto3

from mypy_boto3_firehose import FirehoseClient

client: FirehoseClient = boto3.client("firehose")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: FirehoseClient = session.client("firehose")
```








### Typed dictionations

`mypy_boto3_firehose.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_firehose.type_defs import (
    BufferingHintsTypeDef,
    CloudWatchLoggingOptionsTypeDef,
    CopyCommandTypeDef,
    CreateDeliveryStreamOutputTypeDef,
    DataFormatConversionConfigurationTypeDef,
    DeliveryStreamDescriptionTypeDef,
    DeliveryStreamEncryptionConfigurationInputTypeDef,
    DeliveryStreamEncryptionConfigurationTypeDef,
    DescribeDeliveryStreamOutputTypeDef,
    DeserializerTypeDef,
    DestinationDescriptionTypeDef,
    ElasticsearchBufferingHintsTypeDef,
    ElasticsearchDestinationConfigurationTypeDef,
    ElasticsearchDestinationDescriptionTypeDef,
    ElasticsearchDestinationUpdateTypeDef,
    ElasticsearchRetryOptionsTypeDef,
    EncryptionConfigurationTypeDef,
    ExtendedS3DestinationConfigurationTypeDef,
    ExtendedS3DestinationDescriptionTypeDef,
    ExtendedS3DestinationUpdateTypeDef,
    FailureDescriptionTypeDef,
    HiveJsonSerDeTypeDef,
    HttpEndpointBufferingHintsTypeDef,
    HttpEndpointCommonAttributeTypeDef,
    HttpEndpointConfigurationTypeDef,
    HttpEndpointDescriptionTypeDef,
    HttpEndpointDestinationConfigurationTypeDef,
    HttpEndpointDestinationDescriptionTypeDef,
    HttpEndpointDestinationUpdateTypeDef,
    HttpEndpointRequestConfigurationTypeDef,
    HttpEndpointRetryOptionsTypeDef,
    InputFormatConfigurationTypeDef,
    KinesisStreamSourceConfigurationTypeDef,
    KinesisStreamSourceDescriptionTypeDef,
    KMSEncryptionConfigTypeDef,
    ListDeliveryStreamsOutputTypeDef,
    ListTagsForDeliveryStreamOutputTypeDef,
    OpenXJsonSerDeTypeDef,
    OrcSerDeTypeDef,
    OutputFormatConfigurationTypeDef,
    ParquetSerDeTypeDef,
    ProcessingConfigurationTypeDef,
    ProcessorParameterTypeDef,
    ProcessorTypeDef,
    PutRecordBatchOutputTypeDef,
    PutRecordBatchResponseEntryTypeDef,
    PutRecordOutputTypeDef,
    RecordTypeDef,
    RedshiftDestinationConfigurationTypeDef,
    RedshiftDestinationDescriptionTypeDef,
    RedshiftDestinationUpdateTypeDef,
    RedshiftRetryOptionsTypeDef,
    ResponseMetadata,
    S3DestinationConfigurationTypeDef,
    S3DestinationDescriptionTypeDef,
    S3DestinationUpdateTypeDef,
    SchemaConfigurationTypeDef,
    SerializerTypeDef,
    SourceDescriptionTypeDef,
    SplunkDestinationConfigurationTypeDef,
    SplunkDestinationDescriptionTypeDef,
    SplunkDestinationUpdateTypeDef,
    SplunkRetryOptionsTypeDef,
    TagTypeDef,
    VpcConfigurationDescriptionTypeDef,
    VpcConfigurationTypeDef,
)

def get_structure() -> BufferingHintsTypeDef:
    return {
      ...
    }
```
