# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### ApiObject <a name="org.cdk8s.ApiObject"></a>

#### Initializers <a name="org.cdk8s.ApiObject.Initializer"></a>

```java
import org.cdk8s.ApiObject;

ApiObject.Builder.create(Construct scope, java.lang.String id)
    .apiVersion(java.lang.String)
    .kind(java.lang.String)
//  .metadata(ApiObjectMetadata)
    .build();
```

##### `scope`<sup>Required</sup> <a name="org.cdk8s.ApiObject.parameter.scope"></a>

- *Type:* [`software.constructs.Construct`](#software.constructs.Construct)

the construct scope.

---

##### `id`<sup>Required</sup> <a name="org.cdk8s.ApiObject.parameter.id"></a>

- *Type:* `java.lang.String`

namespace.

---

##### `apiVersion`<sup>Required</sup> <a name="org.cdk8s.ApiObjectProps.parameter.apiVersion"></a>

- *Type:* `java.lang.String`

API version.

---

##### `kind`<sup>Required</sup> <a name="org.cdk8s.ApiObjectProps.parameter.kind"></a>

- *Type:* `java.lang.String`

Resource kind.

---

##### `metadata`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectProps.parameter.metadata"></a>

- *Type:* [`org.cdk8s.ApiObjectMetadata`](#org.cdk8s.ApiObjectMetadata)

Object metadata.

If `name` is not specified, an app-unique name will be allocated by the
framework based on the path of the construct within thes construct tree.

---

#### Methods <a name="Methods"></a>

##### `addDependency` <a name="org.cdk8s.ApiObject.addDependency"></a>

```java
public addDependency(IConstruct dependencies)
```

###### `dependencies`<sup>Required</sup> <a name="org.cdk8s.ApiObject.parameter.dependencies"></a>

- *Type:* [`software.constructs.IConstruct`](#software.constructs.IConstruct)

the dependencies to add.

---

##### `addJsonPatch` <a name="org.cdk8s.ApiObject.addJsonPatch"></a>

```java
public addJsonPatch(JsonPatch ops)
```

###### `ops`<sup>Required</sup> <a name="org.cdk8s.ApiObject.parameter.ops"></a>

- *Type:* [`org.cdk8s.JsonPatch`](#org.cdk8s.JsonPatch)

The JSON-Patch operations to apply.

---

##### `toJson` <a name="org.cdk8s.ApiObject.toJson"></a>

```java
public toJson()
```

#### Static Functions <a name="Static Functions"></a>

##### `of` <a name="org.cdk8s.ApiObject.of"></a>

```java
import org.cdk8s.ApiObject;

ApiObject.of(IConstruct c)
```

###### `c`<sup>Required</sup> <a name="org.cdk8s.ApiObject.parameter.c"></a>

- *Type:* [`software.constructs.IConstruct`](#software.constructs.IConstruct)

The higher-level construct.

---

#### Properties <a name="Properties"></a>

##### `apiGroup`<sup>Required</sup> <a name="org.cdk8s.ApiObject.property.apiGroup"></a>

```java
public java.lang.String getApiGroup();
```

- *Type:* `java.lang.String`

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="org.cdk8s.ApiObject.property.apiVersion"></a>

```java
public java.lang.String getApiVersion();
```

- *Type:* `java.lang.String`

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="org.cdk8s.ApiObject.property.chart"></a>

```java
public Chart getChart();
```

- *Type:* [`org.cdk8s.Chart`](#org.cdk8s.Chart)

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="org.cdk8s.ApiObject.property.kind"></a>

```java
public java.lang.String getKind();
```

- *Type:* `java.lang.String`

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="org.cdk8s.ApiObject.property.metadata"></a>

```java
public ApiObjectMetadataDefinition getMetadata();
```

- *Type:* [`org.cdk8s.ApiObjectMetadataDefinition`](#org.cdk8s.ApiObjectMetadataDefinition)

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="org.cdk8s.ApiObject.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* `java.lang.String`

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---


### App <a name="org.cdk8s.App"></a>

Represents a cdk8s application.

#### Initializers <a name="org.cdk8s.App.Initializer"></a>

```java
import org.cdk8s.App;

App.Builder.create()
//  .outdir(java.lang.String)
//  .outputFileExtension(java.lang.String)
//  .yamlOutputType(YamlOutputType)
    .build();
```

##### `outdir`<sup>Optional</sup> <a name="org.cdk8s.AppProps.parameter.outdir"></a>

- *Type:* `java.lang.String`
- *Default:* CDK8S_OUTDIR if defined, otherwise "dist"

The directory to output Kubernetes manifests.

---

##### `outputFileExtension`<sup>Optional</sup> <a name="org.cdk8s.AppProps.parameter.outputFileExtension"></a>

- *Type:* `java.lang.String`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yamlOutputType`<sup>Optional</sup> <a name="org.cdk8s.AppProps.parameter.yamlOutputType"></a>

- *Type:* [`org.cdk8s.YamlOutputType`](#org.cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---

#### Methods <a name="Methods"></a>

##### `synth` <a name="org.cdk8s.App.synth"></a>

```java
public synth()
```

##### `synthYaml` <a name="org.cdk8s.App.synthYaml"></a>

```java
public synthYaml()
```


#### Properties <a name="Properties"></a>

##### `charts`<sup>Required</sup> <a name="org.cdk8s.App.property.charts"></a>

```java
public java.util.List<Chart> getCharts();
```

- *Type:* java.util.List<[`org.cdk8s.Chart`](#org.cdk8s.Chart)>

Returns all the charts in this app, sorted topologically.

---

##### `outdir`<sup>Required</sup> <a name="org.cdk8s.App.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* `java.lang.String`

The output directory into which manifests will be synthesized.

---

##### `outputFileExtension`<sup>Required</sup> <a name="org.cdk8s.App.property.outputFileExtension"></a>

```java
public java.lang.String getOutputFileExtension();
```

- *Type:* `java.lang.String`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yamlOutputType`<sup>Required</sup> <a name="org.cdk8s.App.property.yamlOutputType"></a>

```java
public YamlOutputType getYamlOutputType();
```

- *Type:* [`org.cdk8s.YamlOutputType`](#org.cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---


### Chart <a name="org.cdk8s.Chart"></a>

#### Initializers <a name="org.cdk8s.Chart.Initializer"></a>

```java
import org.cdk8s.Chart;

Chart.Builder.create(Construct scope, java.lang.String id)
//  .labels(java.util.Map<java.lang.String, java.lang.String>)
//  .namespace(java.lang.String)
    .build();
```

##### `scope`<sup>Required</sup> <a name="org.cdk8s.Chart.parameter.scope"></a>

- *Type:* [`software.constructs.Construct`](#software.constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="org.cdk8s.Chart.parameter.id"></a>

- *Type:* `java.lang.String`

---

##### `labels`<sup>Optional</sup> <a name="org.cdk8s.ChartProps.parameter.labels"></a>

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>
- *Default:* no common labels

Labels to apply to all resources in this chart.

---

##### `namespace`<sup>Optional</sup> <a name="org.cdk8s.ChartProps.parameter.namespace"></a>

- *Type:* `java.lang.String`
- *Default:* no namespace is synthesized (usually this implies "default")

The default namespace for all objects defined in this chart (directly or indirectly).

This namespace will only apply to objects that don't have a
`namespace` explicitly defined for them.

---

#### Methods <a name="Methods"></a>

##### `addDependency` <a name="org.cdk8s.Chart.addDependency"></a>

```java
public addDependency(IConstruct dependencies)
```

###### `dependencies`<sup>Required</sup> <a name="org.cdk8s.Chart.parameter.dependencies"></a>

- *Type:* [`software.constructs.IConstruct`](#software.constructs.IConstruct)

the dependencies to add.

---

##### `generateObjectName` <a name="org.cdk8s.Chart.generateObjectName"></a>

```java
public generateObjectName(ApiObject apiObject)
```

###### `apiObject`<sup>Required</sup> <a name="org.cdk8s.Chart.parameter.apiObject"></a>

- *Type:* [`org.cdk8s.ApiObject`](#org.cdk8s.ApiObject)

The API object to generate a name for.

---

##### `toJson` <a name="org.cdk8s.Chart.toJson"></a>

```java
public toJson()
```

#### Static Functions <a name="Static Functions"></a>

##### `isChart` <a name="org.cdk8s.Chart.isChart"></a>

```java
import org.cdk8s.Chart;

Chart.isChart(java.lang.Object x)
```

###### `x`<sup>Required</sup> <a name="org.cdk8s.Chart.parameter.x"></a>

- *Type:* `java.lang.Object`

---

##### `of` <a name="org.cdk8s.Chart.of"></a>

```java
import org.cdk8s.Chart;

Chart.of(IConstruct c)
```

###### `c`<sup>Required</sup> <a name="org.cdk8s.Chart.parameter.c"></a>

- *Type:* [`software.constructs.IConstruct`](#software.constructs.IConstruct)

a construct node.

---

#### Properties <a name="Properties"></a>

##### `labels`<sup>Required</sup> <a name="org.cdk8s.Chart.property.labels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getLabels();
```

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>

Labels applied to all resources in this chart.

This is an immutable copy.

---

##### `namespace`<sup>Optional</sup> <a name="org.cdk8s.Chart.property.namespace"></a>

```java
public java.lang.String getNamespace();
```

- *Type:* `java.lang.String`

The default namespace for all objects in this chart.

---


### Helm <a name="org.cdk8s.Helm"></a>

Represents a Helm deployment.

Use this construct to import an existing Helm chart and incorporate it into your constructs.

#### Initializers <a name="org.cdk8s.Helm.Initializer"></a>

```java
import org.cdk8s.Helm;

Helm.Builder.create(Construct scope, java.lang.String id)
    .chart(java.lang.String)
//  .helmExecutable(java.lang.String)
//  .helmFlags(java.util.List<java.lang.String>)
//  .releaseName(java.lang.String)
//  .values(java.util.Map<java.lang.String, java.lang.Object>)
    .build();
```

##### `scope`<sup>Required</sup> <a name="org.cdk8s.Helm.parameter.scope"></a>

- *Type:* [`software.constructs.Construct`](#software.constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="org.cdk8s.Helm.parameter.id"></a>

- *Type:* `java.lang.String`

---

##### `chart`<sup>Required</sup> <a name="org.cdk8s.HelmProps.parameter.chart"></a>

- *Type:* `java.lang.String`

The chart name to use. It can be a chart from a helm repository or a local directory.

This name is passed to `helm template` and has all the relevant semantics.

---

##### `helmExecutable`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.parameter.helmExecutable"></a>

- *Type:* `java.lang.String`
- *Default:* "helm"

The local helm executable to use in order to create the manifest the chart.

---

##### `helmFlags`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.parameter.helmFlags"></a>

- *Type:* java.util.List<`java.lang.String`>
- *Default:* []

Additional flags to add to the `helm` execution.

---

##### `releaseName`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.parameter.releaseName"></a>

- *Type:* `java.lang.String`
- *Default:* if unspecified, a name will be allocated based on the construct path

The release name.

> https://helm.sh/docs/intro/using_helm/#three-big-concepts

---

##### `values`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.parameter.values"></a>

- *Type:* java.util.Map<java.lang.String, `java.lang.Object`>
- *Default:* If no values are specified, chart will use the defaults.

Values to pass to the chart.

---



#### Properties <a name="Properties"></a>

##### `releaseName`<sup>Required</sup> <a name="org.cdk8s.Helm.property.releaseName"></a>

```java
public java.lang.String getReleaseName();
```

- *Type:* `java.lang.String`

The helm release name.

---


### Include <a name="org.cdk8s.Include"></a>

Reads a YAML manifest from a file or a URL and defines all resources as API objects within the defined scope.

The names (`metadata.name`) of imported resources will be preserved as-is
from the manifest.

#### Initializers <a name="org.cdk8s.Include.Initializer"></a>

```java
import org.cdk8s.Include;

Include.Builder.create(Construct scope, java.lang.String id)
    .url(java.lang.String)
    .build();
```

##### `scope`<sup>Required</sup> <a name="org.cdk8s.Include.parameter.scope"></a>

- *Type:* [`software.constructs.Construct`](#software.constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="org.cdk8s.Include.parameter.id"></a>

- *Type:* `java.lang.String`

---

##### `url`<sup>Required</sup> <a name="org.cdk8s.IncludeProps.parameter.url"></a>

- *Type:* `java.lang.String`

Local file path or URL which includes a Kubernetes YAML manifest.

---



#### Properties <a name="Properties"></a>

##### `apiObjects`<sup>Required</sup> <a name="org.cdk8s.Include.property.apiObjects"></a>

```java
public java.util.List<ApiObject> getApiObjects();
```

- *Type:* java.util.List<[`org.cdk8s.ApiObject`](#org.cdk8s.ApiObject)>

Returns all the included API objects.

---


## Structs <a name="Structs"></a>

### ApiObjectMetadata <a name="org.cdk8s.ApiObjectMetadata"></a>

Metadata associated with this object.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.ApiObjectMetadata;

ApiObjectMetadata.builder()
//  .annotations(java.util.Map<java.lang.String, java.lang.String>)
//  .finalizers(java.util.List<java.lang.String>)
//  .labels(java.util.Map<java.lang.String, java.lang.String>)
//  .name(java.lang.String)
//  .namespace(java.lang.String)
//  .ownerReferences(java.util.List<OwnerReference>)
    .build();
```

##### `annotations`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.property.annotations"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getAnnotations();
```

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>
- *Default:* No annotations.

Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

They are not queryable and should be
preserved when modifying objects.

> http://kubernetes.io/docs/user-guide/annotations

---

##### `finalizers`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.property.finalizers"></a>

```java
public java.util.List<java.lang.String> getFinalizers();
```

- *Type:* java.util.List<`java.lang.String`>
- *Default:* No finalizers.

Namespaced keys that tell Kubernetes to wait until specific conditions are met before it fully deletes resources marked for deletion.

Must be empty before the object is deleted from the registry. Each entry is
an identifier for the responsible component that will remove the entry from
the list. If the deletionTimestamp of the object is non-nil, entries in
this list can only be removed. Finalizers may be processed and removed in
any order.  Order is NOT enforced because it introduces significant risk of
stuck finalizers. finalizers is a shared field, any actor with permission
can reorder it. If the finalizer list is processed in order, then this can
lead to a situation in which the component responsible for the first
finalizer in the list is waiting for a signal (field value, external
system, or other) produced by a component responsible for a finalizer later
in the list, resulting in a deadlock. Without enforced ordering finalizers
are free to order amongst themselves and are not vulnerable to ordering
changes in the list.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/finalizers/

---

##### `labels`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.property.labels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getLabels();
```

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>
- *Default:* No labels.

Map of string keys and values that can be used to organize and categorize (scope and select) objects.

May match selectors of replication controllers and services.

> http://kubernetes.io/docs/user-guide/labels

---

##### `name`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* `java.lang.String`
- *Default:* an app-unique name generated by the chart

The unique, namespace-global, name of this object inside the Kubernetes cluster.

Normally, you shouldn't specify names for objects and let the CDK generate
a name for you that is application-unique. The names CDK generates are
composed from the construct path components, separated by dots and a suffix
that is based on a hash of the entire path, to ensure uniqueness.

You can supply custom name allocation logic by overriding the
`chart.generateObjectName` method.

If you use an explicit name here, bear in mind that this reduces the
composability of your construct because it won't be possible to include
more than one instance in any app. Therefore it is highly recommended to
leave this unspecified.

---

##### `namespace`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.property.namespace"></a>

```java
public java.lang.String getNamespace();
```

- *Type:* `java.lang.String`
- *Default:* undefined (will be assigned to the 'default' namespace)

Namespace defines the space within each name must be unique.

An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation.
Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty. Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces

---

##### `ownerReferences`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.property.ownerReferences"></a>

```java
public java.util.List<OwnerReference> getOwnerReferences();
```

- *Type:* java.util.List<[`org.cdk8s.OwnerReference`](#org.cdk8s.OwnerReference)>
- *Default:* automatically set by Kubernetes

List of objects depended by this object.

If ALL objects in the list have
been deleted, this object will be garbage collected. If this object is
managed by a controller, then an entry in this list will point to this
controller, with the controller field set to true. There cannot be more
than one managing controller.

Kubernetes sets the value of this field automatically for objects that are
dependents of other objects like ReplicaSets, DaemonSets, Deployments, Jobs
and CronJobs, and ReplicationControllers. You can also configure these
relationships manually by changing the value of this field. However, you
usually don't need to and can allow Kubernetes to automatically manage the
relationships.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/owners-dependents/

---

### ApiObjectProps <a name="org.cdk8s.ApiObjectProps"></a>

Options for defining API objects.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.ApiObjectProps;

ApiObjectProps.builder()
    .apiVersion(java.lang.String)
    .kind(java.lang.String)
//  .metadata(ApiObjectMetadata)
    .build();
```

##### `apiVersion`<sup>Required</sup> <a name="org.cdk8s.ApiObjectProps.property.apiVersion"></a>

```java
public java.lang.String getApiVersion();
```

- *Type:* `java.lang.String`

API version.

---

##### `kind`<sup>Required</sup> <a name="org.cdk8s.ApiObjectProps.property.kind"></a>

```java
public java.lang.String getKind();
```

- *Type:* `java.lang.String`

Resource kind.

---

##### `metadata`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectProps.property.metadata"></a>

```java
public ApiObjectMetadata getMetadata();
```

- *Type:* [`org.cdk8s.ApiObjectMetadata`](#org.cdk8s.ApiObjectMetadata)

Object metadata.

If `name` is not specified, an app-unique name will be allocated by the
framework based on the path of the construct within thes construct tree.

---

### AppProps <a name="org.cdk8s.AppProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.AppProps;

AppProps.builder()
//  .outdir(java.lang.String)
//  .outputFileExtension(java.lang.String)
//  .yamlOutputType(YamlOutputType)
    .build();
```

##### `outdir`<sup>Optional</sup> <a name="org.cdk8s.AppProps.property.outdir"></a>

```java
public java.lang.String getOutdir();
```

- *Type:* `java.lang.String`
- *Default:* CDK8S_OUTDIR if defined, otherwise "dist"

The directory to output Kubernetes manifests.

---

##### `outputFileExtension`<sup>Optional</sup> <a name="org.cdk8s.AppProps.property.outputFileExtension"></a>

```java
public java.lang.String getOutputFileExtension();
```

- *Type:* `java.lang.String`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yamlOutputType`<sup>Optional</sup> <a name="org.cdk8s.AppProps.property.yamlOutputType"></a>

```java
public YamlOutputType getYamlOutputType();
```

- *Type:* [`org.cdk8s.YamlOutputType`](#org.cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---

### ChartProps <a name="org.cdk8s.ChartProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.ChartProps;

ChartProps.builder()
//  .labels(java.util.Map<java.lang.String, java.lang.String>)
//  .namespace(java.lang.String)
    .build();
```

##### `labels`<sup>Optional</sup> <a name="org.cdk8s.ChartProps.property.labels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getLabels();
```

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>
- *Default:* no common labels

Labels to apply to all resources in this chart.

---

##### `namespace`<sup>Optional</sup> <a name="org.cdk8s.ChartProps.property.namespace"></a>

```java
public java.lang.String getNamespace();
```

- *Type:* `java.lang.String`
- *Default:* no namespace is synthesized (usually this implies "default")

The default namespace for all objects defined in this chart (directly or indirectly).

This namespace will only apply to objects that don't have a
`namespace` explicitly defined for them.

---

### CronOptions <a name="org.cdk8s.CronOptions"></a>

Options to configure a cron expression.

All fields are strings so you can use complex expressions. Absence of
a field implies '*'

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.CronOptions;

CronOptions.builder()
//  .day(java.lang.String)
//  .hour(java.lang.String)
//  .minute(java.lang.String)
//  .month(java.lang.String)
//  .weekDay(java.lang.String)
    .build();
```

##### `day`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.property.day"></a>

```java
public java.lang.String getDay();
```

- *Type:* `java.lang.String`
- *Default:* Every day of the month

The day of the month to run this rule at.

---

##### `hour`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.property.hour"></a>

```java
public java.lang.String getHour();
```

- *Type:* `java.lang.String`
- *Default:* Every hour

The hour to run this rule at.

---

##### `minute`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.property.minute"></a>

```java
public java.lang.String getMinute();
```

- *Type:* `java.lang.String`
- *Default:* Every minute

The minute to run this rule at.

---

##### `month`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.property.month"></a>

```java
public java.lang.String getMonth();
```

- *Type:* `java.lang.String`
- *Default:* Every month

The month to run this rule at.

---

##### `weekDay`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.property.weekDay"></a>

```java
public java.lang.String getWeekDay();
```

- *Type:* `java.lang.String`
- *Default:* Any day of the week

The day of the week to run this rule at.

---

### GroupVersionKind <a name="org.cdk8s.GroupVersionKind"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.GroupVersionKind;

GroupVersionKind.builder()
    .apiVersion(java.lang.String)
    .kind(java.lang.String)
    .build();
```

##### `apiVersion`<sup>Required</sup> <a name="org.cdk8s.GroupVersionKind.property.apiVersion"></a>

```java
public java.lang.String getApiVersion();
```

- *Type:* `java.lang.String`

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `kind`<sup>Required</sup> <a name="org.cdk8s.GroupVersionKind.property.kind"></a>

```java
public java.lang.String getKind();
```

- *Type:* `java.lang.String`

The object kind.

---

### HelmProps <a name="org.cdk8s.HelmProps"></a>

Options for `Helm`.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.HelmProps;

HelmProps.builder()
    .chart(java.lang.String)
//  .helmExecutable(java.lang.String)
//  .helmFlags(java.util.List<java.lang.String>)
//  .releaseName(java.lang.String)
//  .values(java.util.Map<java.lang.String, java.lang.Object>)
    .build();
```

##### `chart`<sup>Required</sup> <a name="org.cdk8s.HelmProps.property.chart"></a>

```java
public java.lang.String getChart();
```

- *Type:* `java.lang.String`

The chart name to use. It can be a chart from a helm repository or a local directory.

This name is passed to `helm template` and has all the relevant semantics.

---

##### `helmExecutable`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.property.helmExecutable"></a>

```java
public java.lang.String getHelmExecutable();
```

- *Type:* `java.lang.String`
- *Default:* "helm"

The local helm executable to use in order to create the manifest the chart.

---

##### `helmFlags`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.property.helmFlags"></a>

```java
public java.util.List<java.lang.String> getHelmFlags();
```

- *Type:* java.util.List<`java.lang.String`>
- *Default:* []

Additional flags to add to the `helm` execution.

---

##### `releaseName`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.property.releaseName"></a>

```java
public java.lang.String getReleaseName();
```

- *Type:* `java.lang.String`
- *Default:* if unspecified, a name will be allocated based on the construct path

The release name.

> https://helm.sh/docs/intro/using_helm/#three-big-concepts

---

##### `values`<sup>Optional</sup> <a name="org.cdk8s.HelmProps.property.values"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getValues();
```

- *Type:* java.util.Map<java.lang.String, `java.lang.Object`>
- *Default:* If no values are specified, chart will use the defaults.

Values to pass to the chart.

---

### IncludeProps <a name="org.cdk8s.IncludeProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.IncludeProps;

IncludeProps.builder()
    .url(java.lang.String)
    .build();
```

##### `url`<sup>Required</sup> <a name="org.cdk8s.IncludeProps.property.url"></a>

```java
public java.lang.String getUrl();
```

- *Type:* `java.lang.String`

Local file path or URL which includes a Kubernetes YAML manifest.

---

### NameOptions <a name="org.cdk8s.NameOptions"></a>

Options for name generation.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.NameOptions;

NameOptions.builder()
//  .delimiter(java.lang.String)
//  .extra(java.util.List<java.lang.String>)
//  .includeHash(java.lang.Boolean)
//  .maxLen(java.lang.Number)
    .build();
```

##### `delimiter`<sup>Optional</sup> <a name="org.cdk8s.NameOptions.property.delimiter"></a>

```java
public java.lang.String getDelimiter();
```

- *Type:* `java.lang.String`
- *Default:* "-"

Delimiter to use between components.

---

##### `extra`<sup>Optional</sup> <a name="org.cdk8s.NameOptions.property.extra"></a>

```java
public java.util.List<java.lang.String> getExtra();
```

- *Type:* java.util.List<`java.lang.String`>
- *Default:* [] use the construct path components

Extra components to include in the name.

---

##### `includeHash`<sup>Optional</sup> <a name="org.cdk8s.NameOptions.property.includeHash"></a>

```java
public java.lang.Boolean getIncludeHash();
```

- *Type:* `java.lang.Boolean`
- *Default:* true

Include a short hash as last part of the name.

---

##### `maxLen`<sup>Optional</sup> <a name="org.cdk8s.NameOptions.property.maxLen"></a>

```java
public java.lang.Number getMaxLen();
```

- *Type:* `java.lang.Number`
- *Default:* 63

Maximum allowed length for the name.

---

### OwnerReference <a name="org.cdk8s.OwnerReference"></a>

OwnerReference contains enough information to let you identify an owning object.

An owning object must be in the same namespace as the dependent, or
be cluster-scoped, so there is no namespace field.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.OwnerReference;

OwnerReference.builder()
    .apiVersion(java.lang.String)
    .kind(java.lang.String)
    .name(java.lang.String)
    .uid(java.lang.String)
//  .blockOwnerDeletion(java.lang.Boolean)
//  .controller(java.lang.Boolean)
    .build();
```

##### `apiVersion`<sup>Required</sup> <a name="org.cdk8s.OwnerReference.property.apiVersion"></a>

```java
public java.lang.String getApiVersion();
```

- *Type:* `java.lang.String`

API version of the referent.

---

##### `kind`<sup>Required</sup> <a name="org.cdk8s.OwnerReference.property.kind"></a>

```java
public java.lang.String getKind();
```

- *Type:* `java.lang.String`

Kind of the referent.

> https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

---

##### `name`<sup>Required</sup> <a name="org.cdk8s.OwnerReference.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* `java.lang.String`

Name of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#names

---

##### `uid`<sup>Required</sup> <a name="org.cdk8s.OwnerReference.property.uid"></a>

```java
public java.lang.String getUid();
```

- *Type:* `java.lang.String`

UID of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#uids

---

##### `blockOwnerDeletion`<sup>Optional</sup> <a name="org.cdk8s.OwnerReference.property.blockOwnerDeletion"></a>

```java
public java.lang.Boolean getBlockOwnerDeletion();
```

- *Type:* `java.lang.Boolean`
- *Default:* false. To set this field, a user needs "delete" permission of the
owner, otherwise 422 (Unprocessable Entity) will be returned.

If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed.

Defaults to false. To set this field, a user needs "delete"
permission of the owner, otherwise 422 (Unprocessable Entity) will be
returned.

---

##### `controller`<sup>Optional</sup> <a name="org.cdk8s.OwnerReference.property.controller"></a>

```java
public java.lang.Boolean getController();
```

- *Type:* `java.lang.Boolean`

If true, this reference points to the managing controller.

---

### SizeConversionOptions <a name="org.cdk8s.SizeConversionOptions"></a>

Options for how to convert time to a different unit.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.SizeConversionOptions;

SizeConversionOptions.builder()
//  .rounding(SizeRoundingBehavior)
    .build();
```

##### `rounding`<sup>Optional</sup> <a name="org.cdk8s.SizeConversionOptions.property.rounding"></a>

```java
public SizeRoundingBehavior getRounding();
```

- *Type:* [`org.cdk8s.SizeRoundingBehavior`](#org.cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

### TimeConversionOptions <a name="org.cdk8s.TimeConversionOptions"></a>

Options for how to convert time to a different unit.

#### Initializer <a name="[object Object].Initializer"></a>

```java
import org.cdk8s.TimeConversionOptions;

TimeConversionOptions.builder()
//  .integral(java.lang.Boolean)
    .build();
```

##### `integral`<sup>Optional</sup> <a name="org.cdk8s.TimeConversionOptions.property.integral"></a>

```java
public java.lang.Boolean getIntegral();
```

- *Type:* `java.lang.Boolean`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

## Classes <a name="Classes"></a>

### ApiObjectMetadataDefinition <a name="org.cdk8s.ApiObjectMetadataDefinition"></a>

Object metadata.

#### Initializers <a name="org.cdk8s.ApiObjectMetadataDefinition.Initializer"></a>

```java
import org.cdk8s.ApiObjectMetadataDefinition;

ApiObjectMetadataDefinition.Builder.create()
//  .annotations(java.util.Map<java.lang.String, java.lang.String>)
//  .finalizers(java.util.List<java.lang.String>)
//  .labels(java.util.Map<java.lang.String, java.lang.String>)
//  .name(java.lang.String)
//  .namespace(java.lang.String)
//  .ownerReferences(java.util.List<OwnerReference>)
    .build();
```

##### `annotations`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.parameter.annotations"></a>

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>
- *Default:* No annotations.

Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

They are not queryable and should be
preserved when modifying objects.

> http://kubernetes.io/docs/user-guide/annotations

---

##### `finalizers`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.parameter.finalizers"></a>

- *Type:* java.util.List<`java.lang.String`>
- *Default:* No finalizers.

Namespaced keys that tell Kubernetes to wait until specific conditions are met before it fully deletes resources marked for deletion.

Must be empty before the object is deleted from the registry. Each entry is
an identifier for the responsible component that will remove the entry from
the list. If the deletionTimestamp of the object is non-nil, entries in
this list can only be removed. Finalizers may be processed and removed in
any order.  Order is NOT enforced because it introduces significant risk of
stuck finalizers. finalizers is a shared field, any actor with permission
can reorder it. If the finalizer list is processed in order, then this can
lead to a situation in which the component responsible for the first
finalizer in the list is waiting for a signal (field value, external
system, or other) produced by a component responsible for a finalizer later
in the list, resulting in a deadlock. Without enforced ordering finalizers
are free to order amongst themselves and are not vulnerable to ordering
changes in the list.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/finalizers/

---

##### `labels`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.parameter.labels"></a>

- *Type:* java.util.Map<java.lang.String, `java.lang.String`>
- *Default:* No labels.

Map of string keys and values that can be used to organize and categorize (scope and select) objects.

May match selectors of replication controllers and services.

> http://kubernetes.io/docs/user-guide/labels

---

##### `name`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.parameter.name"></a>

- *Type:* `java.lang.String`
- *Default:* an app-unique name generated by the chart

The unique, namespace-global, name of this object inside the Kubernetes cluster.

Normally, you shouldn't specify names for objects and let the CDK generate
a name for you that is application-unique. The names CDK generates are
composed from the construct path components, separated by dots and a suffix
that is based on a hash of the entire path, to ensure uniqueness.

You can supply custom name allocation logic by overriding the
`chart.generateObjectName` method.

If you use an explicit name here, bear in mind that this reduces the
composability of your construct because it won't be possible to include
more than one instance in any app. Therefore it is highly recommended to
leave this unspecified.

---

##### `namespace`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.parameter.namespace"></a>

- *Type:* `java.lang.String`
- *Default:* undefined (will be assigned to the 'default' namespace)

Namespace defines the space within each name must be unique.

An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation.
Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty. Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces

---

##### `ownerReferences`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadata.parameter.ownerReferences"></a>

- *Type:* java.util.List<[`org.cdk8s.OwnerReference`](#org.cdk8s.OwnerReference)>
- *Default:* automatically set by Kubernetes

List of objects depended by this object.

If ALL objects in the list have
been deleted, this object will be garbage collected. If this object is
managed by a controller, then an entry in this list will point to this
controller, with the controller field set to true. There cannot be more
than one managing controller.

Kubernetes sets the value of this field automatically for objects that are
dependents of other objects like ReplicaSets, DaemonSets, Deployments, Jobs
and CronJobs, and ReplicationControllers. You can also configure these
relationships manually by changing the value of this field. However, you
usually don't need to and can allow Kubernetes to automatically manage the
relationships.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/owners-dependents/

---

#### Methods <a name="Methods"></a>

##### `add` <a name="org.cdk8s.ApiObjectMetadataDefinition.add"></a>

```java
public add(java.lang.String key, java.lang.Object value)
```

###### `key`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `java.lang.String`

Metadata key.

---

###### `value`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `java.lang.Object`

Metadata value.

---

##### `addAnnotation` <a name="org.cdk8s.ApiObjectMetadataDefinition.addAnnotation"></a>

```java
public addAnnotation(java.lang.String key, java.lang.String value)
```

###### `key`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `java.lang.String`

The key.

---

###### `value`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `java.lang.String`

The value.

---

##### `addFinalizers` <a name="org.cdk8s.ApiObjectMetadataDefinition.addFinalizers"></a>

```java
public addFinalizers(java.lang.String finalizers)
```

###### `finalizers`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.finalizers"></a>

- *Type:* `java.lang.String`

the finalizers.

---

##### `addLabel` <a name="org.cdk8s.ApiObjectMetadataDefinition.addLabel"></a>

```java
public addLabel(java.lang.String key, java.lang.String value)
```

###### `key`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `java.lang.String`

The key.

---

###### `value`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `java.lang.String`

The value.

---

##### `addOwnerReference` <a name="org.cdk8s.ApiObjectMetadataDefinition.addOwnerReference"></a>

```java
public addOwnerReference(OwnerReference owner)
```

###### `owner`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.owner"></a>

- *Type:* [`org.cdk8s.OwnerReference`](#org.cdk8s.OwnerReference)

the owner.

---

##### `getLabel` <a name="org.cdk8s.ApiObjectMetadataDefinition.getLabel"></a>

```java
public getLabel(java.lang.String key)
```

###### `key`<sup>Required</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `java.lang.String`

the label.

---

##### `toJson` <a name="org.cdk8s.ApiObjectMetadataDefinition.toJson"></a>

```java
public toJson()
```


#### Properties <a name="Properties"></a>

##### `name`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* `java.lang.String`

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

##### `namespace`<sup>Optional</sup> <a name="org.cdk8s.ApiObjectMetadataDefinition.property.namespace"></a>

```java
public java.lang.String getNamespace();
```

- *Type:* `java.lang.String`

The object's namespace.

---


### Cron <a name="org.cdk8s.Cron"></a>

Represents a cron schedule.

#### Initializers <a name="org.cdk8s.Cron.Initializer"></a>

```java
import org.cdk8s.Cron;

Cron.Builder.create()
//  .day(java.lang.String)
//  .hour(java.lang.String)
//  .minute(java.lang.String)
//  .month(java.lang.String)
//  .weekDay(java.lang.String)
    .build();
```

##### `day`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.parameter.day"></a>

- *Type:* `java.lang.String`
- *Default:* Every day of the month

The day of the month to run this rule at.

---

##### `hour`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.parameter.hour"></a>

- *Type:* `java.lang.String`
- *Default:* Every hour

The hour to run this rule at.

---

##### `minute`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.parameter.minute"></a>

- *Type:* `java.lang.String`
- *Default:* Every minute

The minute to run this rule at.

---

##### `month`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.parameter.month"></a>

- *Type:* `java.lang.String`
- *Default:* Every month

The month to run this rule at.

---

##### `weekDay`<sup>Optional</sup> <a name="org.cdk8s.CronOptions.parameter.weekDay"></a>

- *Type:* `java.lang.String`
- *Default:* Any day of the week

The day of the week to run this rule at.

---


#### Static Functions <a name="Static Functions"></a>

##### `annually` <a name="org.cdk8s.Cron.annually"></a>

```java
import org.cdk8s.Cron;

Cron.annually()
```

##### `daily` <a name="org.cdk8s.Cron.daily"></a>

```java
import org.cdk8s.Cron;

Cron.daily()
```

##### `everyMinute` <a name="org.cdk8s.Cron.everyMinute"></a>

```java
import org.cdk8s.Cron;

Cron.everyMinute()
```

##### `hourly` <a name="org.cdk8s.Cron.hourly"></a>

```java
import org.cdk8s.Cron;

Cron.hourly()
```

##### `monthly` <a name="org.cdk8s.Cron.monthly"></a>

```java
import org.cdk8s.Cron;

Cron.monthly()
```

##### `schedule` <a name="org.cdk8s.Cron.schedule"></a>

```java
import org.cdk8s.Cron;

Cron.schedule(CronOptions options)
```

###### `options`<sup>Required</sup> <a name="org.cdk8s.Cron.parameter.options"></a>

- *Type:* [`org.cdk8s.CronOptions`](#org.cdk8s.CronOptions)

---

##### `weekly` <a name="org.cdk8s.Cron.weekly"></a>

```java
import org.cdk8s.Cron;

Cron.weekly()
```

#### Properties <a name="Properties"></a>

##### `expressionString`<sup>Required</sup> <a name="org.cdk8s.Cron.property.expressionString"></a>

```java
public java.lang.String getExpressionString();
```

- *Type:* `java.lang.String`

Retrieve the expression for this schedule.

---


### DependencyGraph <a name="org.cdk8s.DependencyGraph"></a>

Represents the dependency graph for a given Node.

This graph includes the dependency relationships between all nodes in the
node (construct) sub-tree who's root is this Node.

Note that this means that lonely nodes (no dependencies and no dependants) are also included in this graph as
childless children of the root node of the graph.

The graph does not include cross-scope dependencies. That is, if a child on the current scope depends on a node
from a different scope, that relationship is not represented in this graph.

#### Initializers <a name="org.cdk8s.DependencyGraph.Initializer"></a>

```java
import org.cdk8s.DependencyGraph;

new DependencyGraph(Node node);
```

##### `node`<sup>Required</sup> <a name="org.cdk8s.DependencyGraph.parameter.node"></a>

- *Type:* [`software.constructs.Node`](#software.constructs.Node)

---

#### Methods <a name="Methods"></a>

##### `topology` <a name="org.cdk8s.DependencyGraph.topology"></a>

```java
public topology()
```


#### Properties <a name="Properties"></a>

##### `root`<sup>Required</sup> <a name="org.cdk8s.DependencyGraph.property.root"></a>

```java
public DependencyVertex getRoot();
```

- *Type:* [`org.cdk8s.DependencyVertex`](#org.cdk8s.DependencyVertex)

Returns the root of the graph.

Note that this vertex will always have `null` as its `.value` since it is an artifical root
that binds all the connected spaces of the graph.

---


### DependencyVertex <a name="org.cdk8s.DependencyVertex"></a>

Represents a vertex in the graph.

The value of each vertex is an `IConstruct` that is accessible via the `.value` getter.

#### Initializers <a name="org.cdk8s.DependencyVertex.Initializer"></a>

```java
import org.cdk8s.DependencyVertex;

new DependencyVertex();
new DependencyVertex(IConstruct value);
```

##### `value`<sup>Optional</sup> <a name="org.cdk8s.DependencyVertex.parameter.value"></a>

- *Type:* [`software.constructs.IConstruct`](#software.constructs.IConstruct)

---

#### Methods <a name="Methods"></a>

##### `addChild` <a name="org.cdk8s.DependencyVertex.addChild"></a>

```java
public addChild(DependencyVertex dep)
```

###### `dep`<sup>Required</sup> <a name="org.cdk8s.DependencyVertex.parameter.dep"></a>

- *Type:* [`org.cdk8s.DependencyVertex`](#org.cdk8s.DependencyVertex)

The dependency.

---

##### `topology` <a name="org.cdk8s.DependencyVertex.topology"></a>

```java
public topology()
```


#### Properties <a name="Properties"></a>

##### `inbound`<sup>Required</sup> <a name="org.cdk8s.DependencyVertex.property.inbound"></a>

```java
public java.util.List<DependencyVertex> getInbound();
```

- *Type:* java.util.List<[`org.cdk8s.DependencyVertex`](#org.cdk8s.DependencyVertex)>

Returns the parents of the vertex (i.e dependants).

---

##### `outbound`<sup>Required</sup> <a name="org.cdk8s.DependencyVertex.property.outbound"></a>

```java
public java.util.List<DependencyVertex> getOutbound();
```

- *Type:* java.util.List<[`org.cdk8s.DependencyVertex`](#org.cdk8s.DependencyVertex)>

Returns the children of the vertex (i.e dependencies).

---

##### `value`<sup>Optional</sup> <a name="org.cdk8s.DependencyVertex.property.value"></a>

```java
public IConstruct getValue();
```

- *Type:* [`software.constructs.IConstruct`](#software.constructs.IConstruct)

Returns the IConstruct this graph vertex represents.

`null` in case this is the root of the graph.

---


### Duration <a name="org.cdk8s.Duration"></a>

Represents a length of time.

The amount can be specified either as a literal value (e.g: `10`) which
cannot be negative.

#### Methods <a name="Methods"></a>

##### `toDays` <a name="org.cdk8s.Duration.toDays"></a>

```java
public toDays()
public toDays(TimeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Duration.parameter.opts"></a>

- *Type:* [`org.cdk8s.TimeConversionOptions`](#org.cdk8s.TimeConversionOptions)

---

##### `toHours` <a name="org.cdk8s.Duration.toHours"></a>

```java
public toHours()
public toHours(TimeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Duration.parameter.opts"></a>

- *Type:* [`org.cdk8s.TimeConversionOptions`](#org.cdk8s.TimeConversionOptions)

---

##### `toHumanString` <a name="org.cdk8s.Duration.toHumanString"></a>

```java
public toHumanString()
```

##### `toIsoString` <a name="org.cdk8s.Duration.toIsoString"></a>

```java
public toIsoString()
```

##### `toMilliseconds` <a name="org.cdk8s.Duration.toMilliseconds"></a>

```java
public toMilliseconds()
public toMilliseconds(TimeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Duration.parameter.opts"></a>

- *Type:* [`org.cdk8s.TimeConversionOptions`](#org.cdk8s.TimeConversionOptions)

---

##### `toMinutes` <a name="org.cdk8s.Duration.toMinutes"></a>

```java
public toMinutes()
public toMinutes(TimeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Duration.parameter.opts"></a>

- *Type:* [`org.cdk8s.TimeConversionOptions`](#org.cdk8s.TimeConversionOptions)

---

##### `toSeconds` <a name="org.cdk8s.Duration.toSeconds"></a>

```java
public toSeconds()
public toSeconds(TimeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Duration.parameter.opts"></a>

- *Type:* [`org.cdk8s.TimeConversionOptions`](#org.cdk8s.TimeConversionOptions)

---

##### `unitLabel` <a name="org.cdk8s.Duration.unitLabel"></a>

```java
public unitLabel()
```

#### Static Functions <a name="Static Functions"></a>

##### `days` <a name="org.cdk8s.Duration.days"></a>

```java
import org.cdk8s.Duration;

Duration.days(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Duration.parameter.amount"></a>

- *Type:* `java.lang.Number`

the amount of Days the `Duration` will represent.

---

##### `hours` <a name="org.cdk8s.Duration.hours"></a>

```java
import org.cdk8s.Duration;

Duration.hours(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Duration.parameter.amount"></a>

- *Type:* `java.lang.Number`

the amount of Hours the `Duration` will represent.

---

##### `millis` <a name="org.cdk8s.Duration.millis"></a>

```java
import org.cdk8s.Duration;

Duration.millis(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Duration.parameter.amount"></a>

- *Type:* `java.lang.Number`

the amount of Milliseconds the `Duration` will represent.

---

##### `minutes` <a name="org.cdk8s.Duration.minutes"></a>

```java
import org.cdk8s.Duration;

Duration.minutes(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Duration.parameter.amount"></a>

- *Type:* `java.lang.Number`

the amount of Minutes the `Duration` will represent.

---

##### `parse` <a name="org.cdk8s.Duration.parse"></a>

```java
import org.cdk8s.Duration;

Duration.parse(java.lang.String duration)
```

###### `duration`<sup>Required</sup> <a name="org.cdk8s.Duration.parameter.duration"></a>

- *Type:* `java.lang.String`

an ISO-formtted duration to be parsed.

---

##### `seconds` <a name="org.cdk8s.Duration.seconds"></a>

```java
import org.cdk8s.Duration;

Duration.seconds(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Duration.parameter.amount"></a>

- *Type:* `java.lang.Number`

the amount of Seconds the `Duration` will represent.

---



### JsonPatch <a name="org.cdk8s.JsonPatch"></a>

Utility for applying RFC-6902 JSON-Patch to a document.

Use the the `JsonPatch.apply(doc, ...ops)` function to apply a set of
operations to a JSON document and return the result.

Operations can be created using the factory methods `JsonPatch.add()`,
`JsonPatch.remove()`, etc.


#### Static Functions <a name="Static Functions"></a>

##### `add` <a name="org.cdk8s.JsonPatch.add"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.add(java.lang.String path, java.lang.Object value)
```

###### `path`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `java.lang.String`

---

###### `value`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `java.lang.Object`

---

##### `apply` <a name="org.cdk8s.JsonPatch.apply"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.apply(java.lang.Object document, JsonPatch ops)
```

###### `document`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.document"></a>

- *Type:* `java.lang.Object`

The document to patch.

---

###### `ops`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.ops"></a>

- *Type:* [`org.cdk8s.JsonPatch`](#org.cdk8s.JsonPatch)

The operations to apply.

---

##### `copy` <a name="org.cdk8s.JsonPatch.copy"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.copy(java.lang.String from, java.lang.String path)
```

###### `from`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.from"></a>

- *Type:* `java.lang.String`

---

###### `path`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `java.lang.String`

---

##### `move` <a name="org.cdk8s.JsonPatch.move"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.move(java.lang.String from, java.lang.String path)
```

###### `from`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.from"></a>

- *Type:* `java.lang.String`

---

###### `path`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `java.lang.String`

---

##### `remove` <a name="org.cdk8s.JsonPatch.remove"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.remove(java.lang.String path)
```

###### `path`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `java.lang.String`

---

##### `replace` <a name="org.cdk8s.JsonPatch.replace"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.replace(java.lang.String path, java.lang.Object value)
```

###### `path`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `java.lang.String`

---

###### `value`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `java.lang.Object`

---

##### `test` <a name="org.cdk8s.JsonPatch.test"></a>

```java
import org.cdk8s.JsonPatch;

JsonPatch.test(java.lang.String path, java.lang.Object value)
```

###### `path`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `java.lang.String`

---

###### `value`<sup>Required</sup> <a name="org.cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `java.lang.Object`

---



### Lazy <a name="org.cdk8s.Lazy"></a>

#### Methods <a name="Methods"></a>

##### `produce` <a name="org.cdk8s.Lazy.produce"></a>

```java
public produce()
```

#### Static Functions <a name="Static Functions"></a>

##### `any` <a name="org.cdk8s.Lazy.any"></a>

```java
import org.cdk8s.Lazy;

Lazy.any(IAnyProducer producer)
```

###### `producer`<sup>Required</sup> <a name="org.cdk8s.Lazy.parameter.producer"></a>

- *Type:* [`org.cdk8s.IAnyProducer`](#org.cdk8s.IAnyProducer)

---



### Names <a name="org.cdk8s.Names"></a>

Utilities for generating unique and stable names.


#### Static Functions <a name="Static Functions"></a>

##### `toDnsLabel` <a name="org.cdk8s.Names.toDnsLabel"></a>

```java
import org.cdk8s.Names;

Names.toDnsLabel(Construct scope)
Names.toDnsLabel(Construct scope, NameOptions options)
```

###### `scope`<sup>Required</sup> <a name="org.cdk8s.Names.parameter.scope"></a>

- *Type:* [`software.constructs.Construct`](#software.constructs.Construct)

The construct for which to render the DNS label.

---

###### `options`<sup>Optional</sup> <a name="org.cdk8s.Names.parameter.options"></a>

- *Type:* [`org.cdk8s.NameOptions`](#org.cdk8s.NameOptions)

Name options.

---

##### `toLabelValue` <a name="org.cdk8s.Names.toLabelValue"></a>

```java
import org.cdk8s.Names;

Names.toLabelValue(Construct scope)
Names.toLabelValue(Construct scope, NameOptions options)
```

###### `scope`<sup>Required</sup> <a name="org.cdk8s.Names.parameter.scope"></a>

- *Type:* [`software.constructs.Construct`](#software.constructs.Construct)

The construct for which to render the DNS label.

---

###### `options`<sup>Optional</sup> <a name="org.cdk8s.Names.parameter.options"></a>

- *Type:* [`org.cdk8s.NameOptions`](#org.cdk8s.NameOptions)

Name options.

---



### Size <a name="org.cdk8s.Size"></a>

Represents the amount of digital storage.

The amount can be specified either as a literal value (e.g: `10`) which
cannot be negative.

When the amount is passed as a token, unit conversion is not possible.

#### Methods <a name="Methods"></a>

##### `toGibibytes` <a name="org.cdk8s.Size.toGibibytes"></a>

```java
public toGibibytes()
public toGibibytes(SizeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Size.parameter.opts"></a>

- *Type:* [`org.cdk8s.SizeConversionOptions`](#org.cdk8s.SizeConversionOptions)

---

##### `toKibibytes` <a name="org.cdk8s.Size.toKibibytes"></a>

```java
public toKibibytes()
public toKibibytes(SizeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Size.parameter.opts"></a>

- *Type:* [`org.cdk8s.SizeConversionOptions`](#org.cdk8s.SizeConversionOptions)

---

##### `toMebibytes` <a name="org.cdk8s.Size.toMebibytes"></a>

```java
public toMebibytes()
public toMebibytes(SizeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Size.parameter.opts"></a>

- *Type:* [`org.cdk8s.SizeConversionOptions`](#org.cdk8s.SizeConversionOptions)

---

##### `toPebibytes` <a name="org.cdk8s.Size.toPebibytes"></a>

```java
public toPebibytes()
public toPebibytes(SizeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Size.parameter.opts"></a>

- *Type:* [`org.cdk8s.SizeConversionOptions`](#org.cdk8s.SizeConversionOptions)

---

##### `toTebibytes` <a name="org.cdk8s.Size.toTebibytes"></a>

```java
public toTebibytes()
public toTebibytes(SizeConversionOptions opts)
```

###### `opts`<sup>Optional</sup> <a name="org.cdk8s.Size.parameter.opts"></a>

- *Type:* [`org.cdk8s.SizeConversionOptions`](#org.cdk8s.SizeConversionOptions)

---

#### Static Functions <a name="Static Functions"></a>

##### `gibibytes` <a name="org.cdk8s.Size.gibibytes"></a>

```java
import org.cdk8s.Size;

Size.gibibytes(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Size.parameter.amount"></a>

- *Type:* `java.lang.Number`

---

##### `kibibytes` <a name="org.cdk8s.Size.kibibytes"></a>

```java
import org.cdk8s.Size;

Size.kibibytes(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Size.parameter.amount"></a>

- *Type:* `java.lang.Number`

---

##### `mebibytes` <a name="org.cdk8s.Size.mebibytes"></a>

```java
import org.cdk8s.Size;

Size.mebibytes(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Size.parameter.amount"></a>

- *Type:* `java.lang.Number`

---

##### `pebibyte` <a name="org.cdk8s.Size.pebibyte"></a>

```java
import org.cdk8s.Size;

Size.pebibyte(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Size.parameter.amount"></a>

- *Type:* `java.lang.Number`

---

##### `tebibytes` <a name="org.cdk8s.Size.tebibytes"></a>

```java
import org.cdk8s.Size;

Size.tebibytes(java.lang.Number amount)
```

###### `amount`<sup>Required</sup> <a name="org.cdk8s.Size.parameter.amount"></a>

- *Type:* `java.lang.Number`

---



### Testing <a name="org.cdk8s.Testing"></a>

Testing utilities for cdk8s applications.


#### Static Functions <a name="Static Functions"></a>

##### `app` <a name="org.cdk8s.Testing.app"></a>

```java
import org.cdk8s.Testing;

Testing.app()
Testing.app(AppProps props)
```

###### `props`<sup>Optional</sup> <a name="org.cdk8s.Testing.parameter.props"></a>

- *Type:* [`org.cdk8s.AppProps`](#org.cdk8s.AppProps)

---

##### `chart` <a name="org.cdk8s.Testing.chart"></a>

```java
import org.cdk8s.Testing;

Testing.chart()
```

##### `synth` <a name="org.cdk8s.Testing.synth"></a>

```java
import org.cdk8s.Testing;

Testing.synth(Chart chart)
```

###### `chart`<sup>Required</sup> <a name="org.cdk8s.Testing.parameter.chart"></a>

- *Type:* [`org.cdk8s.Chart`](#org.cdk8s.Chart)

---



### Yaml <a name="org.cdk8s.Yaml"></a>

YAML utilities.


#### Static Functions <a name="Static Functions"></a>

##### ~~`formatObjects`~~ <a name="org.cdk8s.Yaml.formatObjects"></a>

```java
import org.cdk8s.Yaml;

Yaml.formatObjects(java.util.List<java.lang.Object> docs)
```

###### `docs`<sup>Required</sup> <a name="org.cdk8s.Yaml.parameter.docs"></a>

- *Type:* java.util.List<`java.lang.Object`>

---

##### `load` <a name="org.cdk8s.Yaml.load"></a>

```java
import org.cdk8s.Yaml;

Yaml.load(java.lang.String urlOrFile)
```

###### `urlOrFile`<sup>Required</sup> <a name="org.cdk8s.Yaml.parameter.urlOrFile"></a>

- *Type:* `java.lang.String`

a URL of a file path to load from.

---

##### `save` <a name="org.cdk8s.Yaml.save"></a>

```java
import org.cdk8s.Yaml;

Yaml.save(java.lang.String filePath, java.util.List<java.lang.Object> docs)
```

###### `filePath`<sup>Required</sup> <a name="org.cdk8s.Yaml.parameter.filePath"></a>

- *Type:* `java.lang.String`

The output path.

---

###### `docs`<sup>Required</sup> <a name="org.cdk8s.Yaml.parameter.docs"></a>

- *Type:* java.util.List<`java.lang.Object`>

The set of objects.

---

##### `stringify` <a name="org.cdk8s.Yaml.stringify"></a>

```java
import org.cdk8s.Yaml;

Yaml.stringify(java.lang.Object docs)
```

###### `docs`<sup>Required</sup> <a name="org.cdk8s.Yaml.parameter.docs"></a>

- *Type:* `java.lang.Object`

A set of objects to convert to YAML.

---

##### `tmp` <a name="org.cdk8s.Yaml.tmp"></a>

```java
import org.cdk8s.Yaml;

Yaml.tmp(java.util.List<java.lang.Object> docs)
```

###### `docs`<sup>Required</sup> <a name="org.cdk8s.Yaml.parameter.docs"></a>

- *Type:* java.util.List<`java.lang.Object`>

the set of documents to save.

---



## Protocols <a name="Protocols"></a>

### IAnyProducer <a name="org.cdk8s.IAnyProducer"></a>

- *Implemented By:* [`org.cdk8s.IAnyProducer`](#org.cdk8s.IAnyProducer)

#### Methods <a name="Methods"></a>

##### `produce` <a name="org.cdk8s.IAnyProducer.produce"></a>

```java
public produce()
```


## Enums <a name="Enums"></a>

### SizeRoundingBehavior <a name="SizeRoundingBehavior"></a>

Rounding behaviour when converting between units of `Size`.

#### `FAIL` <a name="org.cdk8s.SizeRoundingBehavior.FAIL"></a>

Fail the conversion if the result is not an integer.

---


#### `FLOOR` <a name="org.cdk8s.SizeRoundingBehavior.FLOOR"></a>

If the result is not an integer, round it to the closest integer less than the result.

---


#### `NONE` <a name="org.cdk8s.SizeRoundingBehavior.NONE"></a>

Don't round.

Return even if the result is a fraction.

---


### YamlOutputType <a name="YamlOutputType"></a>

The method to divide YAML output into files.

#### `FILE_PER_APP` <a name="org.cdk8s.YamlOutputType.FILE_PER_APP"></a>

All resources are output into a single YAML file.

---


#### `FILE_PER_CHART` <a name="org.cdk8s.YamlOutputType.FILE_PER_CHART"></a>

Resources are split into seperate files by chart.

---


#### `FILE_PER_RESOURCE` <a name="org.cdk8s.YamlOutputType.FILE_PER_RESOURCE"></a>

Each resource is output to its own file.

---


#### `FOLDER_PER_CHART_FILE_PER_RESOURCE` <a name="org.cdk8s.YamlOutputType.FOLDER_PER_CHART_FILE_PER_RESOURCE"></a>

Each chart in its own folder and each resource in its own file.

---

