# API Reference <a name="API Reference"></a>

## Constructs <a name="Constructs"></a>

### ApiObject <a name="cdk8s.ApiObject"></a>

#### Initializers <a name="cdk8s.ApiObject.Initializer"></a>

```python
import cdk8s

cdk8s.ApiObject(
  scope: Construct,
  id: str,
  api_version: str,
  kind: str,
  metadata: ApiObjectMetadata = None
)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

the construct scope.

---

##### `id`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.id"></a>

- *Type:* `str`

namespace.

---

##### `api_version`<sup>Required</sup> <a name="cdk8s.ApiObjectProps.parameter.api_version"></a>

- *Type:* `str`

API version.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.ApiObjectProps.parameter.kind"></a>

- *Type:* `str`

Resource kind.

---

##### `metadata`<sup>Optional</sup> <a name="cdk8s.ApiObjectProps.parameter.metadata"></a>

- *Type:* [`cdk8s.ApiObjectMetadata`](#cdk8s.ApiObjectMetadata)

Object metadata.

If `name` is not specified, an app-unique name will be allocated by the
framework based on the path of the construct within thes construct tree.

---

#### Methods <a name="Methods"></a>

##### `add_dependency` <a name="cdk8s.ApiObject.add_dependency"></a>

```python
def add_dependency(
  dependencies: IConstruct
)
```

###### `dependencies`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.dependencies"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

the dependencies to add.

---

##### `add_json_patch` <a name="cdk8s.ApiObject.add_json_patch"></a>

```python
def add_json_patch(
  ops: JsonPatch
)
```

###### `ops`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.ops"></a>

- *Type:* [`cdk8s.JsonPatch`](#cdk8s.JsonPatch)

The JSON-Patch operations to apply.

---

##### `to_json` <a name="cdk8s.ApiObject.to_json"></a>

```python
def to_json()
```

#### Static Functions <a name="Static Functions"></a>

##### `of` <a name="cdk8s.ApiObject.of"></a>

```python
import cdk8s

cdk8s.ApiObject.of(
  c: IConstruct
)
```

###### `c`<sup>Required</sup> <a name="cdk8s.ApiObject.parameter.c"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

The higher-level construct.

---

#### Properties <a name="Properties"></a>

##### `api_group`<sup>Required</sup> <a name="cdk8s.ApiObject.property.api_group"></a>

```python
api_group: str
```

- *Type:* `str`

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `api_version`<sup>Required</sup> <a name="cdk8s.ApiObject.property.api_version"></a>

```python
api_version: str
```

- *Type:* `str`

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="cdk8s.ApiObject.property.chart"></a>

```python
chart: Chart
```

- *Type:* [`cdk8s.Chart`](#cdk8s.Chart)

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.ApiObject.property.kind"></a>

```python
kind: str
```

- *Type:* `str`

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="cdk8s.ApiObject.property.metadata"></a>

```python
metadata: ApiObjectMetadataDefinition
```

- *Type:* [`cdk8s.ApiObjectMetadataDefinition`](#cdk8s.ApiObjectMetadataDefinition)

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="cdk8s.ApiObject.property.name"></a>

```python
name: str
```

- *Type:* `str`

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---


### App <a name="cdk8s.App"></a>

Represents a cdk8s application.

#### Initializers <a name="cdk8s.App.Initializer"></a>

```python
import cdk8s

cdk8s.App(
  outdir: str = None,
  output_file_extension: str = None,
  yaml_output_type: YamlOutputType = None
)
```

##### `outdir`<sup>Optional</sup> <a name="cdk8s.AppProps.parameter.outdir"></a>

- *Type:* `str`
- *Default:* CDK8S_OUTDIR if defined, otherwise "dist"

The directory to output Kubernetes manifests.

---

##### `output_file_extension`<sup>Optional</sup> <a name="cdk8s.AppProps.parameter.output_file_extension"></a>

- *Type:* `str`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yaml_output_type`<sup>Optional</sup> <a name="cdk8s.AppProps.parameter.yaml_output_type"></a>

- *Type:* [`cdk8s.YamlOutputType`](#cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---

#### Methods <a name="Methods"></a>

##### `synth` <a name="cdk8s.App.synth"></a>

```python
def synth()
```

##### `synth_yaml` <a name="cdk8s.App.synth_yaml"></a>

```python
def synth_yaml()
```


#### Properties <a name="Properties"></a>

##### `charts`<sup>Required</sup> <a name="cdk8s.App.property.charts"></a>

```python
charts: typing.List[Chart]
```

- *Type:* typing.List[[`cdk8s.Chart`](#cdk8s.Chart)]

Returns all the charts in this app, sorted topologically.

---

##### `outdir`<sup>Required</sup> <a name="cdk8s.App.property.outdir"></a>

```python
outdir: str
```

- *Type:* `str`

The output directory into which manifests will be synthesized.

---

##### `output_file_extension`<sup>Required</sup> <a name="cdk8s.App.property.output_file_extension"></a>

```python
output_file_extension: str
```

- *Type:* `str`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yaml_output_type`<sup>Required</sup> <a name="cdk8s.App.property.yaml_output_type"></a>

```python
yaml_output_type: YamlOutputType
```

- *Type:* [`cdk8s.YamlOutputType`](#cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---


### Chart <a name="cdk8s.Chart"></a>

#### Initializers <a name="cdk8s.Chart.Initializer"></a>

```python
import cdk8s

cdk8s.Chart(
  scope: Construct,
  id: str,
  labels: typing.Mapping[str] = None,
  namespace: str = None
)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.Chart.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk8s.Chart.parameter.id"></a>

- *Type:* `str`

---

##### `labels`<sup>Optional</sup> <a name="cdk8s.ChartProps.parameter.labels"></a>

- *Type:* typing.Mapping[`str`]
- *Default:* no common labels

Labels to apply to all resources in this chart.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ChartProps.parameter.namespace"></a>

- *Type:* `str`
- *Default:* no namespace is synthesized (usually this implies "default")

The default namespace for all objects defined in this chart (directly or indirectly).

This namespace will only apply to objects that don't have a
`namespace` explicitly defined for them.

---

#### Methods <a name="Methods"></a>

##### `add_dependency` <a name="cdk8s.Chart.add_dependency"></a>

```python
def add_dependency(
  dependencies: IConstruct
)
```

###### `dependencies`<sup>Required</sup> <a name="cdk8s.Chart.parameter.dependencies"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

the dependencies to add.

---

##### `generate_object_name` <a name="cdk8s.Chart.generate_object_name"></a>

```python
def generate_object_name(
  api_object: ApiObject
)
```

###### `api_object`<sup>Required</sup> <a name="cdk8s.Chart.parameter.api_object"></a>

- *Type:* [`cdk8s.ApiObject`](#cdk8s.ApiObject)

The API object to generate a name for.

---

##### `to_json` <a name="cdk8s.Chart.to_json"></a>

```python
def to_json()
```

#### Static Functions <a name="Static Functions"></a>

##### `is_chart` <a name="cdk8s.Chart.is_chart"></a>

```python
import cdk8s

cdk8s.Chart.is_chart(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="cdk8s.Chart.parameter.x"></a>

- *Type:* `typing.Any`

---

##### `of` <a name="cdk8s.Chart.of"></a>

```python
import cdk8s

cdk8s.Chart.of(
  c: IConstruct
)
```

###### `c`<sup>Required</sup> <a name="cdk8s.Chart.parameter.c"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

a construct node.

---

#### Properties <a name="Properties"></a>

##### `labels`<sup>Required</sup> <a name="cdk8s.Chart.property.labels"></a>

```python
labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[`str`]

Labels applied to all resources in this chart.

This is an immutable copy.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.Chart.property.namespace"></a>

```python
namespace: str
```

- *Type:* `str`

The default namespace for all objects in this chart.

---


### Helm <a name="cdk8s.Helm"></a>

Represents a Helm deployment.

Use this construct to import an existing Helm chart and incorporate it into your constructs.

#### Initializers <a name="cdk8s.Helm.Initializer"></a>

```python
import cdk8s

cdk8s.Helm(
  scope: Construct,
  id: str,
  chart: str,
  helm_executable: str = None,
  helm_flags: typing.List[str] = None,
  release_name: str = None,
  values: typing.Mapping[typing.Any] = None
)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.Helm.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk8s.Helm.parameter.id"></a>

- *Type:* `str`

---

##### `chart`<sup>Required</sup> <a name="cdk8s.HelmProps.parameter.chart"></a>

- *Type:* `str`

The chart name to use. It can be a chart from a helm repository or a local directory.

This name is passed to `helm template` and has all the relevant semantics.

---

##### `helm_executable`<sup>Optional</sup> <a name="cdk8s.HelmProps.parameter.helm_executable"></a>

- *Type:* `str`
- *Default:* "helm"

The local helm executable to use in order to create the manifest the chart.

---

##### `helm_flags`<sup>Optional</sup> <a name="cdk8s.HelmProps.parameter.helm_flags"></a>

- *Type:* typing.List[`str`]
- *Default:* []

Additional flags to add to the `helm` execution.

---

##### `release_name`<sup>Optional</sup> <a name="cdk8s.HelmProps.parameter.release_name"></a>

- *Type:* `str`
- *Default:* if unspecified, a name will be allocated based on the construct path

The release name.

> https://helm.sh/docs/intro/using_helm/#three-big-concepts

---

##### `values`<sup>Optional</sup> <a name="cdk8s.HelmProps.parameter.values"></a>

- *Type:* typing.Mapping[`typing.Any`]
- *Default:* If no values are specified, chart will use the defaults.

Values to pass to the chart.

---



#### Properties <a name="Properties"></a>

##### `release_name`<sup>Required</sup> <a name="cdk8s.Helm.property.release_name"></a>

```python
release_name: str
```

- *Type:* `str`

The helm release name.

---


### Include <a name="cdk8s.Include"></a>

Reads a YAML manifest from a file or a URL and defines all resources as API objects within the defined scope.

The names (`metadata.name`) of imported resources will be preserved as-is
from the manifest.

#### Initializers <a name="cdk8s.Include.Initializer"></a>

```python
import cdk8s

cdk8s.Include(
  scope: Construct,
  id: str,
  url: str
)
```

##### `scope`<sup>Required</sup> <a name="cdk8s.Include.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

---

##### `id`<sup>Required</sup> <a name="cdk8s.Include.parameter.id"></a>

- *Type:* `str`

---

##### `url`<sup>Required</sup> <a name="cdk8s.IncludeProps.parameter.url"></a>

- *Type:* `str`

Local file path or URL which includes a Kubernetes YAML manifest.

---



#### Properties <a name="Properties"></a>

##### `api_objects`<sup>Required</sup> <a name="cdk8s.Include.property.api_objects"></a>

```python
api_objects: typing.List[ApiObject]
```

- *Type:* typing.List[[`cdk8s.ApiObject`](#cdk8s.ApiObject)]

Returns all the included API objects.

---


## Structs <a name="Structs"></a>

### ApiObjectMetadata <a name="cdk8s.ApiObjectMetadata"></a>

Metadata associated with this object.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.ApiObjectMetadata(
  annotations: typing.Mapping[str] = None,
  finalizers: typing.List[str] = None,
  labels: typing.Mapping[str] = None,
  name: str = None,
  namespace: str = None,
  owner_references: typing.List[OwnerReference] = None
)
```

##### `annotations`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.annotations"></a>

```python
annotations: typing.Mapping[str]
```

- *Type:* typing.Mapping[`str`]
- *Default:* No annotations.

Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

They are not queryable and should be
preserved when modifying objects.

> http://kubernetes.io/docs/user-guide/annotations

---

##### `finalizers`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.finalizers"></a>

```python
finalizers: typing.List[str]
```

- *Type:* typing.List[`str`]
- *Default:* No finalizers.

Namespaced keys that tell Kubernetes to wait until specific conditions are met before it fully deletes resources marked for deletion.

Must be empty before the object is deleted from the registry. Each entry is
an identifier for the responsible component that will remove the entry from
the list. If the deletionTimestamp of the object is non-nil, entries in
this list can only be removed. Finalizers may be processed and removed in
any order.  Order is NOT enforced because it introduces significant risk of
stuck finalizers. finalizers is a shared field, any actor with permission
can reorder it. If the finalizer list is processed in order, then this can
lead to a situation in which the component responsible for the first
finalizer in the list is waiting for a signal (field value, external
system, or other) produced by a component responsible for a finalizer later
in the list, resulting in a deadlock. Without enforced ordering finalizers
are free to order amongst themselves and are not vulnerable to ordering
changes in the list.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/finalizers/

---

##### `labels`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.labels"></a>

```python
labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[`str`]
- *Default:* No labels.

Map of string keys and values that can be used to organize and categorize (scope and select) objects.

May match selectors of replication controllers and services.

> http://kubernetes.io/docs/user-guide/labels

---

##### `name`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.name"></a>

```python
name: str
```

- *Type:* `str`
- *Default:* an app-unique name generated by the chart

The unique, namespace-global, name of this object inside the Kubernetes cluster.

Normally, you shouldn't specify names for objects and let the CDK generate
a name for you that is application-unique. The names CDK generates are
composed from the construct path components, separated by dots and a suffix
that is based on a hash of the entire path, to ensure uniqueness.

You can supply custom name allocation logic by overriding the
`chart.generateObjectName` method.

If you use an explicit name here, bear in mind that this reduces the
composability of your construct because it won't be possible to include
more than one instance in any app. Therefore it is highly recommended to
leave this unspecified.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.namespace"></a>

```python
namespace: str
```

- *Type:* `str`
- *Default:* undefined (will be assigned to the 'default' namespace)

Namespace defines the space within each name must be unique.

An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation.
Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty. Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces

---

##### `owner_references`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.property.owner_references"></a>

```python
owner_references: typing.List[OwnerReference]
```

- *Type:* typing.List[[`cdk8s.OwnerReference`](#cdk8s.OwnerReference)]
- *Default:* automatically set by Kubernetes

List of objects depended by this object.

If ALL objects in the list have
been deleted, this object will be garbage collected. If this object is
managed by a controller, then an entry in this list will point to this
controller, with the controller field set to true. There cannot be more
than one managing controller.

Kubernetes sets the value of this field automatically for objects that are
dependents of other objects like ReplicaSets, DaemonSets, Deployments, Jobs
and CronJobs, and ReplicationControllers. You can also configure these
relationships manually by changing the value of this field. However, you
usually don't need to and can allow Kubernetes to automatically manage the
relationships.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/owners-dependents/

---

### ApiObjectProps <a name="cdk8s.ApiObjectProps"></a>

Options for defining API objects.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.ApiObjectProps(
  api_version: str,
  kind: str,
  metadata: ApiObjectMetadata = None
)
```

##### `api_version`<sup>Required</sup> <a name="cdk8s.ApiObjectProps.property.api_version"></a>

```python
api_version: str
```

- *Type:* `str`

API version.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.ApiObjectProps.property.kind"></a>

```python
kind: str
```

- *Type:* `str`

Resource kind.

---

##### `metadata`<sup>Optional</sup> <a name="cdk8s.ApiObjectProps.property.metadata"></a>

```python
metadata: ApiObjectMetadata
```

- *Type:* [`cdk8s.ApiObjectMetadata`](#cdk8s.ApiObjectMetadata)

Object metadata.

If `name` is not specified, an app-unique name will be allocated by the
framework based on the path of the construct within thes construct tree.

---

### AppProps <a name="cdk8s.AppProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.AppProps(
  outdir: str = None,
  output_file_extension: str = None,
  yaml_output_type: YamlOutputType = None
)
```

##### `outdir`<sup>Optional</sup> <a name="cdk8s.AppProps.property.outdir"></a>

```python
outdir: str
```

- *Type:* `str`
- *Default:* CDK8S_OUTDIR if defined, otherwise "dist"

The directory to output Kubernetes manifests.

---

##### `output_file_extension`<sup>Optional</sup> <a name="cdk8s.AppProps.property.output_file_extension"></a>

```python
output_file_extension: str
```

- *Type:* `str`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

##### `yaml_output_type`<sup>Optional</sup> <a name="cdk8s.AppProps.property.yaml_output_type"></a>

```python
yaml_output_type: YamlOutputType
```

- *Type:* [`cdk8s.YamlOutputType`](#cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---

### ChartProps <a name="cdk8s.ChartProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.ChartProps(
  labels: typing.Mapping[str] = None,
  namespace: str = None
)
```

##### `labels`<sup>Optional</sup> <a name="cdk8s.ChartProps.property.labels"></a>

```python
labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[`str`]
- *Default:* no common labels

Labels to apply to all resources in this chart.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ChartProps.property.namespace"></a>

```python
namespace: str
```

- *Type:* `str`
- *Default:* no namespace is synthesized (usually this implies "default")

The default namespace for all objects defined in this chart (directly or indirectly).

This namespace will only apply to objects that don't have a
`namespace` explicitly defined for them.

---

### CronOptions <a name="cdk8s.CronOptions"></a>

Options to configure a cron expression.

All fields are strings so you can use complex expressions. Absence of
a field implies '*'

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.CronOptions(
  day: str = None,
  hour: str = None,
  minute: str = None,
  month: str = None,
  week_day: str = None
)
```

##### `day`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.day"></a>

```python
day: str
```

- *Type:* `str`
- *Default:* Every day of the month

The day of the month to run this rule at.

---

##### `hour`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.hour"></a>

```python
hour: str
```

- *Type:* `str`
- *Default:* Every hour

The hour to run this rule at.

---

##### `minute`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.minute"></a>

```python
minute: str
```

- *Type:* `str`
- *Default:* Every minute

The minute to run this rule at.

---

##### `month`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.month"></a>

```python
month: str
```

- *Type:* `str`
- *Default:* Every month

The month to run this rule at.

---

##### `week_day`<sup>Optional</sup> <a name="cdk8s.CronOptions.property.week_day"></a>

```python
week_day: str
```

- *Type:* `str`
- *Default:* Any day of the week

The day of the week to run this rule at.

---

### GroupVersionKind <a name="cdk8s.GroupVersionKind"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.GroupVersionKind(
  api_version: str,
  kind: str
)
```

##### `api_version`<sup>Required</sup> <a name="cdk8s.GroupVersionKind.property.api_version"></a>

```python
api_version: str
```

- *Type:* `str`

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `kind`<sup>Required</sup> <a name="cdk8s.GroupVersionKind.property.kind"></a>

```python
kind: str
```

- *Type:* `str`

The object kind.

---

### HelmProps <a name="cdk8s.HelmProps"></a>

Options for `Helm`.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.HelmProps(
  chart: str,
  helm_executable: str = None,
  helm_flags: typing.List[str] = None,
  release_name: str = None,
  values: typing.Mapping[typing.Any] = None
)
```

##### `chart`<sup>Required</sup> <a name="cdk8s.HelmProps.property.chart"></a>

```python
chart: str
```

- *Type:* `str`

The chart name to use. It can be a chart from a helm repository or a local directory.

This name is passed to `helm template` and has all the relevant semantics.

---

##### `helm_executable`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.helm_executable"></a>

```python
helm_executable: str
```

- *Type:* `str`
- *Default:* "helm"

The local helm executable to use in order to create the manifest the chart.

---

##### `helm_flags`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.helm_flags"></a>

```python
helm_flags: typing.List[str]
```

- *Type:* typing.List[`str`]
- *Default:* []

Additional flags to add to the `helm` execution.

---

##### `release_name`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.release_name"></a>

```python
release_name: str
```

- *Type:* `str`
- *Default:* if unspecified, a name will be allocated based on the construct path

The release name.

> https://helm.sh/docs/intro/using_helm/#three-big-concepts

---

##### `values`<sup>Optional</sup> <a name="cdk8s.HelmProps.property.values"></a>

```python
values: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[`typing.Any`]
- *Default:* If no values are specified, chart will use the defaults.

Values to pass to the chart.

---

### IncludeProps <a name="cdk8s.IncludeProps"></a>

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.IncludeProps(
  url: str
)
```

##### `url`<sup>Required</sup> <a name="cdk8s.IncludeProps.property.url"></a>

```python
url: str
```

- *Type:* `str`

Local file path or URL which includes a Kubernetes YAML manifest.

---

### NameOptions <a name="cdk8s.NameOptions"></a>

Options for name generation.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.NameOptions(
  delimiter: str = None,
  extra: typing.List[str] = None,
  include_hash: bool = None,
  max_len: typing.Union[int, float] = None
)
```

##### `delimiter`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.delimiter"></a>

```python
delimiter: str
```

- *Type:* `str`
- *Default:* "-"

Delimiter to use between components.

---

##### `extra`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.extra"></a>

```python
extra: typing.List[str]
```

- *Type:* typing.List[`str`]
- *Default:* [] use the construct path components

Extra components to include in the name.

---

##### `include_hash`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.include_hash"></a>

```python
include_hash: bool
```

- *Type:* `bool`
- *Default:* true

Include a short hash as last part of the name.

---

##### `max_len`<sup>Optional</sup> <a name="cdk8s.NameOptions.property.max_len"></a>

```python
max_len: typing.Union[int, float]
```

- *Type:* `typing.Union[int, float]`
- *Default:* 63

Maximum allowed length for the name.

---

### OwnerReference <a name="cdk8s.OwnerReference"></a>

OwnerReference contains enough information to let you identify an owning object.

An owning object must be in the same namespace as the dependent, or
be cluster-scoped, so there is no namespace field.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.OwnerReference(
  api_version: str,
  kind: str,
  name: str,
  uid: str,
  block_owner_deletion: bool = None,
  controller: bool = None
)
```

##### `api_version`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.api_version"></a>

```python
api_version: str
```

- *Type:* `str`

API version of the referent.

---

##### `kind`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.kind"></a>

```python
kind: str
```

- *Type:* `str`

Kind of the referent.

> https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

---

##### `name`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.name"></a>

```python
name: str
```

- *Type:* `str`

Name of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#names

---

##### `uid`<sup>Required</sup> <a name="cdk8s.OwnerReference.property.uid"></a>

```python
uid: str
```

- *Type:* `str`

UID of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#uids

---

##### `block_owner_deletion`<sup>Optional</sup> <a name="cdk8s.OwnerReference.property.block_owner_deletion"></a>

```python
block_owner_deletion: bool
```

- *Type:* `bool`
- *Default:* false. To set this field, a user needs "delete" permission of the
owner, otherwise 422 (Unprocessable Entity) will be returned.

If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed.

Defaults to false. To set this field, a user needs "delete"
permission of the owner, otherwise 422 (Unprocessable Entity) will be
returned.

---

##### `controller`<sup>Optional</sup> <a name="cdk8s.OwnerReference.property.controller"></a>

```python
controller: bool
```

- *Type:* `bool`

If true, this reference points to the managing controller.

---

### SizeConversionOptions <a name="cdk8s.SizeConversionOptions"></a>

Options for how to convert time to a different unit.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.SizeConversionOptions(
  rounding: SizeRoundingBehavior = None
)
```

##### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.property.rounding"></a>

```python
rounding: SizeRoundingBehavior
```

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

### TimeConversionOptions <a name="cdk8s.TimeConversionOptions"></a>

Options for how to convert time to a different unit.

#### Initializer <a name="[object Object].Initializer"></a>

```python
import cdk8s

cdk8s.TimeConversionOptions(
  integral: bool = None
)
```

##### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.property.integral"></a>

```python
integral: bool
```

- *Type:* `bool`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

## Classes <a name="Classes"></a>

### ApiObjectMetadataDefinition <a name="cdk8s.ApiObjectMetadataDefinition"></a>

Object metadata.

#### Initializers <a name="cdk8s.ApiObjectMetadataDefinition.Initializer"></a>

```python
import cdk8s

cdk8s.ApiObjectMetadataDefinition(
  annotations: typing.Mapping[str] = None,
  finalizers: typing.List[str] = None,
  labels: typing.Mapping[str] = None,
  name: str = None,
  namespace: str = None,
  owner_references: typing.List[OwnerReference] = None
)
```

##### `annotations`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.parameter.annotations"></a>

- *Type:* typing.Mapping[`str`]
- *Default:* No annotations.

Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

They are not queryable and should be
preserved when modifying objects.

> http://kubernetes.io/docs/user-guide/annotations

---

##### `finalizers`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.parameter.finalizers"></a>

- *Type:* typing.List[`str`]
- *Default:* No finalizers.

Namespaced keys that tell Kubernetes to wait until specific conditions are met before it fully deletes resources marked for deletion.

Must be empty before the object is deleted from the registry. Each entry is
an identifier for the responsible component that will remove the entry from
the list. If the deletionTimestamp of the object is non-nil, entries in
this list can only be removed. Finalizers may be processed and removed in
any order.  Order is NOT enforced because it introduces significant risk of
stuck finalizers. finalizers is a shared field, any actor with permission
can reorder it. If the finalizer list is processed in order, then this can
lead to a situation in which the component responsible for the first
finalizer in the list is waiting for a signal (field value, external
system, or other) produced by a component responsible for a finalizer later
in the list, resulting in a deadlock. Without enforced ordering finalizers
are free to order amongst themselves and are not vulnerable to ordering
changes in the list.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/finalizers/

---

##### `labels`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.parameter.labels"></a>

- *Type:* typing.Mapping[`str`]
- *Default:* No labels.

Map of string keys and values that can be used to organize and categorize (scope and select) objects.

May match selectors of replication controllers and services.

> http://kubernetes.io/docs/user-guide/labels

---

##### `name`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.parameter.name"></a>

- *Type:* `str`
- *Default:* an app-unique name generated by the chart

The unique, namespace-global, name of this object inside the Kubernetes cluster.

Normally, you shouldn't specify names for objects and let the CDK generate
a name for you that is application-unique. The names CDK generates are
composed from the construct path components, separated by dots and a suffix
that is based on a hash of the entire path, to ensure uniqueness.

You can supply custom name allocation logic by overriding the
`chart.generateObjectName` method.

If you use an explicit name here, bear in mind that this reduces the
composability of your construct because it won't be possible to include
more than one instance in any app. Therefore it is highly recommended to
leave this unspecified.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.parameter.namespace"></a>

- *Type:* `str`
- *Default:* undefined (will be assigned to the 'default' namespace)

Namespace defines the space within each name must be unique.

An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation.
Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty. Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces

---

##### `owner_references`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadata.parameter.owner_references"></a>

- *Type:* typing.List[[`cdk8s.OwnerReference`](#cdk8s.OwnerReference)]
- *Default:* automatically set by Kubernetes

List of objects depended by this object.

If ALL objects in the list have
been deleted, this object will be garbage collected. If this object is
managed by a controller, then an entry in this list will point to this
controller, with the controller field set to true. There cannot be more
than one managing controller.

Kubernetes sets the value of this field automatically for objects that are
dependents of other objects like ReplicaSets, DaemonSets, Deployments, Jobs
and CronJobs, and ReplicationControllers. You can also configure these
relationships manually by changing the value of this field. However, you
usually don't need to and can allow Kubernetes to automatically manage the
relationships.

> https://kubernetes.io/docs/concepts/overview/working-with-objects/owners-dependents/

---

#### Methods <a name="Methods"></a>

##### `add` <a name="cdk8s.ApiObjectMetadataDefinition.add"></a>

```python
def add(
  key: str,
  value: typing.Any
)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `str`

Metadata key.

---

###### `value`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `typing.Any`

Metadata value.

---

##### `add_annotation` <a name="cdk8s.ApiObjectMetadataDefinition.add_annotation"></a>

```python
def add_annotation(
  key: str,
  value: str
)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `str`

The key.

---

###### `value`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `str`

The value.

---

##### `add_finalizers` <a name="cdk8s.ApiObjectMetadataDefinition.add_finalizers"></a>

```python
def add_finalizers(
  finalizers: str
)
```

###### `finalizers`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.finalizers"></a>

- *Type:* `str`

the finalizers.

---

##### `add_label` <a name="cdk8s.ApiObjectMetadataDefinition.add_label"></a>

```python
def add_label(
  key: str,
  value: str
)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `str`

The key.

---

###### `value`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.value"></a>

- *Type:* `str`

The value.

---

##### `add_owner_reference` <a name="cdk8s.ApiObjectMetadataDefinition.add_owner_reference"></a>

```python
def add_owner_reference(
  api_version: str,
  kind: str,
  name: str,
  uid: str,
  block_owner_deletion: bool = None,
  controller: bool = None
)
```

###### `api_version`<sup>Required</sup> <a name="cdk8s.OwnerReference.parameter.api_version"></a>

- *Type:* `str`

API version of the referent.

---

###### `kind`<sup>Required</sup> <a name="cdk8s.OwnerReference.parameter.kind"></a>

- *Type:* `str`

Kind of the referent.

> https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

---

###### `name`<sup>Required</sup> <a name="cdk8s.OwnerReference.parameter.name"></a>

- *Type:* `str`

Name of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#names

---

###### `uid`<sup>Required</sup> <a name="cdk8s.OwnerReference.parameter.uid"></a>

- *Type:* `str`

UID of the referent.

> http://kubernetes.io/docs/user-guide/identifiers#uids

---

###### `block_owner_deletion`<sup>Optional</sup> <a name="cdk8s.OwnerReference.parameter.block_owner_deletion"></a>

- *Type:* `bool`
- *Default:* false. To set this field, a user needs "delete" permission of the
owner, otherwise 422 (Unprocessable Entity) will be returned.

If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed.

Defaults to false. To set this field, a user needs "delete"
permission of the owner, otherwise 422 (Unprocessable Entity) will be
returned.

---

###### `controller`<sup>Optional</sup> <a name="cdk8s.OwnerReference.parameter.controller"></a>

- *Type:* `bool`

If true, this reference points to the managing controller.

---

##### `get_label` <a name="cdk8s.ApiObjectMetadataDefinition.get_label"></a>

```python
def get_label(
  key: str
)
```

###### `key`<sup>Required</sup> <a name="cdk8s.ApiObjectMetadataDefinition.parameter.key"></a>

- *Type:* `str`

the label.

---

##### `to_json` <a name="cdk8s.ApiObjectMetadataDefinition.to_json"></a>

```python
def to_json()
```


#### Properties <a name="Properties"></a>

##### `name`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadataDefinition.property.name"></a>

```python
name: str
```

- *Type:* `str`

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

##### `namespace`<sup>Optional</sup> <a name="cdk8s.ApiObjectMetadataDefinition.property.namespace"></a>

```python
namespace: str
```

- *Type:* `str`

The object's namespace.

---


### Cron <a name="cdk8s.Cron"></a>

Represents a cron schedule.

#### Initializers <a name="cdk8s.Cron.Initializer"></a>

```python
import cdk8s

cdk8s.Cron(
  day: str = None,
  hour: str = None,
  minute: str = None,
  month: str = None,
  week_day: str = None
)
```

##### `day`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.day"></a>

- *Type:* `str`
- *Default:* Every day of the month

The day of the month to run this rule at.

---

##### `hour`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.hour"></a>

- *Type:* `str`
- *Default:* Every hour

The hour to run this rule at.

---

##### `minute`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.minute"></a>

- *Type:* `str`
- *Default:* Every minute

The minute to run this rule at.

---

##### `month`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.month"></a>

- *Type:* `str`
- *Default:* Every month

The month to run this rule at.

---

##### `week_day`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.week_day"></a>

- *Type:* `str`
- *Default:* Any day of the week

The day of the week to run this rule at.

---


#### Static Functions <a name="Static Functions"></a>

##### `annually` <a name="cdk8s.Cron.annually"></a>

```python
import cdk8s

cdk8s.Cron.annually()
```

##### `daily` <a name="cdk8s.Cron.daily"></a>

```python
import cdk8s

cdk8s.Cron.daily()
```

##### `every_minute` <a name="cdk8s.Cron.every_minute"></a>

```python
import cdk8s

cdk8s.Cron.every_minute()
```

##### `hourly` <a name="cdk8s.Cron.hourly"></a>

```python
import cdk8s

cdk8s.Cron.hourly()
```

##### `monthly` <a name="cdk8s.Cron.monthly"></a>

```python
import cdk8s

cdk8s.Cron.monthly()
```

##### `schedule` <a name="cdk8s.Cron.schedule"></a>

```python
import cdk8s

cdk8s.Cron.schedule(
  day: str = None,
  hour: str = None,
  minute: str = None,
  month: str = None,
  week_day: str = None
)
```

###### `day`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.day"></a>

- *Type:* `str`
- *Default:* Every day of the month

The day of the month to run this rule at.

---

###### `hour`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.hour"></a>

- *Type:* `str`
- *Default:* Every hour

The hour to run this rule at.

---

###### `minute`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.minute"></a>

- *Type:* `str`
- *Default:* Every minute

The minute to run this rule at.

---

###### `month`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.month"></a>

- *Type:* `str`
- *Default:* Every month

The month to run this rule at.

---

###### `week_day`<sup>Optional</sup> <a name="cdk8s.CronOptions.parameter.week_day"></a>

- *Type:* `str`
- *Default:* Any day of the week

The day of the week to run this rule at.

---

##### `weekly` <a name="cdk8s.Cron.weekly"></a>

```python
import cdk8s

cdk8s.Cron.weekly()
```

#### Properties <a name="Properties"></a>

##### `expression_string`<sup>Required</sup> <a name="cdk8s.Cron.property.expression_string"></a>

```python
expression_string: str
```

- *Type:* `str`

Retrieve the expression for this schedule.

---


### DependencyGraph <a name="cdk8s.DependencyGraph"></a>

Represents the dependency graph for a given Node.

This graph includes the dependency relationships between all nodes in the
node (construct) sub-tree who's root is this Node.

Note that this means that lonely nodes (no dependencies and no dependants) are also included in this graph as
childless children of the root node of the graph.

The graph does not include cross-scope dependencies. That is, if a child on the current scope depends on a node
from a different scope, that relationship is not represented in this graph.

#### Initializers <a name="cdk8s.DependencyGraph.Initializer"></a>

```python
import cdk8s

cdk8s.DependencyGraph(
  node: Node
)
```

##### `node`<sup>Required</sup> <a name="cdk8s.DependencyGraph.parameter.node"></a>

- *Type:* [`constructs.Node`](#constructs.Node)

---

#### Methods <a name="Methods"></a>

##### `topology` <a name="cdk8s.DependencyGraph.topology"></a>

```python
def topology()
```


#### Properties <a name="Properties"></a>

##### `root`<sup>Required</sup> <a name="cdk8s.DependencyGraph.property.root"></a>

```python
root: DependencyVertex
```

- *Type:* [`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)

Returns the root of the graph.

Note that this vertex will always have `null` as its `.value` since it is an artifical root
that binds all the connected spaces of the graph.

---


### DependencyVertex <a name="cdk8s.DependencyVertex"></a>

Represents a vertex in the graph.

The value of each vertex is an `IConstruct` that is accessible via the `.value` getter.

#### Initializers <a name="cdk8s.DependencyVertex.Initializer"></a>

```python
import cdk8s

cdk8s.DependencyVertex(
  value: IConstruct = None
)
```

##### `value`<sup>Optional</sup> <a name="cdk8s.DependencyVertex.parameter.value"></a>

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

---

#### Methods <a name="Methods"></a>

##### `add_child` <a name="cdk8s.DependencyVertex.add_child"></a>

```python
def add_child(
  dep: DependencyVertex
)
```

###### `dep`<sup>Required</sup> <a name="cdk8s.DependencyVertex.parameter.dep"></a>

- *Type:* [`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)

The dependency.

---

##### `topology` <a name="cdk8s.DependencyVertex.topology"></a>

```python
def topology()
```


#### Properties <a name="Properties"></a>

##### `inbound`<sup>Required</sup> <a name="cdk8s.DependencyVertex.property.inbound"></a>

```python
inbound: typing.List[DependencyVertex]
```

- *Type:* typing.List[[`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)]

Returns the parents of the vertex (i.e dependants).

---

##### `outbound`<sup>Required</sup> <a name="cdk8s.DependencyVertex.property.outbound"></a>

```python
outbound: typing.List[DependencyVertex]
```

- *Type:* typing.List[[`cdk8s.DependencyVertex`](#cdk8s.DependencyVertex)]

Returns the children of the vertex (i.e dependencies).

---

##### `value`<sup>Optional</sup> <a name="cdk8s.DependencyVertex.property.value"></a>

```python
value: IConstruct
```

- *Type:* [`constructs.IConstruct`](#constructs.IConstruct)

Returns the IConstruct this graph vertex represents.

`null` in case this is the root of the graph.

---


### Duration <a name="cdk8s.Duration"></a>

Represents a length of time.

The amount can be specified either as a literal value (e.g: `10`) which
cannot be negative.

#### Methods <a name="Methods"></a>

##### `to_days` <a name="cdk8s.Duration.to_days"></a>

```python
def to_days(
  integral: bool = None
)
```

###### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.parameter.integral"></a>

- *Type:* `bool`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

##### `to_hours` <a name="cdk8s.Duration.to_hours"></a>

```python
def to_hours(
  integral: bool = None
)
```

###### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.parameter.integral"></a>

- *Type:* `bool`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

##### `to_human_string` <a name="cdk8s.Duration.to_human_string"></a>

```python
def to_human_string()
```

##### `to_iso_string` <a name="cdk8s.Duration.to_iso_string"></a>

```python
def to_iso_string()
```

##### `to_milliseconds` <a name="cdk8s.Duration.to_milliseconds"></a>

```python
def to_milliseconds(
  integral: bool = None
)
```

###### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.parameter.integral"></a>

- *Type:* `bool`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

##### `to_minutes` <a name="cdk8s.Duration.to_minutes"></a>

```python
def to_minutes(
  integral: bool = None
)
```

###### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.parameter.integral"></a>

- *Type:* `bool`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

##### `to_seconds` <a name="cdk8s.Duration.to_seconds"></a>

```python
def to_seconds(
  integral: bool = None
)
```

###### `integral`<sup>Optional</sup> <a name="cdk8s.TimeConversionOptions.parameter.integral"></a>

- *Type:* `bool`
- *Default:* true

If `true`, conversions into a larger time unit (e.g. `Seconds` to `Minutes`) will fail if the result is not an integer.

---

##### `unit_label` <a name="cdk8s.Duration.unit_label"></a>

```python
def unit_label()
```

#### Static Functions <a name="Static Functions"></a>

##### `days` <a name="cdk8s.Duration.days"></a>

```python
import cdk8s

cdk8s.Duration.days(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

the amount of Days the `Duration` will represent.

---

##### `hours` <a name="cdk8s.Duration.hours"></a>

```python
import cdk8s

cdk8s.Duration.hours(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

the amount of Hours the `Duration` will represent.

---

##### `millis` <a name="cdk8s.Duration.millis"></a>

```python
import cdk8s

cdk8s.Duration.millis(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

the amount of Milliseconds the `Duration` will represent.

---

##### `minutes` <a name="cdk8s.Duration.minutes"></a>

```python
import cdk8s

cdk8s.Duration.minutes(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

the amount of Minutes the `Duration` will represent.

---

##### `parse` <a name="cdk8s.Duration.parse"></a>

```python
import cdk8s

cdk8s.Duration.parse(
  duration: str
)
```

###### `duration`<sup>Required</sup> <a name="cdk8s.Duration.parameter.duration"></a>

- *Type:* `str`

an ISO-formtted duration to be parsed.

---

##### `seconds` <a name="cdk8s.Duration.seconds"></a>

```python
import cdk8s

cdk8s.Duration.seconds(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Duration.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

the amount of Seconds the `Duration` will represent.

---



### JsonPatch <a name="cdk8s.JsonPatch"></a>

Utility for applying RFC-6902 JSON-Patch to a document.

Use the the `JsonPatch.apply(doc, ...ops)` function to apply a set of
operations to a JSON document and return the result.

Operations can be created using the factory methods `JsonPatch.add()`,
`JsonPatch.remove()`, etc.


#### Static Functions <a name="Static Functions"></a>

##### `add` <a name="cdk8s.JsonPatch.add"></a>

```python
import cdk8s

cdk8s.JsonPatch.add(
  path: str,
  value: typing.Any
)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `str`

---

###### `value`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `typing.Any`

---

##### `apply` <a name="cdk8s.JsonPatch.apply"></a>

```python
import cdk8s

cdk8s.JsonPatch.apply(
  document: typing.Any,
  ops: JsonPatch
)
```

###### `document`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.document"></a>

- *Type:* `typing.Any`

The document to patch.

---

###### `ops`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.ops"></a>

- *Type:* [`cdk8s.JsonPatch`](#cdk8s.JsonPatch)

The operations to apply.

---

##### `copy` <a name="cdk8s.JsonPatch.copy"></a>

```python
import cdk8s

cdk8s.JsonPatch.copy(
  from: str,
  path: str
)
```

###### `from`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.from"></a>

- *Type:* `str`

---

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `str`

---

##### `move` <a name="cdk8s.JsonPatch.move"></a>

```python
import cdk8s

cdk8s.JsonPatch.move(
  from: str,
  path: str
)
```

###### `from`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.from"></a>

- *Type:* `str`

---

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `str`

---

##### `remove` <a name="cdk8s.JsonPatch.remove"></a>

```python
import cdk8s

cdk8s.JsonPatch.remove(
  path: str
)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `str`

---

##### `replace` <a name="cdk8s.JsonPatch.replace"></a>

```python
import cdk8s

cdk8s.JsonPatch.replace(
  path: str,
  value: typing.Any
)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `str`

---

###### `value`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `typing.Any`

---

##### `test` <a name="cdk8s.JsonPatch.test"></a>

```python
import cdk8s

cdk8s.JsonPatch.test(
  path: str,
  value: typing.Any
)
```

###### `path`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.path"></a>

- *Type:* `str`

---

###### `value`<sup>Required</sup> <a name="cdk8s.JsonPatch.parameter.value"></a>

- *Type:* `typing.Any`

---



### Lazy <a name="cdk8s.Lazy"></a>

#### Methods <a name="Methods"></a>

##### `produce` <a name="cdk8s.Lazy.produce"></a>

```python
def produce()
```

#### Static Functions <a name="Static Functions"></a>

##### `any` <a name="cdk8s.Lazy.any"></a>

```python
import cdk8s

cdk8s.Lazy.any(
  producer: IAnyProducer
)
```

###### `producer`<sup>Required</sup> <a name="cdk8s.Lazy.parameter.producer"></a>

- *Type:* [`cdk8s.IAnyProducer`](#cdk8s.IAnyProducer)

---



### Names <a name="cdk8s.Names"></a>

Utilities for generating unique and stable names.


#### Static Functions <a name="Static Functions"></a>

##### `to_dns_label` <a name="cdk8s.Names.to_dns_label"></a>

```python
import cdk8s

cdk8s.Names.to_dns_label(
  scope: Construct,
  delimiter: str = None,
  extra: typing.List[str] = None,
  include_hash: bool = None,
  max_len: typing.Union[int, float] = None
)
```

###### `scope`<sup>Required</sup> <a name="cdk8s.Names.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The construct for which to render the DNS label.

---

###### `delimiter`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.delimiter"></a>

- *Type:* `str`
- *Default:* "-"

Delimiter to use between components.

---

###### `extra`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.extra"></a>

- *Type:* typing.List[`str`]
- *Default:* [] use the construct path components

Extra components to include in the name.

---

###### `include_hash`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.include_hash"></a>

- *Type:* `bool`
- *Default:* true

Include a short hash as last part of the name.

---

###### `max_len`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.max_len"></a>

- *Type:* `typing.Union[int, float]`
- *Default:* 63

Maximum allowed length for the name.

---

##### `to_label_value` <a name="cdk8s.Names.to_label_value"></a>

```python
import cdk8s

cdk8s.Names.to_label_value(
  scope: Construct,
  delimiter: str = None,
  extra: typing.List[str] = None,
  include_hash: bool = None,
  max_len: typing.Union[int, float] = None
)
```

###### `scope`<sup>Required</sup> <a name="cdk8s.Names.parameter.scope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The construct for which to render the DNS label.

---

###### `delimiter`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.delimiter"></a>

- *Type:* `str`
- *Default:* "-"

Delimiter to use between components.

---

###### `extra`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.extra"></a>

- *Type:* typing.List[`str`]
- *Default:* [] use the construct path components

Extra components to include in the name.

---

###### `include_hash`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.include_hash"></a>

- *Type:* `bool`
- *Default:* true

Include a short hash as last part of the name.

---

###### `max_len`<sup>Optional</sup> <a name="cdk8s.NameOptions.parameter.max_len"></a>

- *Type:* `typing.Union[int, float]`
- *Default:* 63

Maximum allowed length for the name.

---



### Size <a name="cdk8s.Size"></a>

Represents the amount of digital storage.

The amount can be specified either as a literal value (e.g: `10`) which
cannot be negative.

When the amount is passed as a token, unit conversion is not possible.

#### Methods <a name="Methods"></a>

##### `to_gibibytes` <a name="cdk8s.Size.to_gibibytes"></a>

```python
def to_gibibytes(
  rounding: SizeRoundingBehavior = None
)
```

###### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.parameter.rounding"></a>

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

##### `to_kibibytes` <a name="cdk8s.Size.to_kibibytes"></a>

```python
def to_kibibytes(
  rounding: SizeRoundingBehavior = None
)
```

###### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.parameter.rounding"></a>

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

##### `to_mebibytes` <a name="cdk8s.Size.to_mebibytes"></a>

```python
def to_mebibytes(
  rounding: SizeRoundingBehavior = None
)
```

###### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.parameter.rounding"></a>

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

##### `to_pebibytes` <a name="cdk8s.Size.to_pebibytes"></a>

```python
def to_pebibytes(
  rounding: SizeRoundingBehavior = None
)
```

###### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.parameter.rounding"></a>

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

##### `to_tebibytes` <a name="cdk8s.Size.to_tebibytes"></a>

```python
def to_tebibytes(
  rounding: SizeRoundingBehavior = None
)
```

###### `rounding`<sup>Optional</sup> <a name="cdk8s.SizeConversionOptions.parameter.rounding"></a>

- *Type:* [`cdk8s.SizeRoundingBehavior`](#cdk8s.SizeRoundingBehavior)
- *Default:* SizeRoundingBehavior.FAIL

How conversions should behave when it encounters a non-integer result.

---

#### Static Functions <a name="Static Functions"></a>

##### `gibibytes` <a name="cdk8s.Size.gibibytes"></a>

```python
import cdk8s

cdk8s.Size.gibibytes(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

---

##### `kibibytes` <a name="cdk8s.Size.kibibytes"></a>

```python
import cdk8s

cdk8s.Size.kibibytes(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

---

##### `mebibytes` <a name="cdk8s.Size.mebibytes"></a>

```python
import cdk8s

cdk8s.Size.mebibytes(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

---

##### `pebibyte` <a name="cdk8s.Size.pebibyte"></a>

```python
import cdk8s

cdk8s.Size.pebibyte(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

---

##### `tebibytes` <a name="cdk8s.Size.tebibytes"></a>

```python
import cdk8s

cdk8s.Size.tebibytes(
  amount: typing.Union[int, float]
)
```

###### `amount`<sup>Required</sup> <a name="cdk8s.Size.parameter.amount"></a>

- *Type:* `typing.Union[int, float]`

---



### Testing <a name="cdk8s.Testing"></a>

Testing utilities for cdk8s applications.


#### Static Functions <a name="Static Functions"></a>

##### `app` <a name="cdk8s.Testing.app"></a>

```python
import cdk8s

cdk8s.Testing.app(
  outdir: str = None,
  output_file_extension: str = None,
  yaml_output_type: YamlOutputType = None
)
```

###### `outdir`<sup>Optional</sup> <a name="cdk8s.AppProps.parameter.outdir"></a>

- *Type:* `str`
- *Default:* CDK8S_OUTDIR if defined, otherwise "dist"

The directory to output Kubernetes manifests.

---

###### `output_file_extension`<sup>Optional</sup> <a name="cdk8s.AppProps.parameter.output_file_extension"></a>

- *Type:* `str`
- *Default:* .k8s.yaml

The file extension to use for rendered YAML files.

---

###### `yaml_output_type`<sup>Optional</sup> <a name="cdk8s.AppProps.parameter.yaml_output_type"></a>

- *Type:* [`cdk8s.YamlOutputType`](#cdk8s.YamlOutputType)
- *Default:* YamlOutputType.FILE_PER_CHART

How to divide the YAML output into files.

---

##### `chart` <a name="cdk8s.Testing.chart"></a>

```python
import cdk8s

cdk8s.Testing.chart()
```

##### `synth` <a name="cdk8s.Testing.synth"></a>

```python
import cdk8s

cdk8s.Testing.synth(
  chart: Chart
)
```

###### `chart`<sup>Required</sup> <a name="cdk8s.Testing.parameter.chart"></a>

- *Type:* [`cdk8s.Chart`](#cdk8s.Chart)

---



### Yaml <a name="cdk8s.Yaml"></a>

YAML utilities.


#### Static Functions <a name="Static Functions"></a>

##### ~~`format_objects`~~ <a name="cdk8s.Yaml.format_objects"></a>

```python
import cdk8s

cdk8s.Yaml.format_objects(
  docs: typing.List[typing.Any]
)
```

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* typing.List[`typing.Any`]

---

##### `load` <a name="cdk8s.Yaml.load"></a>

```python
import cdk8s

cdk8s.Yaml.load(
  url_or_file: str
)
```

###### `url_or_file`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.url_or_file"></a>

- *Type:* `str`

a URL of a file path to load from.

---

##### `save` <a name="cdk8s.Yaml.save"></a>

```python
import cdk8s

cdk8s.Yaml.save(
  file_path: str,
  docs: typing.List[typing.Any]
)
```

###### `file_path`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.file_path"></a>

- *Type:* `str`

The output path.

---

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* typing.List[`typing.Any`]

The set of objects.

---

##### `stringify` <a name="cdk8s.Yaml.stringify"></a>

```python
import cdk8s

cdk8s.Yaml.stringify(
  docs: typing.Any
)
```

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* `typing.Any`

A set of objects to convert to YAML.

---

##### `tmp` <a name="cdk8s.Yaml.tmp"></a>

```python
import cdk8s

cdk8s.Yaml.tmp(
  docs: typing.List[typing.Any]
)
```

###### `docs`<sup>Required</sup> <a name="cdk8s.Yaml.parameter.docs"></a>

- *Type:* typing.List[`typing.Any`]

the set of documents to save.

---



## Protocols <a name="Protocols"></a>

### IAnyProducer <a name="cdk8s.IAnyProducer"></a>

- *Implemented By:* [`cdk8s.IAnyProducer`](#cdk8s.IAnyProducer)

#### Methods <a name="Methods"></a>

##### `produce` <a name="cdk8s.IAnyProducer.produce"></a>

```python
def produce()
```


## Enums <a name="Enums"></a>

### SizeRoundingBehavior <a name="SizeRoundingBehavior"></a>

Rounding behaviour when converting between units of `Size`.

#### `FAIL` <a name="cdk8s.SizeRoundingBehavior.FAIL"></a>

Fail the conversion if the result is not an integer.

---


#### `FLOOR` <a name="cdk8s.SizeRoundingBehavior.FLOOR"></a>

If the result is not an integer, round it to the closest integer less than the result.

---


#### `NONE` <a name="cdk8s.SizeRoundingBehavior.NONE"></a>

Don't round.

Return even if the result is a fraction.

---


### YamlOutputType <a name="YamlOutputType"></a>

The method to divide YAML output into files.

#### `FILE_PER_APP` <a name="cdk8s.YamlOutputType.FILE_PER_APP"></a>

All resources are output into a single YAML file.

---


#### `FILE_PER_CHART` <a name="cdk8s.YamlOutputType.FILE_PER_CHART"></a>

Resources are split into seperate files by chart.

---


#### `FILE_PER_RESOURCE` <a name="cdk8s.YamlOutputType.FILE_PER_RESOURCE"></a>

Each resource is output to its own file.

---


#### `FOLDER_PER_CHART_FILE_PER_RESOURCE` <a name="cdk8s.YamlOutputType.FOLDER_PER_CHART_FILE_PER_RESOURCE"></a>

Each chart in its own folder and each resource in its own file.

---

