"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolve = void 0;
const lazy_1 = require("./lazy");
function resolve(value) {
    if (value == null) {
        return value;
    }
    // cdk8s token
    if (value instanceof lazy_1.Lazy) {
        const resolved = value.produce();
        return resolve(resolved);
    }
    // implicit token as generated by the cdk8s-cli (e.g IntOrString)
    if (typeof (value.resolve) === 'function') {
        const resolved = value.resolve();
        return resolve(resolved);
    }
    if (typeof (value) !== 'object') {
        return value;
    }
    if (Array.isArray(value)) {
        return value.map(x => resolve(x));
    }
    const result = {};
    for (const [k, v] of Object.entries(value)) {
        result[k] = resolve(v);
    }
    return result;
}
exports.resolve = resolve;
//# sourceMappingURL=data:application/json;base64,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