"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sanitizeValue = void 0;
function sanitizeValue(obj, options = {}) {
    if (obj == null) {
        return undefined;
    }
    if (typeof (obj) !== 'object') {
        return obj;
    }
    if (Array.isArray(obj)) {
        if (options.filterEmptyArrays && obj.length === 0) {
            return undefined;
        }
        return obj.map(x => sanitizeValue(x, options));
    }
    if (obj.constructor.name !== 'Object') {
        throw new Error(`can't render non-simple object of type '${obj.constructor.name}'`);
    }
    const newObj = {};
    const sortKeys = options.sortKeys ?? true;
    const keys = sortKeys ? Object.keys(obj).sort() : Object.keys(obj);
    for (const key of keys) {
        const value = obj[key];
        const newValue = sanitizeValue(value, options);
        if (newValue != null) {
            newObj[key] = newValue;
        }
    }
    if (options.filterEmptyObjects && Object.keys(newObj).length === 0) {
        return undefined;
    }
    return newObj;
}
exports.sanitizeValue = sanitizeValue;
//# sourceMappingURL=data:application/json;base64,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