"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cron = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a cron schedule
 */
class Cron {
    constructor(cronOptions = {}) {
        const minute = fallback(cronOptions.minute, '*');
        const hour = fallback(cronOptions.hour, '*');
        const month = fallback(cronOptions.month, '*');
        const day = fallback(cronOptions.day, '*');
        const weekDay = fallback(cronOptions.weekDay, '*');
        this.expressionString = `${minute} ${hour} ${day} ${month} ${weekDay}`;
    }
    /**
     * Create a cron schedule which runs every minute
     */
    static everyMinute() {
        return Cron.schedule({ minute: '*', hour: '*', day: '*', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs every hour
     */
    static hourly() {
        return Cron.schedule({ minute: '0', hour: '*', day: '*', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs every day at midnight
     */
    static daily() {
        return Cron.schedule({ minute: '0', hour: '0', day: '*', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs every week on Sunday
     */
    static weekly() {
        return Cron.schedule({ minute: '0', hour: '0', day: '*', month: '*', weekDay: '0' });
    }
    /**
     * Create a cron schedule which runs first day of every month
     */
    static monthly() {
        return Cron.schedule({ minute: '0', hour: '0', day: '1', month: '*', weekDay: '*' });
    }
    /**
     * Create a cron schedule which runs first day of January every year
     */
    static annually() {
        return Cron.schedule({ minute: '0', hour: '0', day: '1', month: '1', weekDay: '*' });
    }
    /**
     * Create a custom cron schedule from a set of cron fields
     */
    static schedule(options) {
        return new Cron(options);
    }
    ;
}
exports.Cron = Cron;
_a = JSII_RTTI_SYMBOL_1;
Cron[_a] = { fqn: "cdk8s.Cron", version: "1.7.16" };
function fallback(x, def) {
    return x ?? def;
}
//# sourceMappingURL=data:application/json;base64,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