"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Helm = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const os = require("os");
const path = require("path");
const yaml = require("yaml");
const _child_process_1 = require("./_child_process");
const include_1 = require("./include");
const names_1 = require("./names");
const MAX_HELM_BUFFER = 10 * 1024 * 1024;
/**
 * Represents a Helm deployment.
 *
 * Use this construct to import an existing Helm chart and incorporate it into your constructs.
 */
class Helm extends include_1.Include {
    constructor(scope, id, props) {
        const workdir = fs.mkdtempSync(path.join(os.tmpdir(), 'cdk8s-helm-'));
        const args = new Array();
        args.push('template');
        // values
        if (props.values && Object.keys(props.values).length > 0) {
            const valuesPath = path.join(workdir, 'overrides.yaml');
            fs.writeFileSync(valuesPath, yaml.stringify(props.values));
            args.push('-f', valuesPath);
        }
        // custom flags
        if (props.helmFlags) {
            args.push(...props.helmFlags);
        }
        // release name
        // constraints: https://github.com/helm/helm/issues/6006
        const releaseName = props.releaseName ?? names_1.Names.toDnsLabel(scope, { maxLen: 53, extra: [id] });
        args.push(releaseName);
        // chart
        args.push(props.chart);
        const prog = props.helmExecutable ?? 'helm';
        const outputFile = renderTemplate(workdir, prog, args);
        super(scope, id, { url: outputFile });
        this.releaseName = releaseName;
    }
}
exports.Helm = Helm;
_a = JSII_RTTI_SYMBOL_1;
Helm[_a] = { fqn: "cdk8s.Helm", version: "1.7.16" };
function renderTemplate(workdir, prog, args) {
    const helm = _child_process_1._child_process.spawnSync(prog, args, {
        maxBuffer: MAX_HELM_BUFFER,
    });
    if (helm.error) {
        const err = helm.error.message;
        if (err.includes('ENOENT')) {
            throw new Error(`unable to execute '${prog}' to render Helm chart. Is it installed on your system?`);
        }
        throw new Error(`error while rendering a helm chart: ${err}`);
    }
    if (helm.status !== 0) {
        throw new Error(helm.stderr.toString());
    }
    const outputFile = path.join(workdir, 'chart.yaml');
    const stdout = helm.stdout;
    fs.writeFileSync(outputFile, stdout);
    return outputFile;
}
//# sourceMappingURL=data:application/json;base64,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