"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiObjectMetadataDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _resolve_1 = require("./_resolve");
const _util_1 = require("./_util");
/**
 * Object metadata.
 */
class ApiObjectMetadataDefinition {
    constructor(options = {}) {
        this.name = options.name;
        this.labels = options.labels ?? {};
        this.annotations = options.annotations ?? {};
        this.namespace = options.namespace;
        this.finalizers = options.finalizers ?? [];
        this.ownerReferences = options.ownerReferences ?? [];
        this._additionalAttributes = options ?? {};
    }
    /**
     * Add a label.
     *
     * @param key - The key.
     * @param value - The value.
     */
    addLabel(key, value) {
        this.labels[key] = value;
    }
    /**
     * @returns a value of a label or undefined
     * @param key the label
     */
    getLabel(key) {
        return this.labels[key];
    }
    /**
     * Add an annotation.
     *
     * @param key - The key.
     * @param value - The value.
     */
    addAnnotation(key, value) {
        this.annotations[key] = value;
    }
    /**
     * Add one or more finalizers.
     *
     * @param finalizers the finalizers
     */
    addFinalizers(...finalizers) {
        this.finalizers.push(...finalizers);
    }
    /**
     * Add an owner.
     *
     * @param owner the owner
     */
    addOwnerReference(owner) {
        this.ownerReferences.push(owner);
    }
    /**
     * Adds an arbitrary key/value to the object metadata.
     * @param key Metadata key
     * @param value Metadata value
     */
    add(key, value) {
        this._additionalAttributes[key] = value;
    }
    /**
     * Synthesizes a k8s ObjectMeta for this metadata set.
     */
    toJson() {
        const sanitize = (x) => _util_1.sanitizeValue(x, { filterEmptyArrays: true, filterEmptyObjects: true });
        return sanitize(_resolve_1.resolve({
            ...this._additionalAttributes,
            name: this.name,
            namespace: this.namespace,
            annotations: this.annotations,
            finalizers: this.finalizers,
            ownerReferences: this.ownerReferences,
            labels: this.labels,
        }));
    }
}
exports.ApiObjectMetadataDefinition = ApiObjectMetadataDefinition;
_a = JSII_RTTI_SYMBOL_1;
ApiObjectMetadataDefinition[_a] = { fqn: "cdk8s.ApiObjectMetadataDefinition", version: "1.7.16" };
//# sourceMappingURL=data:application/json;base64,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