# Viewing Generated Code #

If you wish to see the source code generated by a constructed class you need to access the
`MethodMaker` instances on that class.

There is a helper function `get_methods` that can be used to obtain the names and respective
methods that have been attached to the class by the builder.

```python
from ducktools.classbuilder import SlotFields, get_methods, slotclass

@slotclass
class Example:
    __slots__ = SlotFields(
        a='a',
        b='b'
    )

print(get_methods(Example))
```

```
{
  '__init__': <MethodMaker for '__init__' method>, 
  '__repr__': <MethodMaker for '__repr__' method>, 
  '__eq__': <MethodMaker for '__eq__' method>
}
```

These can then be used to examine the generated source code and global variables provided
to the `exec` function. This can be useful for debugging code generators.

```python
from ducktools.classbuilder import SlotFields, get_methods, slotclass

@slotclass
class Example:
    __slots__ = SlotFields(
        a='a',
        b='b',
    )
    
methods = get_methods(Example)

for method in methods.values():
    print(method.code_generator(Example))
```
