"""Model and embedding configurations."""

embeddings = [
  {
    "context_length": 32768,
    "created_at": "2025-04-29",
    "name": "qwen3-embedding:4b",
    "provider": "ollama"
  },
  {
    "context_length": 32768,
    "created_at": "2025-04-29",
    "name": "qwen3-embedding:0.6b",
    "provider": "ollama"
  },
  {
    "context_length": 32768,
    "created_at": "2025-01-01",
    "name": "all-minilm:latest",
    "provider": "ollama"
  },
  {
    "context_length": 32768,
    "created_at": "2025-01-01",
    "name": "embeddinggemma:latest",
    "provider": "ollama"
  },
  {
    "context_length": 32768,
    "created_at": "2025-04-29",
    "name": "qwen3-embedding:latest",
    "provider": "ollama"
  },
  {
    "context_length": 32768,
    "created_at": "2025-01-01",
    "name": "nomic-embed-text:latest",
    "provider": "ollama"
  },
  {
    "context_length": 32768,
    "created_at": "2025-01-01",
    "name": "mxbai-embed-large:latest",
    "provider": "ollama"
  }
]

llms = [
    {
        "provider": "openai",
        "name": "gpt-4o",
        "created_at": "2024-05-01",
        "context_length": 128000
    },
    {
        "provider": "openai",
        "name": "gpt-4o-mini",
        "created_at": "2024-05-01",
        "context_length": 128000
    },
    {
        "provider": "openai",
        "name": "o1-preview",
        "created_at": "2024-09-12",
        "context_length": 128000
    },
    {
        "provider": "openai",
        "name": "o1-mini",
        "created_at": "2024-09-12",
        "context_length": 128000
    },
    {
        "provider": "openai",
        "name": "o3-mini",
        "created_at": "2025-01-31",
        "context_length": 128000
    },
    {
        "provider": "openai",
        "name": "gpt-5",
        "created_at": "2025-08-07",
        "context_length": 400000
    },
    {
        "provider": "openai",
        "name": "gpt-5-mini",
        "created_at": "2025-08-07",
        "context_length": 400000
    },
    {
        "provider": "openai",
        "name": "gpt-5-nano",
        "created_at": "2025-08-07",
        "context_length": 400000
    },
    {
        "provider": "openai",
        "name": "gpt-5-chat-latest",
        "created_at": "2025-08-07",
        "context_length": 400000
    },
    {
        "provider": "perplexity",
        "name": "perplexity",
        "created_at": "2023-01-01",
        "context_length": 65536
    },
    {
        "provider": "ollama",
        "name": "gpt-oss:latest",
        "created_at": "2024-01-01",
        "context_length": 65536
    },
    {
        "provider": "ollama",
        "name": "dolphin3:latest",
        "created_at": "2025-01-01",
        "context_length": 65536
    },
    {
        "provider": "ollama",
        "name": "qwen3-coder:latest",
        "created_at": "2025-04-29",
        "context_length": 32768
    },
    {
        "provider": "ollama",
        "name": "qwen3:latest",
        "created_at": "2025-04-29",
        "context_length": 40000
    },
    {
        "provider": "ollama",
        "name": "llama3:latest",
        "created_at": "2025-01-01",
        "context_length": 65536
    },
    {
        "provider": "ollama",
        "name": "mistral:latest",
        "created_at": "2025-01-01",
        "context_length": 65536
    },
    {
        "provider": "ollama",
        "name": "llama3.1:70b",
        "created_at": "2025-01-01",
        "context_length": 65536
    },
    {
        "provider": "ollama",
        "name": "qwen3:32b",
        "created_at": "2025-04-29",
        "context_length": 40000
    },
    {
        "provider": "ollama",
        "name": "codellama:latest",
        "created_at": "2025-01-01",
        "context_length": 32768
    },
    {
        "provider": "ollama",
        "name": "gemma3:latest",
        "created_at": "2025-01-01",
        "context_length": 32768
    },
    {
        "provider": "ollama",
        "name": "deepseek-r1:latest",
        "created_at": "2025-01-01",
        "context_length": 32768
    },
    {
        "provider": "ollama",
        "name": "llama3.2:latest",
        "created_at": "2025-01-01",
        "context_length": 65536
    },
    {
        "provider": "google",
        "name": "gemini-2.5-pro",
        "created_at": "2025-01-01",
        "context_length": 1048576,
    },
    {
        "provider": "google",
        "name": "gemini-2.5-flash",
        "created_at": "2025-01-01",
        "context_length": 1048576,
    },
    {
        "provider": "google",
        "name": "gemini-2.5-flash-lite",
        "created_at": "2025-01-01",
        "context_length": 1048576,
    },
    {
        "provider": "google",
        "name": "gemini-3-pro",
        "created_at": "2025-01-01",
        "context_length": 1048576,
    },
    {
        "provider": "google",
        "name": "gemini-3-flash",
        "created_at": "2025-01-01",
        "context_length": 1048576,
    },
    {
        "provider": "google",
        "name": "gemini-3-flash-lite",
        "created_at": "2025-01-01",
        "context_length": 1048576,
    },

]
