"""Core models package - shared between ai and edge applications."""

from .user import Users, User, users
from .role import AiRoles, AiRole, ai_roles
from .chat import AIChats, AIChat, ai_chats
from .note import Notes, Note, Size, Status, notes
from .task import PlanTasks, PlanTask, plan_tasks
from .document import AiDocuments, AiDocument, ai_documents
from .code import CodeTemplates, CodeTemplate, code_template
from .sprint import Sprints, Sprint, sprints
from .music import MusicModel, Music, music
from .learn import LearnQuestionsModel, QuizQuestion, learn_questions

__all__ = [
    # User
    'Users', 'User', 'users',
    # Role
    'AiRoles', 'AiRole', 'ai_roles',
    # Chat
    'AIChats', 'AIChat', 'ai_chats',
    # Note
    'Notes', 'Note', 'Size', 'Status', 'notes',
    # Task
    'PlanTasks', 'PlanTask', 'plan_tasks',
    # Document
    'AiDocuments', 'AiDocument', 'ai_documents',
    # Code
    'CodeTemplates', 'CodeTemplate', 'code_template',
    # Sprint
    'Sprints', 'Sprint', 'sprints',
    # Music
    'MusicModel', 'Music', 'music',
    # Learn
    'LearnQuestionsModel', 'QuizQuestion', 'learn_questions',
]
