"""AI Chat model with shared CRUD operations."""
from datetime import datetime
from typing import List, Optional, Any
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class AIChat(CollectionTypes):
    """AI Chat schema - shared between ai and edge."""
    model: str
    title: str
    role_title: str
    id: Optional[str] = None
    messages: List[Any] = []
    path: List[str] = []
    date_updated: datetime
    date_created: datetime


class AIChats(BaseSchema):
    """AI Chat model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('aiChats'))
        self.schema = AIChat


ai_chats = AIChats()
