"""Code Template model with shared CRUD operations."""
from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class CodeTemplate(CollectionTypes):
    """Code Template schema - shared between ai and edge."""
    title: str
    project: str
    role_title: str
    orders: List[str] = []
    date_updated: Optional[datetime] = None
    date_created: Optional[datetime] = None


class CodeTemplates(BaseSchema):
    """Code Template model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('codeTemplates'))
        self.schema = CodeTemplate


code_template = CodeTemplates()
