"""Document model with shared CRUD operations."""
from datetime import datetime
from typing import List, Dict, Optional
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class AiDocument(CollectionTypes):
    """Document schema - shared between ai and edge."""
    title: str
    type: str
    text: str
    messages: List[Dict] = []
    vectors: List[float] = []
    path: List[str] = []
    # RAG metadata fields
    source: Optional[str] = None
    chunk: Optional[int] = None
    score: Optional[float] = None
    original_id: Optional[str] = None
    qdrant_point_id: Optional[str] = None
    date_updated: datetime
    date_created: datetime


class AiDocuments(BaseSchema):
    """Document model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('aiDocuments'))
        self.schema = AiDocument


ai_documents = AiDocuments()
