"""Learn Questions model with shared CRUD operations."""
from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class QuizQuestion(CollectionTypes):
    """Quiz Question schema - shared between ai and edge."""
    id: str
    user_id: str
    type: str
    path: str
    question: str
    options: List[str]
    correctAnswer: str
    submittedAnswer: Optional[str] = ""
    correct: bool = False
    date_updated: Optional[datetime] = None
    date_created: Optional[datetime] = None


class LearnQuestionsModel(BaseSchema):
    """Learn Questions model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('learnQuestions'))
        self.schema = QuizQuestion


learn_questions = LearnQuestionsModel()
