"""Music model with shared CRUD operations."""
from datetime import datetime
from typing import Optional
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class Music(CollectionTypes):
    """Music schema - shared between ai and edge."""
    instrumento: Optional[str] = None
    title: str
    author: str
    tom: Optional[str] = None
    link: Optional[str] = None
    text: Optional[str] = None
    favorite: bool = False
    description: Optional[str] = ""
    date_updated: Optional[datetime] = None
    date_created: Optional[datetime] = None


class MusicModel(BaseSchema):
    """Music model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('musics'))
        self.schema = Music


music = MusicModel()
