"""Note model with shared CRUD operations."""
from datetime import datetime
from typing import List, Optional, Any, Dict
from pydantic import BaseModel as CollectionTypes
from xqzhqdodft.database import db, BaseSchema


class Size(CollectionTypes):
    """Size metadata for notes."""
    characters: int
    words: int
    pages: int


class Status(CollectionTypes):
    """Status metadata for notes."""
    complete: int
    incomplete: int
    total: int


class Note(CollectionTypes):
    """Note schema - shared between ai and edge."""
    user_id: str
    file_path: str
    entry_path: str
    path: str
    type: str = ""
    project: bool = False
    title: str
    text: str
    level: str
    size: Size
    active: bool = True
    status: Status
    tasks: List[str] = []
    date_updated: datetime
    date_created: datetime


class Notes(BaseSchema):
    """Note model with CRUD operations."""
    
    def __init__(self):
        super().__init__(db.get_collection('notes'))
        self.schema = Note


notes = Notes()
